/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.vi.model.PhyNic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class PhyNicImpl
extends AbstractModelObjectImpl {
    static final String QuerySQLByName = "select id, vcenter_id, vhost_id, mo_key, device, mac, last_scan_time from phynic where mac=? ";
    static final String InsertSQL = "insert into phynic(id, vcenter_id, vhost_id, mo_key, device, mac, last_scan_time, last_update_time) values(?,?,?,?,?, ?,?,?)";
    static final String UpdateSQL = "update phynic set vcenter_id=?, vhost_id=?, mo_key=?, device=?, mac=?, last_scan_time=?, last_update_time=? where id=?";
    static final String DeleteSQL = "delete from phynic where id=?";
    static final String TableName = "phynic";
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    private final PhyNic _base;
    private VHostImpl _vhost;
    static final String[] LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};

    PhyNicImpl(String mo_key, String device, String mac) {
        this._base = new PhyNic(mo_key, device, mac);
    }

    public PhyNicImpl(PhyNic pbase) {
        this._base = pbase;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public NameKey getPhynicPK() {
        return (NameKey)this._base.getPK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByName);
                stat.setString(1, this.getKey());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        FabricImpl fabric = this.getFabric();
        if (fabric == null) {
            return null;
        }
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getDeleteSqlStr() {
        return DeleteSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByName;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        if (this._vhost != null) {
            VirtualCenterImpl vc = this._vhost.getVirtualCenter();
            if (vc != null) {
                stat.setLong(2, vc.getDBID());
            } else {
                stat.setLong(2, 0L);
            }
            stat.setLong(3, this._vhost.getDBID());
        } else {
            stat.setLong(2, 0L);
            stat.setLong(3, 0L);
        }
        stat.setString(4, this._base.getKey());
        stat.setString(5, this._base.getDevice());
        stat.setString(6, this._base.getMac());
        stat.setLong(7, this._base.getLastScanTime());
        long lastUpdateTime = System.currentTimeMillis();
        stat.setTimestamp(8, new Timestamp(lastUpdateTime));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._vhost != null) {
            VirtualCenterImpl vc = this._vhost.getVirtualCenter();
            if (vc != null) {
                stat.setLong(1, vc.getDBID());
            } else {
                stat.setLong(1, 0L);
            }
            stat.setLong(2, this._vhost.getDBID());
        } else {
            stat.setLong(1, 0L);
            stat.setLong(2, 0L);
        }
        stat.setString(3, this._base.getKey());
        stat.setString(4, this._base.getDevice());
        stat.setString(5, this._base.getMac());
        stat.setLong(6, this._base.getLastScanTime());
        long lastUpdateTime = System.currentTimeMillis();
        stat.setTimestamp(7, new Timestamp(lastUpdateTime));
        stat.setLong(8, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._base.getMac());
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        return wasPresent;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    public void setVhost(VHostImpl vhost) {
        NameKey newVhostPK;
        NameKey oldVhostPK = this._base.getVhostPK();
        NameKey nameKey = newVhostPK = vhost == null ? null : (NameKey)vhost.getPK();
        if (!GenUtil.equals(oldVhostPK, newVhostPK)) {
            if (this._vhost != vhost) {
                this._vhost = vhost;
            }
            this._base.setVhostPK(newVhostPK);
        }
    }

    public NameKey getNameKey() {
        return this._base.getNameKey();
    }

    public String getKey() {
        return this._base.getKey();
    }

    public void setKey(String key) {
        this._base.setKey(key);
    }

    public String getMac() {
        return this._base.getMac();
    }

    public void setMac(String macAddress) {
        this._base.setMac(macAddress);
    }

    public String getDevice() {
        return this._base.getDevice();
    }

    public void setDevice(String device) {
        this._base.setDevice(device);
    }

    public String getMoRef() {
        return this._base.getMoRef();
    }

    public void setMoRef(String moRef) {
        this._base.setMoRef(moRef);
    }

    public String dump(int level) {
        return null;
    }
}

