/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.PmIndexBookMarkBase;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class PmIndexBookMarkImpl
extends AbstractDBObjectImpl {
    static final String QuerySQL = "select TYPE,  BOOKMARKINDEX, BOOKMARKCOUNT, SERVERID  from pm_indexbookmark where serverid = ? or SERVERID is null";
    static final String QuerySQLById = "select TYPE,  BOOKMARKINDEX, BOOKMARKCOUNT, SERVERID  from pm_indexbookmark where serverid = ? and TYPE = ? ";
    static final String InsertSQL = "insert into pm_indexbookmark (TYPE,  BOOKMARKINDEX, BOOKMARKCOUNT, SERVERID ) values (?,?,?,?) ";
    static final String UpdateSQL = "update pm_indexbookmark set BOOKMARKINDEX=?,BOOKMARKCOUNT=? where SERVERID = ? and TYPE=?";
    static final String TableName = "pm_indexbookmark";
    private PmIndexBookMarkBase _base;
    private static int _ServerId = 0;
    boolean recordExist = false;

    public PmIndexBookMarkImpl(PmIndexBookMarkBase base) {
        _ServerId = ClusterSequence.getSequence().getServerId();
        this._base = base;
        this.setDBID(base.getDBID());
    }

    public PmIndexBookMarkBase getBase() {
        return this._base;
    }

    @Override
    public long getDBID() {
        return this._base.getDBID();
    }

    @Override
    public void setDBID(long id) {
        this._base.setDBID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block5: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLById);
                stat.setInt(1, _ServerId);
                stat.setLong(2, this._base.getType());
                rs = stat.executeQuery();
                this.recordExist = rs.next();
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block5;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (!this.recordExist) {
            this.checkPreexistRecord(con);
        }
        if (!this.recordExist) {
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            stat.setInt(1, this._base.getType());
            stat.setInt(2, this._base.getIndex());
            stat.setInt(3, this._base.getCount());
            stat.setInt(4, this._base.getServerid());
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        stat.setInt(1, this._base.getIndex());
        stat.setInt(2, this._base.getCount());
        stat.setInt(3, this._base.getServerid());
        stat.setInt(4, this._base.getType());
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadAllFromDB() throws SQLException {
        ArrayList arrayList;
        _ServerId = ClusterSequence.getSequence().getServerId();
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQL);
            stat.setInt(1, _ServerId);
            rs = stat.executeQuery();
            ArrayList al = PmIndexBookMarkImpl.loadDBRecord(rs);
            rs.close();
            rs = null;
            arrayList = al;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PmIndexBookMarkBase findByPK(Connection con, int pk) throws SQLException {
        _ServerId = ClusterSequence.getSequence().getServerId();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLById);
            stat.setInt(1, _ServerId);
            stat.setInt(2, pk);
            ArrayList al = PmIndexBookMarkImpl.loadDBRecord(rs);
            PmIndexBookMarkBase pmIndexBookMarkBase = (PmIndexBookMarkBase)al.get(0);
            return pmIndexBookMarkBase;
        }
        catch (SQLException ex) {
            PmIndexBookMarkBase pmIndexBookMarkBase = null;
            return pmIndexBookMarkBase;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception ex) {}
            }
            try {
                ConnectionManager.returnConnection(con);
            }
            catch (Exception ex) {}
        }
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<PmIndexBookMarkBase> al = new ArrayList<PmIndexBookMarkBase>();
        while (rs.next()) {
            PmIndexBookMarkBase ppb = new PmIndexBookMarkBase(rs.getInt("TYPE"), rs.getInt("BOOKMARKINDEX"), rs.getInt("BOOKMARKCOUNT"), rs.getInt("SERVERID"));
            if (ppb.getIndex() != ClusterSequence.getSequence().getServerId()) {
                int n = (ppb.getIndex() + 10) / 10 * 10 + _ServerId;
            }
            ppb.setServerid(_ServerId);
            al.add(ppb);
        }
        return al;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }
}

