/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.zm.ZoneDataCache;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.VshManager;
import com.cisco.dcbu.lib.snmp.proxy.ProxyTransportOptions;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUserEntry;
import com.cisco.dcbu.lib.snmp.transport.SnmpTransportProviderIf;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportProvider;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanFportKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.BrcdSnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.GroupManager;
import com.cisco.dcbu.sm.server.model.HostClusterImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.PmExtraOidImpl;
import com.cisco.dcbu.sm.server.model.StorageEnclosureImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.vi.model.VirtualMachine;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SanManager {
    static final String PROP_SNMP_LOCALPORT = "snmp.localport";
    static final String PROP_SNMP_TIMEOUT = "snmp.timeout";
    static final String PROP_SNMP_RETRIES = "snmp.retries";
    static final SnmpOID _SsmFeatureVar = new SnmpOID(MibNode.get("ssmProvFeatureIfRowStatus").getOid());
    static final SnmpOID _SsmSsnFeatureVar = new SnmpOID(MibNode.get("ssmSsnProvFeatureRowStatus").getOid());
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    public static boolean Test = false;
    private static SanManager _Instance;
    private static SnmpSession _SnmpSession;
    public static int _DefMaxOpenSwitches;
    private SyncedInt _curFabricId;
    private ConcurrentHashMap<FabricPK, FabricImpl> _fabricByPK;
    private ConcurrentHashMap<WwnKey, ConcurrentHashMap<FabricPK, SwitchImpl>> _switchByWwnKey;
    private ConcurrentHashMap<WwnKey, ConcurrentHashMap<FabricPK, EndPortImpl>> _endportByWwnKey;
    private ConcurrentHashMap<NameKey, EnclosureImpl> _enclByNameKey;
    private ConcurrentHashMap<NameKey, HostClusterImpl> _hostClusterByNameKey;
    private Map<SwitchIntKey, ConcurrentHashMap<FabricPK, Set<EndPortImpl>>> _endportsBySwIntKey;
    private transient ConcurrentHashMap<InetAddress, ConcurrentHashMap<FabricPK, SwitchImpl>> _switchByIp;
    private static CopyOnWriteArrayList<ModelEventListenerIf> _Listeners;
    private static CopyOnWriteArrayList<ModelEventListenerIf> _Plisteners;
    private DbLoadStatus _dbLoadStatus = DbLoadStatus.NOTLOADED;

    private SanManager() {
        this._fabricByPK = new ConcurrentHashMap();
        this._switchByWwnKey = new ConcurrentHashMap();
        this._switchByIp = new ConcurrentHashMap();
        this._endportByWwnKey = new ConcurrentHashMap();
        this._enclByNameKey = new ConcurrentHashMap();
        this._hostClusterByNameKey = new ConcurrentHashMap();
        this._endportsBySwIntKey = new ConcurrentHashMap<SwitchIntKey, ConcurrentHashMap<FabricPK, Set<EndPortImpl>>>();
        this._curFabricId = new SyncedInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SanManager getInstance() {
        if (_Instance == null) {
            _Instance = new SanManager();
        }
        if (_Instance != null && _Instance.getDbLoadStatus() == DbLoadStatus.LOADFAILED) {
            SanManager sanManager = _Instance;
            synchronized (sanManager) {
                _Instance.loadFabricsFromDB();
            }
        }
        return _Instance;
    }

    public static void close() {
        if (_Instance != null && _Instance.getNumOfFabrics() != 0) {
            FabricImpl[] fabrics = _Instance.getFabrics();
            for (int i = 0; i < fabrics.length; ++i) {
                _Instance.closeFabric(fabrics[i]);
            }
        }
    }

    public static void initSnmp() throws Exception {
        Integer retries;
        Integer timeout;
        if (_SnmpSession != null) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"fms");
        ProxyTransportOptions opt = null;
        InetAddress localaddr = null;
        Integer localport = Integer.getInteger(PROP_SNMP_LOCALPORT);
        _SnmpSession = SnmpSession.getInstance();
        String value = System.getProperty("snmp.proxy");
        if (value != null && value.length() != 0) {
            InetAddress proxyAddr = null;
            int proxyPort = 9198;
            int del = value.indexOf(58);
            String proxyHost = null;
            try {
                if (del != -1) {
                    proxyHost = value.substring(0, del);
                    proxyPort = Integer.parseInt(value.substring(del + 1).trim());
                    if (proxyPort <= 0 || proxyPort > 65535) {
                        throw new NumberFormatException(String.valueOf(proxyPort));
                    }
                    proxyAddr = InetAddress.getByName(value.substring(0, del));
                } else {
                    proxyHost = value;
                    proxyAddr = InetAddress.getByName(value.substring(0));
                }
                if (proxyAddr != null && !NetUtil.isLocalHost(proxyAddr.getHostAddress())) {
                    opt = new ProxyTransportOptions(proxyAddr, proxyPort);
                }
            }
            catch (UnknownHostException uhe) {
                boolean localNic = false;
                Enumeration<NetworkInterface> nifs = null;
                try {
                    nifs = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException ex) {
                    // empty catch block
                }
                if (nifs != null) {
                    while (nifs.hasMoreElements()) {
                        NetworkInterface ni = nifs.nextElement();
                        if (!ni.getName().equals(proxyHost)) continue;
                        localNic = true;
                        break;
                    }
                }
                if (!localNic) {
                    logger.warn((Object)("Invalid proxy server address: " + proxyHost + ". Use local IP address as proxy server address"));
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)("Invalid proxy server port: " + nfe.getMessage()));
            }
        }
        if (opt != null) {
            _SnmpSession.open("proxy", opt);
        } else {
            _SnmpSession.open(localaddr, localport == null ? 0 : localport);
            if (SnmpSession._PreferTcp) {
                SnmpSession.getInstance("tcp").open("tcp", new TcpTransportOptions(null, 161, localport == null ? 0 : localport));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SnmpSession initialized on " + _SnmpSession.getLocalHostAddress() + ":" + _SnmpSession.getLocalPort() + ", remote port=" + _SnmpSession.getRemotePort()));
        }
        if ((timeout = Integer.getInteger(PROP_SNMP_TIMEOUT)) != null) {
            SnmpPeer.setClassTimeout(timeout);
        }
        if ((retries = Integer.getInteger(PROP_SNMP_RETRIES)) != null) {
            SnmpPeer.setClassRetries(retries);
        }
    }

    public static SnmpSession getSnmpSession() {
        return _SnmpSession;
    }

    public int getNumOfSans() {
        return 1;
    }

    public int getNumOfFabrics() {
        return this._fabricByPK.size();
    }

    public boolean reachMaxFabrics() {
        Integer maxopen = Integer.getInteger("fabric.maxopen");
        return maxopen != null && maxopen <= this._fabricByPK.size();
    }

    public void validateSeedSwitch(InetAddress swIp, SnmpUser user) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (user == null || user.getRoleName() == null) {
            throw new Exception("Invalid user login information");
        }
        FabricImpl fabric = this.findFabric(swIp);
        if (fabric != null) {
            return;
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, user);
        SnmpAdapter.validateSeedSwitch(peer);
    }

    public void validateSeedSwitch(InetAddress swIp, SnmpUserOpt snmpUserOpt) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (snmpUserOpt == null) {
            throw new Exception("Invalid user login information");
        }
        FabricImpl fabric = this.findFabric(swIp);
        if (fabric != null) {
            return;
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, snmpUserOpt);
        SnmpPeer.addPeer(peer);
        SnmpAdapter.validateSeedSwitch(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricImpl createFabric(FabricPK pkey) {
        FabricImpl fabric = null;
        ConcurrentHashMap<FabricPK, FabricImpl> concurrentHashMap = this._fabricByPK;
        synchronized (concurrentHashMap) {
            if (pkey == null) {
                int fid = this._curFabricId.increment();
                try {
                    fid = (int)Sequence.getSequence().getFabricPK();
                    this._curFabricId.set(fid);
                }
                catch (SQLException ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"Can not get fabric id from db, use local incremental id:", (Throwable)ex);
                }
                pkey = new FabricPK(fid);
            } else {
                fabric = this.findFabric(pkey);
            }
            if (fabric == null) {
                fabric = new FabricImpl(pkey);
                this._fabricByPK.put(fabric.getPK(), fabric);
            }
        }
        return fabric;
    }

    public FabricImpl[] getFabrics() {
        return this._fabricByPK.values().toArray(new FabricImpl[this._fabricByPK.size()]);
    }

    public boolean checkIfFabricNameExists(String name) {
        FabricImpl[] fabrics = this.getFabrics();
        for (int i = 0; i < fabrics.length; ++i) {
            if (!name.equals(fabrics[i].getFabricName())) continue;
            return true;
        }
        return false;
    }

    public FabricPK[] getFabricPKs() {
        return this._fabricByPK.keySet().toArray(new FabricPK[this._fabricByPK.size()]);
    }

    void removeFabric(FabricImpl fabric) {
        this._fabricByPK.remove(fabric.getPK());
        this.notifyFabricRemoved(fabric);
    }

    public FabricImpl openFabric(InetAddress ipAddr, SnmpUser user, String inVsans, String exVsans) throws Exception {
        int ethSws;
        if (user == null || user.getRoleName() == null) {
            return null;
        }
        SwitchImpl[] switches = Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true")) ? SanManager.getInstance().getSwitches() : SanManager.getInstance().getNonNpvSwitches();
        int sanSws = switches == null ? 0 : switches.length;
        if (sanSws + (ethSws = DCManager.getInstance().getNumEthSwitchesNoFex()) >= _DefMaxOpenSwitches) {
            throw new Exception("Unable to add or manage these switches. This server is managing the recommended maximum of " + _DefMaxOpenSwitches + " switches");
        }
        FabricImpl fabric = this.findFabric(ipAddr, inVsans, exVsans);
        if (fabric != null && fabric.getFarbicStatus() == 2) {
            return fabric;
        }
        FabricPK dbPk = FabricImpl.findFPKBySeedIPVsans(ipAddr, inVsans, exVsans);
        if (dbPk != null) {
            return this.manageFabric(dbPk, ipAddr, user);
        }
        if (fabric == null) {
            if (this.reachMaxFabrics()) {
                throw new Exception("Maximum number of fabrics is reached.");
            }
            fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr, inVsans, exVsans);
            if (Boolean.getBoolean("fabric.snapshot")) {
                return fabric;
            }
            if (fabric == null) {
                FabricPK fpk = InventoryPersistentManager.queryFabricPKByIpVsans(ipAddr, inVsans, exVsans);
                fabric = this.createFabric(fpk);
                SwitchImpl seed = this.createSwitch(null, ipAddr, fabric);
                seed.setMDS(true);
                seed.setManageable(true, null);
                fabric.setSeed(seed);
                fabric.setIncludedVsanList(inVsans);
                fabric.setExcludedVsanList(exVsans);
            } else {
                SwitchImpl seed = fabric.getSeed();
                if (seed == null) {
                    seed = this.createSwitch(null, ipAddr, fabric);
                    seed.setMDS(true);
                    seed.setManageable(true, null);
                    fabric.setSeed(seed);
                } else {
                    seed.setDiscFlags(97279);
                }
                SnmpUser oldUser = fabric.getCredentials();
                if (oldUser != null) {
                    user = oldUser;
                }
            }
            fabric.setCredentials(user, false);
            DiscoveryManager.getInstance().discoverFabric(fabric, DiscoveryType.FABRIC_INITIAL);
            String fabricName = fabric.getPK().toString();
            if (fabricName == null) {
                fabricName = "Fabric_" + fabric.getSeed().getInetAddress().getHostAddress().replace('.', '-');
            }
            if (fabric.getDBID() > 0L) {
                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fabric.getPK(), IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fabricName + "' opened", Severity.INFO.getValue(), 0));
            }
        }
        return fabric;
    }

    public FabricImpl manageFabric(FabricPK fabricPK) throws Exception {
        SnmpTransportProviderIf tranportProvider;
        long seedid;
        FabricImpl fs = this.findFabric(fabricPK);
        if (fs == null) {
            InetAddress ipAddr = GlobalFabricManager.getInstance().getSeedSwitchAddress(fabricPK);
            fs = InventoryPersistentManager.getInstance().reloadFabric(ipAddr);
            if (fs == null) {
                _Logger.error((Object)("can not find fabric in db for seed switch:" + ipAddr));
                return null;
            }
        }
        if ((seedid = fs.getSeedDBID()) == 0L) {
            seedid = FabricImpl.findSeedSwitchIdByPk(fabricPK);
        }
        if (this._switchByIp != null && _SnmpSession != null && SnmpSession._PreferTcp && (tranportProvider = _SnmpSession.getTransportProviderObject()) != null && tranportProvider instanceof TcpTransportProvider) {
            TcpTransportProvider tcpTransportProvider = (TcpTransportProvider)tranportProvider;
            for (InetAddress ip : this._switchByIp.keySet()) {
                tcpTransportProvider.stopSession(ip.getHostAddress());
            }
        }
        InetAddress ipAddr = SwitchImpl.findSwitchMgmtAddrByPK(seedid);
        UsmUserEntry.authenticate(fs.getCredentials(), ipAddr);
        FabricImpl fabric = SanManager.getInstance().manageFabric(fabricPK, ipAddr, fs.getCredentials());
        if (fabric != null) {
            ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fabricPK, IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fabric.getPK().toString() + "' managed", Severity.INFO.getValue(), 0));
        }
        return fabric;
    }

    public FabricImpl manageFabric(FabricPK fpk, InetAddress ipAddr, SnmpUser user) throws Exception {
        if (user.getRoleName() == null) {
            _Logger.error((Object)"user role name is null");
            return null;
        }
        FabricImpl fabric = this.findFabric(fpk);
        if (fabric == null) {
            String[] vsanScope = FabricImpl.findVsanScopeByPk(fpk);
            fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr, vsanScope[0], vsanScope[1]);
            if (fabric == null) {
                _Logger.error((Object)("can not find fabric in db for seed switch:" + ipAddr));
                return null;
            }
        } else {
            InventoryPersistentManager.getInstance().reloadFabric(fabric);
        }
        if (fabric != null) {
            this._fabricByPK.put(fpk, fabric);
        }
        if (Boolean.getBoolean("fabric.snapshot")) {
            return fabric;
        }
        SwitchImpl seed = fabric.getSeed();
        if (seed == null) {
            seed = this.createSwitch(null, ipAddr, fabric);
            try {
                seed.setMDS(!this.isBrcdSwitchPeer(ipAddr, user));
            }
            catch (Exception e) {
                _Logger.warn((Object)("cannot check whether seed is Brocade switch or not: " + ipAddr), (Throwable)e);
                seed.setMDS(true);
            }
            seed.setManageable(true, null);
            fabric.setSeed(seed);
        } else {
            seed.setDiscFlags(97279);
        }
        fabric.setCredentials(user, false);
        DiscoveryManager.getInstance().discoverFabric(fabric, DiscoveryType.FABRIC_INITIAL);
        return fabric;
    }

    public boolean isOpened(FabricPK pkey) throws Exception {
        if (pkey == null) {
            return false;
        }
        FabricImpl fabric = this.findFabric(pkey);
        if (fabric != null) {
            int status = fabric.getFarbicStatus();
            return status == 2 || status == 4;
        }
        return false;
    }

    public void unmanageFabric(FabricPK fabricPK) throws Exception {
        SanManager sm = SanManager.getInstance();
        FabricImpl fabric = sm.findFabric(fabricPK);
        if (fabric == null) {
            throw new RemoteException(fabricPK + " not found");
        }
        if (fabric.isInInitialDiscovery()) {
            throw new RemoteException("Can not unmanage fabric " + fabricPK + ", it is in initial discovery");
        }
        sm.closeFabric(fabric);
        ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fabric.getPK(), IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fabric.getPK().toString() + "' unmanaged", Severity.INFO.getValue(), 0));
    }

    public void rediscoverFabric(FabricPK pkey, DiscoveryType discType) throws Exception {
        if (pkey == null) {
            throw new Exception("Fabric is null");
        }
        try {
            FabricPK[] fpks = new FabricPK[]{pkey};
            if (fpks != null) {
                for (int i = 0; i < fpks.length; ++i) {
                    FabricImpl fabric = SanManager.getInstance().findFabric(fpks[i]);
                    if (fabric == null) {
                        throw new Exception("cannot find fabric " + fpks[i]);
                    }
                    if (!fabric.isManaged()) {
                        throw new Exception(fpks[i] + " is not managed.");
                    }
                    DiscoveryManager.getInstance().discoverFabric(fabric, discType);
                    fabric.setDiscoveryType(discType);
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fpks[i], IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fpks[i].toString() + "' rediscovered", Severity.INFO.getValue(), 0));
                }
                try {
                    ZoneDataCache.getZoneDataCahche().invalidateCache();
                }
                catch (Exception ex) {
                    _Logger.info((Object)("Failed in clearing Zone Manager WS cache " + ex.getMessage()));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("rediscover error: " + ex.getMessage(), ex);
        }
    }

    public void closeFabric(FabricPK pk) {
        FabricImpl fabric = this.findFabric(pk);
        if (fabric != null) {
            this.closeFabric(fabric);
        }
    }

    public void closeFabric(FabricPK pk, boolean cleanCache) {
        this.closeFabric(pk, cleanCache, false);
    }

    public void closeFabric(FabricPK pk, boolean cleanCache, boolean cleanSwitchCache) {
        FabricImpl fabric = this.findFabric(pk);
        if (fabric != null) {
            this.closeFabric(fabric, cleanCache, cleanSwitchCache);
        }
    }

    public void closePersistedFabric(FabricPK pk, boolean cleanCache, boolean cleanSwitchCache) throws Exception {
        FabricImpl fabric = this.findFabric(pk);
        if (fabric == null) {
            throw new Exception("Fabric is not existing on the server or is removed from this server already");
        }
        if (!fabric.isPersisted() || fabric.isInInitialDiscovery()) {
            throw new Exception("Fabric is still in initial discovery or not persisted yet");
        }
        this.closeFabric(fabric, cleanCache, cleanSwitchCache);
    }

    public void closeFabric(FabricImpl fabric) {
        this.closeFabric(fabric, false);
    }

    public void closeFabric(FabricImpl fabric, boolean cleanCache) {
        this.closeFabric(fabric, cleanCache, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFabric(FabricImpl fabric, boolean cleanCache, boolean cleanSwitchCache) {
        block13: {
            try {
                SwitchImpl[] sws = fabric.getSwitches();
                if (sws == null || sws.length <= 0) break block13;
                for (int i = 0; i < sws.length; ++i) {
                    if (sws[i].isMDS()) {
                        try {
                            VshManager.getInstance().closeVsh(sws[i].getIpAddress());
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                    }
                    sws[i].clean();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        try {
            if (fabric.getFarbicStatus() == 1 || fabric.getFarbicStatus() == 3 || fabric.getFarbicStatus() == 6 || fabric.attemptFabric(2, 5, fabric.getDiscoveryTimeout())) {
                fabric.close(cleanSwitchCache);
                if (cleanCache) {
                    this._fabricByPK.remove(fabric.getPK());
                }
            }
        }
        catch (Exception ex) {
            fabric.releaseFabric(2);
            _Logger.log((Priority)Level.WARN, (Object)("close fabric" + fabric + "error: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            fabric.releaseFabric(6);
        }
    }

    public void persistFabric(FabricImpl fabric, boolean persist) {
        fabric.setPersistent(persist);
    }

    public FabricImpl findFabric(FabricPK pkey) {
        if (pkey == null) {
            return null;
        }
        return this._fabricByPK.get(pkey);
    }

    public FabricPK findFabricPK(IslPK pkey) {
        FabricPK[] pks;
        if (pkey == null) {
            return null;
        }
        for (FabricPK fKey : pks = this.getFabricPKs()) {
            if (this.findFabric(fKey) == null || this.findFabric(fKey).findIsl(pkey._p1) == null) continue;
            return fKey;
        }
        return null;
    }

    public FabricImpl findFabricBySwitchPK(WwnKey swPK, FabricPK fpk) {
        SwitchImpl sw = this.findSwitch(swPK, fpk);
        return sw != null ? sw.getFabric() : null;
    }

    public FabricPK findFabricPK(InetAddress inetAddr, String inVsans, String exVsans) {
        FabricImpl fabric = this.findFabric(inetAddr, inVsans, exVsans);
        return fabric == null ? null : fabric.getPK();
    }

    public FabricImpl findFabric(InetAddress inetAddr, String inVsans, String exVsans) {
        if (inetAddr == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric = this._switchByIp.get(inetAddr);
        if (swByFabric == null) {
            return null;
        }
        String inVsanStr = null;
        String exVsanStr = null;
        for (SwitchImpl sw : swByFabric.values()) {
            inVsanStr = sw.getFabric().getIncludedVsanList();
            exVsanStr = sw.getFabric().getExcludedVsanList();
            if (!(inVsans == null && exVsans == null ? inVsanStr == null && exVsanStr == null : (inVsans == null && exVsans != null ? inVsanStr == null && exVsans.equals(exVsanStr) : (inVsans != null && exVsans == null ? inVsans.equals(inVsanStr) && exVsanStr == null : inVsans.equals(inVsanStr) && exVsans.equals(exVsanStr))))) continue;
            return sw.getFabric();
        }
        return null;
    }

    public List<FabricImpl> findFabrics(InetAddress inetAddr) {
        if (inetAddr == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric = this._switchByIp.get(inetAddr);
        if (swByFabric == null) {
            return null;
        }
        ArrayList<FabricImpl> results = new ArrayList<FabricImpl>();
        ArrayList<FabricImpl> removedFabrics = new ArrayList<FabricImpl>();
        for (SwitchImpl sw : swByFabric.values()) {
            if (sw == null) continue;
            FabricImpl fabric = sw.getFabric();
            if (fabric != null && this._fabricByPK.get(fabric.getPK()) == null) {
                _Logger.log((Priority)Level.WARN, (Object)("Unreference switch found: " + sw));
                removedFabrics.add(fabric);
                continue;
            }
            results.add(fabric);
        }
        for (FabricImpl fa : removedFabrics) {
            try {
                swByFabric.remove(fa.getPK());
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"Close staled switch: ", (Throwable)ex);
            }
            try {
                fa.close();
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"Close staled fabric: ", (Throwable)ex);
            }
        }
        if (swByFabric == null || swByFabric.size() == 0) {
            this._switchByIp.remove(inetAddr);
        }
        return results;
    }

    public FabricImpl findFabric(InetAddress inetAddr) {
        if (inetAddr == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric = this._switchByIp.get(inetAddr);
        if (swByFabric == null) {
            return null;
        }
        Collection<SwitchImpl> swList = swByFabric.values();
        SwitchImpl sw = null;
        if (swList != null && swList.size() > 0) {
            SwitchImpl[] swAlist = swList.toArray(new SwitchImpl[swList.size()]);
            sw = swAlist[0];
        }
        if (sw != null) {
            FabricImpl fabric = sw.getFabric();
            if (fabric != null && this._fabricByPK.get(fabric.getPK()) == null) {
                _Logger.log((Priority)Level.WARN, (Object)("Unreference switch found: " + sw));
                try {
                    swByFabric.remove(fabric.getPK());
                    if (swByFabric == null || swByFabric.size() == 0) {
                        this._switchByIp.remove(inetAddr);
                    }
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"Close staled switch: ", (Throwable)ex);
                }
                try {
                    fabric.close();
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"Close staled fabric: ", (Throwable)ex);
                }
                return null;
            }
            return fabric;
        }
        return null;
    }

    public FabricImpl findFabric(String swAddr) throws Exception {
        return this.findFabric(InetAddress.getByName(swAddr));
    }

    public FabricPK findFabricPK(InetAddress swIp) {
        FabricImpl f = this.findFabric(swIp);
        return f != null ? f.getPK() : null;
    }

    public VsanImpl findVsan(VsanPK vPK) {
        FabricImpl fabric;
        VsanImpl vsan = null;
        Iterator<FabricImpl> i$ = this._fabricByPK.values().iterator();
        while (i$.hasNext() && (vsan = (fabric = i$.next()).findVsan(vPK)) == null) {
        }
        return vsan;
    }

    public List<FcPortBase> getFcPortsBySwitch(WwnKey swPK, FabricPK fabricPK) {
        if (fabricPK == null || swPK == null) {
            return null;
        }
        SwitchImpl swImpl = this.findSwitch(swPK, fabricPK);
        if (swImpl == null) {
            return null;
        }
        return swImpl.getPorts();
    }

    public List<FcPortBase> findFcPortBase(SwitchBase sw) {
        SwitchImpl swImpl;
        if (sw != null && (swImpl = this.findSwitch(sw.getWwn(), sw.getFabricPK())) != null) {
            return swImpl.getPorts();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchImpl createSwitch(Wwn swwn, InetAddress ip, FabricImpl fabric) {
        ConcurrentHashMap<WwnKey, ConcurrentHashMap<FabricPK, SwitchImpl>> concurrentHashMap = this._switchByWwnKey;
        synchronized (concurrentHashMap) {
            WwnKey swPK = null;
            SwitchImpl sw = null;
            if (swwn != null) {
                swPK = new WwnKey(swwn);
                sw = this.findSwitch(swPK, fabric.getPK());
            }
            if (sw == null && ip != null) {
                sw = this.findSwitch(ip, fabric.getPK());
            }
            if (sw == null) {
                ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric;
                sw = new SwitchImpl(swPK, ip);
                sw.setFabric(fabric);
                if (swPK != null) {
                    swByFabric = this._switchByWwnKey.get(swPK);
                    if (swByFabric == null) {
                        swByFabric = new ConcurrentHashMap();
                    }
                    swByFabric.put(fabric.getPK(), sw);
                    this._switchByWwnKey.put(swPK, swByFabric);
                }
                if (ip != null) {
                    swByFabric = this._switchByIp.get(ip);
                    if (swByFabric == null) {
                        swByFabric = new ConcurrentHashMap();
                    }
                    swByFabric.put(fabric.getPK(), sw);
                    this._switchByIp.put(ip, swByFabric);
                } else if (swwn != null && WwnDictionary.isBrocadeWwn(swwn.getValue())) {
                    sw.getBase().setSysName("Brocade-" + swwn.toHexString(false));
                }
                SanManager.notifyModelObjectCreated(sw);
            }
            return sw;
        }
    }

    public void addSwitchByPK(SwitchImpl sw) {
        if (sw != null && sw.getPK() != null) {
            ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric = this._switchByWwnKey.get(sw.getSwitchPK());
            if (swByFabric == null) {
                swByFabric = new ConcurrentHashMap();
            }
            swByFabric.put(sw.getFabricPK(), sw);
            this._switchByWwnKey.put(sw.getSwitchPK(), swByFabric);
            SanManager.notifyModelObjectCreated(sw);
        }
    }

    public void removeSwitch(SwitchImpl sw) {
        this.removeSwitch(sw, false);
    }

    public void removeSwitch(SwitchImpl sw, boolean cleanCache) {
        FabricImpl fabric;
        if (sw != null) {
            sw.setManageable(false, "Unmanaged");
            sw.clean();
        }
        if ((fabric = sw.getFabric()) == null) {
            return;
        }
        FabricPK fpk = fabric.getPK();
        ConcurrentHashMap<FabricPK, SwitchImpl> swByFabricPK = null;
        if (sw.getSwitchPK() != null) {
            swByFabricPK = this._switchByWwnKey.get(sw.getSwitchPK());
        }
        if (cleanCache) {
            if (swByFabricPK != null) {
                swByFabricPK.remove(fpk);
            }
            if ((swByFabricPK == null || swByFabricPK.size() == 0) && sw.getSwitchPK() != null) {
                this._switchByWwnKey.remove(sw.getSwitchPK());
            }
            if (sw.getInetAddress() != null) {
                swByFabricPK = this._switchByIp.get(sw.getInetAddress());
                if (swByFabricPK != null) {
                    swByFabricPK.remove(fpk);
                }
                if (swByFabricPK == null || swByFabricPK.size() == 0) {
                    this._switchByIp.remove(sw.getInetAddress());
                }
            }
        }
        if (sw.isPeerCreated() && (swByFabricPK == null || swByFabricPK.size() == 0)) {
            EventControllerService ec = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
            ec.delSource(sw);
            if (sw.isTrapRegistered() && sw.isManageableMDS()) {
                try {
                    sw.createPeer().getSession();
                    if (SnmpSession._PreferTcp) {
                        CountDownLatch doneSignal = new CountDownLatch(1);
                        ec.deregisterTrap(sw.createPeer(), doneSignal);
                        doneSignal.await(5L, TimeUnit.SECONDS);
                    } else {
                        ec.deregisterTrap(sw.createPeer());
                    }
                }
                catch (InterruptedException ie) {
                    _Logger.debug((Object)ie.getMessage());
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
            if (sw.isPeerCreated()) {
                try {
                    SnmpPeer.removePeer(sw.createPeer());
                    sw.resetPeer();
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
        SanManager.notifyModelObjectRemoved(sw);
    }

    public void changeSwitchIp(WwnKey swPK, InetAddress inetAddr) throws Exception {
        SwitchImpl sw = this.findSwitch(swPK, null);
        if (sw != null) {
            InetAddress oldAddr = sw.getInetAddress();
            if (oldAddr == null || !oldAddr.toString().equals(inetAddr.toString())) {
                sw.resetPeer();
                sw.setManagementAddressInUse(inetAddr);
                sw.setManagementAddresses(new InetAddress[]{inetAddr});
                sw.setManageable(true, null);
                sw.setDiscFlag(1);
                if (sw.isMDS()) {
                    // empty if block
                }
                Connection con = null;
                try {
                    con = ConnectionManager.getConnection();
                    InventoryPersistentManager.getInstance().persistDBObject(con, sw);
                    InventoryPersistentManager.getInstance().persistSwitchMgmtAddresses(con, sw);
                }
                catch (Exception e) {
                    _Logger.warn((Object)("changeSwitchIp: failed to persist IP address for switch '" + sw.getName() + "'"), (Throwable)e);
                    throw e;
                }
                finally {
                    DbUtil.close(con);
                }
            }
        } else {
            throw new Exception("switch " + swPK.toString() + " cannot be found");
        }
    }

    public SwitchImpl mergeSwitch(SwitchImpl sw, FabricImpl currentFabric) {
        if (sw == null || currentFabric == null) {
            if ((sw == null || currentFabric == null) && _Logger.isDebugEnabled()) {
                _Logger.debug((Object)("SANManager--mergeSwitch: invalid arguement--" + String.valueOf(sw) + ", " + String.valueOf(currentFabric)), (Throwable)new NullPointerException());
            }
            return sw;
        }
        if (sw.getFabric() == null || sw.getFabric() == currentFabric) {
            sw.setFabric(currentFabric);
            return sw;
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("SanManager-- mergeSwitch:" + sw + "-- between switch fabric:" + sw.getFabric() + "-- with current fabric:" + currentFabric));
        }
        Wwn swwn = sw.getWwn();
        InetAddress ip = sw.getInetAddress();
        currentFabric.addDupSwitches(sw);
        sw = this.createSwitch(swwn, ip, currentFabric);
        return sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchIpChanged(SwitchImpl sw, InetAddress[] oldAddrs, InetAddress[] newAddrs) {
        ConcurrentHashMap<InetAddress, ConcurrentHashMap<FabricPK, SwitchImpl>> concurrentHashMap = this._switchByIp;
        synchronized (concurrentHashMap) {
            int i;
            if (oldAddrs != null) {
                for (i = 0; i < oldAddrs.length; ++i) {
                    if (newAddrs != null && GenUtil.linearSearch(newAddrs, oldAddrs[i]) >= 0) continue;
                    this._switchByIp.remove(oldAddrs[i]);
                }
            }
            if (newAddrs != null) {
                for (i = 0; i < newAddrs.length; ++i) {
                    if (oldAddrs != null && GenUtil.linearSearch(oldAddrs, newAddrs[i]) >= 0) continue;
                    ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric = this._switchByIp.get(newAddrs[i]);
                    if (swByFabric == null) {
                        swByFabric = new ConcurrentHashMap();
                    }
                    swByFabric.put(sw.getFabricPK(), sw);
                    this._switchByIp.put(newAddrs[i], swByFabric);
                    SwitchImpl oldSw = null;
                    if (oldSw == null || oldSw == sw) continue;
                    _Logger.warn((Object)(oldSw.getWwn() + " and " + sw.getWwn() + " share the same IP Address " + newAddrs[i].getHostAddress()));
                    if (oldSw.getPK() == null && sw.getPK() != null) continue;
                    if (!oldSw.isManageable()) {
                        _Logger.log((Priority)Level.WARN, (Object)(oldSw + " is removed"));
                        this.purgeSwitch(oldSw);
                        continue;
                    }
                    if (!oldSw.isMDS() || !sw.isMDS()) continue;
                    String oui = Integer.toString(WwnDictionary.getVendorId(sw.getWwn().getValue()), 16);
                    String str = "Switch IP changed: please add 0x" + oui + " to server.properties: newOUIs=";
                    LogEvent e = new LogEvent((Object)sw.getFabric().getPK(), LogEventType.OTHER, Severity.WARNING, sw.getFabric().getPK().getName(), str, sw.getFabric().getDBID());
                    ((EventLoggerService)ServiceConfig.findService((String)"Event Logger Service")).logEvent(e);
                    _Logger.warn((Object)str);
                }
                SanManager.notifyModelObjectCreated(sw);
            }
        }
    }

    public SwitchImpl findSwitchByIP(InetAddress ipAddr) {
        FabricPK[] pks = SanManager.getInstance().getFabricPKs();
        SwitchImpl sw = null;
        for (FabricPK fKey : pks) {
            sw = SanManager.getInstance().findSwitch(ipAddr, fKey);
            if (sw == null) continue;
            return sw;
        }
        return null;
    }

    public SwitchImpl findSwitchByPK(WwnKey swPK) {
        FabricPK[] pks = SanManager.getInstance().getFabricPKs();
        SwitchImpl sw = null;
        for (FabricPK fKey : pks) {
            sw = SanManager.getInstance().findSwitch(swPK, fKey);
            if (sw == null) continue;
            return sw;
        }
        return null;
    }

    public SwitchImpl[] findSwitches(WwnKey swPK) {
        if (swPK == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> swByFabricPK = this._switchByWwnKey.get(swPK);
        if (swByFabricPK == null) {
            return null;
        }
        SwitchImpl[] sws = swByFabricPK.values().toArray(new SwitchImpl[swByFabricPK.size()]);
        return sws;
    }

    public SwitchImpl findSwitch(WwnKey swPK, FabricPK fPk) {
        if (swPK == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> switchByFabricPK = this._switchByWwnKey.get(swPK);
        if (switchByFabricPK == null) {
            return null;
        }
        if (fPk == null) {
            SwitchImpl[] sws = switchByFabricPK.values().toArray(new SwitchImpl[switchByFabricPK.size()]);
            return sws[0];
        }
        return switchByFabricPK.get(fPk);
    }

    public SwitchImpl findSwitchByPK(WwnKey swPK, FabricImpl fabric) {
        if (swPK == null || fabric == null) {
            return null;
        }
        if (fabric.isVsanScoped()) {
            return this.findSwitch(swPK, fabric.getPK());
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> switchByFabricPK = this._switchByWwnKey.get(swPK);
        if (switchByFabricPK == null) {
            return null;
        }
        SwitchImpl sw = switchByFabricPK.get(fabric.getPK());
        if (sw != null) {
            return sw;
        }
        for (FabricPK fPk : switchByFabricPK.keySet()) {
            FabricImpl fImpl = this.findFabric(fPk);
            if (fImpl == null || fImpl.isVsanScoped()) continue;
            return switchByFabricPK.get(fPk);
        }
        return null;
    }

    public SwitchImpl findSwitch(InetAddress ipAddr, FabricPK fPk) {
        if (ipAddr == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, SwitchImpl> switchByFabricPK = this._switchByIp.get(ipAddr);
        if (fPk == null) {
            if (switchByFabricPK == null) {
                return null;
            }
            SwitchImpl[] sws = switchByFabricPK.values().toArray(new SwitchImpl[switchByFabricPK.size()]);
            return sws[0];
        }
        if (switchByFabricPK != null) {
            return switchByFabricPK.get(fPk);
        }
        return null;
    }

    public SwitchImpl findSwitch(Wwn wwn, FabricPK fPk) {
        if (wwn == null || fPk == null) {
            return null;
        }
        return this.findSwitch(new WwnKey(wwn), fPk);
    }

    public SwitchImpl findSwitch(Wwn wwn, boolean includeVsanWwns) {
        return null;
    }

    public String findSwitchIpByPK(WwnKey swPK, FabricPK fPk) {
        SwitchImpl sw = this.findSwitch(swPK, fPk);
        return sw == null ? null : sw.getIpAddress();
    }

    public String findSwitchIpBySysName(String swName) {
        if (swName == null) {
            return null;
        }
        for (ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric : this._switchByWwnKey.values()) {
            for (SwitchImpl sw0 : swByFabric.values()) {
                String sysName = sw0.getSysName();
                if (sysName == null || !sysName.equals(swName)) continue;
                return sw0.getIpAddress();
            }
        }
        return swName;
    }

    public SwitchImpl[] getSwitches() {
        Iterator<ConcurrentHashMap<FabricPK, SwitchImpl>> itr = this._switchByWwnKey.values().iterator();
        ArrayList<SwitchImpl> switchList = new ArrayList<SwitchImpl>();
        while (itr.hasNext()) {
            ConcurrentHashMap<FabricPK, SwitchImpl> map = itr.next();
            switchList.addAll(map.values());
        }
        Collections.sort(switchList);
        return switchList.toArray(new SwitchImpl[0]);
    }

    public SwitchImpl[] getNonNpvSwitches() {
        ArrayList<SwitchImpl> results = new ArrayList<SwitchImpl>();
        for (ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric : this._switchByWwnKey.values()) {
            for (SwitchImpl sw : swByFabric.values()) {
                if (sw.isNpvEnabled()) continue;
                results.add(sw);
            }
        }
        Collections.sort(results);
        return results.toArray(new SwitchImpl[results.size()]);
    }

    public SwitchImpl[] getSwitchesForFabric(FabricPK fpk) {
        ArrayList<SwitchImpl> results = new ArrayList<SwitchImpl>();
        for (ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric : this._switchByWwnKey.values()) {
            for (SwitchImpl sw : swByFabric.values()) {
                if (!sw.getFabricPK().equals(fpk)) continue;
                results.add(sw);
            }
        }
        Collections.sort(results);
        return results.toArray(new SwitchImpl[results.size()]);
    }

    public SwitchImpl[] getSwitchesByIpForFabric(FabricPK fpk) {
        ArrayList<SwitchImpl> results = new ArrayList<SwitchImpl>();
        for (ConcurrentHashMap<FabricPK, SwitchImpl> swByFabric : this._switchByIp.values()) {
            for (SwitchImpl sw : swByFabric.values()) {
                if (!sw.getFabricPK().equals(fpk)) continue;
                results.add(sw);
            }
        }
        Collections.sort(results);
        return results.toArray(new SwitchImpl[results.size()]);
    }

    public SwitchImpl[] findAttachedSwitches(SwitchImpl sw) {
        HashSet<SwitchImpl> sws = new HashSet<SwitchImpl>();
        IslImpl[] isls = sw.getFabric().getIsls();
        for (int i = 0; i < isls.length; ++i) {
            IslImpl isl = isls[i];
            if (isl.getSwitch1() == sw) {
                sws.add(isl.getSwitch2());
                continue;
            }
            if (isl.getSwitch2() != sw) continue;
            sws.add(isl.getSwitch1());
        }
        return sws.size() == 0 ? null : sws.toArray(new SwitchImpl[sws.size()]);
    }

    public List findSubFabrics(FabricImpl fabric) {
        ArrayList<HashSet> list = new ArrayList<HashSet>();
        IslImpl[] isls = fabric.getIsls();
        for (int i = 0; i < isls.length; ++i) {
            IslImpl isl = isls[i];
            SwitchImpl sw1 = isl.getSwitch1();
            SwitchImpl sw2 = isl.getSwitch2();
            HashSet h1 = null;
            HashSet h2 = null;
            for (HashSet h : list) {
                if (h.contains(sw1)) {
                    h1 = h;
                    continue;
                }
                if (!h.contains(sw2)) continue;
                h2 = h;
            }
            if (h1 != null) {
                if (h2 != null) {
                    if (h1 == h2) continue;
                    h1.addAll(h2);
                    list.remove(h2);
                    continue;
                }
                h1.add(sw2);
                continue;
            }
            if (h2 != null) {
                h2.add(sw1);
                continue;
            }
            HashSet<SwitchImpl> h = new HashSet<SwitchImpl>();
            h.add(sw1);
            h.add(sw2);
            list.add(h);
        }
        SwitchImpl[] sws = fabric.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            HashSet h = null;
            for (HashSet hh : list) {
                if (!hh.contains(sws[i])) continue;
                h = hh;
                break;
            }
            if (h != null) continue;
            h = new HashSet();
            h.add(sws[i]);
            list.add(h);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPortImpl createEndPort(Wwn pwwn, Wwn nwwn, int[] fc4Type, byte[] fc4Features, FabricImpl fabric) {
        WwnKey epPK = new WwnKey(pwwn);
        ConcurrentHashMap<WwnKey, ConcurrentHashMap<FabricPK, EndPortImpl>> concurrentHashMap = this._endportByWwnKey;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<FabricPK, EndPortImpl> epByFabric = this._endportByWwnKey.get(epPK);
            EndPortImpl ep = null;
            if (epByFabric == null) {
                epByFabric = new ConcurrentHashMap();
            } else if (fabric != null) {
                ep = epByFabric.get(fabric.getPK());
            }
            if (ep == null) {
                ep = new EndPortImpl(epPK, nwwn, fc4Type, fc4Features);
                if (fabric != null) {
                    ep.setFabric(fabric);
                    this._endportByWwnKey.put(epPK, epByFabric);
                    epByFabric.put(fabric.getPK(), ep);
                    fabric.modelObjectAdded(ep);
                }
            }
            return ep;
        }
    }

    public ArrayList<EndPortImpl> findEndPortByFWwn(Wwn fwwn) {
        if (fwwn == null) {
            return null;
        }
        ArrayList<EndPortImpl> list = new ArrayList<EndPortImpl>();
        for (ConcurrentHashMap<FabricPK, EndPortImpl> epByFabricPK : this._endportByWwnKey.values()) {
            if (epByFabricPK == null) break;
            for (EndPortImpl ep : epByFabricPK.values()) {
                if (Arrays.equals(fwwn.getValue(), ep.getfWwn())) {
                    list.add(ep);
                    continue;
                }
                if (ep.getNumVsans() <= 1) continue;
                VsanFportKey[] fPorts = ep.getVsanFports();
                for (int i = 0; fPorts != null && i < fPorts.length; ++i) {
                    if (!Arrays.equals(fwwn.getValue(), fPorts[i]._fwwn.getValue())) continue;
                    list.add(ep);
                }
            }
        }
        return list;
    }

    public EndPortImpl findEndPort(Wwn pwwn, FabricPK fPK) {
        if (pwwn == null || fPK == null) {
            return null;
        }
        return this.findEndPort(new WwnKey(pwwn), fPK);
    }

    public EndPortImpl findEndPort(WwnKey epPK, FabricPK fPK) {
        if (epPK == null || fPK == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, EndPortImpl> endPortByFabricPK = this._endportByWwnKey.get(epPK);
        if (endPortByFabricPK != null) {
            return endPortByFabricPK.get(fPK);
        }
        return null;
    }

    public EndPortImpl[] findEndPorts(WwnKey epPK) {
        if (epPK == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, EndPortImpl> endPortByFabricPK = this._endportByWwnKey.get(epPK);
        if (endPortByFabricPK != null) {
            return endPortByFabricPK.values().toArray(new EndPortImpl[endPortByFabricPK.size()]);
        }
        return null;
    }

    public EndPortImpl[] findEndPorts(Wwn pwwn) {
        if (pwwn == null) {
            return null;
        }
        WwnKey epPK = new WwnKey(pwwn);
        return this.findEndPorts(epPK);
    }

    public EndPortImpl findEndPort(Wwn pwwn) {
        if (pwwn == null) {
            return null;
        }
        WwnKey epPK = new WwnKey(pwwn);
        return this.findEndPort(epPK);
    }

    public EndPortImpl findEndPortByWwn(Wwn pwwn) {
        return this.findEndPort(pwwn);
    }

    public EndPortImpl findEndPortByPK(WwnKey epPK) {
        return this.findEndPort(epPK);
    }

    public EndPortImpl findEndPort(WwnKey epPK) {
        EndPortImpl ret = null;
        EndPortImpl[] eps = this.findEndPorts(epPK);
        if (eps != null && eps.length > 0) {
            ret = eps[0];
            for (EndPortImpl epi : eps) {
                if (epi.getFabricPK() == null || !epi.isPresent()) continue;
                ret = epi;
                break;
            }
        }
        return ret;
    }

    public ArrayList<EndPortImpl> findEndportsBySwitchIfIndex(FabricPK fPK, WwnKey swPK, int ifindex) {
        if (fPK == null || swPK == null || ifindex < 0) {
            return new ArrayList<EndPortImpl>();
        }
        SwitchIntKey key = new SwitchIntKey(swPK, ifindex);
        ConcurrentHashMap<FabricPK, Set<EndPortImpl>> epsetByfPK = this._endportsBySwIntKey.get(key);
        if (epsetByfPK == null) {
            return new ArrayList<EndPortImpl>();
        }
        Set<EndPortImpl> epset = epsetByfPK.get(fPK);
        if (epset == null) {
            return new ArrayList<EndPortImpl>();
        }
        return new ArrayList<EndPortImpl>(epset);
    }

    public EndPortImpl findEndPort(String alias, FabricPK fpk) {
        EndPortImpl[] resultList = this.findEndPorts(fpk);
        if (resultList == null) {
            return null;
        }
        for (int i = 0; i < resultList.length; ++i) {
            String da = resultList[i].getDeviceAlias();
            if (da == null || !da.equals(alias)) continue;
            return resultList[i];
        }
        return null;
    }

    public EndPortImpl[] findEndPorts(FabricPK fpk) {
        ArrayList<EndPortImpl> resultList = new ArrayList<EndPortImpl>();
        Collection<ConcurrentHashMap<FabricPK, EndPortImpl>> tmpList = this._endportByWwnKey.values();
        for (ConcurrentHashMap<FabricPK, EndPortImpl> fabricEndPort : tmpList) {
            Collection<EndPortImpl> endPorts = fabricEndPort.values();
            for (EndPortImpl endPort : endPorts) {
                if (endPort.getFabricPK() == null || !endPort.getFabricPK().equals(fpk)) continue;
                resultList.add(endPort);
            }
        }
        return resultList.toArray(new EndPortImpl[resultList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEPSwIntKeyTableWithAdd(EndPortImpl ep) {
        if (ep == null || ep.getFabricPK() == null) {
            return;
        }
        SwitchIntKey key = ep.getSwitchIntKey();
        if (key != null) {
            Map<SwitchIntKey, ConcurrentHashMap<FabricPK, Set<EndPortImpl>>> map = this._endportsBySwIntKey;
            synchronized (map) {
                ConcurrentHashMap<FabricPK, Set<EndPortImpl>> epByfPK = this._endportsBySwIntKey.get(key);
                if (epByfPK == null) {
                    epByfPK = new ConcurrentHashMap();
                }
                Set<EndPortImpl> epset = null;
                if (ep.getFabricPK() != null) {
                    epset = epByfPK.get(ep.getFabricPK());
                }
                if (epset == null) {
                    epset = new HashSet<EndPortImpl>();
                    epByfPK.put(ep.getFabricPK(), epset);
                }
                epset.add(ep);
                this._endportsBySwIntKey.put(key, epByfPK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEPSwIntKeyTableWithRemove(EndPortImpl ep) {
        if (ep == null) {
            return;
        }
        SwitchIntKey key = ep.getSwitchIntKey();
        if (key != null) {
            Map<SwitchIntKey, ConcurrentHashMap<FabricPK, Set<EndPortImpl>>> map = this._endportsBySwIntKey;
            synchronized (map) {
                ConcurrentHashMap<FabricPK, Set<EndPortImpl>> epByfPK = this._endportsBySwIntKey.get(key);
                if (epByfPK == null) {
                    return;
                }
                Set<EndPortImpl> epset = epByfPK.get(ep.getFabricPK());
                if (epset != null) {
                    epset.remove(ep);
                    if (epset.size() == 0) {
                        this._endportsBySwIntKey.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEPTableWithAdd(EndPortImpl ep) {
        if (ep == null || ep.getFabricPK() == null) {
            return;
        }
        WwnKey key = ep.getEndPortPK();
        if (key != null) {
            ConcurrentHashMap<WwnKey, ConcurrentHashMap<FabricPK, EndPortImpl>> concurrentHashMap = this._endportByWwnKey;
            synchronized (concurrentHashMap) {
                ConcurrentHashMap<FabricPK, EndPortImpl> epByfPK = this._endportByWwnKey.get(key);
                if (epByfPK == null) {
                    epByfPK = new ConcurrentHashMap();
                }
                epByfPK.put(ep.getFabricPK(), ep);
                this._endportByWwnKey.put(key, epByfPK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEPTableWithRemove(EndPortImpl ep) {
        if (ep == null || ep.getFabricPK() == null) {
            return;
        }
        WwnKey key = ep.getEndPortPK();
        if (key != null) {
            ConcurrentHashMap<WwnKey, ConcurrentHashMap<FabricPK, EndPortImpl>> concurrentHashMap = this._endportByWwnKey;
            synchronized (concurrentHashMap) {
                ConcurrentHashMap<FabricPK, EndPortImpl> epByfPK = this._endportByWwnKey.get(key);
                if (epByfPK == null) {
                    return;
                }
                epByfPK.remove(ep.getFabricPK());
                if (epByfPK.isEmpty()) {
                    this._endportByWwnKey.remove(key);
                }
            }
        }
    }

    public EndPortImpl[] getEndPorts() {
        ArrayList<EndPortImpl> resultList = new ArrayList<EndPortImpl>();
        Collection<ConcurrentHashMap<FabricPK, EndPortImpl>> tmpList = this._endportByWwnKey.values();
        for (ConcurrentHashMap<FabricPK, EndPortImpl> fabricEndPort : tmpList) {
            Collection<EndPortImpl> endPorts = fabricEndPort.values();
            for (EndPortImpl endPort : endPorts) {
                resultList.add(endPort);
            }
        }
        return resultList.toArray(new EndPortImpl[resultList.size()]);
    }

    public void removeEndPort(EndPortImpl ep) {
        if (ep != null) {
            this.updateEPTableWithRemove(ep);
            this.updateEPSwIntKeyTableWithRemove(ep);
            ep.disconnect();
            SanManager.notifyModelObjectRemoved(ep);
        }
    }

    public void deleteEndPort(EndPortImpl ep, FabricImpl fabric) {
        if (ep == null) {
            return;
        }
        this.updateEPTableWithRemove(ep);
        this.updateEPSwIntKeyTableWithRemove(ep);
        if (fabric != null) {
            fabric.deleteEndPort(ep);
        } else {
            ep.disconnect();
            try {
                InventoryPersistentManager.getInstance().purgeEndPort(ep);
            }
            catch (Exception e) {
                _Logger.warn((Object)("Cannot purge the endport from DB:" + ep));
            }
        }
        SanManager.notifyModelObjectRemoved(ep);
    }

    public void removeEndPorts(Collection eps) {
        if (eps != null) {
            for (Object obj : eps) {
                if (!(obj instanceof EndPortImpl)) continue;
                EndPortImpl ep = (EndPortImpl)obj;
                this.updateEPTableWithRemove(ep);
                this.updateEPSwIntKeyTableWithRemove(ep);
                ep.disconnect();
                EnclosureImpl enc = ep.getEnclosure();
                if (enc != null) {
                    enc.dereferenceEndPort(ep);
                }
                SanManager.notifyModelObjectRemoved(ep);
            }
        }
    }

    public List findAttachedEndPorts(SwitchImpl sw) {
        short[] vids = sw.getVsanIds();
        ArrayList<EndPortImpl> ports = new ArrayList<EndPortImpl>();
        for (int i = 0; i < vids.length; ++i) {
            VsanImpl v = sw.getVsan(vids[i]);
            if (v == null) continue;
            for (EndPortImpl ep : v.getEndPorts()) {
                if (ep.getSwitch() != sw) continue;
                ports.add(ep);
            }
        }
        return ports.size() != 0 ? ports : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostClusterImpl createHostCluster(String name) {
        ConcurrentHashMap<NameKey, HostClusterImpl> concurrentHashMap = this._hostClusterByNameKey;
        synchronized (concurrentHashMap) {
            HostClusterImpl hostCluster = this.findHostClusterByName(name);
            if (hostCluster == null) {
                hostCluster = new HostClusterImpl(name);
                this._hostClusterByNameKey.put(hostCluster.getClusterPK(), hostCluster);
            }
            return hostCluster;
        }
    }

    public HostClusterImpl[] getHostClusters() {
        return this._hostClusterByNameKey.values().toArray(new HostClusterImpl[this._hostClusterByNameKey.size()]);
    }

    public HostClusterImpl findHostClusterByPK(NameKey pkey) {
        return pkey == null ? null : this._hostClusterByNameKey.get(pkey);
    }

    public HostClusterImpl findHostClusterByName(String name) {
        return this.findHostClusterByPK(new NameKey(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnclosureImpl createEnclosure(String name, InetAddress ipAddress, boolean isVirtual) {
        ConcurrentHashMap<NameKey, EnclosureImpl> concurrentHashMap = this._enclByNameKey;
        synchronized (concurrentHashMap) {
            EnclosureImpl enc = this.findEnclosureByName(name);
            if (enc == null) {
                enc = new EnclosureImpl(name, ipAddress, isVirtual);
                this._enclByNameKey.put(enc.getEnclosurePK(), enc);
            }
            return enc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnclosure(EnclosureImpl enc) {
        ConcurrentHashMap<NameKey, EnclosureImpl> concurrentHashMap = this._enclByNameKey;
        synchronized (concurrentHashMap) {
            this._enclByNameKey.put(enc.getEnclosurePK(), enc);
        }
    }

    public EnclosureImpl[] getEnclosures() {
        return this._enclByNameKey.values().toArray(new EnclosureImpl[this._enclByNameKey.size()]);
    }

    public EnclosureImpl findEnclosureByPK(NameKey pkey) {
        return pkey == null ? null : this._enclByNameKey.get(pkey);
    }

    public EnclosureImpl findEnclosureByName(String name) {
        return this.findEnclosureByPK(new NameKey(name));
    }

    public EnclosureImpl findEnclosureByPortWwn(Wwn pwwn) {
        if (pwwn == null) {
            return null;
        }
        ConcurrentHashMap<FabricPK, EndPortImpl> epByFPK = this._endportByWwnKey.get(new WwnKey(pwwn));
        if (epByFPK == null) {
            return null;
        }
        EnclosureImpl enc = null;
        for (EndPortImpl ep : epByFPK.values()) {
            enc = ep.getEnclosure();
            if (enc == null) continue;
            return enc;
        }
        return null;
    }

    public void changeEnclosureName(EnclosureImpl encl, String newName) {
        if (newName == null || encl == null) {
            return;
        }
        if (!encl.getEnclosureName().equals(newName)) {
            PKIf oldKey = encl.getPK();
            encl.setEnclosureName(newName);
            this._enclByNameKey.remove(oldKey);
            this._enclByNameKey.put(encl.getEnclosurePK(), encl);
        }
    }

    public void cleanEnclosure() {
        List<EnclosureImpl> list = EnclosureImpl.findObsoleteEnclosures();
        for (EnclosureImpl encl : list) {
            try {
                this.removeEnclosure(encl.getEnclosurePK());
            }
            catch (Exception ex) {
                _Logger.debug((Object)("cleanEnclosure: " + ex.getMessage()));
            }
            try {
                InventoryPersistentManager.getInstance().deleteDBObject(encl);
            }
            catch (SQLException e) {
                _Logger.error((Object)"cleanEnclosure", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnclosure(NameKey encPK, String newEncName, String ipAddress, String dmPath, int type, String vendor, String model, String version, String osInfo) throws Exception {
        EnclosureImpl enc;
        if (encPK == null) {
            enc = this.createEnclosure(newEncName, InetAddress.getByName(ipAddress), true);
        } else {
            enc = this.findEnclosureByPK(new NameKey(newEncName));
            if (enc == null) {
                enc = this.findEnclosureByPK(encPK);
            } else {
                EnclosureImpl encSource = this.findEnclosureByPK(encPK);
                ArrayList<EndPortImpl> eps = null;
                if (encSource != null && encSource.getEndPorts() != null && !encSource.getEndPorts().isEmpty()) {
                    eps = new ArrayList<EndPortImpl>(encSource.getEndPorts().size());
                    eps.addAll(encSource.getEndPorts());
                    for (EndPortImpl ep : eps) {
                        ep.setEnclosure(enc);
                    }
                }
            }
            if (enc == null) {
                throw new Exception("enclosure " + encPK._name + " not found");
            }
            this.changeEnclosureName(enc, newEncName);
            enc.setIpAddress(ipAddress);
        }
        enc.setDMPath(dmPath);
        enc.setType(type);
        enc.setVendor(vendor);
        enc.setModel(model);
        enc.setVersion(version);
        enc.setOSInfo(osInfo);
        InventoryPersistentManager.getInstance().persistDBObject(enc);
        long fId = 0L;
        if (enc.getEndPorts() != null && !enc.getEndPorts().isEmpty() && (fId = enc.getEndPorts().get(0).getFabric().getDBID()) > 0L) {
            HostManager.getInstance().persistEnclosureHosts(fId);
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            StorageEnclosureImpl.persistStorageEnclosures(con);
        }
        catch (Exception e) {
            _Logger.info((Object)("updateEnclosure: failed to update storage enclosure. " + e.getMessage()));
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnclosure(NameKey encPK, String newEncName, String ipAddress, String dmPath, int type, String vendor, String model, String version) throws Exception {
        EnclosureImpl enc;
        if (encPK == null) {
            enc = this.createEnclosure(newEncName, InetAddress.getByName(ipAddress), true);
        } else {
            enc = this.findEnclosureByPK(new NameKey(newEncName));
            if (enc == null) {
                enc = this.findEnclosureByPK(encPK);
            } else {
                EnclosureImpl encSource = this.findEnclosureByPK(encPK);
                ArrayList<EndPortImpl> eps = null;
                if (encSource != null && encSource.getEndPorts() != null && !encSource.getEndPorts().isEmpty()) {
                    eps = new ArrayList<EndPortImpl>(encSource.getEndPorts().size());
                    eps.addAll(encSource.getEndPorts());
                    for (EndPortImpl ep : eps) {
                        ep.setEnclosure(enc);
                    }
                }
            }
            if (enc == null) {
                throw new Exception("enclosure " + encPK._name + " not found");
            }
            this.changeEnclosureName(enc, newEncName);
            enc.setIpAddress(ipAddress);
        }
        enc.setDMPath(dmPath);
        enc.setType(type);
        enc.setVendor(vendor);
        enc.setModel(model);
        enc.setVersion(version);
        InventoryPersistentManager.getInstance().persistDBObject(enc);
        long fId = 0L;
        if (enc.getEndPorts() != null && !enc.getEndPorts().isEmpty() && (fId = enc.getEndPorts().get(0).getFabric().getDBID()) > 0L) {
            HostManager.getInstance().persistEnclosureHosts(fId);
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            StorageEnclosureImpl.persistStorageEnclosures(con);
        }
        catch (Exception e) {
            _Logger.info((Object)("updateEnclosure: failed to update storage enclosure. " + e.getMessage()));
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void removeEnclosure(NameKey encPK) throws Exception {
        EnclosureImpl enc = this.findEnclosureByPK(encPK);
        if (enc == null) {
            throw new Exception("enclosure " + encPK._name + " not found");
        }
        ArrayList<EndPortImpl> eps = null;
        if (enc.getEndPorts() != null && !enc.getEndPorts().isEmpty()) {
            eps = new ArrayList<EndPortImpl>(enc.getEndPorts().size());
            eps.addAll(enc.getEndPorts());
            for (EndPortImpl ep : eps) {
                ep.setEnclosure(null);
            }
        }
        this._enclByNameKey.remove(encPK);
    }

    public void updateEndPortEnclosure(WwnKey epPK, NameKey encPK) throws Exception {
    }

    public void updateEndPortEnclosure(FabricPK fpk, WwnKey epPK, NameKey encPK) throws Exception {
        EndPortImpl ep = this.findEndPort(epPK, fpk);
        if (ep == null) {
            throw new Exception("Endport not found in fabric.");
        }
        EnclosureImpl enc = null;
        if (encPK == null) {
            EnclosureImpl oldEnc = ep.getEnclosure();
            if (oldEnc != null) {
                this.removeEnclosure(oldEnc.getEnclosurePK());
                InventoryPersistentManager.getInstance().deleteDBObject(oldEnc);
            }
            ep.setEnclosure(null);
        } else {
            enc = this.findEnclosureByPK(encPK);
            if (enc == null) {
                enc = this.createEnclosure(encPK._name, null, true);
                EnclosureImpl oldEnc = ep.getEnclosure();
                if (oldEnc != null && oldEnc.getEndPorts() != null && oldEnc.getEndPorts().size() == 1) {
                    this.removeEnclosure(oldEnc.getEnclosurePK());
                    InventoryPersistentManager.getInstance().deleteDBObject(oldEnc);
                }
            }
            ep.setEnclosure(enc);
        }
        if (enc != null) {
            InventoryPersistentManager.getInstance().persistDBObject(enc);
        }
        InventoryPersistentManager.getInstance().persistDBObject(ep);
    }

    public VirtualMachine[] findVirtualMachinesByEnclosurePK(NameKey pkey) {
        EnclosureImpl encl = this.findEnclosureByPK(pkey);
        if (encl == null) {
            return null;
        }
        List<VmImpl> vmList = encl.getVms();
        if (vmList == null || vmList.size() == 0) {
            return null;
        }
        ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>(vmList.size());
        for (VmImpl vm : vmList) {
            vms.add((VirtualMachine)vm.getBaseObject());
        }
        return vms.toArray(new VirtualMachine[vms.size()]);
    }

    public ClusterImpl findCluster(ClusterPK cPK) {
        FabricImpl fabric;
        ClusterImpl cluster = null;
        Iterator<FabricImpl> i$ = this._fabricByPK.values().iterator();
        while (i$.hasNext() && (cluster = (fabric = i$.next()).findCluster(cPK)) == null) {
        }
        return cluster;
    }

    public ClusterImpl[] findClusters(FabricPK pkey) {
        FabricImpl fabric = this.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        return fabric.getClusters();
    }

    void purge() {
    }

    public static void addListener(ModelEventListenerIf listener) {
        SanManager.addListener(listener, false);
    }

    public static void addListener(ModelEventListenerIf listener, boolean needLog) {
        if (!needLog) {
            _Plisteners.add(listener);
        }
        _Listeners.add(listener);
    }

    public void notifyFabricDiscovered(FabricImpl fabric) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricDiscovered(fabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricOpened:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricOpened(FabricImpl fabric) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricOpened(fabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricOpened:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricOpenedNoLog(FabricImpl fabric) {
        for (ModelEventListenerIf lis : _Plisteners) {
            try {
                lis.fabricOpened(fabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricOpened:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricClosed(FabricImpl fabric) {
        if (fabric != null) {
            SanManager.notifyFabricClosed(fabric.getPK());
        }
    }

    static void notifyFabricClosedLog(FabricImpl fabric) {
        if (fabric != null) {
            SanManager.notifyFabricClosedLog(fabric.getPK());
        }
    }

    static void notifyFabricClosed(FabricPK fpk) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricClosed(fpk);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricClosed:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricClosedLog(FabricPK fpk) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricClosed(fpk);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricClosed:", (Throwable)ex);
            }
        }
    }

    public void notifyFabricRemoved(FabricImpl fabric) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricRemoved(fabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricOpened:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricMerged(mergerFabric, mergeePK);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricMerged:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricSplit(origFabric, newFabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricSplit:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricEmptied(FabricImpl fabric) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricEmptied(fabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricEmptied:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricRediscovered(FabricImpl fabric) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.fabricRediscovered(fabric);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricRediscovered:", (Throwable)ex);
            }
        }
    }

    static void notifyMembersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
        SanManager.notifyMembersAdded(fabric, mos, true);
    }

    static void notifyMembersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos, boolean needlog) {
        if (needlog) {
            for (ModelEventListenerIf lis : _Listeners) {
                try {
                    lis.membersAdded(fabric, mos);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyMembersAdded:", (Throwable)ex);
                }
            }
        } else {
            for (ModelEventListenerIf lis : _Plisteners) {
                try {
                    lis.membersAdded(fabric, mos);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyMembersAdded:", (Throwable)ex);
                }
            }
        }
        SanManager.autoRegistation(fabric, mos);
    }

    static void notifyDBObjectPurged(long dbid) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.dbObjectPurged(dbid);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("notifyDBObjectPurged:" + dbid), (Throwable)ex);
            }
        }
    }

    private static void autoRegistation(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
        boolean autoReg;
        boolean bl = autoReg = Boolean.valueOf(System.getProperty("trap.listen", "true")) != false && Boolean.valueOf(System.getProperty("trap.autoregistration", "true")) != false;
        if (!fabric.isInitialDiscovery() && autoReg) {
            for (int i = 0; i < mos.length; ++i) {
                SwitchImpl sw;
                if (!(mos[i] instanceof SwitchImpl) || (sw = (SwitchImpl)mos[i]).isTrapRegistered() || !sw.isManageableMDS()) continue;
                try {
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).registerTrap(sw.createPeer());
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
    }

    static void notifyMembersRemoved(FabricImpl fabric, PKIf[] pks) {
        SanManager.notifyMembersRemoved(fabric, pks, true);
    }

    static void notifyMembersRemoved(FabricImpl fabric, PKIf[] pks, boolean needlog) {
        if (needlog) {
            for (ModelEventListenerIf lis : _Listeners) {
                try {
                    lis.membersRemoved(fabric, pks);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyMembersRemoved:", (Throwable)ex);
                }
            }
        } else {
            for (ModelEventListenerIf lis : _Plisteners) {
                try {
                    lis.membersRemoved(fabric, pks);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyMembersRemoved:", (Throwable)ex);
                }
            }
        }
        SanManager.autoDeregister(fabric, pks);
    }

    private static void autoDeregister(FabricImpl fabric, PKIf[] pks) {
        if (!fabric.isInitialDiscovery()) {
            for (int i = 0; i < pks.length; ++i) {
                SwitchImpl sw;
                if (!(pks[i] instanceof WwnKey) || (sw = SanManager.getInstance().findSwitch((WwnKey)pks[i], fabric.getPK())) == null || !sw.isTrapRegistered() || !sw.isManageableMDS()) continue;
                try {
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).deregisterTrap(sw.createPeer());
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
    }

    static void notifyMembersChanged(FabricImpl fabric, ChangedModelObject[] mos) {
        SanManager.notifyMembersChanged(fabric, mos, true);
    }

    static void notifyMembersChanged(FabricImpl fabric, ChangedModelObject[] mos, boolean needlog) {
        if (needlog) {
            for (ModelEventListenerIf lis : _Listeners) {
                try {
                    lis.membersChanged(fabric, mos);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyMembersChanged:", (Throwable)ex);
                }
            }
        } else {
            for (ModelEventListenerIf lis : _Plisteners) {
                try {
                    lis.membersChanged(fabric, mos);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyMembersChanged:", (Throwable)ex);
                }
            }
        }
    }

    static void notifyMembersMoved(FabricImpl fabric, MovedModelObject[] mos) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.membersMoved(fabric, mos);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersMoved:", (Throwable)ex);
            }
        }
    }

    static void notifyMembersPurged(FabricImpl fabric, PKIf[] pks) {
        for (ModelEventListenerIf lis : _Listeners) {
            try {
                lis.memberPurged(fabric, pks);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersPurged:", (Throwable)ex);
            }
        }
    }

    static void notifyModelObjectCreated(AbstractModelObjectImpl mo) {
        SanManager.notifyModelObjectCreated(mo, true);
    }

    static void notifyModelObjectCreated(AbstractModelObjectImpl mo, boolean needlog) {
        if (needlog) {
            for (ModelEventListenerIf lis : _Listeners) {
                try {
                    lis.modelObjectCreated(mo);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyModelObjectCreated:", (Throwable)ex);
                }
            }
        } else {
            for (ModelEventListenerIf lis : _Plisteners) {
                try {
                    lis.modelObjectCreated(mo);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyModelObjectCreated:", (Throwable)ex);
                }
            }
        }
    }

    static void notifyModelObjectRemoved(AbstractModelObjectImpl mo) {
        SanManager.notifyModelObjectRemoved(mo, true);
    }

    static void notifyModelObjectRemoved(AbstractModelObjectImpl mo, boolean needlog) {
        if (needlog) {
            for (ModelEventListenerIf lis : _Listeners) {
                try {
                    lis.modelObjectRemoved(mo);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyModelObjectRemoved:", (Throwable)ex);
                }
            }
        } else {
            for (ModelEventListenerIf lis : _Plisteners) {
                try {
                    lis.modelObjectRemoved(mo);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyModelObjectRemoved:", (Throwable)ex);
                }
            }
        }
    }

    public String dumpHashes() {
        Field[] flds;
        StringBuilder sb = new StringBuilder();
        for (Field field : flds = this.getClass().getDeclaredFields()) {
            try {
                Object o = field.get(this);
                if (!(o instanceof Map)) continue;
                String name = field.getName();
                Map map = (Map)o;
                sb.append('\n');
                if (name.charAt(0) == '_') {
                    sb.append(name.substring(1));
                } else {
                    sb.append(name);
                }
                sb.append(": ");
                if (map == null) {
                    sb.append("none");
                } else {
                    sb.append(map.size());
                    Set s = map.entrySet();
                    for (Map.Entry ent : s) {
                        sb.append("\n\tkey=").append(ent.getKey()).append(" \tvalue=").append(ent.getValue());
                    }
                }
                sb.append('\n');
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void purgeFabric(FabricImpl fabric) throws Exception {
        long fDbid = fabric.getDBID();
        if (fabric == null) {
            return;
        }
        this.closeFabric(fabric, true, true);
        try {
            InventoryPersistentManager.purgeFabric(fabric);
            SanManager.notifyDBObjectPurged(fDbid);
            ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fabric.getPK(), IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fabric.getPK().toString() + "' removed", Severity.INFO.getValue(), 0));
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("purge fabric " + fabric), (Throwable)ex);
            throw ex;
        }
        this.notifyFabricRemoved(fabric);
        GroupManager.getInstance().removeGroup(fabric.getPK());
        int deletedRows = PmExtraOidImpl.deletePMExtraOidByFid(fabric.getDBID());
        if (deletedRows > 0) {
            PMImpl pm = PMImpl.getInstance();
            pm.restart();
        }
        SanManager.getInstance().cleanEnclosure();
        HostManager.getInstance().cleanupSanHosts();
        StorageEnclosureImpl.cleanupSanStorages();
    }

    public void purgeFabricfromDB(FabricPK fpk) throws Exception {
        try {
            long fabDBID = FabricImpl.findDbIdByFPK(fpk.get_fid());
            InventoryPersistentManager.purgeFabric(fabDBID);
            SanManager.notifyDBObjectPurged(fabDBID);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("purge fabric " + fpk.get_fid()), (Throwable)ex);
            throw ex;
        }
        SanManager.notifyFabricClosed(fpk);
    }

    public void purgeFabric(FabricPK pk, long fabricDBID) throws Exception {
        FabricImpl fabric = null;
        if (pk != null) {
            fabric = this.findFabric(pk);
        }
        if (fabric != null) {
            this.purgeFabric(fabric);
        } else if (fabricDBID > 0L) {
            try {
                InventoryPersistentManager.purgeFabric(fabricDBID);
                SanManager.notifyDBObjectPurged(fabricDBID);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge fabric dbid " + fabricDBID), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void purgeSwitch(SwitchImpl sw) {
        if (sw == null) {
            return;
        }
        FabricImpl fabric = sw.getFabric();
        if (_Logger.isTraceEnabled()) {
            try {
                throw new Exception(sw + " is purged");
            }
            catch (Exception e) {
                _Logger.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (fabric != null) {
            fabric.removeSwitchAndLinks(sw);
        }
        this.removeSwitch(sw, true);
        try {
            InventoryPersistentManager.purgeSwitchAndComponents(sw);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("delete switch components" + sw), (Throwable)ex);
        }
        ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(sw.getPK(), IdentityManager.getInstance().getClientAddress(), sw.getDBID(), "DCNM-SAN", LogEventType.SWITCH_MANAGEABILITY.toString(), IdentityManager.getInstance().getCurrentUsername(), "Switch '" + sw.getName() + "' removed", Severity.INFO.getValue(), 0));
    }

    public void purgeIsl(IslPK islPK) throws Exception {
        if (islPK == null) {
            return;
        }
        FabricImpl fabric = null;
        SwitchImpl sw = null;
        WwnKey swpk = islPK.getSwitchIntKey1()._swPK;
        if (swpk != null && (sw = this.findSwitch(swpk, null)) != null) {
            fabric = sw.getFabric();
        }
        if (fabric == null && (swpk = islPK.getSwitchIntKey2()._swPK) != null && (sw = this.findSwitch(swpk, null)) != null) {
            fabric = sw.getFabric();
        }
        if (fabric != null) {
            IslImpl isl = fabric.findIsl(islPK.getSwitchIntKey1());
            if (isl == null) {
                isl = fabric.findIsl(islPK.getSwitchIntKey2());
            }
            if (isl != null) {
                this.assertFabric(fabric);
                fabric.removeIsl(isl, true);
                InventoryPersistentManager.getInstance().purgeIsl(isl);
            } else {
                throw new Exception("Isl does not exist");
            }
        }
    }

    public void purgeNpvLink(SwitchIntKey fportPK) throws Exception {
        if (fportPK == null) {
            return;
        }
        FabricImpl fabric = null;
        SwitchImpl sw = this.findSwitch(fportPK._swPK, null);
        if (sw != null) {
            fabric = sw.getFabric();
        }
        if (fabric != null) {
            NpvLinkImpl npvl = fabric.findNpvLink(fportPK);
            if (npvl != null) {
                this.assertFabric(fabric);
                fabric.removeNpvLink(npvl);
                InventoryPersistentManager.getInstance().purgeNpvLink(npvl);
            } else {
                throw new Exception("NPV link does not exist");
            }
        }
    }

    public void purgeEndPort(EndPortImpl ep, FabricImpl fabImpl) {
        if (ep == null || fabImpl == null) {
            return;
        }
        ConcurrentHashMap<FabricPK, EndPortImpl> epByFPK = this._endportByWwnKey.get(ep.getEndPortPK());
        if (epByFPK != null) {
            EndPortImpl tep = epByFPK.get(fabImpl.getPK());
            if (tep == ep) {
                epByFPK.remove(fabImpl.getPK());
            }
            if (epByFPK.isEmpty()) {
                this._endportByWwnKey.remove(ep.getEndPortPK());
            }
        }
        this.updateEPSwIntKeyTableWithRemove(ep);
        if (fabImpl != null) {
            fabImpl.removeEndPort(ep, true);
            try {
                InventoryPersistentManager.getInstance().purgeEndPort(ep);
            }
            catch (Exception e) {
                _Logger.warn((Object)("Cannot purge the endport from DB:" + ep));
            }
        }
    }

    public void purgeEndPort(WwnKey pk, FabricPK fpk) throws Exception {
        FabricImpl fabric;
        if (pk == null) {
            return;
        }
        ConcurrentHashMap<FabricPK, EndPortImpl> epByFPK = this._endportByWwnKey.get(pk);
        if (epByFPK == null) {
            throw new Exception("Endport does not exist");
        }
        EndPortImpl ep = epByFPK.remove(fpk);
        if (ep == null) {
            throw new Exception("Endport does not exist");
        }
        this.updateEPSwIntKeyTableWithRemove(ep);
        if (fpk != null && (fabric = this.findFabric(fpk)) != null) {
            this.assertFabric(fabric);
            fabric.removeEndPort(ep, true);
            InventoryPersistentManager.getInstance().purgeEndPort(ep);
        }
    }

    public void purgeEnclosure(NameKey pk) throws Exception {
        if (pk == null) {
            return;
        }
        EnclosureImpl enclosure = this.findEnclosureByPK(pk);
        if (enclosure == null) {
            throw new Exception("Enclosure does not exist");
        }
        this.removeEnclosure(pk);
        InventoryPersistentManager.getInstance().purgeEnclosure(enclosure);
    }

    public boolean shouldPurgeNpvLink(NpvLinkImpl npvLink) {
        if (npvLink == null) {
            return false;
        }
        SwitchImpl coreSw = npvLink.getCoreSwitch();
        SwitchImpl edgeSw = npvLink.getEdgeSwitch();
        return !npvLink.isPresent() || coreSw == null || this.findSwitch(coreSw.getSwitchPK(), coreSw.getFabricPK()) == null || edgeSw == null || this.findSwitch(edgeSw.getSwitchPK(), edgeSw.getFabricPK()) == null;
    }

    void assertFabric(FabricImpl fabric) throws Exception {
        if (fabric != null && fabric.isDiscovering()) {
            throw new Exception("DCNM is busy polling/discovering this fabric");
        }
    }

    public void loadFabricsFromDB() {
        InventoryPersistentManager mgr = InventoryPersistentManager.getInstance();
        this._dbLoadStatus = DbLoadStatus.LOADING;
        try {
            if (mgr.loadPersistentFabricsFromDB() != null) {
                FabricImpl[] fs = this.getFabrics();
                if (fs != null) {
                    DiscoveryManager dm = DiscoveryManager.getInstance();
                    for (int i = 0; i < fs.length; ++i) {
                        if (!fs[i].isPersistent()) continue;
                        dm.discoverFabric(fs[i], DiscoveryType.FABRIC_INITIAL);
                    }
                }
                this._dbLoadStatus = DbLoadStatus.LOADED;
            } else {
                this._dbLoadStatus = DbLoadStatus.LOADFAILED;
            }
        }
        catch (SQLException ex) {
            _Logger.error((Object)"load fabric from db failed:", (Throwable)ex);
            this._dbLoadStatus = DbLoadStatus.LOADFAILED;
        }
    }

    public DbLoadStatus getDbLoadStatus() {
        return this._dbLoadStatus;
    }

    public FabricImpl openFabric(InetAddress ipAddr, SnmpUser user, boolean supportBrcdNpvDisc, String inVsans, String exVsans) throws Exception {
        FabricPK dbPk;
        FabricImpl fabric;
        int ethSws;
        if (user == null || user.getRoleName() == null || ipAddr == null) {
            _Logger.error((Object)("Invalid paramaters from open fabric:" + ipAddr + ", " + user));
            return null;
        }
        SwitchImpl[] switches = Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true")) ? SanManager.getInstance().getSwitches() : SanManager.getInstance().getNonNpvSwitches();
        int sanSws = switches == null ? 0 : switches.length;
        if (sanSws + (ethSws = DCManager.getInstance().getNumEthSwitchesNoFex()) >= _DefMaxOpenSwitches) {
            throw new Exception("Unable to add or manage these switches. This server is managing the recommended maximum of " + _DefMaxOpenSwitches + " switches");
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Try to load from server for:" + ipAddr));
        }
        if ((fabric = this.findFabric(ipAddr)) != null) {
            if (!supportBrcdNpvDisc && fabric.getSeed() != null && fabric.isBrcdNpvFabric()) {
                _Logger.warn((Object)("Opened a Brocade NPV fabric without Brocade NPV support:" + ipAddr + "," + fabric.getFabricName()));
            }
            if (fabric.getFarbicStatus() == 2) {
                return fabric;
            }
        }
        if ((dbPk = FabricImpl.findFPKBySeedIP(ipAddr)) != null) {
            return this.manageFabric(dbPk, ipAddr, user, supportBrcdNpvDisc);
        }
        if (this.reachMaxFabrics()) {
            throw new Exception("Maximum number of fabrics is reached.");
        }
        SnmpPeer swPeer = SnmpAdapter.createSnmpPeer(ipAddr, user);
        boolean isBrcdSeed = this.isBrcdSwitchPeer(swPeer);
        if (!supportBrcdNpvDisc && isBrcdSeed) {
            throw new IllegalArgumentException("Cannot open a Brocade NPV fabric without Brocade NPV support:" + ipAddr + "," + (fabric != null ? fabric.getFabricName() : ""));
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Try to load from DB for:" + ipAddr));
        }
        if (fabric == null) {
            fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr, inVsans, exVsans);
            if (Boolean.getBoolean("fabric.snapshot")) {
                return fabric;
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Try to create BrcdNpvFabric for:" + ipAddr));
        }
        if (fabric == null) {
            FabricPK fpk = InventoryPersistentManager.queryFabricPKByIpVsans(ipAddr, inVsans, exVsans);
            fabric = this.createFabric(fpk);
        }
        if (fabric.getSeed() != null) {
            fabric.getSeed().setDiscFlags(97279);
        } else if (isBrcdSeed) {
            byte[] swwn = BrcdSnmpAdapter.getBrcdSwitchWwn(swPeer);
            String sver = BrcdSnmpAdapter.getBrcdSwitchVersion(swPeer);
            SwitchImpl bseed = this.createSwitch(new Wwn(swwn), ipAddr, fabric);
            bseed.setVersion(sver);
            bseed.setManageable(true, null);
            bseed.setMDS(false);
            fabric.setSeed(bseed);
        } else {
            SwitchImpl seed = this.createSwitch(null, ipAddr, fabric);
            seed.setMDS(true);
            seed.setManageable(true, null);
            fabric.setSeed(seed);
        }
        SnmpUser oldUser = fabric.getCredentials();
        if (oldUser != null) {
            user = oldUser;
        }
        fabric.setCredentials(user, false);
        DiscoveryManager.getInstance().discoverFabric(fabric, DiscoveryType.FABRIC_INITIAL);
        String fabricName = fabric.getFabricName();
        if (fabricName == null) {
            fabricName = "Fabric_" + fabric.getSeed().getInetAddress().getHostAddress().replace('.', '-');
        }
        if (fabric.getDBID() > 0L) {
            ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fabric.getPK(), IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fabricName + "' opened", Severity.INFO.getValue(), 0));
        }
        return fabric;
    }

    public FabricImpl manageFabric(FabricPK fpk, InetAddress ipAddr, SnmpUser user, boolean supportBrcdNpvDisc) throws Exception {
        if (user == null || user.getRoleName() == null) {
            _Logger.error((Object)"user role name is null");
            return null;
        }
        FabricImpl fabric = this.findFabric(fpk);
        if (fabric == null) {
            fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr);
            if (fabric == null) {
                _Logger.error((Object)("can not find fabric in db for seed switch:" + ipAddr));
                return null;
            }
        } else {
            InventoryPersistentManager.getInstance().reloadFabric(fabric);
        }
        if (fabric != null) {
            this._fabricByPK.put(fpk, fabric);
        }
        if (Boolean.getBoolean("fabric.snapshot")) {
            return fabric;
        }
        SwitchImpl seed = fabric.getSeed();
        if (seed != null) {
            if (!supportBrcdNpvDisc && fabric.isBrcdNpvFabric()) {
                _Logger.warn((Object)("Opened a Brocade NPV fabric without Brocade NPV support:" + ipAddr + "," + fabric.getFabricName()));
            }
            seed.setDiscFlags(97279);
        } else {
            SnmpPeer swPeer = SnmpAdapter.createSnmpPeer(ipAddr, user);
            boolean isBrcdSeed = this.isBrcdSwitchPeer(swPeer);
            if (!supportBrcdNpvDisc && isBrcdSeed) {
                _Logger.warn((Object)("Opened a Brocade NPV fabric without Brocade NPV support:" + ipAddr + "," + fabric.getFabricName()));
            }
            if (isBrcdSeed) {
                byte[] swwn = BrcdSnmpAdapter.getBrcdSwitchWwn(swPeer);
                seed = this.createSwitch(new Wwn(swwn), ipAddr, fabric);
                seed.setManageable(true, null);
                seed.setMDS(false);
                fabric.setSeed(seed);
            } else {
                seed = this.createSwitch(null, ipAddr, fabric);
                seed.setMDS(true);
                seed.setManageable(true, null);
                fabric.setSeed(seed);
            }
        }
        fabric.setCredentials(user, false);
        DiscoveryManager.getInstance().discoverFabric(fabric, DiscoveryType.FABRIC_INITIAL);
        return fabric;
    }

    public void validateSeedSwitch(InetAddress swIp, SnmpUser user, boolean supportBrcdNpvDisc) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (user == null || user.getRoleName() == null) {
            throw new Exception("Invalid user login information");
        }
        FabricImpl fabric = this.findFabric(swIp);
        if (fabric != null) {
            return;
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, user);
        BrcdSnmpAdapter.validateSeedSwitch(peer, supportBrcdNpvDisc);
    }

    public void validateSeedSwitch(InetAddress swIp, SnmpUserOpt user, boolean supportBrcdNpvDisc) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (user == null) {
            throw new Exception("Invalid user login information");
        }
        FabricImpl fabric = this.findFabric(swIp);
        if (fabric != null) {
            return;
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, user);
        BrcdSnmpAdapter.validateSeedSwitch(peer, supportBrcdNpvDisc);
    }

    public boolean isBrcdSwitchPeer(SnmpPeer peer) throws Exception {
        if (peer == null) {
            throw new IllegalArgumentException("Switch peer cannot be null");
        }
        return BrcdSnmpAdapter.isBrcdSwitch(peer);
    }

    public boolean isBrcdSwitchPeer(InetAddress swIp, SnmpUserOpt snmpUserOpt) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (snmpUserOpt == null) {
            throw new Exception("Invalid user login information");
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, snmpUserOpt);
        return BrcdSnmpAdapter.isBrcdSwitch(peer);
    }

    public boolean isBrcdSwitchPeer(InetAddress swIp, SnmpUser user) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (user == null) {
            throw new Exception("Invalid user login information");
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, user);
        return BrcdSnmpAdapter.isBrcdSwitch(peer);
    }

    public boolean isCommonSwitchFound(FabricPK[] pkeys) throws Exception {
        ArrayList<FabricPK> fabrics = new ArrayList<FabricPK>();
        for (int i = 0; pkeys != null && i < pkeys.length; ++i) {
            _Logger.debug("SanManager->isCommonSwitchFound, adding fPK " + pkeys[i] == null ? "" : Integer.valueOf(pkeys[i].get_fid()));
            fabrics.add(pkeys[i]);
        }
        boolean found = false;
        HashMap<WwnKey, Set<FabricPK>> fabricsByswwn = GlobalFabricManager.getInstance().getAllDuplicatedSwitches();
        if (fabricsByswwn != null && fabricsByswwn.size() > 0) {
            HashSet<WwnKey> npvSwPKs = GlobalFabricManager.getInstance().getAllNpvSwPKs();
            for (WwnKey sw : fabricsByswwn.keySet()) {
                if (npvSwPKs.contains(sw)) continue;
                int fabricsFound = 0;
                Set<FabricPK> fabricPKs = fabricsByswwn.get(sw);
                for (FabricPK fpk : fabricPKs) {
                    if (!fabrics.contains(fpk)) continue;
                    ++fabricsFound;
                }
                if (fabricsFound <= true || fabricsFound != fabrics.size()) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public boolean isBrcdNpvFabric(FabricPK fabricPK) throws Exception {
        if (fabricPK == null) {
            throw new IllegalArgumentException("Invalid parameter:" + fabricPK);
        }
        FabricImpl fabImpl = this.findFabric(fabricPK);
        if (fabImpl == null) {
            throw new Exception("Cannot find the fabric for the key:" + fabricPK);
        }
        return fabImpl.isBrcdNpvFabric();
    }

    public void addBrcdNpvCore(FabricPK fabricPK, InetAddress swIP) throws Exception {
        if (fabricPK == null || swIP == null) {
            throw new IllegalArgumentException("Invalid parameter for add Brocade NPV core:" + fabricPK + "," + swIP);
        }
        FabricImpl fabImpl = this.findFabric(fabricPK);
        if (fabImpl == null) {
            throw new Exception("Cannot find the fabric for the key:" + fabricPK);
        }
        if (!fabImpl.isBrcdNpvFabric()) {
            throw new Exception("Cannot add a Brocade NPV core to a non-Brocade NPV fabric" + fabImpl);
        }
        SnmpUser user = fabImpl.getCredentials();
        SnmpPeer swPeer = SnmpAdapter.createSnmpPeer(swIP, user);
        boolean isBrcdSeed = this.isBrcdSwitchPeer(swPeer);
        if (!isBrcdSeed) {
            throw new IllegalArgumentException("Adding switch is not a Brocade switch:" + swIP);
        }
        byte[] swwn = BrcdSnmpAdapter.getBrcdSwitchWwn(swPeer);
        String sver = BrcdSnmpAdapter.getBrcdSwitchVersion(swPeer);
        SwitchImpl bsw = this.createSwitch(new Wwn(swwn), swIP, fabImpl);
        bsw.setVersion(sver);
        bsw.setManageable(true, null);
        bsw.setMDS(false);
        DiscoveryManager.getInstance().discoverFabric(fabImpl, DiscoveryType.FABRIC_AUTODEMAND);
        fabImpl.setDiscoveryType(DiscoveryType.FABRIC_AUTODEMAND);
    }

    public List<Card> getCardsWithFeatureEnabled(FabricPK fabricPK, String featureName) throws Exception {
        if (fabricPK == null || featureName == null) {
            throw new IllegalArgumentException("Invalid parameter for get Cards With Feature Enabled:" + fabricPK + "," + featureName);
        }
        FabricImpl fabImpl = this.findFabric(fabricPK);
        if (fabImpl == null) {
            throw new Exception("Cannot find the fabric for the key:" + fabricPK);
        }
        SwitchImpl[] switches = fabImpl.getSwitches();
        return this.getCardsWithFeatureEnabled(Arrays.asList(switches), featureName);
    }

    public List<Card> getCardsWithFeatureEnabled(List<SwitchImpl> switches, String featureName) throws Exception {
        InventoryManager im = InventoryManager.getInstance();
        ArrayList<Card> enabledCards = new ArrayList<Card>();
        for (SwitchImpl nextSwitch : switches) {
            int[] oid;
            int[] oid2;
            if (!nextSwitch.isMDS()) continue;
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(_SsmFeatureVar));
            SnmpPDU rspPdu = SnmpFetch.getBulk(nextSwitch.createPeer(), vbl);
            vbl = rspPdu.getVariables();
            int oidOffset = _SsmFeatureVar.getValue().length;
            for (int i = 0; i < vbl.size() && oidOffset + 3 < (oid2 = vbl.getVb(i).getOid().getValue()).length; ++i) {
                String nextFeatureName = SnmpString.toString(oid2, oidOffset + 3, oid2.length);
                if (!featureName.equals(nextFeatureName)) continue;
                int ifStartPort = oid2[oidOffset];
                int slot = IfIndexUtil.ifIndex2Card(ifStartPort);
                Card card = im.findCard(nextSwitch.getSwitchPK(), slot + 1);
                if (card == null || vbl.intValue(i) != 1) continue;
                enabledCards.add(card);
            }
            vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(_SsmSsnFeatureVar));
            rspPdu = SnmpFetch.getBulk(nextSwitch.createPeer(), vbl, 24);
            vbl = rspPdu.getVariables();
            oidOffset = _SsmSsnFeatureVar.getValue().length;
            int[] lastOid = null;
            for (int i = 0; i < vbl.size() && !Arrays.equals(oid = vbl.getVb(i).getOid().getValue(), lastOid) && oidOffset + 4 < oid.length; ++i) {
                String nextFeatureName = SnmpString.toString(oid, oidOffset + 4, oid.length);
                if (featureName.equals(nextFeatureName)) {
                    int physicalIndex = oid[oidOffset];
                    int slot = physicalIndex - 21;
                    Card card = im.findCard(nextSwitch.getSwitchPK(), slot);
                    if (card != null && vbl.intValue(i) == 1) {
                        enabledCards.add(card);
                    }
                }
                lastOid = oid;
            }
        }
        return enabledCards;
    }

    public synchronized void moveFabric(FabricPK fabricpk, SnmpUser snmpUser, boolean remove) throws Exception {
        if (fabricpk == null) {
            throw new Exception("fabric PK doesn't exist");
        }
        if (!remove && snmpUser == null) {
            throw new Exception("snmpUser is not available");
        }
        try {
            long fabricId = FabricImpl.findDbIdByFPK(fabricpk.get_fid());
            if (PMImpl.getInstance().isFabricInCollection((int)fabricId)) {
                throw new Exception("The Fabric with fabric id: " + fabricId + " is in pm collection and can not be moved");
            }
        }
        catch (SQLException e1) {
            throw new Exception(e1.getMessage());
        }
        int serverId = ClusterSequence.getSequence().getServerId();
        try {
            if (remove) {
                SanManager.getInstance().closePersistedFabric(fabricpk, true, true);
                ClusterMapping.getInstance().deleteLOGIC(serverId, fabricpk.get_fid());
            } else {
                FabricImpl fabric = SanManager.getInstance().findFabric(fabricpk);
                if (fabric != null) {
                    throw new Exception("the fabric already exists on the server");
                }
                InetAddress ipAddr = SwitchImpl.findSwitchAddrinDB(FabricImpl.findSeedSwitchIdByPk(fabricpk));
                if (ipAddr == null) {
                    throw new Exception("can not find seed switch in db for seed switch:" + ipAddr);
                }
                ClusterMapping.getInstance().persistLOGIC(serverId, fabricpk.get_fid());
                SanManager.getInstance().manageFabric(fabricpk, ipAddr, snmpUser);
            }
        }
        catch (Exception e) {
            throw new Exception("Can not move fabric: " + e.getMessage());
        }
    }

    static {
        _SnmpSession = SnmpSession.getInstance();
        _Listeners = new CopyOnWriteArrayList();
        _Plisteners = new CopyOnWriteArrayList();
        Integer n = Integer.getInteger("fabric.maxOpenSwitches");
        _DefMaxOpenSwitches = n == null || n <= 0 ? 150 : n;
    }

    public static enum DbLoadStatus {
        NOTLOADED,
        LOADING,
        LOADED,
        LOADFAILED;

    }
}

