/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.serviceconf.AbstractService;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VshManager;
import com.cisco.dcbu.lib.snmp.proxy.ProxyTransportOptions;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUserEntry;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.StorageEnclosureImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SanManagerService
extends AbstractService {
    static final String PROP_SNMP_LOCALPORT = "snmp.localport";
    static final String PROP_SNMP_TIMEOUT = "snmp.timeout";
    static final String PROP_SNMP_RETRIES = "snmp.retries";
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    private static SnmpSession _SnmpSession = SnmpSession.getInstance();
    private SyncedInt _curFabricId;
    private ConcurrentHashMap<FabricPK, FabricImpl> _fabricByPK;
    private ConcurrentHashMap<WwnKey, SwitchImpl> _switchByWwnKey;
    private ConcurrentHashMap<WwnKey, EndPortImpl> _endportByWwnKey;
    private Map<SwitchIntKey, Set<EndPortImpl>> _endportsBySwIntKey;
    private ConcurrentHashMap<NameKey, EnclosureImpl> _enclByNameKey;
    private transient ConcurrentHashMap<InetAddress, SwitchImpl> _switchByIp;
    private static ModelEventListenerIf[] _Listeners;

    public SanManagerService() {
        super("San Manager Service");
    }

    protected void initImpl(Object[] params) throws Exception {
        this._fabricByPK = new ConcurrentHashMap();
        this._switchByWwnKey = new ConcurrentHashMap();
        this._switchByIp = new ConcurrentHashMap();
        this._endportByWwnKey = new ConcurrentHashMap();
        this._endportsBySwIntKey = new ConcurrentHashMap<SwitchIntKey, Set<EndPortImpl>>();
        this._enclByNameKey = new ConcurrentHashMap();
        this._curFabricId = new SyncedInt(0);
        GlobalFabricManager.getInstance();
    }

    protected void stopImpl() {
        if (this.getNumOfFabrics() != 0) {
            FabricImpl[] fabrics = this.getFabrics();
            for (int i = 0; i < fabrics.length; ++i) {
                this.closeFabric(fabrics[i]);
            }
        }
    }

    public static void initSnmp() throws Exception {
        Integer retries;
        Integer timeout;
        if (_SnmpSession != null) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"fms");
        ProxyTransportOptions opt = null;
        InetAddress localaddr = null;
        Integer localport = Integer.getInteger(PROP_SNMP_LOCALPORT);
        _SnmpSession = SnmpSession.getInstance();
        String value = System.getProperty("snmp.proxy");
        if (value != null && value.length() != 0) {
            InetAddress proxyAddr = null;
            int proxyPort = 9198;
            int del = value.indexOf(58);
            String proxyHost = null;
            try {
                if (del != -1) {
                    proxyHost = value.substring(0, del);
                    proxyPort = Integer.parseInt(value.substring(del + 1).trim());
                    if (proxyPort <= 0 || proxyPort > 65535) {
                        throw new NumberFormatException(String.valueOf(proxyPort));
                    }
                    proxyAddr = InetAddress.getByName(value.substring(0, del));
                } else {
                    proxyHost = value;
                    proxyAddr = InetAddress.getByName(value.substring(0));
                }
                if (proxyAddr != null && !NetUtil.isLocalHost(proxyAddr.getHostAddress())) {
                    opt = new ProxyTransportOptions(proxyAddr, proxyPort);
                }
            }
            catch (UnknownHostException uhe) {
                boolean localNic = false;
                Enumeration<NetworkInterface> nifs = null;
                try {
                    nifs = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException ex) {
                    // empty catch block
                }
                if (nifs != null) {
                    while (nifs.hasMoreElements()) {
                        NetworkInterface ni = nifs.nextElement();
                        if (!ni.getName().equals(proxyHost)) continue;
                        localNic = true;
                        break;
                    }
                }
                if (!localNic) {
                    logger.warn((Object)("Invalid proxy server address: " + proxyHost + ". Use local IP address as proxy server address"));
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)("Invalid proxy server port: " + nfe.getMessage()));
            }
        }
        if (opt != null) {
            _SnmpSession.open("proxy", opt);
        } else {
            _SnmpSession.open(localaddr, localport == null ? 0 : localport);
            if (SnmpSession._PreferTcp) {
                SnmpSession.getInstance("tcp").open("tcp", new TcpTransportOptions(null, 161, localport == null ? 0 : localport));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SnmpSession initialized on " + _SnmpSession.getLocalHostAddress() + ":" + _SnmpSession.getLocalPort() + ", remote port=" + _SnmpSession.getRemotePort()));
        }
        if ((timeout = Integer.getInteger(PROP_SNMP_TIMEOUT)) != null) {
            SnmpPeer.setClassTimeout(timeout);
        }
        if ((retries = Integer.getInteger(PROP_SNMP_RETRIES)) != null) {
            SnmpPeer.setClassRetries(retries);
        }
    }

    public static SnmpSession getSnmpSession() {
        return _SnmpSession;
    }

    public int getNumOfSans() {
        return 1;
    }

    public int getNumOfFabrics() {
        return this._fabricByPK.size();
    }

    public boolean reachMaxFabrics() {
        Integer maxopen = Integer.getInteger("fabric.maxopen");
        return maxopen != null && maxopen <= this._fabricByPK.size();
    }

    public void validateSeedSwitch(InetAddress swIp, SnmpUser user) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (user == null || user.getRoleName() == null) {
            throw new Exception("Invalid user login information");
        }
        FabricImpl fabric = this.findFabric(swIp);
        if (fabric != null) {
            return;
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, user);
        SnmpAdapter.validateSeedSwitch(peer);
    }

    public void validateSeedSwitch(InetAddress swIp, SnmpUserOpt snmpUserOpt) throws Exception {
        if (swIp == null) {
            throw new Exception("Invalid IP address:" + swIp);
        }
        if (snmpUserOpt == null) {
            throw new Exception("Invalid user login information");
        }
        FabricImpl fabric = this.findFabric(swIp);
        if (fabric != null) {
            return;
        }
        SnmpPeer peer = SnmpAdapter.createSnmpPeer(swIp, snmpUserOpt);
        SnmpAdapter.validateSeedSwitch(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricImpl createFabric(FabricPK pkey) {
        FabricImpl fabric = null;
        ConcurrentHashMap<FabricPK, FabricImpl> concurrentHashMap = this._fabricByPK;
        synchronized (concurrentHashMap) {
            if (pkey == null) {
                int fid = this._curFabricId.increment();
                try {
                    fid = (int)Sequence.getSequence().getFabricPK();
                    this._curFabricId.set(fid);
                }
                catch (SQLException ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"Can not get fabric id from db, use local incremental id:", (Throwable)ex);
                }
                pkey = new FabricPK(fid);
            } else {
                fabric = this.findFabric(pkey);
            }
            if (fabric == null) {
                fabric = new FabricImpl(pkey);
                this._fabricByPK.put(fabric.getPK(), fabric);
            }
        }
        return fabric;
    }

    public FabricImpl[] getFabrics() {
        return this._fabricByPK.values().toArray(new FabricImpl[this._fabricByPK.size()]);
    }

    public FabricPK[] getFabricPKs() {
        return this._fabricByPK.keySet().toArray(new FabricPK[this._fabricByPK.size()]);
    }

    void removeFabric(FabricImpl fabric) {
        this._fabricByPK.remove(fabric.getPK());
        SanManagerService.notifyFabricClosed(fabric);
    }

    public FabricImpl openFabric(InetAddress ipAddr, SnmpUser user, String inVsans, String exVsans) throws Exception {
        if (user.getRoleName() == null) {
            return null;
        }
        FabricImpl fabric = this.findFabric(ipAddr);
        FabricPK dbPk = FabricImpl.findFPKBySeedIPVsans(ipAddr, inVsans, exVsans);
        if (dbPk != null) {
            return this.manageFabric(dbPk, ipAddr, user);
        }
        if (fabric == null) {
            if (this.reachMaxFabrics()) {
                throw new Exception("Maximum number of fabrics is reached.");
            }
            fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr, inVsans, exVsans);
            if (Boolean.getBoolean("fabric.snapshot")) {
                return fabric;
            }
            if (fabric == null) {
                FabricPK fpk = InventoryPersistentManager.queryFabricPKByIpVsans(ipAddr, inVsans, exVsans);
                fabric = this.createFabric(fpk);
                SwitchImpl seed = this.createSwitch(null, ipAddr, fabric);
                seed.setMDS(true);
                seed.setManageable(true, null);
                fabric.setSeed(seed);
            } else {
                SwitchImpl seed = fabric.getSeed();
                if (seed == null) {
                    seed = this.createSwitch(null, ipAddr, fabric);
                    seed.setMDS(true);
                    seed.setManageable(true, null);
                    fabric.setSeed(seed);
                } else {
                    seed.setDiscFlags(97279);
                }
                SnmpUser oldUser = fabric.getCredentials();
                if (oldUser != null) {
                    user = oldUser;
                }
            }
            fabric.setCredentials(user, false);
            DiscoveryManager.getInstance().discoverFabric(fabric, DiscoveryType.FABRIC_INITIAL);
        }
        return fabric;
    }

    public void manageFabric(FabricPK fabricPK) throws Exception {
        FabricImpl fs = SanManager.getInstance().findFabric(fabricPK);
        long seedid = fs.getSeedDBID();
        if (seedid == 0L) {
            seedid = FabricImpl.findSeedSwitchIdByPk(fabricPK);
        }
        InetAddress ipAddr = SwitchImpl.findSwitchMgmtAddrByPK(seedid);
        UsmUserEntry.authenticate(fs.getCredentials(), ipAddr);
        SanManager.getInstance().manageFabric(fabricPK, ipAddr, fs.getCredentials());
    }

    public FabricImpl manageFabric(FabricPK fpk, InetAddress ipAddr, SnmpUser user) throws Exception {
        if (user == null || user.getRoleName() == null) {
            return null;
        }
        FabricImpl fabric = this.findFabric(fpk);
        String inVsans = fabric == null ? null : fabric.getIncludedVsanList();
        String exVsans = fabric == null ? null : fabric.getExcludedVsanList();
        fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr, inVsans, exVsans);
        if (fabric != null) {
            this._fabricByPK.put(fpk, fabric);
        }
        if (Boolean.getBoolean("fabric.snapshot")) {
            return fabric;
        }
        if (fabric == null) {
            return null;
        }
        SwitchImpl seed = fabric.getSeed();
        if (seed == null) {
            seed = this.createSwitch(null, ipAddr, fabric);
            seed.setMDS(true);
            seed.setManageable(true, null);
            fabric.setSeed(seed);
        } else {
            seed.setDiscFlags(97279);
        }
        fabric.setCredentials(user, false);
        DiscoveryManager.getInstance().discoverFabric(fabric, DiscoveryType.FABRIC_INITIAL);
        return fabric;
    }

    public boolean isOpened(FabricPK pkey) throws Exception {
        if (pkey == null) {
            return false;
        }
        FabricImpl fabric = this.findFabric(pkey);
        if (fabric != null) {
            int status = fabric.getFarbicStatus();
            return status == 2 || status == 4;
        }
        return false;
    }

    public void unmanageFabric(FabricPK fabricPK) throws Exception {
        SanManagerService sm = (SanManagerService)ServiceConfig.findService((String)"San Manager Service");
        FabricImpl fabric = sm.findFabric(fabricPK);
        if (fabric == null) {
            throw new RemoteException(fabricPK + " not found");
        }
        sm.closeFabric(fabric);
    }

    public void closeFabric(FabricPK pk) {
        FabricImpl fabric = this.findFabric(pk);
        if (fabric != null) {
            this.closeFabric(fabric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFabric(FabricImpl fabric) {
        block12: {
            try {
                SwitchImpl[] sws = fabric.getSwitches();
                if (sws == null || sws.length <= 0) break block12;
                for (int i = 0; i < sws.length; ++i) {
                    if (sws[i].isMDS()) {
                        try {
                            VshManager.getInstance().closeVsh(sws[i].getIpAddress());
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                    }
                    sws[i].clean();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        try {
            if (fabric.getFarbicStatus() == 1 || fabric.getFarbicStatus() == 6 || fabric.attemptFabric(2, 5, fabric.getDiscoveryTimeout())) {
                fabric.close();
            }
        }
        catch (Exception ex) {
            fabric.releaseFabric(2);
            _Logger.log((Priority)Level.WARN, (Object)("close fabric" + fabric + "error: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            fabric.releaseFabric(6);
        }
    }

    public void persistFabric(FabricImpl fabric, boolean persist) {
        fabric.setPersistent(persist);
    }

    public FabricImpl findFabric(FabricPK pkey) {
        if (pkey == null) {
            return null;
        }
        return this._fabricByPK.get(pkey);
    }

    public FabricImpl findFabricBySwitchPK(WwnKey swPK) {
        SwitchImpl sw = this.findSwitch(swPK);
        return sw != null ? sw.getFabric() : null;
    }

    public FabricImpl findFabric(InetAddress inetAddr) {
        SwitchImpl sw;
        SwitchImpl switchImpl = sw = inetAddr != null ? this._switchByIp.get(inetAddr) : null;
        if (sw != null) {
            FabricImpl fabric = sw.getFabric();
            if (fabric != null && this._fabricByPK.get(fabric.getPK()) == null) {
                _Logger.log((Priority)Level.WARN, (Object)("Unreference switch found: " + sw));
                try {
                    this._switchByIp.remove(inetAddr);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"Close staled switch: ", (Throwable)ex);
                }
                try {
                    fabric.close();
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"Close staled fabric: ", (Throwable)ex);
                }
                return null;
            }
            return fabric;
        }
        return null;
    }

    public FabricImpl findFabric(String swAddr) throws Exception {
        return this.findFabric(InetAddress.getByName(swAddr));
    }

    public FabricPK findFabricPK(InetAddress swIp) {
        FabricImpl f = this.findFabric(swIp);
        return f != null ? f.getPK() : null;
    }

    public VsanImpl findVsan(VsanPK vPK) {
        FabricImpl fabric;
        VsanImpl vsan = null;
        Iterator<FabricImpl> i$ = this._fabricByPK.values().iterator();
        while (i$.hasNext() && (vsan = (fabric = i$.next()).findVsan(vPK)) == null) {
        }
        return vsan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchImpl createSwitch(Wwn swwn, InetAddress ip, FabricImpl fabric) {
        ConcurrentHashMap<WwnKey, SwitchImpl> concurrentHashMap = this._switchByWwnKey;
        synchronized (concurrentHashMap) {
            WwnKey swPK = null;
            SwitchImpl sw = null;
            if (swwn != null) {
                swPK = new WwnKey(swwn);
                sw = this.findSwitch(swPK);
            }
            if (sw == null && ip != null) {
                sw = this.findSwitch(ip);
            }
            if (sw == null) {
                sw = new SwitchImpl(swPK, ip);
                sw.setFabric(fabric);
                if (swPK != null) {
                    this._switchByWwnKey.put(swPK, sw);
                }
                if (ip != null) {
                    this._switchByIp.put(ip, sw);
                }
                SanManagerService.notifyModelObjectCreated(sw);
            }
            return sw;
        }
    }

    void addSwitchByPK(SwitchImpl sw) {
        if (sw != null && sw.getPK() != null) {
            this._switchByWwnKey.put(sw.getSwitchPK(), sw);
            SanManagerService.notifyModelObjectCreated(sw);
        }
    }

    public void removeSwitch(SwitchImpl sw) {
        if (sw.isPeerCreated()) {
            EventControllerService ec = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
            ec.delSource(sw);
            if (sw.isTrapRegistered() && sw.isManageableMDS()) {
                try {
                    ec.deregisterTrap(sw.createPeer());
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
            if (sw.isPeerCreated()) {
                try {
                    SnmpPeer.removePeer(sw.createPeer());
                }
                catch (SnmpException snmpException) {
                    // empty catch block
                }
            }
        }
        sw.clean();
        SanManagerService.notifyModelObjectRemoved(sw);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeSwitchIp(WwnKey swPK, InetAddress inetAddr) throws Exception {
        SwitchImpl sw = this.findSwitch(swPK);
        if (sw == null) throw new Exception("switch " + swPK.toString() + " cannot be found");
        InetAddress oldAddr = sw.getInetAddress();
        if (oldAddr.toString().equals(inetAddr.toString())) return;
        sw.resetPeer();
        sw.setManagementAddressInUse(inetAddr);
        sw.setManagementAddresses(new InetAddress[]{inetAddr});
        sw.setManageable(true, null);
        sw.setDiscFlag(1);
        if (!sw.isMDS()) return;
    }

    public SwitchImpl mergeSwitch(SwitchImpl sw, FabricImpl anotherFabric) {
        if (sw == null || anotherFabric == null) {
            if ((sw == null || anotherFabric == null) && _Logger.isDebugEnabled()) {
                _Logger.debug((Object)("SANManager--mergeSwitch: invalid arguement--" + String.valueOf(sw) + ", " + String.valueOf(anotherFabric)), (Throwable)new NullPointerException());
            }
            return sw;
        }
        if (sw.getFabric() == null || sw.getFabric() == anotherFabric) {
            sw.setFabric(anotherFabric);
            return sw;
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("SanManager-- mergeSwitch:" + sw + "-- between switch fabric:" + sw.getFabric() + "-- with fabric:" + anotherFabric));
        }
        FabricImpl swCurrFabric = sw.getFabric();
        Wwn swwn = sw.getWwn();
        InetAddress ip = sw.getInetAddress();
        this.purgeSwitch(sw);
        sw = this.createSwitch(swwn, ip, anotherFabric);
        return sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchIpChanged(SwitchImpl sw, InetAddress[] oldAddrs, InetAddress[] newAddrs) {
        ConcurrentHashMap<InetAddress, SwitchImpl> concurrentHashMap = this._switchByIp;
        synchronized (concurrentHashMap) {
            int i;
            if (oldAddrs != null) {
                for (i = 0; i < oldAddrs.length; ++i) {
                    if (newAddrs != null && GenUtil.linearSearch(newAddrs, oldAddrs[i]) >= 0) continue;
                    this._switchByIp.remove(oldAddrs[i]);
                }
            }
            if (newAddrs != null) {
                for (i = 0; i < newAddrs.length; ++i) {
                    SwitchImpl oldSw;
                    if (oldAddrs != null && GenUtil.linearSearch(oldAddrs, newAddrs[i]) >= 0 || (oldSw = this._switchByIp.put(newAddrs[i], sw)) == null || oldSw == sw) continue;
                    _Logger.warn((Object)(oldSw.getWwn() + " and " + sw.getWwn() + " share the same IP Address " + newAddrs[i].getHostAddress()));
                    if (oldSw.getPK() == null && sw.getPK() != null) continue;
                    if (!oldSw.isManageable()) {
                        _Logger.log((Priority)Level.WARN, (Object)(oldSw + " is removed"));
                        this.purgeSwitch(oldSw);
                        continue;
                    }
                    if (!oldSw.isMDS() || !sw.isMDS()) continue;
                    String oui = Integer.toString(WwnDictionary.getVendorId(sw.getWwn().getValue()), 16);
                    String str = "Switch IP changed:  please add 0x" + oui + " to server.properties: newOUIs=";
                    LogEvent e = new LogEvent((Object)sw.getFabric().getPK(), LogEventType.OTHER, Severity.WARNING, sw.getFabric().getPK().getName(), str, sw.getFabric().getDBID());
                    ((EventLoggerService)ServiceConfig.findService((String)"Event Logger Service")).logEvent(e);
                    _Logger.warn((Object)str);
                }
                SanManagerService.notifyModelObjectCreated(sw);
            }
        }
    }

    public SwitchImpl findSwitch(WwnKey swPK) {
        if (swPK == null) {
            return null;
        }
        return this._switchByWwnKey.get(swPK);
    }

    public SwitchImpl findSwitch(InetAddress ipAddr) {
        return ipAddr != null ? this._switchByIp.get(ipAddr) : null;
    }

    public SwitchImpl findSwitch(Wwn wwn) {
        return this.findSwitch(new WwnKey(wwn));
    }

    public SwitchImpl findSwitch(Wwn wwn, FabricPK fPK) {
        SwitchImpl swImpl = this.findSwitch(new WwnKey(wwn));
        return swImpl != null && swImpl.getFabricPK() != null && swImpl.getFabricPK().equals(fPK) ? swImpl : null;
    }

    public SwitchImpl findSwitch(Wwn wwn, boolean includeVsanWwns) {
        SwitchImpl sw = this.findSwitch(wwn);
        if (sw != null) {
            return sw;
        }
        if (!includeVsanWwns) {
            return null;
        }
        if (WwnDictionary.isCiscoWwn(wwn.getValue()) && !WwnDictionary.isQuailWwn(wwn.getValue())) {
            byte[] bswwn = new byte[8];
            System.arraycopy(wwn.getValue(), 0, bswwn, 0, 8);
            WwnDictionary.vsanWwnToSwwn(bswwn);
            return this.findSwitch(new Wwn(bswwn));
        }
        for (SwitchImpl sw0 : this._switchByWwnKey.values()) {
            short[] vids = sw0.getVsanIds();
            if (vids == null || vids.length == 0) continue;
            for (int j = 0; j < vids.length; ++j) {
                if (!wwn.equals(sw0.getVsanWwn(vids[j]))) continue;
                return sw0;
            }
        }
        return null;
    }

    public String findSwitchIpByPK(WwnKey swPK) {
        SwitchImpl sw = this.findSwitch(swPK);
        return sw == null ? null : sw.getIpAddress();
    }

    public String findSwitchIpBySysName(String swName) {
        if (swName == null) {
            return null;
        }
        for (SwitchImpl sw0 : this._switchByWwnKey.values()) {
            String sysName = sw0.getSysName();
            if (sysName == null || !sysName.equals(swName)) continue;
            return sw0.getIpAddress();
        }
        return swName;
    }

    public SwitchImpl[] getSwitches() {
        return this._switchByWwnKey.values().toArray(new SwitchImpl[this._switchByWwnKey.size()]);
    }

    public SwitchImpl[] findAttachedSwitches(SwitchImpl sw) {
        HashSet<SwitchImpl> sws = new HashSet<SwitchImpl>();
        IslImpl[] isls = sw.getFabric().getIsls();
        for (int i = 0; i < isls.length; ++i) {
            IslImpl isl = isls[i];
            if (isl.getSwitch1() == sw) {
                sws.add(isl.getSwitch2());
                continue;
            }
            if (isl.getSwitch2() != sw) continue;
            sws.add(isl.getSwitch1());
        }
        return sws.size() == 0 ? null : sws.toArray(new SwitchImpl[sws.size()]);
    }

    public List findSubFabrics(FabricImpl fabric) {
        ArrayList<HashSet> list = new ArrayList<HashSet>();
        IslImpl[] isls = fabric.getIsls();
        for (int i = 0; i < isls.length; ++i) {
            IslImpl isl = isls[i];
            SwitchImpl sw1 = isl.getSwitch1();
            SwitchImpl sw2 = isl.getSwitch2();
            HashSet h1 = null;
            HashSet h2 = null;
            for (HashSet h : list) {
                if (h.contains(sw1)) {
                    h1 = h;
                    continue;
                }
                if (!h.contains(sw2)) continue;
                h2 = h;
            }
            if (h1 != null) {
                if (h2 != null) {
                    if (h1 == h2) continue;
                    h1.addAll(h2);
                    list.remove(h2);
                    continue;
                }
                h1.add(sw2);
                continue;
            }
            if (h2 != null) {
                h2.add(sw1);
                continue;
            }
            HashSet<SwitchImpl> h = new HashSet<SwitchImpl>();
            h.add(sw1);
            h.add(sw2);
            list.add(h);
        }
        SwitchImpl[] sws = fabric.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            HashSet h = null;
            for (HashSet hh : list) {
                if (!hh.contains(sws[i])) continue;
                h = hh;
                break;
            }
            if (h != null) continue;
            h = new HashSet();
            h.add(sws[i]);
            list.add(h);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPortImpl createEndPort(Wwn pwwn, Wwn nwwn, int[] fc4Type, byte[] fc4Features, FabricImpl fabric) {
        WwnKey epPK = new WwnKey(pwwn);
        ConcurrentHashMap<WwnKey, EndPortImpl> concurrentHashMap = this._endportByWwnKey;
        synchronized (concurrentHashMap) {
            EndPortImpl ep = this.findEndPortByPK(epPK);
            if (ep == null) {
                ep = new EndPortImpl(epPK, nwwn, fc4Type, fc4Features);
                ep.setFabric(fabric);
                this._endportByWwnKey.put(epPK, ep);
                if (fabric != null) {
                    SanManagerService.notifyMembersAdded(fabric, new AbstractModelObjectImpl[]{ep});
                }
            }
            return ep;
        }
    }

    public EndPortImpl findEndPortByPK(WwnKey epKey) {
        return epKey == null ? null : this._endportByWwnKey.get(epKey);
    }

    public ArrayList<EndPortImpl> findEndPortByFWwn(byte[] fwwn) {
        if (fwwn == null) {
            return null;
        }
        ArrayList<EndPortImpl> list = new ArrayList<EndPortImpl>();
        for (EndPortImpl ep : this._endportByWwnKey.values()) {
            if (!Arrays.equals(fwwn, ep.getfWwn())) continue;
            list.add(ep);
        }
        return list;
    }

    public EndPortImpl findEndPortByWwn(Wwn pwwn) {
        return this.findEndPortByPK(new WwnKey(pwwn));
    }

    public EndPortImpl findEndPortByWwn(Wwn pwwn, FabricPK fPK) {
        EndPortImpl epImpl = this.findEndPortByWwn(pwwn);
        return epImpl != null && epImpl.getFabricPK().equals(fPK) ? epImpl : null;
    }

    public ArrayList<EndPortImpl> findEndportsBySwitchIfIndex(WwnKey swPK, int ifindex) {
        if (swPK == null || ifindex < 0) {
            return new ArrayList<EndPortImpl>();
        }
        SwitchIntKey key = new SwitchIntKey(swPK, ifindex);
        Set<EndPortImpl> epset = this._endportsBySwIntKey.get(key);
        if (epset == null) {
            return new ArrayList<EndPortImpl>();
        }
        return new ArrayList<EndPortImpl>(epset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEPSwIntKeyTableWithAdd(EndPortImpl ep) {
        if (ep == null) {
            return;
        }
        SwitchIntKey key = ep.getSwitchIntKey();
        if (key != null) {
            Map<SwitchIntKey, Set<EndPortImpl>> map = this._endportsBySwIntKey;
            synchronized (map) {
                Set<EndPortImpl> epset = this._endportsBySwIntKey.get(key);
                if (epset == null) {
                    epset = new HashSet<EndPortImpl>();
                    this._endportsBySwIntKey.put(key, epset);
                }
                epset.add(ep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEPSwIntKeyTableWithRemove(EndPortImpl ep) {
        if (ep == null) {
            return;
        }
        SwitchIntKey key = ep.getSwitchIntKey();
        if (key != null) {
            Map<SwitchIntKey, Set<EndPortImpl>> map = this._endportsBySwIntKey;
            synchronized (map) {
                Set<EndPortImpl> epset = this._endportsBySwIntKey.get(key);
                if (epset != null) {
                    epset.remove(ep);
                    if (epset.size() == 0) {
                        this._endportsBySwIntKey.remove(key);
                    }
                }
            }
        }
    }

    public EndPortImpl[] getEndPorts() {
        return this._endportByWwnKey.values().toArray(new EndPortImpl[this._endportByWwnKey.size()]);
    }

    public void removeEndPort(EndPortImpl ep) {
        if (ep != null) {
            this._endportByWwnKey.remove(ep.getEndPortPK());
            this.updateEPSwIntKeyTableWithRemove(ep);
            ep.disconnect();
        }
    }

    public void removeEndPorts(Collection eps) {
        this._endportByWwnKey.values().removeAll(eps);
        if (eps != null) {
            for (Object obj : eps) {
                if (!(obj instanceof EndPortImpl)) continue;
                EndPortImpl ep = (EndPortImpl)obj;
                this.updateEPSwIntKeyTableWithRemove(ep);
            }
        }
    }

    public List findAttachedEndPorts(SwitchImpl sw) {
        short[] vids = sw.getVsanIds();
        ArrayList<EndPortImpl> ports = new ArrayList<EndPortImpl>();
        for (int i = 0; i < vids.length; ++i) {
            VsanImpl v = sw.getVsan(vids[i]);
            if (v == null) continue;
            for (EndPortImpl ep : v.getEndPorts()) {
                if (ep.getSwitch() != sw) continue;
                ports.add(ep);
            }
        }
        return ports.size() != 0 ? ports : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnclosureImpl createEnclosure(String name, InetAddress ipAddress, boolean isVirtual) {
        ConcurrentHashMap<NameKey, EnclosureImpl> concurrentHashMap = this._enclByNameKey;
        synchronized (concurrentHashMap) {
            EnclosureImpl enc = this.findEnclosureByName(name);
            if (enc == null) {
                enc = new EnclosureImpl(name, ipAddress, isVirtual);
                this._enclByNameKey.put(enc.getEnclosurePK(), enc);
            }
            return enc;
        }
    }

    public EnclosureImpl[] getEnclosures() {
        return this._enclByNameKey.values().toArray(new EnclosureImpl[this._enclByNameKey.size()]);
    }

    public EnclosureImpl findEnclosureByPK(NameKey pkey) {
        return pkey == null ? null : this._enclByNameKey.get(pkey);
    }

    public EnclosureImpl findEnclosureByName(String name) {
        return this.findEnclosureByPK(new NameKey(name));
    }

    public EnclosureImpl findEnclosureByPortWwn(Wwn pwwn) {
        EndPortImpl ep = pwwn == null ? null : this._endportByWwnKey.get(new WwnKey(pwwn));
        return ep != null ? ep.getEnclosure() : null;
    }

    public void changeEnclosureName(EnclosureImpl encl, String newName) {
        if (newName == null || encl == null) {
            return;
        }
        if (!encl.getEnclosureName().equals(newName)) {
            PKIf oldKey = encl.getPK();
            encl.setEnclosureName(newName);
            this._enclByNameKey.remove(oldKey);
            this._enclByNameKey.put(encl.getEnclosurePK(), encl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnclosure(NameKey encPK, String newEncName, String ipAddress, String dmPath, int type, String vendor, String model, String version) throws Exception {
        EnclosureImpl enc;
        if (encPK == null) {
            enc = this.createEnclosure(newEncName, InetAddress.getByName(ipAddress), true);
        } else {
            enc = this.findEnclosureByPK(encPK);
            if (enc == null) {
                throw new Exception("enclosure " + encPK._name + " not found");
            }
            this.changeEnclosureName(enc, newEncName);
            enc.setIpAddress(ipAddress);
        }
        enc.setDMPath(dmPath);
        enc.setType(type);
        enc.setVendor(vendor);
        enc.setModel(model);
        enc.setVersion(version);
        InventoryPersistentManager.getInstance().persistDBObject(enc);
        long fId = 0L;
        if (enc.getEndPorts() != null && !enc.getEndPorts().isEmpty() && (fId = enc.getEndPorts().get(0).getFabric().getDBID()) > 0L) {
            HostManager.getInstance().persistEnclosureHosts(fId);
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            StorageEnclosureImpl.persistStorageEnclosures(con);
        }
        catch (Exception e) {
            _Logger.info((Object)("updateEnclosure: failed to update storage enclosure. " + e.getMessage()));
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void removeEnclosure(NameKey encPK) throws Exception {
        EnclosureImpl enc = this.findEnclosureByPK(encPK);
        if (enc == null) {
            throw new Exception("enclosure " + encPK._name + " not found");
        }
        ArrayList<EndPortImpl> eps = null;
        if (enc.getEndPorts() != null && !enc.getEndPorts().isEmpty()) {
            eps = new ArrayList<EndPortImpl>(enc.getEndPorts().size());
            eps.addAll(enc.getEndPorts());
            for (EndPortImpl ep : eps) {
                ep.setEnclosure(null);
            }
        }
        this._enclByNameKey.remove(encPK);
    }

    public void updateEndPortEnclosure(WwnKey epPK, NameKey encPK) throws Exception {
        EndPortImpl ep = this.findEndPortByPK(epPK);
        EnclosureImpl enc = null;
        if (encPK == null) {
            if (ep != null) {
                ep.setEnclosure(null);
            }
        } else {
            enc = this.findEnclosureByPK(encPK);
            if (enc == null) {
                enc = this.createEnclosure(encPK._name, null, true);
            }
            if (ep != null) {
                ep.setEnclosure(enc);
            } else {
                enc.addEndPort(epPK);
            }
        }
        if (enc != null) {
            InventoryPersistentManager.getInstance().persistDBObject(enc);
        }
        if (ep != null) {
            InventoryPersistentManager.getInstance().persistDBObject(ep);
        }
    }

    void purge() {
        Iterator<AbstractModelObjectImpl> it = this._switchByWwnKey.values().iterator();
        while (it.hasNext()) {
            SwitchImpl sw = it.next();
            if (sw.isPresent() || sw.getFabric() != null) continue;
            it.remove();
            InetAddress[] addrs = sw.getManagementAddresses();
            if (addrs == null) continue;
            for (int i = 0; i < addrs.length; ++i) {
                this._switchByIp.remove(addrs[i]);
            }
        }
        it = this._endportByWwnKey.values().iterator();
        while (it.hasNext()) {
            EndPortImpl ep = (EndPortImpl)it.next();
            if (ep.isPresent() || ep.getFabric() != null) continue;
            it.remove();
            this.updateEPSwIntKeyTableWithRemove(ep);
            EnclosureImpl enc = ep.getEnclosure();
            if (enc == null) continue;
            enc.dereferenceEndPort(ep);
        }
    }

    public static void addListener(ModelEventListenerIf listener) {
        if (_Listeners == null) {
            _Listeners = new ModelEventListenerIf[]{listener};
        } else {
            ModelEventListenerIf[] na = new ModelEventListenerIf[_Listeners.length + 1];
            System.arraycopy(_Listeners, 0, na, 0, _Listeners.length);
            na[SanManagerService._Listeners.length] = listener;
            _Listeners = na;
        }
    }

    static void notifyFabricOpened(FabricImpl fabric) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].fabricOpened(fabric);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricOpened:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricClosed(FabricImpl fabric) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].fabricClosed(fabric);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricClosed:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].fabricMerged(mergerFabric, mergeePK);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricMerged:", (Throwable)ex);
            }
        }
    }

    static void notifyFabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].fabricSplit(origFabric, newFabric);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyFabricSplit:", (Throwable)ex);
            }
        }
    }

    static void notifyMembersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
        boolean autoReg;
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].membersAdded(fabric, mos);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersAdded:", (Throwable)ex);
            }
        }
        boolean bl = autoReg = Boolean.valueOf(System.getProperty("trap.listen", "true")) != false && Boolean.valueOf(System.getProperty("trap.autoregistration", "true")) != false;
        if (!fabric.isInitialDiscovery() && autoReg) {
            for (int i = 0; i < mos.length; ++i) {
                SwitchImpl sw;
                if (!(mos[i] instanceof SwitchImpl) || (sw = (SwitchImpl)mos[i]).isTrapRegistered() || !sw.isManageableMDS()) continue;
                try {
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).registerTrap(sw.createPeer());
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
    }

    static void notifyMembersRemoved(FabricImpl fabric, PKIf[] pks) {
        int i;
        for (i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].membersRemoved(fabric, pks);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersRemoved:", (Throwable)ex);
            }
        }
        if (!fabric.isInitialDiscovery()) {
            for (i = 0; i < pks.length; ++i) {
                SwitchImpl sw;
                if (!(pks[i] instanceof WwnKey) || (sw = SanManager.getInstance().findSwitch((WwnKey)pks[i], fabric.getPK())) == null || !sw.isTrapRegistered() || !sw.isManageableMDS()) continue;
                try {
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).deregisterTrap(sw.createPeer());
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
    }

    static void notifyMembersChanged(FabricImpl fabric, ChangedModelObject[] mos) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].membersChanged(fabric, mos);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersChanged:", (Throwable)ex);
            }
        }
    }

    static void notifyMembersMoved(FabricImpl fabric, MovedModelObject[] mos) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].membersMoved(fabric, mos);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersMoved:", (Throwable)ex);
            }
        }
    }

    static void notifyMembersPurged(FabricImpl fabric, PKIf[] pks) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].memberPurged(fabric, pks);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyMembersPurged:", (Throwable)ex);
            }
        }
    }

    static void notifyModelObjectCreated(AbstractModelObjectImpl mo) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].modelObjectCreated(mo);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyModelObjectCreated:", (Throwable)ex);
            }
        }
    }

    static void notifyModelObjectRemoved(AbstractModelObjectImpl mo) {
        for (int i = 0; i < _Listeners.length; ++i) {
            try {
                _Listeners[i].modelObjectRemoved(mo);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyModelObjectRemoved:", (Throwable)ex);
            }
        }
    }

    public String dumpHashes() {
        Field[] flds;
        StringBuilder sb = new StringBuilder();
        for (Field field : flds = ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Object o = field.get((Object)this);
                if (!(o instanceof Map)) continue;
                String name = field.getName();
                Map map = (Map)o;
                sb.append('\n');
                if (name.charAt(0) == '_') {
                    sb.append(name.substring(1));
                } else {
                    sb.append(name);
                }
                sb.append(": ");
                if (map == null) {
                    sb.append("none");
                } else {
                    sb.append(map.size());
                    Set s = map.entrySet();
                    for (Map.Entry ent : s) {
                        sb.append("\n\tkey=").append(ent.getKey()).append(" \tvalue=").append(ent.getValue());
                    }
                }
                sb.append('\n');
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void purgeFabric(FabricImpl fabric) throws Exception {
        if (fabric == null) {
            return;
        }
        this.closeFabric(fabric);
        try {
            InventoryPersistentManager.getInstance();
            InventoryPersistentManager.purgeFabric(fabric);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("purge fabric " + fabric), (Throwable)ex);
            throw ex;
        }
        this.removeFabric(fabric);
    }

    public void purgeFabric(FabricPK pk, long fabricId) throws Exception {
        FabricImpl fabric = null;
        if (pk != null) {
            fabric = this.findFabric(pk);
        }
        if (fabric != null) {
            this.purgeFabric(fabric);
        } else if (fabricId > 0L) {
            try {
                InventoryPersistentManager.getInstance();
                InventoryPersistentManager.purgeFabric(fabricId);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge fabric " + fabricId), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void purgeSwitch(SwitchImpl sw) {
        if (sw == null) {
            return;
        }
        FabricImpl fabric = sw.getFabric();
        if (fabric != null) {
            fabric.removeSwitchAndLinks(sw);
        }
        this.removeSwitch(sw);
        try {
            InventoryPersistentManager.getInstance();
            InventoryPersistentManager.purgeSwitchAndComponents(sw);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("delete switch components" + sw), (Throwable)ex);
        }
    }

    public void purgeIsl(IslPK islPK) throws Exception {
        if (islPK == null) {
            return;
        }
        FabricImpl fabric = null;
        SwitchImpl sw = null;
        WwnKey swpk = islPK.getSwitchIntKey1()._swPK;
        if (swpk != null && (sw = this.findSwitch(swpk)) != null) {
            fabric = sw.getFabric();
        }
        if (fabric == null && (swpk = islPK.getSwitchIntKey2()._swPK) != null && (sw = this.findSwitch(swpk)) != null) {
            fabric = sw.getFabric();
        }
        if (fabric != null) {
            IslImpl isl = fabric.findIsl(islPK.getSwitchIntKey1());
            if (isl == null) {
                isl = fabric.findIsl(islPK.getSwitchIntKey2());
            }
            if (isl != null) {
                this.assertFabric(fabric);
                fabric.removeIsl(isl, true);
                InventoryPersistentManager.getInstance().purgeIsl(isl);
            } else {
                throw new Exception("Isl does not exist");
            }
        }
    }

    public void purgeEndPort(WwnKey pk) throws Exception {
        FabricImpl fabric;
        if (pk == null) {
            return;
        }
        EndPortImpl ep = this._endportByWwnKey.remove(pk);
        if (ep == null) {
            throw new Exception("Endport does not exist");
        }
        this.updateEPSwIntKeyTableWithRemove(ep);
        FabricPK fpk = ep.getFabricPK();
        if (fpk != null && (fabric = this.findFabric(fpk)) != null) {
            this.assertFabric(fabric);
            fabric.removeEndPort(ep, true);
            InventoryPersistentManager.getInstance().purgeEndPort(ep);
        }
    }

    public void purgeEnclosure(NameKey pk) throws Exception {
        if (pk == null) {
            return;
        }
        EnclosureImpl enclosure = this.findEnclosureByPK(pk);
        if (enclosure == null) {
            throw new Exception("Enclosure does not exist");
        }
        this.removeEnclosure(pk);
        InventoryPersistentManager.getInstance().purgeEnclosure(enclosure);
    }

    void assertFabric(FabricImpl fabric) throws Exception {
        if (fabric != null && fabric.isDiscovering()) {
            throw new Exception("DCNM is busy polling/discovering this fabric");
        }
    }

    public void loadFabricsFromDB() throws SQLException {
        InventoryPersistentManager mgr = InventoryPersistentManager.getInstance();
        mgr.loadPersistentFabricsFromDB();
        FabricImpl[] fs = this.getFabrics();
        if (fs != null) {
            DiscoveryManager dm = DiscoveryManager.getInstance();
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].isPersistent()) continue;
                dm.discoverFabric(fs[i], DiscoveryType.FABRIC_INITIAL);
            }
        }
    }
}

