/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.SnmpCommunityBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class SnmpCommunityImpl
extends AbstractDBObjectImpl {
    final SnmpCommunityBase _snmpCommunityBase;
    static final String QuerySQL = "select id, ip_address, read, write from snmp_community";
    static final String QuerySQLByIPReadWrite = "select id from snmp_community where ip_address=? and read=? and write=?";
    static final String InsertSQL = "insert into snmp_community(id, ip_address, read, write) values(?,?,?,?)";
    static final String UpdateSQL = "update snmp_community set ip_address=?, read=?, write=? where id=?";
    static final String TableName = "snmp_community";

    public SnmpCommunityImpl(SnmpCommunityBase base) {
        this._snmpCommunityBase = base;
        this.setDBID(base.getDBID());
    }

    @Override
    public long getDBID() {
        return this._snmpCommunityBase.getDBID();
    }

    @Override
    public void setDBID(long id) {
        this._snmpCommunityBase.setDBID(id);
    }

    void checkPreexistRecord(Connection con) throws SQLException {
        PreparedStatement stat = con.prepareStatement(QuerySQLByIPReadWrite);
        ResultSet rs = null;
        try {
            this.setupCheckExistenceStatement(stat);
            rs = stat.executeQuery();
            if (rs.next()) {
                this.setDBID(rs.getLong(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB() throws SQLException {
        ArrayList<SnmpCommunityBase> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQL);
            rs = stat.executeQuery();
            ArrayList<SnmpCommunityBase> al = new ArrayList<SnmpCommunityBase>();
            while (rs.next()) {
                SnmpCommunityBase b = new SnmpCommunityBase(rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4));
                al.add(b);
            }
            arrayList = al;
        }
        catch (SQLException ex) {
            ArrayList arrayList2;
            try {
                ex.printStackTrace();
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByIPReadWrite;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setString(2, this._snmpCommunityBase.getIpAddress());
        stat.setString(3, this._snmpCommunityBase.getReadCommunityString());
        stat.setString(4, this._snmpCommunityBase.getWriteCommunityString());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._snmpCommunityBase.getIpAddress());
        stat.setString(2, this._snmpCommunityBase.getReadCommunityString());
        stat.setString(3, this._snmpCommunityBase.getWriteCommunityString());
        stat.setLong(4, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._snmpCommunityBase.getIpAddress());
        stat.setString(2, this._snmpCommunityBase.getReadCommunityString());
        stat.setString(3, this._snmpCommunityBase.getWriteCommunityString());
    }
}

