/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.UcsBladeBase;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UcsBladeImpl
extends AbstractModelObjectImpl {
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    static final String QueryExistingRecord = "select id from ucs_blade where switch_id=? and dn=?";
    static final String InsertSQL = "insert into ucs_blade(id, switch_id, admin_power, admin_state, assigned_to_dn, association, availability, available_memory, chassis_id, descr, dn, low_voltage_memory, managing_inst, memory_speed, model, name, num_of_adaptors, num_of_cores, num_of_cores_enabled, num_of_cpus, num_of_eth_host_ifs, num_of_fc_host_ifs, num_of_threads, oper_power, oper_qualifier, oper_state, operability, original_uuid, presence, revision, serial, server_id, slot_id,  total_memory, uuid, vendor, created_time, last_update_time) values (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    static final String UpdateSQL = "update ucs_blade set switch_id=?, admin_power=?, admin_state=?, assigned_to_dn=?, association=?, availability=?, available_memory=?, chassis_id=?, descr=?, dn=?, low_voltage_memory=?, managing_inst=?, memory_speed=?, model=?, name=?, num_of_adaptors=?, num_of_cores=?, num_of_cores_enabled=?, num_of_cpus=?, num_of_eth_host_ifs=?, num_of_fc_host_ifs=?, num_of_threads=?, oper_power=?, oper_qualifier=?, oper_state=?, operability=?, original_uuid=?, presence=?, revision=?, serial=?, server_id=?, slot_id=?, total_memory=?, uuid=?, vendor=?, last_update_time=? where id=?";
    static final String UcsBladeCleanSQL = "delete from ucs_blade where switch_id=? and last_update_time < ?";
    private UcsBladeBase base = null;
    private final String tableName = "UCS_BLADE";

    public UcsBladeImpl() {
    }

    public UcsBladeImpl(long swId, String adminPower, String adminState, String assignedToDn, String association, String availability, long availableMemory, int chassisId, String descr, String dn, String lowVoltageMemory, String managingInst, int memorySpeed, String model, String name, int numOfAdaptors, int numOfCores, int numOfCoresEnabled, int numOfCpus, int numOfEthHostIfs, int numOfFcHostIfs, int numOfThreads, String operPower, String operQualifier, String operState, String operability, String originalUuid, String presence, int revision, String serial, String serverId, int slotId, long totalMemory, String uuid, String vendor) {
        this.base = new UcsBladeBase(swId, adminPower, adminState, assignedToDn, association, availability, availableMemory, chassisId, descr, dn, lowVoltageMemory, managingInst, memorySpeed, model, name, numOfAdaptors, numOfCores, numOfCoresEnabled, numOfCpus, numOfEthHostIfs, numOfFcHostIfs, numOfThreads, operPower, operQualifier, operState, operability, originalUuid, presence, revision, serial, serverId, slotId, totalMemory, uuid, vendor);
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this.base;
    }

    public UcsBladeBase getBase() {
        return this.base;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        return true;
    }

    @Override
    public String getDBTableName() {
        return "UCS_BLADE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QueryExistingRecord);
                stat.setLong(1, this.base.getSwitchId());
                stat.setString(2, this.base.getDn());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setLong(i++, this.base.getSwitchId());
        stat.setString(i++, this.base.getAdminPower());
        stat.setString(i++, this.base.getAdminState());
        stat.setString(i++, this.base.getAssignedToDn());
        stat.setString(i++, this.base.getAssociation());
        stat.setString(i++, this.base.getAvailability());
        stat.setLong(i++, this.base.getAvailableMemory());
        stat.setInt(i++, this.base.getChassisId());
        stat.setString(i++, this.base.getDescr());
        stat.setString(i++, this.base.getDn());
        stat.setString(i++, this.base.getLowVoltageMemory());
        stat.setString(i++, this.base.getManagingInst());
        stat.setInt(i++, this.base.getMemorySpeed());
        stat.setString(i++, this.base.getModel());
        stat.setString(i++, this.base.getName());
        stat.setInt(i++, this.base.getNumOfAdaptors());
        stat.setInt(i++, this.base.getNumOfCores());
        stat.setInt(i++, this.base.getNumOfCoresEnabled());
        stat.setInt(i++, this.base.getNumOfCpus());
        stat.setInt(i++, this.base.getNumOfEthHostIfs());
        stat.setInt(i++, this.base.getNumOfFcHostIfs());
        stat.setInt(i++, this.base.getNumOfThreads());
        stat.setString(i++, this.base.getOperPower());
        stat.setString(i++, this.base.getOperQualifier());
        stat.setString(i++, this.base.getOperState());
        stat.setString(i++, this.base.getOperability());
        stat.setString(i++, this.base.getOriginalUuid());
        stat.setString(i++, this.base.getPresence());
        stat.setInt(i++, this.base.getRevision());
        stat.setString(i++, this.base.getSerial());
        stat.setString(i++, this.base.getServerId());
        stat.setInt(i++, this.base.getSlotId());
        stat.setLong(i++, this.base.getTotalMemory());
        stat.setString(i++, this.base.getUuid());
        stat.setString(i++, this.base.getVendor());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, System.currentTimeMillis());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.base.getSwitchId());
        stat.setString(i++, this.base.getAdminPower());
        stat.setString(i++, this.base.getAdminState());
        stat.setString(i++, this.base.getAssignedToDn());
        stat.setString(i++, this.base.getAssociation());
        stat.setString(i++, this.base.getAvailability());
        stat.setLong(i++, this.base.getAvailableMemory());
        stat.setInt(i++, this.base.getChassisId());
        stat.setString(i++, this.base.getDescr());
        stat.setString(i++, this.base.getDn());
        stat.setString(i++, this.base.getLowVoltageMemory());
        stat.setString(i++, this.base.getManagingInst());
        stat.setInt(i++, this.base.getMemorySpeed());
        stat.setString(i++, this.base.getModel());
        stat.setString(i++, this.base.getName());
        stat.setInt(i++, this.base.getNumOfAdaptors());
        stat.setInt(i++, this.base.getNumOfCores());
        stat.setInt(i++, this.base.getNumOfCoresEnabled());
        stat.setInt(i++, this.base.getNumOfCpus());
        stat.setInt(i++, this.base.getNumOfEthHostIfs());
        stat.setInt(i++, this.base.getNumOfFcHostIfs());
        stat.setInt(i++, this.base.getNumOfThreads());
        stat.setString(i++, this.base.getOperPower());
        stat.setString(i++, this.base.getOperQualifier());
        stat.setString(i++, this.base.getOperState());
        stat.setString(i++, this.base.getOperability());
        stat.setString(i++, this.base.getOriginalUuid());
        stat.setString(i++, this.base.getPresence());
        stat.setInt(i++, this.base.getRevision());
        stat.setString(i++, this.base.getSerial());
        stat.setString(i++, this.base.getServerId());
        stat.setInt(i++, this.base.getSlotId());
        stat.setLong(i++, this.base.getTotalMemory());
        stat.setString(i++, this.base.getUuid());
        stat.setString(i++, this.base.getVendor());
        stat.setLong(i++, System.currentTimeMillis());
        stat.setLong(i++, this.getDBID());
    }

    public void persistDBObject(Connection con) throws DBException, SQLException {
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        try {
            ps = this.getUpdateSql(con);
            if (ps != null) {
                ps.execute();
                int count = ps.getUpdateCount();
                if (count == 0) {
                    _Logger.log((Priority)Level.INFO, (Object)("update 0 count, insert object: " + this.getClass().getName()));
                    this.setDBID(0L);
                    ps1 = this.getUpdateSql(con);
                    ps1.execute();
                }
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)"persistDBObject", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(ps);
            DbUtil.close(ps1);
        }
    }

    public static void persistUcsBlades(Connection con, List<UcsBladeImpl> blades) throws SQLException, DBException {
        if (blades == null || blades.isEmpty()) {
            return;
        }
        try {
            for (int i = 0; i < blades.size(); ++i) {
                blades.get(i).persistDBObject(con);
            }
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        catch (DBException dbex) {
            throw dbex;
        }
    }

    public static void deleteOldUcsBlades(Connection con, long swId, long updateTime) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(UcsBladeCleanSQL);
            ps.setLong(1, swId);
            ps.setLong(2, updateTime);
            ps.execute();
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        finally {
            DbUtil.close(ps);
        }
    }
}

