/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.UcsBladeMgmtIfBase;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UcsBladeMgmtIfImpl
extends AbstractModelObjectImpl {
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    static final String QueryExistingRecord = "select id from ucs_blade_mgmt_if where switch_id=? and blade_id=? and dn=?";
    static final String InsertSQL = "insert into ucs_blade_mgmt_if(id, switch_id, blade_id, access_type, admin_state, discovery, dn, epdn, ext_broadcast, ext_gw, ext_ip, ext_mask, if_id, if_role, if_type, ip, locale, mac, mask, name, peer_chassis_id, peer_dn, peer_port_id, peer_slot_id, port_id, slot_id, state_qual, subject, transport, type, vnet, created_time, last_update_time) values (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    static final String UpdateSQL = "update ucs_blade_mgmt_if set switch_id=?, blade_id=?, access_type=?, admin_state=?, discovery=?, dn=?, epdn=?, ext_broadcast=?, ext_gw=?, ext_ip=?, ext_mask=?, if_id=?, if_role=?, if_type=?, ip=?, locale=?, mac=?, mask=?, name=?, peer_chassis_id=?, peer_dn=?, peer_port_id=?, peer_slot_id=?, port_id=?, slot_id=?, state_qual=?, subject=?, transport=?, type=?, vnet=?, last_update_time=? where id=?";
    static final String CleanSQL = "delete from ucs_blade_mgmt_if where switch_id=? and last_update_time < ?";
    private UcsBladeMgmtIfBase base = null;
    private final String tableName = "UCS_BLADE_MGMT_IF";

    public UcsBladeMgmtIfImpl() {
    }

    public UcsBladeMgmtIfImpl(String access, String adminState, String discovery, String dn, String epDn, String extBroadcast, String extGw, String extIp, String extMask, int ifId, String ifRole, String ifType, String ip, String locale, String mac, String mask, String name, String peerChassisId, String peerDn, int peerPortId, int peerSlotId, int portId, int slotId, String stateQual, String subject, String transport, String type, int vnet) {
        this.base = new UcsBladeMgmtIfBase(access, adminState, discovery, dn, epDn, extBroadcast, extGw, extIp, extMask, ifId, ifRole, ifType, ip, locale, mac, mask, name, peerChassisId, peerDn, peerPortId, peerSlotId, portId, slotId, stateQual, subject, transport, type, vnet);
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this.base;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        return true;
    }

    public UcsBladeMgmtIfBase getBase() {
        return this.base;
    }

    @Override
    public String getDBTableName() {
        return "UCS_BLADE_MGMT_IF";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QueryExistingRecord);
                stat.setLong(1, this.base.getSwitchId());
                stat.setLong(2, this.base.getBladeId());
                stat.setString(3, this.base.getDn());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setLong(i++, this.base.getSwitchId());
        stat.setLong(i++, this.base.getBladeId());
        stat.setString(i++, this.base.getAccess());
        stat.setString(i++, this.base.getAdminState());
        stat.setString(i++, this.base.getDiscovery());
        stat.setString(i++, this.base.getDn());
        stat.setString(i++, this.base.getEpDn());
        stat.setString(i++, this.base.getExtBroadcast());
        stat.setString(i++, this.base.getExtGw());
        stat.setString(i++, this.base.getExtIp());
        stat.setString(i++, this.base.getExtMask());
        stat.setInt(i++, this.base.getIfId());
        stat.setString(i++, this.base.getIfRole());
        stat.setString(i++, this.base.getIfType());
        stat.setString(i++, this.base.getIp());
        stat.setString(i++, this.base.getLocale());
        stat.setString(i++, this.base.getMac());
        stat.setString(i++, this.base.getMask());
        stat.setString(i++, this.base.getName());
        stat.setString(i++, this.base.getPeerChassisId());
        stat.setString(i++, this.base.getPeerDn());
        stat.setInt(i++, this.base.getPeerPortId());
        stat.setInt(i++, this.base.getPeerSlotId());
        stat.setInt(i++, this.base.getPortId());
        stat.setInt(i++, this.base.getSlotId());
        stat.setString(i++, this.base.getStateQual());
        stat.setString(i++, this.base.getSubject());
        stat.setString(i++, this.base.getTransport());
        stat.setString(i++, this.base.getType());
        stat.setInt(i++, this.base.getVnet());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, System.currentTimeMillis());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.base.getSwitchId());
        stat.setLong(i++, this.base.getBladeId());
        stat.setString(i++, this.base.getAccess());
        stat.setString(i++, this.base.getAdminState());
        stat.setString(i++, this.base.getDiscovery());
        stat.setString(i++, this.base.getDn());
        stat.setString(i++, this.base.getEpDn());
        stat.setString(i++, this.base.getExtBroadcast());
        stat.setString(i++, this.base.getExtGw());
        stat.setString(i++, this.base.getExtIp());
        stat.setString(i++, this.base.getExtMask());
        stat.setInt(i++, this.base.getIfId());
        stat.setString(i++, this.base.getIfRole());
        stat.setString(i++, this.base.getIfType());
        stat.setString(i++, this.base.getIp());
        stat.setString(i++, this.base.getLocale());
        stat.setString(i++, this.base.getMac());
        stat.setString(i++, this.base.getMask());
        stat.setString(i++, this.base.getName());
        stat.setString(i++, this.base.getPeerChassisId());
        stat.setString(i++, this.base.getPeerDn());
        stat.setInt(i++, this.base.getPeerPortId());
        stat.setInt(i++, this.base.getPeerSlotId());
        stat.setInt(i++, this.base.getPortId());
        stat.setInt(i++, this.base.getSlotId());
        stat.setString(i++, this.base.getStateQual());
        stat.setString(i++, this.base.getSubject());
        stat.setString(i++, this.base.getTransport());
        stat.setString(i++, this.base.getType());
        stat.setInt(i++, this.base.getVnet());
        stat.setLong(i++, System.currentTimeMillis());
        stat.setLong(i++, this.getDBID());
    }

    public void persistDBObject(Connection con) throws DBException, SQLException {
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        try {
            ps = this.getUpdateSql(con);
            if (ps != null) {
                ps.execute();
                int count = ps.getUpdateCount();
                if (count == 0) {
                    _Logger.log((Priority)Level.INFO, (Object)("update 0 count, insert object: " + this.getClass().getName()));
                    this.setDBID(0L);
                    ps1 = this.getUpdateSql(con);
                    ps1.execute();
                }
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)"UcsBladeMgmtIfImpl.persistDBObject failed", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(ps);
            DbUtil.close(ps1);
        }
    }

    public static void persist(Connection con, List<UcsBladeMgmtIfImpl> mgmtIfs) throws SQLException, DBException {
        if (mgmtIfs == null || mgmtIfs.isEmpty()) {
            return;
        }
        try {
            for (int i = 0; i < mgmtIfs.size(); ++i) {
                mgmtIfs.get(i).persistDBObject(con);
            }
        }
        catch (SQLException sqlex) {
            _Logger.log((Priority)Level.WARN, (Object)"UcsBladeMgmtIfImpl.persistDBObject failed", (Throwable)sqlex);
            throw sqlex;
        }
        catch (DBException dbex) {
            throw dbex;
        }
    }

    public static void deleteOldObjects(Connection con, long swId, long updateTime) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(CleanSQL);
            ps.setLong(1, swId);
            ps.setLong(2, updateTime);
            ps.execute();
        }
        catch (SQLException sqlex) {
            _Logger.log((Priority)Level.WARN, (Object)"UcsBladeMgmtIfImpl.deleteOldObjects failed", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(ps);
        }
    }
}

