/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DataStoreImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GuestNicImpl;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.vi.model.GuestNic;
import com.cisco.dcbu.vi.model.PhyNic;
import com.cisco.dcbu.vi.model.VirtualMachine;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class VmImpl
extends AbstractModelObjectImpl {
    static final String QuerySQLByName = "select id, vcenter_id, vhost_id, name, memory_size, cpucount, os_type, dns_name, ip_address, power_state, heart_beat_status, disk_read_avg, disk_write_avg, moRef, last_scan_time from vm where moref=? and vcenter_id=? order by vhost_id ";
    static final String QuerySQLByVhostIDName = "select id, vcenter_id, vhost_id, name, memory_size, cpucount, os_type, dns_name, ip_address, power_state, heart_beat_status, disk_read_avg, disk_write_avg, moRef, last_scan_time from vm where vhost_id=? and wwn=?";
    static final String QueryExistingRecordSQL = "select id, vcenter_id, vhost_id, name, memory_size, cpucount, os_type, dns_name, ip_address, power_state, heart_beat_status, disk_read_avg, disk_write_avg, moRef, last_scan_time from vm where moref=? and vhost_id=? ";
    static final String InsertSQL = "insert into vm(id, vcenter_id, vhost_id, name, full_name, memory_size, cpucount, os_type, dns_name, ip_address, power_state, heart_beat_status, disk_read_avg, disk_write_avg, moRef, last_scan_time,last_update_time) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?)";
    static final String UpdateSQL = "update vm set vcenter_id=?, vhost_id=?, name=?, full_name=?, memory_size=?, cpucount=?, os_type=?, dns_name=?, ip_address=?, power_state=?, heart_beat_status=?, disk_read_avg=?, disk_write_avg=?, moref=?, last_scan_time=?, last_update_time=? where id=?";
    static final String DeleteSQL = "delete from vm where id=?";
    static final String TableName = "vm";
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    private final VirtualMachine _base;
    private VHostImpl _vhost;
    private DataStoreImpl _dataStore;
    private ConcurrentHashMap<NameKey, GuestNicImpl> _guestnicByNameKey = new ConcurrentHashMap();
    static final String[] LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};

    VmImpl(String name, String fullName, String moRef, long memorySize, int cpuCount, String ostype) {
        this._base = new VirtualMachine(name, fullName, moRef, memorySize, cpuCount, ostype);
    }

    VmImpl(String name, String fullName, String moRef, long memorySize, int cpuCount, long hostId, String ostype, String ipaddr, int powerState) {
        this._base = new VirtualMachine(name, fullName, moRef, memorySize, cpuCount, hostId, ostype, ipaddr, powerState);
    }

    public VmImpl(VirtualMachine vbase) {
        this._base = vbase;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public NameKey getVmPK() {
        return (NameKey)this._base.getPK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QueryExistingRecordSQL);
                stat.setString(1, this.getMoRef());
                stat.setLong(2, this.getHostId());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        FabricImpl fabric = this.getFabric();
        if (fabric == null) {
            return null;
        }
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getDeleteSqlStr() {
        return DeleteSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByName;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        if (this._vhost != null) {
            VirtualCenterImpl vc = this._vhost.getVirtualCenter();
            if (vc != null) {
                stat.setLong(2, vc.getDBID());
            } else {
                stat.setLong(2, 0L);
            }
            stat.setLong(3, this._vhost.getDBID());
        } else {
            stat.setLong(2, 0L);
            stat.setLong(3, 0L);
        }
        stat.setString(4, this._base.getName());
        stat.setString(5, this._base.getFullName());
        stat.setLong(6, this._base.getMemorySize());
        stat.setInt(7, this._base.getCpuCount());
        stat.setString(8, this._base.getOstype());
        stat.setString(9, "");
        InetAddress ipAddr = null;
        try {
            if (this._base.getIpAddress() != null && !this._base.getIpAddress().trim().equals("")) {
                ipAddr = InetAddress.getByName(this._base.getIpAddress());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (ipAddr != null) {
            stat.setBytes(10, ipAddr.getAddress());
        } else {
            stat.setNull(10, -2);
        }
        stat.setInt(11, this._base.getPowerState());
        stat.setString(12, this._base.getGuestHeartbeatStatus());
        stat.setDouble(13, this._base.getDiskReadAvg());
        stat.setDouble(14, this._base.getDiskWriteAvg());
        stat.setString(15, this._base.getMoRef());
        stat.setLong(16, this._base.getLastScanTime());
        long lastUpdateTime = System.currentTimeMillis();
        stat.setTimestamp(17, new Timestamp(lastUpdateTime));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._vhost != null) {
            VirtualCenterImpl vc = this._vhost.getVirtualCenter();
            if (vc != null) {
                stat.setLong(1, vc.getDBID());
            } else {
                stat.setLong(1, 0L);
            }
            stat.setLong(2, this._vhost.getDBID());
        } else {
            stat.setLong(1, 0L);
            stat.setLong(2, 0L);
        }
        stat.setString(3, this._base.getName());
        stat.setString(4, this._base.getFullName());
        stat.setLong(5, this._base.getMemorySize());
        stat.setInt(6, this._base.getCpuCount());
        stat.setString(7, this._base.getOstype());
        stat.setString(8, "");
        InetAddress ipAddr = null;
        try {
            if (this._base.getIpAddress() != null && !this._base.getIpAddress().trim().equals("")) {
                ipAddr = InetAddress.getByName(this._base.getIpAddress());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (ipAddr != null) {
            stat.setBytes(9, ipAddr.getAddress());
        } else {
            stat.setNull(9, -2);
        }
        stat.setInt(10, this._base.getPowerState());
        stat.setString(11, this._base.getGuestHeartbeatStatus());
        stat.setDouble(12, this._base.getDiskReadAvg());
        stat.setDouble(13, this._base.getDiskWriteAvg());
        stat.setString(14, this._base.getMoRef());
        stat.setLong(15, this._base.getLastScanTime());
        long lastUpdateTime = System.currentTimeMillis();
        stat.setTimestamp(16, new Timestamp(lastUpdateTime));
        stat.setLong(17, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._base.getMoRef());
        if (this._vhost != null) {
            VirtualCenterImpl vc = this._vhost.getVirtualCenter();
            if (vc != null) {
                stat.setLong(2, vc.getDBID());
            } else {
                stat.setLong(2, 0L);
            }
        } else {
            stat.setLong(2, 0L);
        }
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        return wasPresent;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    public VHostImpl getVhost() {
        return this._vhost;
    }

    public void setVhost(VHostImpl vhost) {
        NameKey newVhostPK;
        NameKey oldVhostPK = this._base.getVhostPK();
        NameKey nameKey = newVhostPK = vhost == null ? null : (NameKey)vhost.getPK();
        if (!GenUtil.equals(oldVhostPK, newVhostPK)) {
            if (this._vhost != vhost) {
                if (this._vhost != null) {
                    this._vhost.removeVm((NameKey)this._base.getPK());
                }
                if (vhost != null) {
                    vhost.addVm(this);
                }
                this._vhost = vhost;
            }
            this._base.setVhostPK(newVhostPK);
        }
    }

    public DataStoreImpl getDataStore() {
        return this._dataStore;
    }

    public void setDataStore(DataStoreImpl dataStore) {
        NameKey newDataStorePK;
        NameKey oldDataStorePK = this._base.getDataStorePK();
        NameKey nameKey = newDataStorePK = dataStore == null ? null : (NameKey)dataStore.getPK();
        if (!GenUtil.equals(oldDataStorePK, newDataStorePK)) {
            this._dataStore = dataStore;
            this._base.setDataStorePK(newDataStorePK);
            this._base.setDataStore(dataStore.getName());
        }
    }

    public NameKey getNameKey() {
        return this._base.getNameKey();
    }

    public String getName() {
        return this._base.getName();
    }

    public void setName(String name) {
        this._base.setName(name);
    }

    public String getFullName() {
        return this._base.getFullName();
    }

    public void setFullName(String name) {
        this._base.setFullName(name);
    }

    public long getMemorySize() {
        return this._base.getMemorySize();
    }

    public void setMemorySize(long memorySize) {
        this._base.setMemorySize(memorySize);
    }

    public int getCpuCount() {
        return this._base.getCpuCount();
    }

    public void setCpuCount(int cpuCount) {
        this._base.setCpuCount(cpuCount);
    }

    public int getPowerState() {
        return this._base.getPowerState();
    }

    public void setPowerState(int powerState) {
        this._base.setPowerState(powerState);
    }

    public String getGuestHeartbeatStatus() {
        return this._base.getGuestHeartbeatStatus();
    }

    public void setGuestHeartbeatStatus(String guestHeartbeatStatus) {
        this._base.setGuestHeartbeatStatus(guestHeartbeatStatus);
    }

    public String getOstype() {
        return this._base.getOstype();
    }

    public void setOstype(String ostype) {
        this._base.setOstype(ostype);
    }

    public String getIpAddress() {
        return this._base.getIpAddress();
    }

    public void setIpAddress(String ipaddress) {
        this._base.setIpAddress(ipaddress);
    }

    public String getDnsName() {
        return this._base.getDnsName();
    }

    public void setDnsName(String dnsname) {
        this._base.setDnsName(dnsname);
    }

    public GuestNic[] getVnic() {
        return this._base.getVnic();
    }

    public void setVnic(GuestNic[] vnic) {
        this._base.setVnic(vnic);
    }

    public List<String> getPnicKeys() {
        return this._base.getPnicKeys();
    }

    public PhyNic[] getPnic() {
        return this._base.getPnic();
    }

    public void setPnic(PhyNic[] pnic) {
        this._base.setPnic(pnic);
    }

    public long getHostId() {
        return this._base.getHostId();
    }

    public void setHostId(long hostId) {
        this._base.setHostId(hostId);
    }

    public double getDiskReadAvg() {
        return this._base.getDiskReadAvg();
    }

    public void setDiskReadAvg(double diskReadAvg) {
        this._base.setDiskReadAvg(diskReadAvg);
    }

    public double getDiskWriteAvg() {
        return this._base.getDiskWriteAvg();
    }

    public void setDiskWriteAvg(double diskWriteAvg) {
        this._base.setDiskWriteAvg(diskWriteAvg);
    }

    public long getLastUpdateTime() {
        return this._base.getLastUpdateTime();
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this._base.setLastUpdateTime(lastUpdateTime);
    }

    public String getMoRef() {
        return this._base.getMoRef();
    }

    public void setMoRef(String moRef) {
        this._base.setMoRef(moRef);
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(LIL[level]).append("VM : ").append(this.getMoRef()).append(LIL[level + 1]).append("Name: ").append(this.getName()).append(LIL[level + 1]).append("FullName: ").append(this.getFullName()).append(LIL[level + 1]).append("MemorySize: ").append(this.getMemorySize()).append(LIL[level + 1]).append("CpuCount: ").append(this.getCpuCount()).append(LIL[level + 1]).append("HostId: ").append(this.getHostId()).append(LIL[level + 1]).append("OsType: ").append(this.getOstype()).append(LIL[level + 1]).append("DnsName: ").append(this.getDnsName()).append(LIL[level + 1]).append("IpAddress: ").append(this.getIpAddress()).append(LIL[level + 1]).append("GuestHeartbeatStatus: ").append(this.getGuestHeartbeatStatus()).append(LIL[level + 1]).append("PowerState: ").append(this.getPowerState()).append(LIL[level + 1]).append("DataStore: ").append(this._base.getDataStore()).append(LIL[level + 1]).append("DiskReadAvg: ").append(this.getDiskReadAvg()).append(LIL[level + 1]).append("DiskWriteAvg: ").append(this.getDiskWriteAvg()).append(LIL[level + 1]).append("LastUpdateTime: ").append(new Date(this.getLastUpdateTime()));
        sb.append(LIL[level + 1]).append("Virtual NICs: ");
        GuestNic[] vnics = this.getVnic();
        if (vnics == null || vnics.length == 0) {
            sb.append(LIL[level + 2]).append("n/a");
        } else {
            for (int i = 0; i < vnics.length; ++i) {
                if (vnics[i] == null) continue;
                sb.append(LIL[level + 2]).append("Network: ").append(vnics[i].getNetwork()).append(LIL[level + 2]).append("MacAddress: ").append(vnics[i].getMacAddress()).append(LIL[level + 2]).append("IpAddresses: ");
                String[] ipAddresses = vnics[i].getIpAddress();
                for (int j = 0; ipAddresses != null && j < ipAddresses.length; ++j) {
                    sb.append(LIL[level + 2]).append(ipAddresses[j]).append(",");
                }
                sb.append("\n");
            }
        }
        sb.append(LIL[level + 1]).append("Host Physical NICs: ");
        PhyNic[] pnics = this.getPnic();
        if (pnics == null || pnics.length == 0) {
            sb.append(LIL[level + 2]).append("n/a");
        } else {
            for (int i = 0; i < pnics.length; ++i) {
                if (pnics[i] != null) {
                    sb.append(LIL[level + 2]).append("Device: ").append(pnics[i].getDevice()).append(LIL[level + 2]).append("Key: ").append(pnics[i].getKey()).append(LIL[level + 2]).append("MacAddress: ").append(pnics[i].getMac());
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVNics(GuestNic[] vnics) {
        ConcurrentHashMap<NameKey, GuestNicImpl> concurrentHashMap = this._guestnicByNameKey;
        synchronized (concurrentHashMap) {
            ArrayList prevnics = new ArrayList(this._guestnicByNameKey.keySet());
            for (int i = 0; vnics != null && i < vnics.length; ++i) {
                GuestNicImpl vnicImpl = this.findGuestnicByName(vnics[i].getMacAddress());
                if (vnicImpl == null) {
                    vnicImpl = new GuestNicImpl(vnics[i]);
                } else {
                    vnicImpl.setNetwork(vnics[i].getNetwork());
                    vnicImpl.setIpAddress(vnics[i].getIpAddress());
                }
                vnicImpl.setVM(this);
                this._guestnicByNameKey.put(new NameKey(vnics[i].getMacAddress()), vnicImpl);
                prevnics.remove(new NameKey(vnics[i].getMacAddress()));
            }
            for (NameKey prevnic : prevnics) {
                this._guestnicByNameKey.remove(prevnic);
            }
            this._base.setVnic(vnics);
        }
    }

    public GuestNicImpl findGuestnicByPK(NameKey pkey) {
        return pkey == null ? null : this._guestnicByNameKey.get(pkey);
    }

    public GuestNicImpl findGuestnicByName(String name) {
        return this.findGuestnicByPK(new NameKey(name));
    }

    public GuestNicImpl[] getVNics() {
        return this._guestnicByNameKey.values().toArray(new GuestNicImpl[this._guestnicByNameKey.size()]);
    }

    public PhyNic[] getPhyNics() {
        return this._base.getPnic();
    }

    public PhyNicImpl getPhyNic(String pnickey) {
        return this._vhost.findPhynicByName(pnickey);
    }
}

