/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class VmPhynicImpl
extends AbstractDBObjectImpl {
    static final String QuerySQLByVcenterId = "select vm_phynic_info.vm_id, vm_phynic_info.phynic_id from vm_phynic_info, vm where vm.vcenter_id = ? and vm_phynic_info.vm_id = vm.id";
    static final String QuerySQLByvmIdphynicId = "select vm_id, phynic_id from vm_phynic_info where vm_id=? and phynic_id=?";
    static final String InsertSQL = "insert into vm_phynic_info(vm_id, phynic_id, last_update_time) values(?,?,?)";
    static final String UpdateSQL = "update vm_phynic_info set last_update_time=? where vm_id=? and phynic_id=?";
    static final String TableName = "vm_phynic_info";
    final VmImpl _vm;
    final PhyNicImpl _phynic;

    public VmPhynicImpl(VmImpl vm, PhyNicImpl phynic) throws IllegalArgumentException {
        if (vm == null || phynic == null) {
            throw new IllegalArgumentException("Null vm or phynic is not allowed");
        }
        this._vm = vm;
        this._phynic = phynic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = con.prepareStatement(QuerySQLByvmIdphynicId);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(1L);
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByvmIdphynicId;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vm.getDBID());
        stat.setLong(2, this._phynic.getDBID());
        stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
        stat.setLong(2, this._vm.getDBID());
        stat.setLong(3, this._phynic.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vm.getDBID());
        stat.setLong(2, this._phynic.getDBID());
    }
}

