/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FlexAttachRunnable
extends NpvRunnable {
    static final int[] _cfaVirtualWwnAutoOid = MibNode.get("cfaVirtualWwnAuto").getOid();
    static Logger _logger = LogManager.getLogger((String)"fms.npv");
    protected SwitchBase _sw;
    protected SnmpUserOpt _snmpUserOpt;
    protected CommunicationObjectSender _sender;
    protected long _requestId;
    protected int _mode;

    public FlexAttachRunnable(long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, int mode, CommunicationObjectSender sender) {
        this._sw = sw;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        this._requestId = requestId;
        this._mode = mode;
    }

    @Override
    public void run() {
        try {
            QueueResponseObject result = this.setGlobalVirtualWWNAuto();
            this._sender.send(result);
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to set Virtual WWN Auto mode for switch:" + this._sw.toString() + " received error: " + se.getMessage()));
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    public QueueResponseObject setGlobalVirtualWWNAuto() throws SnmpException {
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_cfaVirtualWwnAutoOid), new SnmpInt(this._mode));
        SnmpPDU resp = peer.send(pdu);
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }
}

