/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.pm.PmConfig;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.pm.PMStatisticsManager;
import com.cisco.dcbu.sm.server.pm.PMSwitchSummary;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmDisplay;
import com.cisco.dcbu.sm.server.pm.PortGroupSummary;
import com.cisco.dcbu.sm.server.pm.Query;
import com.cisco.dcbu.sm.server.pm.pmutil.PMMigration;
import com.cisco.dcbu.sm.server.pm.pmutil.RrdToDBSync;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

public class PM {
    private static Timer _Timer = null;
    static DBSyncTask _SyncTask = null;
    static PmCollect _Collector = null;
    public static Logger _Logger = LogManager.getLogger((String)"PM");

    public static void main(String[] argv) {
        try {
            if (argv.length == 0 || argv[0].equals("help")) {
                PM.quit();
            } else {
                PM.loadProperties();
                switch (argv[0].charAt(0)) {
                    case 'e': {
                        if (argv.length != 2) break;
                        new PmDisplay().export(argv[1]);
                        break;
                    }
                    case 'x': {
                        if (argv.length != 3) break;
                        PM.export(argv[1], argv[2]);
                        break;
                    }
                    case 'm': {
                        PMMigration.main(new String[0]);
                        break;
                    }
                    case 's': {
                        RrdToDBSync.main(new String[0]);
                        break;
                    }
                    case 'c': {
                        if (argv.length != 2) break;
                        PmCollect.createRrd(Integer.parseInt(argv[1]));
                    }
                }
            }
        }
        catch (Exception ex) {
            if (_Logger == null) {
                System.out.println(ex.getMessage());
            } else {
                _Logger.fatal((Object)ex.getMessage());
            }
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void loadProperties() throws IOException {
        GenUtil.loadServerProperties(null);
        Logger _Log4j = LogManager.getLogger((String)"log4j");
        String logConfFile = System.getProperty("org.apache.log4j.file");
        if (logConfFile == null) {
            logConfFile = ClientCache.getConfDir() + "log4j_fms.xml";
            try {
                Logger temp;
                DOMConfigurator.configure((String)logConfFile);
                LoggerRepository lRep = LogManager.getLoggerRepository();
                Enumeration enu = lRep.getCurrentLoggers();
                while (enu.hasMoreElements()) {
                    temp = (Logger)enu.nextElement();
                    temp.setLevel(Level.OFF);
                }
                temp = lRep.getRootLogger();
                temp.setLevel(Level.OFF);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        _Log4j.info((Object)"Log4j configuration loaded!");
    }

    private static void quit() {
        System.out.println("usage: pm {[export <output_directory>]\n[xport <rrdFile> <xmlFile>]\n[sync]");
        System.exit(1);
    }

    public static void initLogger() {
        if (_Logger != null) {
            return;
        }
    }

    public static String collect() {
        String ret = null;
        try {
            _Collector = new PmCollect(true);
            if (_Timer == null) {
                _Timer = new Timer();
                _SyncTask = new DBSyncTask();
                _Timer.schedule((TimerTask)_SyncTask, 600000L, 3600000L);
                _Logger.info((Object)"DBSyncTask is added");
            }
            return ret;
        }
        catch (Exception ex) {
            _Logger.info((Object)("PM collection not started: " + ex.getMessage() + "--" + ex.toString()));
            ret = ex.getMessage();
            return ret;
        }
    }

    public static void stop() {
        if (_Timer != null) {
            _Timer.cancel();
            _Timer = null;
        }
        if (_SyncTask != null) {
            _SyncTask.stop();
            _SyncTask = null;
        }
        if (_Collector != null) {
            _Collector.stop();
            _Collector = null;
        }
    }

    public static boolean isRunning() throws Exception {
        return _SyncTask != null && PM._SyncTask.keepAlive;
    }

    public static void forceSyncDb(PrintStream ps) {
        if (_SyncTask != null) {
            _SyncTask.syncToDb();
            ps.println("forced to update db");
        } else {
            ps.println("_SyncTask is null");
        }
    }

    private static void printDetails(PrintStream ps, PmConfig[] configs) {
        if (configs == null) {
            return;
        }
        for (int i = 0; i < configs.length; ++i) {
            ps.println("       " + configs[i].toString());
        }
    }

    public static void printPmConfig(PrintStream ps, String[] params) {
        boolean showDetail = false;
        if (params != null && params[0].startsWith("det")) {
            showDetail = true;
        }
        if (_Collector != null) {
            ps.println("ISL:" + PmCollect._MetaData._islDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._islDef);
            }
            ps.println("FLOW:" + PmCollect._MetaData._flowDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._flowDef);
            }
            ps.println("INIT:" + PmCollect._MetaData._initiatorDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._initiatorDef);
            }
            ps.println("TARGET:" + PmCollect._MetaData._targetDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._targetDef);
            }
            ps.println("GIGE:" + PmCollect._MetaData._gigeDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._gigeDef);
            }
            ps.println("ETHINTF:" + PmCollect._MetaData._ethintfDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._ethintfDef);
            }
            ps.println("ETHISL:" + PmCollect._MetaData._ethislDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._ethislDef);
            }
            ps.println("OTHER:" + PmCollect._MetaData._otherDef.length);
            if (showDetail) {
                PM.printDetails(ps, PmCollect._MetaData._otherDef);
            }
            if (showDetail) {
                for (InetAddress ip : PmCollect._QueryByIp.keySet()) {
                    ps.println();
                    ps.println(ip.toString());
                    List<Query> querys = PmCollect._QueryByIp.get(ip);
                    for (Query q : querys) {
                        ps.println("         " + q._db.getRrdFile().getFilePath() + ":" + q.getIndex() + ":" + q._rrdPath);
                    }
                }
            }
        } else {
            ps.println("PM collector not configured");
        }
    }

    private static void export(String rrdFile, String xmlFile) throws IOException, RrdException {
        RrdDb rrdDb = new RrdDb(rrdFile);
        rrdDb.dumpXml(xmlFile);
        rrdDb.close();
    }

    private static void imp(String xmlFile, String rrdFile) throws IOException, RrdException {
        RrdDb rrdDb2 = new RrdDb(rrdFile, xmlFile);
        rrdDb2.close();
    }

    static class DBSyncTask
    extends TimerTask {
        boolean keepAlive = true;
        int count = 0;
        Lock aggregationlocker = new ReentrantLock();

        @Override
        public void run() {
            this.syncToDb();
        }

        public int getResponseRate() {
            int retInt = -1;
            if (PmCollect._totleSent != 0L) {
                long ret = PmCollect._totleReceived * 100L / PmCollect._totleSent;
                _Logger.info((Object)("TotalReceived:" + PmCollect._totleReceived + " TotalSent:" + PmCollect._totleSent));
                PmCollect._totleSent = 0L;
                PmCollect._totleReceived = 0L;
                retInt = ret > 100L ? 100 : (int)ret;
                retInt = retInt < 0 ? 0 : retInt;
            }
            return retInt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void syncToDb() {
            if (this.aggregationlocker.tryLock()) {
                try {
                    _Logger.debug((Object)("DBSyncTask run  aggregate2DB _DoneBuildDb:" + PmCollect._DoneBuildDb + " keepAlive:" + this.keepAlive));
                    if (PmCollect._DoneBuildDb != 1 || !this.keepAlive) return;
                    long startAt = System.currentTimeMillis();
                    PMStatisticsManager.aggregrate2DB(this.count);
                    long end = System.currentTimeMillis();
                    long dur = (end - startAt) / 1000L;
                    _Logger.info((Object)("Done PM db update  at " + new Timestamp(end) + ", " + dur + " sec."));
                    startAt = System.currentTimeMillis();
                    PortGroupSummary.getInstance().aggregate2DB();
                    PMSwitchSummary.aggregate2DB();
                    ++this.count;
                    end = System.currentTimeMillis();
                    dur = (end - startAt) / 1000L;
                    Timestamp endt = new Timestamp(end);
                    _Logger.info((Object)("Done switch summary  at " + endt + ", " + dur + " sec."));
                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    int repRate = this.getResponseRate();
                    if (repRate != -1) {
                        PMImpl.getInstance().setRunning(repRate + "% response in last hour. " + " last DB update: " + df.format(Calendar.getInstance().getTime()));
                        if (repRate >= PmCollect._pmResponseRateThreshold) return;
                        this.sendEvent("PM response rate is " + repRate + "%");
                        return;
                    }
                    PMImpl.getInstance().setRunning("no request in last hour.  last DB update: " + df.format(Calendar.getInstance().getTime()));
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                finally {
                    this.aggregationlocker.unlock();
                }
            } else {
                _Logger.warn((Object)": skip aggregation, previous task in progress");
            }
        }

        public void stop() {
            this.keepAlive = false;
        }

        private void sendEvent(String msg) {
            SyslogEntry se = new SyslogEntry(FMServerImpl.getInstance().getCurrentServerInetAddr(), -1L, "DCNM-SAN", LogEventType.OTHER.toString(), "DCNM Server", msg, Severity.INFO.getValue(), 0);
            ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(se);
        }
    }
}

