/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.pm.PmChartInfo;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.pm.PmConfig;
import com.cisco.dcbu.sm.server.pm.PMStatisticsManager;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmConfigUtil;
import com.cisco.dcbu.sm.server.pm.PmDisplay;
import com.cisco.dcbu.sm.server.pm.PmFileStoreManager;
import com.cisco.dcbu.sm.server.pm.PmMetadata;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

public class PmChart {
    static final String PATH = PmCollect.getPmDir();
    static final int CHART_WIDTH = 450;
    static final int CHART_HEIGHT = 190;
    static final String DB_PATH = PATH + File.separator + "db";
    static final String WWW_PATH = PATH + File.separator + "www";
    static final String REPORT_DIR = File.separator + "reports";
    static PmMetadata _MetaData = null;
    private static PmChart _Instance = null;
    private Map<String, String[]> rt_IpToVarMap = new HashMap<String, String[]>();

    private PmChart() {
    }

    public static PmChart getInstance() {
        if (_Instance == null) {
            _Instance = new PmChart();
        }
        return _Instance;
    }

    public static PmChartInfo getPmChartInfo(String rrdFile, int pmType, int chartType, long start, long end) throws IOException, RrdException {
        String[] rrdFiles;
        long[] interval = PmChart.getInterval(chartType, start, end);
        PmConfig def = null;
        double[][] stats = null;
        double[][] errStats = null;
        boolean haveErr = false;
        boolean rtChart = interval == null;
        HashMap<String, String[]> ipToVarMap = new HashMap<String, String[]>();
        for (String rrd : rrdFiles = rrdFile.split(";")) {
            int i;
            try {
                def = PmChart.getRrdFileConfig(rrd, pmType);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (rtChart) {
                ipToVarMap.putAll(def._ipToVarMap);
                continue;
            }
            if (rtChart) {
                return new PmChartInfo(def._message, def._title, null, null, ipToVarMap);
            }
            String fileNameLogical = DB_PATH + File.separator + def._rrdFile;
            String errFileNameLogical = DB_PATH + File.separator + def._errRrdFile;
            String fileName = PmFileStoreManager.getInstance().getMappedFileName(fileNameLogical);
            String errFileName = PmFileStoreManager.getInstance().getMappedFileName(errFileNameLogical);
            short dataIndex = PmFileStoreManager.getInstance().getIndex(fileNameLogical);
            int errDataIndex = pmType == 2 ? -1 : (int)PmFileStoreManager.getInstance().getIndex(errFileNameLogical);
            RrdDb db = new RrdDb(fileName);
            FetchPoint[] fetchPoints = PMStatisticsManager.getRrdData(db, "AVERAGE", interval[0], interval[1], (int)dataIndex);
            FetchPoint[] fetchMaxPoints = PMStatisticsManager.getRrdData(db, "MAX", interval[0], interval[1], (int)dataIndex);
            if (stats == null) {
                stats = new double[fetchPoints.length][5];
            }
            for (i = 0; i < fetchPoints.length; ++i) {
                double rx = fetchPoints[i].getValues()[0];
                double[] dArray = stats[i];
                dArray[0] = dArray[0] + (Double.isNaN(rx) || rx < 0.0 ? 0.0 : rx);
                if (pmType == 5) {
                    stats[i][1] = Double.NaN;
                } else {
                    double tx = fetchPoints[i].getValues()[1];
                    double[] dArray2 = stats[i];
                    dArray2[1] = dArray2[1] + (Double.isNaN(tx) || tx < 0.0 ? 0.0 : tx);
                }
                stats[i][2] = fetchPoints[i].getTime();
            }
            for (i = 0; i < fetchMaxPoints.length; ++i) {
                double[] fparr = fetchMaxPoints[i].getValues();
                double rx = fparr[0];
                double[] dArray = stats[i];
                dArray[3] = dArray[3] + (Double.isNaN(rx) || rx < 0.0 ? Double.NaN : PmChart.convert(rx, pmType));
                if (fparr.length > 1) {
                    double tx = fetchMaxPoints[i].getValues()[1];
                    double[] dArray3 = stats[i];
                    dArray3[4] = dArray3[4] + (Double.isNaN(tx) || tx < 0.0 ? Double.NaN : PmChart.convert(tx, pmType));
                    continue;
                }
                double[] dArray4 = stats[i];
                dArray4[4] = dArray4[4] + 0.0;
            }
            db.close();
            RrdDb errDb = null;
            if (errFileName != null && new File(errFileName).exists()) {
                errDb = new RrdDb(errFileName);
                FetchPoint[] errFetchPoints = PMStatisticsManager.getRrdData(errDb, "AVERAGE", interval[0], interval[1], errDataIndex);
                errStats = new double[errFetchPoints.length][3];
                double discard = Double.NaN;
                double error = Double.NaN;
                for (int i2 = 0; i2 < errFetchPoints.length; ++i2) {
                    discard = errFetchPoints[i2].getValues()[0];
                    error = errFetchPoints[i2].getValues()[1];
                    if (!haveErr && (!Double.isNaN(discard) && discard > 0.0 || !Double.isNaN(error) && error > 0.0)) {
                        haveErr = true;
                    }
                    double[] dArray = errStats[i2];
                    dArray[0] = dArray[0] + discard;
                    double[] dArray5 = errStats[i2];
                    dArray5[1] = dArray5[1] + error;
                    errStats[i2][2] = errFetchPoints[i2].getTime();
                }
                errDb.close();
            }
            ipToVarMap.putAll(def._ipToVarMap);
        }
        if (def == null) {
            return null;
        }
        return new PmChartInfo(def._message, def._title, stats, haveErr ? errStats : (double[][])null, ipToVarMap);
    }

    private static PmConfig getRrdFileConfig(String rrdFile, int pmType) throws Exception {
        _MetaData = PmDisplay.loadMetaData(false);
        PmConfig def = null;
        try {
            def = new PmConfigUtil(rrdFile, pmType).findPmConfig();
            if (def != null && def._isDoubleFlow && def._vars.length == 1) {
                def = new PmConfigUtil(rrdFile, pmType).findFlowWithDiffIPPmConfig(rrdFile);
            } else if (def._ipToVarMap == null) {
                def._ipToVarMap = new HashMap<String, String[]>();
                def._ipToVarMap.put(def._ipAddr, def._vars);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (def == null) {
            def = _MetaData.findDef(rrdFile, pmType);
        }
        return def;
    }

    public static double[][] getPmStats(String rrdFile, int pmType, int chartType) throws IOException, RrdException {
        return PmChart.getPmStats(rrdFile, pmType, chartType, -1L, -1L);
    }

    public static double[][] getPmStats(String rrdFile, int pmType, int chartType, long start, long end) throws IOException, RrdException {
        String[] rrdFiles;
        if (rrdFile.length() == 0) {
            return new double[0][];
        }
        long[] interval = PmChart.getInterval(chartType, start, end);
        double[][] stats = null;
        for (String rrd : rrdFiles = rrdFile.split(";")) {
            double tx;
            double[] fparr;
            int i;
            String fileNameLogical = DB_PATH + File.separator + rrd;
            String err_rrd = rrd.substring(0, rrd.indexOf(".rrd")) + "_err.rrd";
            String errFileNameLogical = DB_PATH + File.separator + err_rrd;
            String fileName = PmFileStoreManager.getInstance().getMappedFileName(fileNameLogical);
            String errFileName = PmFileStoreManager.getInstance().getMappedFileName(errFileNameLogical);
            short dataIndex = PmFileStoreManager.getInstance().getIndex(fileNameLogical);
            int errDataIndex = pmType == 2 ? -1 : (int)PmFileStoreManager.getInstance().getIndex(errFileNameLogical);
            RrdDb errDb = null;
            double[][] errStats = null;
            boolean haveErr = false;
            if (interval == null) {
                return null;
            }
            if (errFileName != null && new File(errFileName).exists() && errDataIndex != -1) {
                errDb = new RrdDb(errFileName);
                FetchPoint[] errFetchPoints = PMStatisticsManager.getRrdData(errDb, "AVERAGE", interval[0], interval[1], errDataIndex);
                errStats = new double[errFetchPoints.length][3];
                double discard = Double.NaN;
                double error = Double.NaN;
                for (int i2 = 0; i2 < errFetchPoints.length; ++i2) {
                    discard = errFetchPoints[i2].getValues()[0];
                    error = errFetchPoints[i2].getValues()[1];
                    if (!haveErr && (!Double.isNaN(discard) && discard > 0.0 || !Double.isNaN(error) && error > 0.0)) {
                        haveErr = true;
                    }
                    double[] dArray = errStats[i2];
                    dArray[0] = dArray[0] + discard;
                    double[] dArray2 = errStats[i2];
                    dArray2[1] = dArray2[1] + error;
                    errStats[i2][2] = errFetchPoints[i2].getTime();
                }
                errDb.close();
            }
            RrdDb db = new RrdDb(fileName);
            FetchPoint[] fetchPoints = PMStatisticsManager.getRrdData(db, "AVERAGE", interval[0], interval[1], (int)dataIndex);
            FetchPoint[] fetchMaxPoints = PMStatisticsManager.getRrdData(db, "MAX", interval[0], interval[1], (int)dataIndex);
            if (!haveErr) {
                stats = new double[fetchPoints.length][5];
                for (i = 0; i < fetchPoints.length; ++i) {
                    fparr = fetchPoints[i].getValues();
                    double rx = fparr[0];
                    double[] dArray = stats[i];
                    dArray[0] = dArray[0] + (Double.isNaN(rx) || rx < 0.0 ? Double.NaN : PmChart.convert(rx, pmType));
                    if (fparr.length > 1) {
                        tx = fetchPoints[i].getValues()[1];
                        double[] dArray3 = stats[i];
                        dArray3[1] = dArray3[1] + (Double.isNaN(tx) || tx < 0.0 ? Double.NaN : PmChart.convert(tx, pmType));
                    } else {
                        double[] dArray4 = stats[i];
                        dArray4[1] = dArray4[1] + 0.0;
                    }
                    stats[i][2] = fetchPoints[i].getTime();
                }
                for (i = 0; i < fetchMaxPoints.length; ++i) {
                    fparr = fetchMaxPoints[i].getValues();
                    double rx = fparr[0];
                    double[] dArray = stats[i];
                    dArray[3] = dArray[3] + (Double.isNaN(rx) || rx < 0.0 ? Double.NaN : PmChart.convert(rx, pmType));
                    if (fparr.length > 1) {
                        tx = fetchMaxPoints[i].getValues()[1];
                        double[] dArray5 = stats[i];
                        dArray5[4] = dArray5[4] + (Double.isNaN(tx) || tx < 0.0 ? Double.NaN : PmChart.convert(tx, pmType));
                        continue;
                    }
                    double[] dArray6 = stats[i];
                    dArray6[4] = dArray6[4] + 0.0;
                }
            } else {
                stats = new double[fetchPoints.length][7];
                for (i = 0; i < fetchPoints.length; ++i) {
                    fparr = fetchPoints[i].getValues();
                    double rx = fparr[0];
                    double[] dArray = stats[i];
                    dArray[0] = dArray[0] + (Double.isNaN(rx) || rx < 0.0 ? Double.NaN : PmChart.convert(rx, pmType));
                    if (fparr.length > 1) {
                        tx = fetchPoints[i].getValues()[1];
                        double[] dArray7 = stats[i];
                        dArray7[1] = dArray7[1] + (Double.isNaN(tx) || tx < 0.0 ? Double.NaN : PmChart.convert(tx, pmType));
                    } else {
                        double[] dArray8 = stats[i];
                        dArray8[1] = dArray8[1] + 0.0;
                    }
                    stats[i][2] = fetchPoints[i].getTime();
                }
                for (i = 0; i < fetchMaxPoints.length; ++i) {
                    fparr = fetchMaxPoints[i].getValues();
                    double rx = fparr[0];
                    double[] dArray = stats[i];
                    dArray[3] = dArray[3] + (Double.isNaN(rx) || rx < 0.0 ? Double.NaN : PmChart.convert(rx, pmType));
                    if (fparr.length > 1) {
                        tx = fetchMaxPoints[i].getValues()[1];
                        double[] dArray9 = stats[i];
                        dArray9[4] = dArray9[4] + (Double.isNaN(tx) || tx < 0.0 ? Double.NaN : PmChart.convert(tx, pmType));
                    } else {
                        double[] dArray10 = stats[i];
                        dArray10[4] = dArray10[4] + 0.0;
                    }
                    stats[i][5] = Double.isNaN(errStats[i][1]) || errStats[i][1] < 0.0 ? Double.NaN : errStats[i][1];
                    stats[i][6] = Double.isNaN(errStats[i][0]) || errStats[i][0] < 0.0 ? Double.NaN : errStats[i][0];
                }
            }
            db.close();
        }
        return stats;
    }

    static double convert(double in, int pmType) {
        double result = in;
        if (pmType == 11 || pmType == 10) {
            result = in * 10.0 / 8.0;
        }
        return result;
    }

    public static long[] getInterval(int chartType, long start, long end) {
        long startTime = -1L;
        long endTime = System.currentTimeMillis() / 1000L;
        switch (chartType) {
            case 1: {
                startTime = endTime - 86400L;
                break;
            }
            case 2: {
                startTime = endTime - 604800L;
                break;
            }
            case 3: {
                startTime = endTime - 2419200L;
                break;
            }
            case 4: {
                startTime = endTime - 31449600L;
                break;
            }
            case 5: {
                startTime = start;
                endTime = end;
                break;
            }
            default: {
                return null;
            }
        }
        return new long[]{startTime, endTime};
    }

    public static long[] getRealTimeStats(String ipAddr, String ifIndex) throws Exception {
        SnmpPeer peer = PmCollect.findPeer(ipAddr);
        VarBindList vbl = PmChart.buildVBList(ifIndex);
        SnmpPDU responsePdu = SnmpFetch.get(peer, vbl);
        long[] values = new long[]{responsePdu.getVariables().longValue(0), responsePdu.getVariables().longValue(1)};
        return values;
    }

    public long[] getRealTimeStats(String rrdFile, int pmType) throws Exception {
        String[] rrdFiles;
        PmConfig def = null;
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String rrd : rrdFiles = rrdFile.split(";")) {
            try {
                def = PmChart.getRrdFileConfig(rrd, pmType);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            map.putAll(def._ipToVarMap);
        }
        return PmChart.getRealTimeStats(map, pmType);
    }

    public static long[] getRealTimeStats(Map<String, String[]> map, int type) throws Exception {
        long[] values = new long[4];
        Iterator<String> itr = map.keySet().iterator();
        String srcIp = null;
        double rx = 0.0;
        double tx = 0.0;
        while (itr.hasNext()) {
            VarBindList vbList;
            srcIp = itr.next();
            String[] srcVars = map.get(srcIp);
            SnmpPeer srcPeer = PmCollect.findPeer(srcIp);
            VarBindList srcVbl = PmChart.buildVBList(srcVars);
            SnmpPDU responsePdu = SnmpFetch.get(srcPeer, srcVbl);
            values[3] = type;
            if (type != 2) {
                vbList = responsePdu.getVariables();
                rx = vbList.longValue(0);
                values[0] = (long)((double)values[0] + (Double.isNaN(rx) ? 0.0 : rx));
                if (vbList.size() > 1) {
                    tx = vbList.longValue(1);
                    values[1] = (long)((double)values[1] + (Double.isNaN(tx) ? 0.0 : tx));
                }
                values[2] = responsePdu.getTimeReceived();
                continue;
            }
            if (type != 2) {
                return values;
            }
            vbList = responsePdu.getVariables();
            rx = vbList.longValue(0);
            values[0] = (long)((double)values[0] + (Double.isNaN(rx) ? 0.0 : rx));
            if (vbList.size() > 1) {
                tx = vbList.longValue(1);
                values[1] = (long)((double)values[1] + (Double.isNaN(tx) ? 0.0 : tx));
            }
            values[2] = responsePdu.getTimeReceived();
            if (!itr.hasNext()) continue;
            String desIp = itr.next();
            String[] desVars = map.get(desIp);
            SnmpPeer desPeer = PmCollect.findPeer(desIp);
            VarBindList desVbl = PmChart.buildVBList(desVars);
            responsePdu = SnmpFetch.get(desPeer, desVbl);
            rx = responsePdu.getVariables().longValue(0);
            values[1] = (long)((double)values[1] + (Double.isNaN(rx) ? 0.0 : rx));
        }
        return values;
    }

    private static VarBindList buildVBList(String ifIndex) {
        VarBindList vbl = null;
        String[] oids = new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex};
        vbl = new VarBindList();
        for (int j = 0; j < oids.length; ++j) {
            vbl.add(new SnmpVarBind(new SnmpOID(oids[j])));
        }
        return vbl;
    }

    private static VarBindList buildVBList(String[] oids) {
        VarBindList vbl = null;
        vbl = new VarBindList();
        for (int j = 0; j < oids.length; ++j) {
            vbl.add(new SnmpVarBind(new SnmpOID(oids[j])));
        }
        return vbl;
    }

    public static void main(String[] args) {
        try {
            double[][] pmStats = PmChart.getPmStats("2100001b320227cb.rrd;", 3, 1);
            File toFile = new File("c:\\tmp\\data.xml");
            BufferedWriter writer = new BufferedWriter(new FileWriter(toFile));
            writer.write("<Document>");
            if (pmStats == null) {
                return;
            }
            for (int i = 0; i < pmStats.length; ++i) {
                double[] pmStat = pmStats[i];
                writer.write("<row>");
                writer.write("<Time>");
                writer.write(String.valueOf(pmStat[2]));
                writer.write("</Time>");
                writer.write("<Rx>");
                writer.write(PmChart.dataFormat(pmStat[0]));
                writer.write("</Rx>");
                writer.write("<Tx>");
                writer.write(PmChart.dataFormat(pmStat[1]));
                writer.write("</Tx>");
                writer.write("</row>");
                writer.newLine();
            }
            writer.write("</Document>");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String dataFormat(double d) {
        if (Double.isNaN(d)) {
            return "0.0";
        }
        String expression = d < 1000.0 ? "0.000" : "0.000E0";
        DecimalFormat df = new DecimalFormat(expression);
        return df.format(d);
    }
}

