/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm.pmutil;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.pm.PmConfig;
import com.cisco.dcbu.sm.common.pm.PmErrorDiscardConfig;
import com.cisco.dcbu.sm.common.pm.PmEvent;
import com.cisco.dcbu.sm.common.pm.PmEventDef;
import com.cisco.dcbu.sm.common.rif.PMEventConsumerRif;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.pm.PM;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.net.InetAddress;

public class PmEventDispatcher
implements ModelEventListenerIf {
    static PmEventDispatcher _Instance;
    static PmEventDef _Def;
    static PMEventConsumerRif _Consumer;
    static boolean _started;

    private PmEventDispatcher() {
    }

    public static PmEventDispatcher getInstance() {
        if (_Instance == null) {
            _Instance = new PmEventDispatcher();
        }
        return _Instance;
    }

    public void setEventDef(PmEventDef def) {
        _Def = def;
    }

    public void setEventConsumer(PMEventConsumerRif consumer) {
        _Consumer = consumer;
    }

    public void start() {
        if (!_started) {
            SanManager.addListener(_Instance);
            DCManager.getInstance().addListener(_Instance);
            _started = true;
        }
    }

    public void sendEvent(PmEvent event) {
        try {
            if (_Consumer != null) {
                _Consumer.consume(event);
            }
        }
        catch (Exception ex) {
            PM._Logger.warn((Object)"PmEventDispatch:sendEvent error", (Throwable)ex);
        }
    }

    @Override
    public void fabricOpened(FabricImpl fImpl) {
    }

    @Override
    public void fabricDiscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricRemoved(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricImpl fImpl) {
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
    }

    @Override
    public void fabricRediscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] o) {
    }

    @Override
    public void membersRemoved(FabricImpl fImpl, PKIf[] o) {
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] o) {
    }

    @Override
    public void membersAdded(FabricImpl fImpl, AbstractModelObjectImpl[] o) {
        for (int i = 0; i < o.length; ++i) {
            int type;
            if (o[i] instanceof IslImpl) {
                type = 1;
                IslImpl isl = (IslImpl)o[i];
                if (!this.isMonitoring(fImpl, isl)) continue;
                this.sendEvent(isl, type);
                continue;
            }
            if (!(o[i] instanceof EndPortImpl)) continue;
            EndPortImpl ep = (EndPortImpl)o[i];
            int n = type = ep.isTarget() ? 7 : 4;
            if (!this.isMonitoring(fImpl, ep)) continue;
            this.sendEvent(ep, type);
        }
    }

    @Override
    public void membersChanged(FabricImpl fImpl, ChangedModelObject[] o) {
        block10: for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            PKIf pkey = o[i].getPK();
            short propId = o[i]._propId;
            short attrType = (short)(propId & 0xFF00);
            switch (attrType) {
                case 1280: {
                    int type;
                    IslImpl isl = fImpl.findIsl(((IslPK)pkey).getSwitchIntKey1());
                    if (isl == null || !this.isMonitoring(fImpl, isl)) continue block10;
                    switch (propId) {
                        case 1281: {
                            if ((Boolean)o[i].getNewValue() == null) break;
                            type = (Boolean)o[i].getNewValue() != false ? 2 : 3;
                            this.sendEvent(isl, type);
                        }
                    }
                    continue block10;
                }
                case 1536: {
                    int type;
                    EndPortImpl ep = SanManager.getInstance().findEndPort((WwnKey)pkey, fImpl.getPK());
                    if (ep == null || ep.getSwitch() == null || !ep.getSwitch().isManageable() || !ep.getSwitch().isMDS() || !this.isMonitoring(fImpl, ep)) continue block10;
                    switch (propId) {
                        case 1537: {
                            type = (Boolean)o[i].getNewValue() != false ? (ep.isTarget() ? 8 : 5) : (ep.isTarget() ? 9 : 6);
                            this.sendEvent(ep, type);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void lanOpened(LanImpl lan) {
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
    }

    @Override
    public void lanClosed(LanImpl lan) {
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] o) {
        for (int i = 0; i < o.length; ++i) {
            int type;
            if (o[i] instanceof EthIslImpl) {
                type = 10;
                EthIslImpl isl = (EthIslImpl)o[i];
                if (!this.isMonitoring(lan, isl)) continue;
                this.sendEvent(isl, type);
                continue;
            }
            if (!(o[i] instanceof EthPortImpl)) continue;
            EthPortImpl sp = (EthPortImpl)o[i];
            type = 13;
            if (!this.isMonitoring(lan, sp)) continue;
            this.sendEvent(sp, type);
        }
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] o) {
        block10: for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            PKIf pkey = o[i].getPK();
            short propId = o[i]._propId;
            short attrType = (short)(propId & 0xFF00);
            switch (attrType) {
                case 1280: {
                    int type;
                    EthIslImpl isl = lan.findEthIsl((EthIslPK)pkey);
                    if (isl == null || !this.isMonitoring(lan, isl)) continue block10;
                    switch (propId) {
                        case 1281: {
                            if ((Boolean)o[i].getNewValue() == null) break;
                            type = (Boolean)o[i].getNewValue() != false ? 11 : 12;
                            this.sendEvent(isl, type);
                        }
                    }
                    continue block10;
                }
                case 2048: {
                    int type;
                    EthPortImpl ep = DCManager.getInstance().getLan().findEthPort((SwitchIntKeyIf)pkey);
                    if (ep == null || ep.getSwitch() == null || !ep.getSwitch().isManageable() || !this.isMonitoring(lan, ep)) continue block10;
                    switch (propId) {
                        case 1537: {
                            type = (Boolean)o[i].getNewValue() != false ? 14 : 15;
                            this.sendEvent(ep, type);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    boolean isMonitoring(FabricImpl fImpl, IslImpl isl) {
        return _Def.isMonitoring(fImpl, isl);
    }

    boolean isMonitoring(FabricImpl fImpl, EndPortImpl ep) {
        return _Def.isMonitoring(fImpl, ep);
    }

    boolean isMonitoring(LanImpl fImpl, EthIslImpl isl) {
        return _Def.isMonitoring(fImpl, isl);
    }

    boolean isMonitoring(LanImpl fImpl, EthPortImpl ep) {
        return _Def.isMonitoring(fImpl, ep);
    }

    private boolean isSanSwitchLicensed(long switchId) {
        SwitchAssignedLicenseInfo sLicense = FileLicensingHelper.getInstance().getSanLicenseInfoSwitchAssignment(switchId);
        return sLicense.isLicensed();
    }

    void sendEvent(IslImpl isl, int type) {
        SwitchImpl sw1 = isl.getSwitch1();
        int ifIndex1 = isl.getIfIndex1();
        SwitchImpl sw2 = isl.getSwitch2();
        int ifIndex2 = isl.getIfIndex2();
        if (!sw1.isManageable() && !sw2.isManageable()) {
            return;
        }
        if (!sw1.isMDS() && !sw2.isMDS()) {
            return;
        }
        if (!this.isSanSwitchLicensed(sw1.getDBID()) && !this.isSanSwitchLicensed(sw2.getDBID())) {
            return;
        }
        int ifIndex = sw1.isManageable() && !sw1.isBrocade() ? ifIndex1 : ifIndex2;
        boolean e = WwnDictionary.isEnabled();
        boolean p = WwnDictionary.isPrepend();
        WwnDictionary.setEnabled(false);
        WwnDictionary.setPrepend(false);
        String rrd = sw1.getWwn().toString().replaceAll(":", "") + "_" + ifIndex1 + "_" + sw2.getWwn().toString().replaceAll(":", "") + "_" + ifIndex2 + ".rrd";
        WwnDictionary.setEnabled(e);
        WwnDictionary.setPrepend(p);
        PmConfig pc = new PmConfig(rrd, sw1.isManageable() && !sw1.isBrocade() ? sw1.getInetAddress().getHostAddress() : sw2.getInetAddress().getHostAddress(), sw1.getName() + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + sw2.getName() + " " + IfIndexUtil.ifIndexToName(ifIndex2) + " Traffic", "Rx,Tx Bytes/sec", new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, PmConfig.LABELS, String.valueOf(isl.getSpeed()), 0, 1);
        String msgStr = "ISL:" + sw1.getName() + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + sw2.getName() + " " + IfIndexUtil.ifIndexToName(ifIndex2) + ",  " + IfIndexUtil.ifIndexToName(ifIndex1) + ", Port: " + IfIndexUtil.ifIndexToName(ifIndex1) + ", VSAN: " + isl.getVsansAsString() + ", %s>=%d%%, Speed :" + DisplayUtil.formatSpeed(isl.getSpeed());
        pc.setMsgString(msgStr);
        pc.setIfname(IfIndexUtil.ifIndexToName(ifIndex1));
        pc.setEntity(sw1.getName() + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + sw2.getName() + " " + IfIndexUtil.ifIndexToName(ifIndex2));
        if (PmCollect._CollectErrorDiscard) {
            PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
            pc.addErrorDiscardConfig(edconf);
            edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
            pc.addErrorDiscardConfig(edconf);
        }
        PmEvent pe = new PmEvent(pc, type);
        this.sendEvent(pe);
    }

    String getName(InetAddress ip, String sysName) {
        if (sysName != null && sysName.length() > 0) {
            return sysName;
        }
        return ip.toString().replaceAll("//", "");
    }

    void sendEvent(EthIslImpl isl, int type) {
        EthSwitchImpl sw1 = isl.getSwitch1();
        EthSwitchImpl sw2 = isl.getSwitch2();
        int ifIndex1 = isl.getIfIndex1();
        InetAddress ip1 = sw1.getInetAddress();
        long speed1 = isl.getSpeed();
        String sname1 = sw1.getName();
        InetAddress ip2 = sw2.getInetAddress();
        int ifIndex2 = isl.getIfIndex2();
        String sname2 = sw2.getName();
        if (isl.getPort2().getIfname().startsWith("up")) {
            ip2 = sw1.getInetAddress();
        } else if (isl.getPort1().getIfname().startsWith("up")) {
            ip1 = sw2.getInetAddress();
            ifIndex1 = isl.getIfIndex2();
            ip2 = ip1;
            ifIndex2 = isl.getIfIndex1();
            sname2 = sw1.getName();
            sname1 = sw2.getName();
        }
        int ifIndex = ifIndex1;
        if (!sw1.isManageable() && !sw2.isManageable()) {
            return;
        }
        if (!GlobalDCManager.getInstance().isLanSwitchPmCollect(sw1.getDBID()) && !GlobalDCManager.getInstance().isLanSwitchPmCollect(sw2.getDBID())) {
            return;
        }
        String rrd = ip1.getHostAddress().replace(".", "X") + "_" + ifIndex1 + "_" + ip2.getHostAddress().replace(".", "X") + "_" + ifIndex2 + ".rrd";
        String switchIpToUse = ip1.getHostAddress();
        PmConfig pc = new PmConfig(rrd, switchIpToUse, this.getName(ip1, sname1) + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + this.getName(ip2, sname2) + " " + IfIndexUtil.ifIndexToName(ifIndex2) + " Traffic", "Rx,Tx Bytes/sec", new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, PmConfig.LABELS, String.valueOf(speed1), 0, 10);
        PM._Logger.debug((Object)("found isl " + this.getName(ip1, sname1) + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + this.getName(ip2, sname2) + " " + IfIndexUtil.ifIndexToName(ifIndex2)));
        if (PmCollect.getMetaData()._collectLanError) {
            PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
            pc.addErrorDiscardConfig(edconf);
            edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
            pc.addErrorDiscardConfig(edconf);
        }
        PmEvent pe = new PmEvent(pc, type);
        this.sendEvent(pe);
    }

    void sendEvent(EndPortImpl ep, int type) {
        SwitchImpl sw = ep.getSwitch();
        if (sw == null || !sw.isMDS() || ep.getIfIndex() == 0 || !this.isSanSwitchLicensed(sw.getDBID())) {
            return;
        }
        boolean e = WwnDictionary.isEnabled();
        boolean p = WwnDictionary.isPrepend();
        WwnDictionary.setEnabled(false);
        WwnDictionary.setPrepend(false);
        int ifIndex = ep.getIfIndex();
        PmConfig pc = new PmConfig(ep.getPortWwn().toString().replaceAll(":", "") + ".rrd", sw.getInetAddress().getHostAddress(), ep.getName(), "Rx,Tx Bytes/sec", new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ep.getIfIndex(), "1.3.6.1.2.1.31.1.1.1.10." + ep.getIfIndex()}, PmConfig.LABELS, String.valueOf(ep.getSpeed()), 0, ep.isTarget() ? 4 : 3);
        String msgStr = (ep.isTarget() ? "Storage:" : "Host:") + ep.getName() + ", Port:" + IfIndexUtil.ifIndexToName(ifIndex) + ", VSAN:" + ep.getVsan() + ", %s>=%d%%, Speed:" + DisplayUtil.formatSpeed(ep.getSpeed());
        pc.setMsgString(msgStr);
        pc.setEntity(ep.getName());
        pc.setIfname(IfIndexUtil.ifIndexToName(ifIndex));
        if (PmCollect._CollectErrorDiscard) {
            PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
            pc.addErrorDiscardConfig(edconf);
            edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
            pc.addErrorDiscardConfig(edconf);
        }
        WwnDictionary.setEnabled(e);
        WwnDictionary.setPrepend(p);
        PmEvent pe = new PmEvent(pc, type);
        this.sendEvent(pe);
    }

    void sendEvent(EthPortImpl ep, int type) {
        EthSwitchImpl sw = ep.getSwitch();
        if (sw == null || !sw.isManageable() || ep.getIfIndex() == 0 || !GlobalDCManager.getInstance().isLanSwitchPmCollect(sw.getDBID())) {
            return;
        }
        InetAddress ip = sw.getInetAddress();
        int ifIndex = ep.getIfIndex();
        String rrd = ip.getHostAddress().replace(".", "X") + "_" + ifIndex + "_" + "ethintf" + ".rrd";
        String name = ep.getIfname();
        long speed = ep.getIfSpeed();
        PmConfig pc = new PmConfig(rrd, ip.getHostAddress(), name, "Rx,Tx Bytes/sec", new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, PmConfig.LABELS, String.valueOf(speed), 0, 11);
        if (PmCollect.getMetaData()._collectLanError) {
            PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
            pc.addErrorDiscardConfig(edconf);
            edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
            pc.addErrorDiscardConfig(edconf);
        }
        PmEvent pe = new PmEvent(pc, type);
        this.sendEvent(pe);
    }

    static {
        _started = false;
    }
}

