/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.scheduler.jobs;

import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.config.BackUpConfiguration;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.scheduler.jobs.ReportJob;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class BackUpConfigJob
extends ReportJob
implements StatefulJob,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail jobDetail = context.getJobDetail();
        String groupJobName = jobDetail.getFullName();
        String jobName = groupJobName.substring(groupJobName.indexOf(46) + 1, groupJobName.length());
        this._Log.info((Object)("Executing config job " + jobName));
        try {
            long fDbID;
            Integer fidInt = (Integer)jobDetail.getJobDataMap().get((Object)"FabricPK");
            int fId = fidInt != null ? fidInt : 0;
            Long fdbIdLong = (Long)jobDetail.getJobDataMap().get((Object)"selectedFabricDBID");
            long l = fDbID = fdbIdLong != null ? fdbIdLong : 0L;
            if (!BackUpConfiguration.isBackUpServerConfigured()) {
                throw new Exception("Please configure Backup Server from Admin/SFTP Credentials");
            }
            String[] data = BackUpConfiguration.getBackupServerData();
            int serverType = (Integer)jobDetail.getJobDataMap().get((Object)"ServerType");
            if (serverType != 3 && serverType != 1) {
                serverType = Integer.parseInt(data[0]);
            }
            String prtUsrName = data[1];
            String prtPassword = data[2];
            String rootDir = data[3];
            int configType = (Integer)jobDetail.getJobDataMap().get((Object)"ConfigType");
            boolean isLan = (Boolean)jobDetail.getJobDataMap().get((Object)"isLan");
            String defaultRmiPort = System.getProperty("server.port", "4447");
            String server = System.getProperty("server.bindaddrs", "127.0.0.1");
            if (server == null || server.equals("")) {
                server = "localhost";
            }
            int rmiPort = Integer.parseInt(defaultRmiPort);
            EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
            if (rif == null) {
                throw new Exception("Unable to reach local host server.");
            }
            String serverIp = null;
            String[] outDat = null;
            if (!isLan) {
                FabricPK fPk = null;
                if (fdbIdLong == null) {
                    fPk = new FabricPK(fId);
                    fDbID = FabricImpl.findDbIdByFPK(fId);
                }
                if ((serverIp = ClusterMapping.getInstance().qIPStrfromFDBID(fDbID)) == null) {
                    throw new Exception("Unable to reach server for Fabric ID:" + fDbID);
                }
                if (fPk == null) {
                    fPk = FabricImpl.findFPKByDbId(fDbID);
                }
                WebAnalysisRif wbRif = (WebAnalysisRif)rif.getRemoteService(serverIp, defaultRmiPort, "WebAnalysisBean", WebAnalysisRif.class.getName());
                if (fPk == null) {
                    throw new Exception("Unable to find Fabric ID for Fabric DB ID:" + fDbID);
                }
                outDat = wbRif.backUpFabric(fPk._fid, configType, serverType, prtUsrName, prtPassword, rootDir, isLan);
            } else {
                WebAnalysisRif wbRif = rif.getWebAnalysis();
                outDat = wbRif.backUpEtherSwitchGroup(fDbID, configType, serverType, prtUsrName, prtPassword, rootDir);
            }
            GregorianCalendar curDate = new GregorianCalendar();
            curDate.setTime(new Date());
            String dtStr = String.format("%1$tH:%1$tM %1$tm/%1$td/%1$tY", curDate);
            if (jobDetail != null) {
                jobDetail.getJobDataMap().put("reportStatus", outDat != null && outDat.length > 0 ? dtStr + "," + outDat[0] : "");
            }
            if (jobDetail != null) {
                jobDetail.getJobDataMap().put((Object)"GenerationTime", (Object)new Date());
            }
        }
        catch (Exception ex) {
            int rtnCharLoc;
            int n = rtnCharLoc = ex.getMessage() != null ? ex.getMessage().indexOf(10) : -1;
            if (jobDetail != null) {
                jobDetail.getJobDataMap().put("reportStatus", rtnCharLoc != -1 ? ex.getMessage().substring(0, rtnCharLoc) : ex.getMessage());
            }
            this._Log.info((Object)("Error:" + jobName + "  " + ex.getMessage()));
            throw new JobExecutionException(ex.getMessage());
        }
    }

    @Override
    protected String constructURL(JobDetail jobDetail, String jobName, String generationTime) throws UnknownHostException {
        return null;
    }
}

