/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.se;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CommandReader
implements Runnable {
    private static final int NOT_READY = -2;
    private InputStream m_in;
    private IOException m_ex = null;
    private int m_length = -2;
    private static long TIMEOUT = 300L;
    private byte[] m_data = null;

    public CommandReader(InputStream in, byte[] data) {
        this.m_in = in;
        this.m_length = -2;
        this.m_data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            CommandReader commandReader = this;
            synchronized (commandReader) {
                this.m_length = this.m_in.read(this.m_data);
                this.notifyAll();
                for (int i = 0; i < 3; ++i) {
                    Thread.currentThread();
                    Thread.sleep(TIMEOUT);
                    this.notifyAll();
                }
            }
        }
        catch (IOException ex) {
            this.m_ex = ex;
        }
        catch (Exception ex) {
            this.m_ex = new IOException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readData(InputStream in, byte[] data) throws IOException {
        CommandReader reader = new CommandReader(in, data);
        Thread th = new Thread((Runnable)reader, "CommandReader");
        th.start();
        try {
            CommandReader commandReader = reader;
            synchronized (commandReader) {
                int count = 0;
                while (reader.m_length == -2) {
                    reader.wait(TIMEOUT);
                    if (++count <= 3) continue;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (reader.m_ex != null) {
            throw reader.m_ex;
        }
        if (reader.m_length <= 0) {
            throw new IOException("can not read from switch. Read length:" + reader.m_length);
        }
        return reader.m_length;
    }

    static int readPrompt(InputStream in, OutputStream out, byte[] data) throws IOException {
        byte[] bytes = new byte[1024];
        int length = 0;
        try {
            out.write("\n".getBytes());
            out.flush();
            byte[] ex_out = new byte[1024];
            int ex_length = in.read(ex_out);
            String ex_prompt = new String(ex_out, 0, ex_length);
            while (true) {
                out.write("\n".getBytes());
                out.flush();
                length = in.read(bytes);
                String prompt = new String(bytes, 0, length);
                if (length != ex_length || !ex_prompt.equals(prompt)) {
                    ex_prompt = prompt;
                    ex_length = length;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return length;
    }
}

