/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.se;

import com.cisco.dcbu.lib.jnm.SshUserInfo;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.server.se.CommandReader;
import com.cisco.dcbu.sm.server.se.SEMediator;
import com.cisco.dcbu.sm.server.se.SESshMediatorPdu;
import com.cisco.dcbu.sm.server.se.SESshMediatorReqPdu;
import com.cisco.dcbu.sm.server.se.SESshMediatorRespPdu;
import com.cisco.dcbu.sm.server.se.pdu.SeActiveJobCountResp;
import com.cisco.dcbu.sm.server.se.pdu.SeAlgoListResp;
import com.cisco.dcbu.sm.server.se.pdu.SeCreateJobResp;
import com.cisco.dcbu.sm.server.se.pdu.SeCreateSessionResp;
import com.cisco.dcbu.sm.server.se.pdu.SeDeleteJobResp;
import com.cisco.dcbu.sm.server.se.pdu.SeDiscoveryResp;
import com.cisco.dcbu.sm.server.se.pdu.SeGetJobListResp;
import com.cisco.dcbu.sm.server.se.pdu.SeGetVIListResp;
import com.cisco.dcbu.sm.server.se.pdu.SeJobActionResp;
import com.cisco.dcbu.sm.server.se.pdu.SeJobStatusResp;
import com.cisco.dcbu.sm.server.se.pdu.SePduHdr;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SESshMediator
implements SEMediator {
    private static final int SSH_READ_TIMEOUT = Integer.getInteger("dmm.read.timeout", 60000);
    private static final int SSH_INIT_READ_TIMEOUT = Integer.getInteger("dmm.read.ini.timeout", 15000);
    private static final int SSH_CONNECT_TIMEOUT = Integer.getInteger("dmm.connect.timeout", 10000);
    private static final boolean CONNECTION_RETRY = Boolean.getBoolean("dmm.connection.retry");
    private static short SSM_PORT = (short)2047;
    static final byte CARRIAGE_RETURN = 13;
    static final boolean _AsciiMode = true;
    static boolean _UseSocket = true;
    public static Logger _Logger = LogManager.getLogger((String)"se");
    public static short SSH = 1;
    protected Vsh _vsh;
    private Session _session = null;
    private Channel _channel = null;
    private InputStream _in;
    private OutputStream _out;
    public static byte SE_PDU_VERSION = 1;
    static int _ReqId = 3;
    private String _user;
    private String _pass;
    private String _mgmtIp = null;
    private String _ssmCardIp = null;
    static char[] s_hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static SePduHdr getHeader(byte type, SESshMediatorReqPdu pdu) throws IOException {
        SePduHdr hdr = new SePduHdr();
        hdr.setOpcode(type);
        hdr.setVersion(SE_PDU_VERSION);
        hdr.setReqId(SESshMediator.getReqId());
        pdu.setPduHdr(hdr);
        int hdrLen = hdr.toByteArray().length;
        int pduLen = pdu.toByteArray().length;
        hdr.setLength((short)(pduLen - hdrLen));
        return hdr;
    }

    public static int getReqId() {
        return _ReqId++;
    }

    @Override
    public void reconnect() throws IOException {
        this.setUpInternal(this._mgmtIp, this._ssmCardIp);
    }

    public SESshMediator(String host, String user, String passCode) throws IOException {
        this._user = user;
        this._pass = passCode;
    }

    public static String toHexString(long value) {
        StringBuffer buf = new StringBuffer();
        byte[] setValues = new byte[8];
        setValues[7] = (byte)(value >> 56 & 0xFFL);
        setValues[6] = (byte)(value >> 48 & 0xFFL);
        setValues[5] = (byte)(value >> 40 & 0xFFL);
        setValues[4] = (byte)(value >> 32 & 0xFFL);
        setValues[3] = (byte)(value >> 24 & 0xFFL);
        setValues[2] = (byte)(value >> 16 & 0xFFL);
        setValues[1] = (byte)(value >> 8 & 0xFFL);
        setValues[0] = (byte)(value & 0xFFL);
        try {
            boolean hasValue = false;
            for (int i = 7; i >= 0; --i) {
                if (setValues[i] == 0) {
                    if (!hasValue) {
                        continue;
                    }
                } else {
                    hasValue = true;
                }
                buf.append(SESshMediator.toHexString(setValues[i]));
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)("can not convert to String:" + ex.getMessage()), (Throwable)ex);
        }
        return buf.toString();
    }

    private static String toHexString(byte in) {
        StringBuffer buf = new StringBuffer();
        try {
            byte lowPos = (byte)(in & 0xF);
            byte highPos = (byte)(in >> 4 & 0xF);
            buf.append(s_hexChar[highPos]);
            buf.append(s_hexChar[lowPos]);
        }
        catch (Exception ex) {
            _Logger.error((Object)("can not convert to String:" + ex.getMessage()), (Throwable)ex);
        }
        return buf.toString();
    }

    @Override
    public Object sendRecv(short messageType, Object in) throws IOException {
        return this.sendRecv(messageType, in, false);
    }

    @Override
    public Object sendRecv(short messageType, Object in, boolean retry) throws IOException {
        SESshMediatorReqPdu pduIn = (SESshMediatorReqPdu)in;
        try {
            return this.sendRecv(messageType, pduIn);
        }
        catch (IOException ioe) {
            if (retry) {
                this.reconnect();
                return this.sendRecv(messageType, pduIn);
            }
            throw ioe;
        }
    }

    private Object sendRecv(short messageType, SESshMediatorReqPdu pduIn) throws IOException {
        SESshMediatorPdu resp = this.sendRecvInternal(messageType, pduIn);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SESshMediatorPdu sendRecvInternal(short messageType, Object in) throws IOException {
        byte[] toWrite = ((SESshMediatorPdu)in).toByteArray();
        SESshMediatorRespPdu ret = null;
        SESshMediatorReqPdu pduIn = (SESshMediatorReqPdu)in;
        System.out.println("MMMM send:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + pduIn.toString());
        _Logger.debug((Object)("send:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + pduIn.toString()));
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this.write(toWrite);
            switch (messageType) {
                case 0: {
                    SeGetVIListResp pdu = new SeGetVIListResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 1: {
                    SeCreateJobResp createJobResp = new SeCreateJobResp();
                    createJobResp.fromByteArray(this.read(toWrite.length));
                    ret = createJobResp;
                    break;
                }
                case 4: {
                    SeDiscoveryResp discoveryResp = new SeDiscoveryResp();
                    discoveryResp.fromByteArray(this.read(toWrite.length));
                    ret = discoveryResp;
                    break;
                }
                case 3: {
                    SeCreateSessionResp sessionResp = new SeCreateSessionResp();
                    sessionResp.fromByteArray(this.read(toWrite.length));
                    ret = sessionResp;
                    break;
                }
                case 6: {
                    SeAlgoListResp algoResp = new SeAlgoListResp();
                    algoResp.fromByteArray(this.read(toWrite.length));
                    ret = algoResp;
                    break;
                }
                case 7: {
                    SeGetJobListResp jobsResp = new SeGetJobListResp();
                    jobsResp.fromByteArray(this.read(toWrite.length));
                    ret = jobsResp;
                    break;
                }
                case 5: {
                    SeJobStatusResp statusResp = new SeJobStatusResp();
                    statusResp.fromByteArray(this.read(toWrite.length));
                    ret = statusResp;
                    break;
                }
                case 2: {
                    SeJobActionResp jobActionResp = new SeJobActionResp();
                    jobActionResp.fromByteArray(this.read(toWrite.length));
                    ret = jobActionResp;
                    break;
                }
                case 8: {
                    SeDeleteJobResp deletJobResp = new SeDeleteJobResp();
                    deletJobResp.fromByteArray(this.read(toWrite.length));
                    ret = deletJobResp;
                    break;
                }
                case 9: {
                    SeActiveJobCountResp getActiveJobCountResp = new SeActiveJobCountResp();
                    getActiveJobCountResp.fromByteArray(this.read(toWrite.length));
                    ret = getActiveJobCountResp;
                    break;
                }
            }
            _Logger.debug((Object)("recv:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + ret));
        }
        return ret;
    }

    private String getString(byte[] toSend) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < toSend.length; ++i) {
            buf.append(SESshMediator.toHexString(toSend[i]));
        }
        buf.append("\n");
        return buf.toString();
    }

    private void write(byte[] toWrite) throws IOException {
        byte[] toSend = toWrite;
        String asciiStr = this.getString(toSend);
        System.out.println(" -SE- send:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + asciiStr);
        _Logger.debug((Object)(" -SE- send:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + asciiStr));
        toSend = asciiStr.getBytes();
        try {
            this._out.write(toSend);
        }
        catch (IOException ex) {
            this.setUpInternal(this._mgmtIp, this._ssmCardIp);
            this._out.write(toSend);
        }
    }

    private ByteBuffer read(int skipLength) throws IOException {
        byte[] skip = new byte[skipLength * 2 + 2];
        int x = this._in.read(skip);
        byte[] all = new byte[8000];
        int read_len = this._in.read(all);
        if (read_len == -1) {
            throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds - to " + this._mgmtIp + ": " + this._ssmCardIp + ": ");
        }
        ByteBuffer ret = null;
        _Logger.debug((Object)("recv:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + new String(all, 0, read_len)));
        ret = ByteBuffer.allocate(81920);
        int total_length = this.getBnaryFromHex(all, read_len, ret, true);
        _Logger.debug((Object)("pdu total length:" + total_length));
        int count = 0;
        while (read_len < total_length) {
            all = new byte[8000];
            int temp = this._in.read(all);
            if (temp == -1) {
                throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds ");
            }
            if (temp % 2 == 1) {
                _Logger.debug((Object)("read an odd number of bytes - " + temp + " will read one more "));
                byte[] oneMore = new byte[1];
                int oneMoreLength = this._in.read(oneMore);
                if (oneMoreLength == -1) {
                    throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds ");
                }
                all[temp] = oneMore[0];
                ++temp;
                _Logger.debug((Object)("read one more - " + oneMoreLength + " will append to last read"));
            }
            _Logger.debug((Object)("read " + temp + " bytes" + " readlen: " + (read_len += temp) + " total_length: " + total_length));
            this.getBnaryFromHex(all, temp, ret, false);
            ++count;
        }
        ret.rewind();
        return ret;
    }

    private int getBnaryFromHex(byte[] all, int read_len, ByteBuffer ret, boolean getCount) {
        String preHex = "";
        int total_length = 8;
        for (int count = 0; count < read_len; count += 2) {
            String hex;
            block7: {
                hex = new String(all, count, 2);
                try {
                    byte[] value = SnmpString.fromHexString(hex, false);
                    ret.put(value[0]);
                    if (getCount && count == 6) {
                        value = SnmpString.fromHexString(preHex + hex, false);
                        total_length = value[1];
                        if (total_length < 0) {
                            total_length = 256 + total_length;
                        }
                        if (value[0] < 0) {
                            int temp = value[0];
                            total_length += (temp += 256) * 256;
                        } else {
                            total_length += value[0] * 256;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    if (count == total_length - 2) break block7;
                    _Logger.debug((Object)("stop at hex:" + hex + ":" + count));
                }
            }
            preHex = hex;
        }
        return total_length;
    }

    public static int getBinaryFromHex(char[] all, int read_len, ByteBuffer ret, boolean getCount) {
        String preHex = "";
        int total_length = 8;
        for (int count = 0; count < read_len; count += 2) {
            String hex;
            block5: {
                hex = new String(all, count, 2);
                try {
                    byte[] value = SnmpString.fromHexString(hex, false);
                    ret.put(value[0]);
                    if (getCount && count == 6) {
                        value = SnmpString.fromHexString(preHex + hex, false);
                        total_length = value[1];
                        if (total_length < 0) {
                            total_length = 256 + total_length;
                        }
                        total_length += value[0] * 256;
                    }
                }
                catch (NumberFormatException ex) {
                    if (count == total_length - 2) break block5;
                    _Logger.debug((Object)("stop at hex:" + hex + ":" + count));
                }
            }
            preHex = hex;
        }
        return total_length;
    }

    @Override
    public void setUp(String mgmtIp, String ssmCardIp) throws IOException {
        this.setUp(mgmtIp, ssmCardIp, CONNECTION_RETRY);
    }

    @Override
    public void setUp(String mgmtIp, String ssmCardIp, boolean retry) throws IOException {
        if (ssmCardIp == null || ssmCardIp.trim().equals("")) {
            throw new IOException("ssmCardIp is null");
        }
        try {
            this.setUpInternal(mgmtIp, ssmCardIp);
        }
        catch (IOException ex) {
            if (retry) {
                _Logger.debug((Object)"caught an exception: one more try");
                this.setUpInternal(mgmtIp, ssmCardIp);
            }
            throw ex;
        }
    }

    private void setUpInternal(String mgmtIp, String ssmCardIp) throws IOException {
        JSch jsch = new JSch();
        this._mgmtIp = mgmtIp;
        this._ssmCardIp = ssmCardIp;
        try {
            this._session = jsch.getSession(this._user, mgmtIp);
            this._session.setPassword(this._pass);
            this._session.setUserInfo(new SshUserInfo(this._pass));
            this._session.setTimeout(SSH_INIT_READ_TIMEOUT);
            this._session.connect(SSH_CONNECT_TIMEOUT);
            if (!this._session.isConnected()) {
                throw new IOException("can not open session to:" + ssmCardIp + " on switcher: " + mgmtIp);
            }
            this._session.setTimeout(SSH_READ_TIMEOUT);
            this._channel = this._session.openChannel("shell");
            this._in = this._channel.getInputStream();
            this._out = this._channel.getOutputStream();
            this._channel.connect();
            String connectTo = "telnet " + ssmCardIp + "  " + SSM_PORT + "\n";
            _Logger.debug((Object)("SE telnet to:" + mgmtIp + ":" + ssmCardIp));
            if (!this.doHandShack(connectTo, mgmtIp)) {
                throw new IOException("Can not connect to ssmCard:" + ssmCardIp + " on MDS: " + mgmtIp);
            }
        }
        catch (JSchException ex) {
            throw new IOException("Failed to connect to" + mgmtIp + " " + ex.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void disconnect() {
        _Logger.debug((Object)("disconnect:" + this._mgmtIp + ":" + this._ssmCardIp));
        if (this._channel != null) {
            this._channel.disconnect();
        }
        if (this._session != null) {
            this._session.disconnect();
        }
    }

    public boolean doHandShack(String connectTo, String switchIp) throws IOException {
        byte[] outArr = new byte[2048];
        int length = this._in.read(outArr);
        String peek = new String(outArr, 0, length);
        CommandReader.readPrompt(this._in, this._out, outArr);
        String no_monitor = "terminal no monitor_force\n";
        this._out.write(no_monitor.getBytes());
        this._out.flush();
        this._out.write(connectTo.getBytes());
        this._out.flush();
        while (peek.indexOf("Escape") < 0) {
            try {
                length = CommandReader.readData(this._in, outArr);
            }
            catch (IOException io) {
                _Logger.error((Object)("error during read:" + io.getMessage()));
                throw new IOException("can not connect to line card " + connectTo + " on MDS " + switchIp + ", recieved read error: " + io.getMessage());
            }
            peek = new String(outArr, 0, length);
            if (peek.indexOf("Connection refused") < 0) continue;
            _Logger.error((Object)("can not connect to line card " + connectTo + " on MDS " + switchIp + ", refused to connect to SSM"));
            throw new IOException("can not connect to line card " + connectTo + " on MDS " + switchIp + ", refused to connect to SSM");
        }
        if (peek.indexOf("Connection closed") >= 0) {
            _Logger.error((Object)("can not connect to line card, Telnet session is closed:" + connectTo + " on MDS " + switchIp));
            throw new IOException("can not connect to line card, Telnet session is closed:" + connectTo + " on MDS " + switchIp);
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String str = "01000000040000000600000002000000000000000000000000202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202000000021000000184AB968E300000000000000000000000050060E80042C5C5000000000";
        ByteBuffer ret = ByteBuffer.allocate(40960);
        StringReader _in = new StringReader(str);
        char[] all = new char[1024];
        int read_len = _in.read(all, 0, str.length());
        if (read_len == -1) {
            throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds ");
        }
        SESshMediator.getBinaryFromHex(all, read_len, ret, true);
        ret.rewind();
        SeDiscoveryResp pdu = new SeDiscoveryResp();
        pdu.fromByteArray(ret);
        System.out.println(pdu);
    }
}

