/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.se.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.se.SESshMediatorRespPdu;
import com.cisco.dcbu.sm.server.se.pdu.SeAlgoData;
import com.cisco.dcbu.sm.server.se.pdu.SePduHdr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SeAlgoListResp
implements SESshMediatorRespPdu {
    private SePduHdr m_pdu_hdr;
    private byte m_algo_count;
    private List m_algo_list;

    public void setPduHdr(SePduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    @Override
    public SePduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setAlgoCount(byte algo_count) {
        this.m_algo_count = algo_count;
    }

    public byte getAlgoCount() {
        return this.m_algo_count;
    }

    public void setAlgoList(List algo_list) {
        this.m_algo_list = algo_list;
    }

    public List getAlgoList() {
        return this.m_algo_list;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeByte(stream, this.m_algo_count, 1);
        for (int i = 0; i < this.m_algo_list.size(); ++i) {
            SeAlgoData obj = (SeAlgoData)this.m_algo_list.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new SePduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_algo_count = SshMediatorHelper.readByte(stream, 1);
        this.m_algo_list = new ArrayList();
        for (int i = 0; i < this.m_algo_count; ++i) {
            SeAlgoData obj = new SeAlgoData();
            obj.fromByteArray(stream);
            this.m_algo_list.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(SeAlgoListResp:");
        buf.append("m_algo_count:" + this.m_algo_count + ":");
        buf.append("m_algo_list:");
        for (int i = 0; i < this.m_algo_list.size(); ++i) {
            buf.append(":" + this.m_algo_list.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

