/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.se.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.se.SESshMediatorReqPdu;
import com.cisco.dcbu.sm.server.se.pdu.SePduHdr;
import com.cisco.dcbu.sm.server.se.pdu.SeTLV;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SeCreateJobReq
implements SESshMediatorReqPdu {
    private SePduHdr m_pdu_hdr;
    private int m_job_id;
    private String m_job_name;
    private int m_vsan_id;
    private int m_length;
    private List m_tlv_list;

    @Override
    public void setPduHdr(SePduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    @Override
    public SePduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setJobId(int job_id) {
        this.m_job_id = job_id;
    }

    public int getJobId() {
        return this.m_job_id;
    }

    public void setJobName(String job_name) {
        this.m_job_name = job_name;
    }

    public String getJobName() {
        return this.m_job_name;
    }

    public void setVsanId(int vsan_id) {
        this.m_vsan_id = vsan_id;
    }

    public int getVsanId() {
        return this.m_vsan_id;
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    public int getLength() {
        return this.m_length;
    }

    public void setTlvList(List tlv_list) {
        this.m_tlv_list = tlv_list;
    }

    public List getTlvList() {
        return this.m_tlv_list;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeInt(stream, this.m_job_id, 4);
        SshMediatorHelper.writeString(stream, this.m_job_name, 64);
        SshMediatorHelper.writeInt(stream, this.m_vsan_id, 4);
        SshMediatorHelper.writeInt(stream, this.m_length, 4);
        for (int i = 0; i < this.m_tlv_list.size(); ++i) {
            SeTLV obj = (SeTLV)this.m_tlv_list.get(i);
            SshMediatorHelper.writeSeTLV(stream, obj);
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new SePduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_job_id = SshMediatorHelper.readInt(stream, 4);
        this.m_job_name = SshMediatorHelper.readString(stream, 64);
        this.m_vsan_id = SshMediatorHelper.readInt(stream, 4);
        this.m_length = SshMediatorHelper.readInt(stream, 4);
        this.m_tlv_list = new ArrayList();
        for (int i = 0; i < this.m_length; ++i) {
            SeTLV obj = new SeTLV();
            obj.fromByteArray(stream);
            this.m_tlv_list.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(SeCreateJobReq:");
        buf.append("m_job_id:" + this.m_job_id + ":");
        buf.append("m_job_name:" + this.m_job_name + ":");
        buf.append("m_vsan_id:" + this.m_vsan_id + ":");
        buf.append("m_length:" + this.m_length + ":");
        buf.append("m_tlv_list:");
        for (int i = 0; i < this.m_tlv_list.size(); ++i) {
            buf.append(":" + this.m_tlv_list.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

