/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.se.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.se.SESshMediatorReqPdu;
import com.cisco.dcbu.sm.server.se.pdu.SePduHdr;
import com.cisco.dcbu.sm.server.se.pdu.SeTarget;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SeDiscoveryReq
implements SESshMediatorReqPdu {
    private SePduHdr m_pdu_hdr;
    private byte m_flags;
    private int m_vsan_id;
    private int m_job_id;
    private int m_target_count;
    private List m_se_target;

    @Override
    public void setPduHdr(SePduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    @Override
    public SePduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setFlags(byte flags) {
        this.m_flags = flags;
    }

    public byte getFlags() {
        return this.m_flags;
    }

    public void setVsanId(int vsan_id) {
        this.m_vsan_id = vsan_id;
    }

    public int getVsanId() {
        return this.m_vsan_id;
    }

    public void setJobId(int job_id) {
        this.m_job_id = job_id;
    }

    public int getJobId() {
        return this.m_job_id;
    }

    public void setTargetCount(int target_count) {
        this.m_target_count = target_count;
    }

    public int getTargetCount() {
        return this.m_target_count;
    }

    public void setSeTarget(List se_target) {
        this.m_se_target = se_target;
    }

    public List getSeTarget() {
        return this.m_se_target;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeByte(stream, this.m_flags, 1);
        SshMediatorHelper.writeInt(stream, this.m_vsan_id, 4);
        SshMediatorHelper.writeInt(stream, this.m_job_id, 4);
        SshMediatorHelper.writeInt(stream, this.m_se_target.size(), 4);
        for (int i = 0; i < this.m_se_target.size(); ++i) {
            SeTarget obj = (SeTarget)this.m_se_target.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new SePduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_flags = SshMediatorHelper.readByte(stream, 1);
        this.m_vsan_id = SshMediatorHelper.readInt(stream, 4);
        this.m_job_id = SshMediatorHelper.readInt(stream, 4);
        this.m_target_count = SshMediatorHelper.readInt(stream, 4);
        this.m_se_target = new ArrayList();
        for (int i = 0; i < this.m_target_count; ++i) {
            SeTarget obj = new SeTarget();
            obj.fromByteArray(stream);
            this.m_se_target.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(SeDiscoveryReq:");
        buf.append("m_flags:" + this.m_flags + ":");
        buf.append("m_vsan_id:" + this.m_vsan_id + ":");
        buf.append("m_job_id:" + this.m_job_id + ":");
        buf.append("m_target_count:" + this.m_target_count + ":");
        buf.append("m_se_target:");
        for (int i = 0; i < this.m_se_target.size(); ++i) {
            buf.append(":" + this.m_se_target.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

