/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.sm.common.security.RoleType;
import com.cisco.dcbu.sm.common.security.UserRoles;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.security.UserFabricImpl;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class FMUser
implements Serializable {
    private static final long serialVersionUID = -4040681681953169551L;
    public static Logger _Logger = Logger.getLogger((String)FMUser.class.getName());
    private long _userId;
    private String _userName;
    private String _hashedPwd;
    private List<String> _roles = new ArrayList<String>();
    private ConcurrentHashMap<FabricPK, SnmpUser> _SnmpUsers = new ConcurrentHashMap(5);

    public int hashCode() {
        int result = 17;
        int c = this._userName == null ? 0 : this._userName.hashCode();
        result = 37 * result + c;
        c = this._hashedPwd == null ? 0 : this._hashedPwd.hashCode();
        result = 37 * result + c;
        c = this._roles == null ? 0 : this._roles.hashCode();
        result = 37 * result + c;
        return result;
    }

    public FMUser(long userId, String userName, String hashedPwd, String role) throws Exception {
        if (userName == null || userName.length() == 0) {
            throw new Exception("userName can't be null or empty string");
        }
        this._userId = userId;
        this._userName = userName;
        this._hashedPwd = hashedPwd;
        if (role != null && role.trim().length() != 0) {
            this._roles.add(role);
        }
    }

    public FMUser(long userId, String userName, String hashedPwd, List<String> roles) throws Exception {
        if (userName == null || userName.length() == 0) {
            throw new Exception("userName can't be null or empty string");
        }
        this._userId = userId;
        this._userName = userName;
        this._hashedPwd = hashedPwd;
        if (roles != null && roles.size() != 0) {
            this._roles.addAll(roles);
        }
    }

    public FMUser(String userName, String hashedPwd, String role) throws Exception {
        this(0L, userName, hashedPwd, role);
    }

    public FMUser(String userName, String hashedPwd, List<String> roles) throws Exception {
        this(0L, userName, hashedPwd, roles);
    }

    public String getHashedPwd() {
        return this._hashedPwd;
    }

    public void setHashedPwd(String hashedPwd) {
        this._hashedPwd = hashedPwd;
    }

    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRoleName() {
        String result = null;
        List<String> list = this._roles;
        synchronized (list) {
            for (String role : this._roles) {
                if (!UserRoles.INSTANCE.isAdminRole(role)) continue;
                result = role;
                break;
            }
            if (result == null) {
                result = Collections.unmodifiableList(this._roles).get(0);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRoles() {
        List<String> result = null;
        List<String> list = this._roles;
        synchronized (list) {
            result = Collections.unmodifiableList(this._roles);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleName(String role) {
        List<String> list = this._roles;
        synchronized (list) {
            this._roles.clear();
            this._roles.add(0, role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoles(List<String> roles) {
        List<String> list = this._roles;
        synchronized (list) {
            this._roles.clear();
            this._roles.addAll(roles);
        }
    }

    public boolean isUserInRole(String roleName) {
        return this._roles.contains(roleName);
    }

    public ConcurrentHashMap<FabricPK, SnmpUser> getSnmpUsers() {
        return this._SnmpUsers;
    }

    public void setSnmpUsers(HashMap<FabricPK, SnmpUser> snmpUsers) {
        if (snmpUsers == null || snmpUsers.isEmpty()) {
            return;
        }
        this._SnmpUsers.putAll(snmpUsers);
    }

    public SnmpUser getSnmpUser(FabricPK fabricPK) {
        SnmpUser snmpUser = this._SnmpUsers.get(fabricPK);
        if (snmpUser == null) {
            try {
                snmpUser = UserFabricImpl.getSnmpUser(this._userName, fabricPK);
            }
            catch (SQLException e) {
                _Logger.info((Object)e.getMessage());
            }
        }
        return snmpUser;
    }

    public void addSnmpUser(FabricPK fabricPK, SnmpUser snmpUser) {
        if (snmpUser == null) {
            return;
        }
        this._SnmpUsers.put(fabricPK, snmpUser);
        AddUserThread usrThrd = new AddUserThread(fabricPK, snmpUser);
        new Thread(usrThrd).start();
    }

    public boolean isAdmin() {
        return UserRoles.INSTANCE.isAdmin(this._roles);
    }

    public boolean isSAAdmin() {
        return this._roles.size() != 0 && !UserRoles.INSTANCE.isAdmin(this._roles) && this._roles.contains((Object)RoleType.ROLE_SA_ADMIN);
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof FMUser)) {
            return false;
        }
        FMUser dx = (FMUser)x;
        return dx.getUserName().equals(this._userName) && dx.getHashedPwd().equals(this._hashedPwd) && dx.getRoles().equals(this._roles);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getUserName());
        sb.append(", SnmpUsers:");
        Iterator it = this._SnmpUsers.keySet().iterator();
        while (it.hasNext()) {
            sb.append("\n\t").append(it.next());
        }
        return sb.toString();
    }

    public class AddUserThread
    implements Runnable {
        FabricPK _fabricPK;
        SnmpUser _snmpUser;

        public AddUserThread(FabricPK fabricPK, SnmpUser snmpUser) {
            this._fabricPK = fabricPK;
            this._snmpUser = snmpUser;
        }

        @Override
        public void run() {
            try {
                UserFabricImpl.addSnmpUser(FMUser.this._userName, this._fabricPK, this._snmpUser);
            }
            catch (Exception e) {
                _Logger.trace((Object)e.getMessage());
                return;
            }
        }
    }
}

