/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.security.RoleType;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.RadiusConfig;
import com.cisco.dcbu.sm.server.security.ServerAuthenticatorIf;
import com.cisco.dcbu.sm.server.security.UMUtil;
import com.cisco.dcbu.sm.server.security.UserFabricImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.dictionary.Attr_NASPort;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RadiusAuthenticator
implements ServerAuthenticatorIf {
    public static Logger _Logger = LogManager.getLogger((String)"fms.security");
    protected final int AUTH_NOT_TRIED = -1;
    protected final int AUTH_FAIL = 0;
    protected final int AUTH_PASS = 1;
    private static final int SOCK_TIME_OUT = 3;
    private static final int NUM_RETRIES = 1;
    private String[] depth = new String[]{".server.primary", ".server.secondary", ".server.tertiary"};
    private RadiusConfig[] configs = new RadiusConfig[this.depth.length];

    public RadiusAuthenticator() {
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        for (int i = 0; i < this.depth.length; ++i) {
            RadiusConfig rc = new RadiusConfig();
            String server = System.getProperty("aaa" + this.depth[i] + ".name");
            String secret = System.getProperty("aaa" + this.depth[i] + ".secret");
            if (secret != null && secret.startsWith("#")) {
                try {
                    secret = StringEncrypter.DESedeDecrypt(secret.substring(1));
                }
                catch (Exception ex) {
                    _Logger.error((Object)("RadiusAuthenticator can not decryt secret: " + secret));
                    break;
                }
            }
            String authPort = System.getProperty("radius" + this.depth[i] + ".auth-port");
            String acctPort = System.getProperty("radius" + this.depth[i] + ".acct-port");
            String method = System.getProperty("aaa" + this.depth[i] + ".auth-method");
            if (server == null || server.trim().length() == 0) {
                server = null;
                continue;
            }
            if (secret == null || secret.trim().length() == 0) {
                secret = null;
            }
            if (authPort == null || authPort.trim().length() == 0) {
                authPort = "1812";
            }
            if (acctPort == null || acctPort.trim().length() == 0) {
                acctPort = "1813";
            }
            if (method == null || method.trim().length() == 0) {
                method = null;
            }
            _Logger.log((Priority)Level.INFO, (Object)("aaa" + this.depth[i] + " = " + server + ", authPort = " + authPort + ", method = " + method));
            rc.setSecret(secret);
            rc.setMethod(method);
            try {
                rc.setServer(InetAddress.getByName(server).getHostName());
            }
            catch (UnknownHostException e) {
                _Logger.log((Priority)Level.TRACE, (Object)e.getMessage());
            }
            try {
                int port1 = Integer.parseInt(authPort);
                rc.setAuthPort(port1);
            }
            catch (NumberFormatException nfe) {
                _Logger.log((Priority)Level.TRACE, (Object)"Unexpected : number expected for auth port.");
            }
            try {
                int port2 = Integer.parseInt(acctPort);
                rc.setAcctPort(port2);
            }
            catch (NumberFormatException nfe) {
                _Logger.log((Priority)Level.TRACE, (Object)"Unexpected : number expected for acct port.");
            }
            this.configs[i] = rc;
        }
    }

    @Override
    public String getName() {
        return "radius";
    }

    @Override
    public FMUser authenticate(String userName, String authPassword) throws Exception {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            for (int i = 0; i < this.configs.length; ++i) {
                int result = -1;
                if (this.configs[i] == null) continue;
                try {
                    result = this.radiusAuthenticate(this.configs[i], userName, StringEncrypter.DESedeDecrypt(authPassword), roles);
                }
                catch (Exception e) {
                    _Logger.log((Priority)Level.WARN, (Object)(userName + " authentication is failed on " + this.configs[i].getServer() + " error: "), (Throwable)e);
                }
                if (result == 1) {
                    _Logger.log((Priority)Level.INFO, (Object)(userName + " login from  " + this.configs[i].getServer() + " is succeeded."));
                    if (roles.isEmpty()) {
                        roles.add(RoleType.ROLE_OPER.value());
                    }
                    FMUser fmUser = new FMUser(userName + "@RADIUS", authPassword, roles);
                    fmUser.setSnmpUsers(UserFabricImpl.loadFromDB(fmUser.getUserName()));
                    return fmUser;
                }
                if (result == 0) {
                    _Logger.log((Priority)Level.INFO, (Object)(userName + " login from  " + this.configs[i].getServer() + " is failed."));
                    return null;
                }
                _Logger.log((Priority)Level.INFO, (Object)(userName + " login from  " + this.configs[i].getServer() + " is failed."));
            }
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)ex.getMessage());
        }
        throw new Exception("Radius server is not validating user normally");
    }

    public int radiusAuthenticate(RadiusConfig cfg, String userName, String authPassword, List<String> roles) {
        if (cfg.getSecret() == null || cfg.getMethod() == null) {
            return -1;
        }
        String radiusServer = cfg.getServer();
        int authPort = cfg.getAuthPort();
        int acctPort = cfg.getAcctPort();
        String sharedSecret = cfg.getSecret();
        int authenticated = -1;
        try {
            InetAddress addr = InetAddress.getByName(radiusServer);
            RadiusClient rc = new RadiusClient(addr, sharedSecret, authPort, acctPort, 3);
            _Logger.log((Priority)Level.INFO, (Object)("Login using Radius Autenticate, userName=" + userName + ", sharedSecret=" + sharedSecret + ", authPort=" + authPort + ", acctPort=" + acctPort));
            AttributeList attributeList = new AttributeList();
            attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)userName)));
            attributeList.add((RadiusAttribute)new Attr_NASPort((Serializable)Integer.valueOf(authPort)));
            AccessRequest request = new AccessRequest(rc, attributeList);
            request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)authPassword)));
            String authMethod = null;
            authMethod = cfg.getMethod();
            RadiusResponse reply = null;
            if (authMethod.equalsIgnoreCase("pap")) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is PAP");
                reply = rc.authenticate(request, (net.jradius.client.auth.RadiusAuthenticator)new PAPAuthenticator(), 1);
            } else if (authMethod.equalsIgnoreCase("chap")) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is CHAP");
                reply = rc.authenticate(request, (net.jradius.client.auth.RadiusAuthenticator)new CHAPAuthenticator(), 1);
            } else if (authMethod.equalsIgnoreCase("mschapv1")) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is MSCHAPV1");
                reply = rc.authenticate(request, (net.jradius.client.auth.RadiusAuthenticator)new MSCHAPv1Authenticator(), 1);
            } else if (authMethod.equalsIgnoreCase("mschapv2")) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is MSCHAPV2");
                reply = rc.authenticate(request, (net.jradius.client.auth.RadiusAuthenticator)new MSCHAPv2Authenticator(), 1);
            } else {
                _Logger.log((Priority)Level.WARN, (Object)"Authentication method is unknown");
            }
            if (reply == null) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Authentication Reply is null.");
                authenticated = -1;
            } else if (reply instanceof AccessAccept) {
                _Logger.log((Priority)Level.INFO, (Object)("Radius Authentication Reply is AccessAccept: " + reply.toString()));
                if (roles != null) {
                    roles.addAll(this.setRole((RadiusPacket)reply));
                }
                RadiusAuthenticator.printAttributes((RadiusPacket)reply);
                authenticated = 1;
            } else {
                _Logger.log((Priority)Level.INFO, (Object)("Radius Authentication Reply is AccessReject: " + reply.toString()));
                authenticated = 0;
            }
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.TRACE, (Object)ex.getMessage());
            authenticated = -1;
        }
        return authenticated;
    }

    private List<String> setRole(RadiusPacket rp) {
        ArrayList<String> roles = new ArrayList<String>();
        if (rp == null || rp.getAttributes() == null) {
            return roles;
        }
        List attributes = rp.getAttributes().getAttributeList();
        RadiusAttribute tempRa = null;
        for (int i = 0; i < attributes.size(); ++i) {
            tempRa = (RadiusAttribute)attributes.get(i);
            if (tempRa.getType() != 26L || tempRa.getValue() == null) continue;
            String str = new String(tempRa.getValue().toString()).trim();
            roles.addAll(UMUtil.getRoleNameFromCiscoAVPair(str));
            if (roles.size() > 0) break;
        }
        return roles;
    }

    private static void printAttributes(RadiusPacket rp) {
        List attributes = rp.getAttributes().getAttributeList();
        _Logger.log((Priority)Level.TRACE, (Object)"Response Packet Attributes");
        _Logger.log((Priority)Level.TRACE, (Object)"\tType\tValue");
        for (int i = 0; i < attributes.size(); ++i) {
            RadiusAttribute tempRa = (RadiusAttribute)attributes.get(i);
            String roleTotal = new String(tempRa.getValue().toString());
            if (tempRa.getType() == 26L) {
                int rolesIndex = roleTotal.indexOf("roles=\"");
                if (rolesIndex == -1) {
                    _Logger.log((Priority)Level.TRACE, (Object)"no roles");
                } else {
                    String rolestart = roleTotal.substring(rolesIndex + "roles\"".length() + 1);
                    int endIndex = rolestart.indexOf("\"");
                    String roles = rolestart.substring(0, endIndex);
                    _Logger.log((Priority)Level.TRACE, (Object)("Effective Role is " + roles));
                }
            }
            _Logger.log((Priority)Level.TRACE, (Object)("\t" + tempRa.getType() + "\t(" + tempRa.getClass().getName() + ")" + roleTotal));
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("aaa.server.primary.name", "172.16.33.108");
        System.setProperty("aaa.server.primary.secret", "cisco");
        System.setProperty("aaa.server.primary.auth-method", "mschapv2");
        System.setProperty("radius.server.primary.auth-port", "1812");
        System.setProperty("radius.server.primary.acct-port", "1813");
        RadiusConfig cfg = new RadiusConfig();
        cfg.setSecret("cisco");
        cfg.setServer("172.16.33.108");
        cfg.setMethod("mschapv2");
        ArrayList<String> roles = new ArrayList<String>();
        RadiusAuthenticator auth = new RadiusAuthenticator();
        auth.radiusAuthenticate(cfg, "admin", "nbv_12345", roles);
        System.out.println("roles is: " + roles);
    }
}

