/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.RoleFabricImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class RoleImpl {
    public static Logger _Logger = Logger.getLogger((String)RoleImpl.class.getName());
    static final String QuerySQLByRoleName = "select role_name from role where role_name=?";
    static final String QuerySQL = "select role_name from role";
    static final String InsertSQL = "insert into role(role_name) values(?)";
    static final String DeleteSQL = "delete from role where role_name=?";
    static final String TableName = "role";
    String _role;

    public RoleImpl(String role) {
        this._role = role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPreexistRecord(Connection con, String role) {
        boolean status;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            status = false;
            try {
                stat = con.prepareStatement(QuerySQLByRoleName);
                stat.setString(1, role);
                rs = stat.executeQuery();
                if (rs.next()) {
                    status = true;
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _Logger.info((Object)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteRole(String role) {
        ResultSet rs;
        PreparedStatement stat2;
        PreparedStatement stat;
        Connection con;
        block7: {
            boolean bl;
            block6: {
                con = null;
                stat = null;
                stat2 = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(QuerySQLByRoleName);
                    stat.setString(1, role);
                    rs = stat.executeQuery();
                    if (rs.next()) {
                        stat2 = con.prepareStatement(DeleteSQL);
                        stat2.setString(1, role);
                        stat2.executeUpdate();
                        RoleFabricImpl.deleteRole(role);
                        DCNMUserImpl.updateRoleToBasic(role);
                        bl = true;
                        DbUtil.close(rs);
                        break block6;
                    }
                    DbUtil.close(rs);
                    break block7;
                }
                catch (Exception ex) {
                    _Logger.info((Object)ex);
                    return false;
                }
            }
            DbUtil.close(stat);
            DbUtil.close(stat2);
            DbUtil.close(con);
            return bl;
        }
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return false;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(stat2);
            DbUtil.close(con);
        }
    }

    public static boolean insertRole(String roleName) throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement stat2;
        PreparedStatement stat;
        Connection con;
        block5: {
            con = null;
            stat = null;
            stat2 = null;
            rs = null;
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByRoleName);
            stat.setString(1, roleName);
            rs = stat.executeQuery();
            if (!rs.next()) break block5;
            boolean bl2 = false;
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(stat2);
            DbUtil.close(con);
            return bl2;
        }
        try {
            stat2 = con.prepareStatement(InsertSQL);
            stat2.setString(1, roleName);
            stat2.executeUpdate();
            bl = true;
        }
        catch (SQLException e) {
            try {
                _Logger.trace((Object)e.getMessage());
                throw new SQLException("inserRole failed: " + e.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getAllRoles() throws SQLException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQL);
            rs = stat.executeQuery();
            ArrayList<String> al = new ArrayList<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            arrayList = al.size() == 0 ? null : al;
        }
        catch (SQLException ex) {
            ArrayList<String> arrayList2;
            try {
                _Logger.trace((Object)ex.getMessage());
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public String getDBTableName() {
        return TableName;
    }

    public static void main(String[] strArgs) {
        try {
            boolean re = RoleImpl.insertRole("tttt");
            System.out.println("The result is: " + re);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

