/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.test;

import com.cisco.dcbu.sm.server.test.DiscoverAutomation;
import com.cisco.dcbu.smis.jaxws.ep.CallResult;
import com.cisco.dcbu.smis.jaxws.ep.SnmpCredential;
import com.cisco.dcbu.smis.jaxws.ep.SnmpException;
import com.cisco.dcbu.smis.jaxws.ep.SnmpV3Type;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DiscoverAutomationExt
extends Thread {
    public String fabDetails;

    public DiscoverAutomationExt(String fabDetails) {
        this.fabDetails = fabDetails;
    }

    @Override
    public void run() {
        String seedSw = null;
        String version = null;
        String user = null;
        String pwd = null;
        String protocol = null;
        String serverIP = null;
        String community = null;
        String vCenterIp = null;
        SnmpCredential userCredential = null;
        SnmpV3Type v3Protocol = null;
        InetAddress inetAdd = null;
        Boolean deepDiscovery = false;
        try {
            String[] values = this.fabDetails.split(",");
            if (values[0].trim().equals("SAN")) {
                if (values.length == 4) {
                    seedSw = values[1].trim();
                    community = values[2].trim();
                    serverIP = values[3].trim();
                    inetAdd = InetAddress.getByName(serverIP);
                    userCredential = new SnmpCredential(null, community, false, null, null);
                    this.discoverFabric(seedSw, userCredential, inetAdd.getHostAddress());
                } else if (values.length == 7) {
                    seedSw = values[1].trim();
                    version = values[2].trim();
                    user = values[3].trim();
                    pwd = values[4].trim();
                    protocol = values[5].trim();
                    serverIP = values[6].trim();
                    v3Protocol = SnmpV3Type.fromString((String)protocol);
                    inetAdd = InetAddress.getByName(serverIP);
                    userCredential = new SnmpCredential(user, null, true, pwd, v3Protocol);
                    this.discoverFabric(seedSw, userCredential, inetAdd.getHostAddress());
                }
            } else if (values[0].trim().equals("LAN")) {
                if (values.length == 4) {
                    seedSw = values[1].trim();
                    community = values[2].trim();
                    serverIP = values[3].trim();
                    inetAdd = InetAddress.getByName(serverIP);
                    userCredential = new SnmpCredential(null, community, false, null, null);
                    this.discoverLan(seedSw, userCredential, "1", " ", null, false, inetAdd.getHostAddress());
                } else if (values.length == 11) {
                    seedSw = values[1].trim();
                    version = values[2].trim();
                    user = values[3].trim();
                    pwd = values[4].trim();
                    String maxHop = values[5].trim();
                    String enablePwd = values[6].trim();
                    Long groupDbId = Long.parseLong(values[7].trim());
                    protocol = values[8].trim();
                    serverIP = values[9].trim();
                    v3Protocol = SnmpV3Type.fromString((String)protocol);
                    deepDiscovery = new Boolean(values[10].trim());
                    inetAdd = InetAddress.getByName(serverIP);
                    userCredential = new SnmpCredential(user, null, true, pwd, v3Protocol);
                    this.discoverLan(seedSw, userCredential, maxHop, enablePwd, groupDbId, deepDiscovery, inetAdd.getHostAddress());
                }
            } else if (values[0].trim().equals("VCenter")) {
                vCenterIp = values[1].trim();
                user = values[2].trim();
                pwd = values[3].trim();
                serverIP = values[4].trim();
                this.addVCenter(vCenterIp, user, pwd, serverIP);
            } else {
                System.out.println("Please provide valid information in the file.\nFor SNMP V2 format should be : SeedSwitchIP,CommunityString,ServerIP.\nFor SNMP V3 format should be : SeedSwitchIP,v3,Username,Password,Protocol,ServerIP");
                ++DiscoverAutomation.fail;
            }
            System.out.println("\n====================================================================================================\n");
        }
        catch (UnknownHostException e) {
            System.out.println(e.toString() + " is not a valid ip address/hostname ");
            ++DiscoverAutomation.fail;
            ++DiscoverAutomation.countFab;
            System.out.println("\n====================================================================================================\n");
        }
        catch (Exception e) {
            ++DiscoverAutomation.fail;
            ++DiscoverAutomation.countFab;
            System.out.println("Error in discovering fabric for the seed switch " + seedSw + " " + e.getMessage());
            System.out.println("\n====================================================================================================\n");
        }
    }

    private void addVCenter(String vcIP, String username, String passwd, String serverIpaddress) throws Exception {
        try {
            CallResult returnObj = new CallResult();
            System.out.println("Discovering VCenter " + vcIP + "....");
            returnObj = DiscoverAutomation.san.addVirtualCenter(vcIP, username, passwd, serverIpaddress);
            if (returnObj.getResultStatus() == 0) {
                System.out.println("Virtual Center Discovered with vCenter IP : " + vcIP);
                ++DiscoverAutomation.pass;
            } else if (returnObj.getResultStatus() == 1 || returnObj.getResultStatus() != 0) {
                System.out.println(returnObj.getResultMessage());
                ++DiscoverAutomation.fail;
            }
        }
        catch (SnmpException se) {
            throw se;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void discoverLan(String seedIp, SnmpCredential userCredential, String maxHop, String enablePwd, Long groupDbId, boolean deepDiscovery, String serverIpaddress) throws Exception {
        try {
            CallResult returnObj = new CallResult();
            System.out.println("Discovering Lan Fabric for seedSwitch " + seedIp + "....");
            if (enablePwd.equals(null)) {
                enablePwd = " ";
            }
            if ((returnObj = DiscoverAutomation.san.discoverLan(seedIp, false, userCredential, maxHop, enablePwd, groupDbId.longValue(), deepDiscovery, serverIpaddress)).getResultStatus() == 0) {
                System.out.println("Lan Fabric Discovered with SeedSwitch IP : " + seedIp);
                ++DiscoverAutomation.pass;
            } else if (returnObj.getResultStatus() == 1 || returnObj.getResultStatus() != 0) {
                System.out.println(returnObj.getResultMessage());
                ++DiscoverAutomation.fail;
            }
        }
        catch (SnmpException se) {
            throw se;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void discoverFabric(String seedSwitch, SnmpCredential userCredential, String serverIP) throws Exception {
        try {
            CallResult returnObj = new CallResult();
            System.out.println("Discovering Fabric for seedSwitch " + seedSwitch + "....");
            returnObj = DiscoverAutomation.san.discoverFabricWithServer(seedSwitch, userCredential, serverIP, "true");
            if (returnObj.getResultStatus() == 0) {
                System.out.println("Fabric Discovered with SeedSwitch IP : " + seedSwitch);
                ++DiscoverAutomation.pass;
            } else if (returnObj.getResultStatus() == 1 || returnObj.getResultStatus() != 0) {
                System.out.println(seedSwitch + " : " + returnObj.getResultMessage());
                ++DiscoverAutomation.fail;
            }
        }
        catch (SnmpException se) {
            throw se;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

