/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.test.hammer;

import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.sm.server.test.hammer.HammerTest;
import com.cisco.dcbu.sm.server.test.hammer.MetaData;
import com.ibm.wsdl.factory.WSDLFactoryImpl;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DynamicInvokeTest
implements HammerTest {
    Logger _log = LogManager.getLogger((String)"Tests.DynamicInvokeTest");

    @Override
    public void run() {
        System.out.println(">>>>Dynamic Invoke Tests are starting ...  ");
        this.init();
        this.diiexecute();
        System.out.println("<<<<Dynamic Invoke Tests have been done ...  ");
    }

    public void diiexecute() {
        String[] implURIs = MetaData.getWsdlImplURIs();
        if (implURIs == null) {
            return;
        }
        for (String implURI : implURIs) {
            try {
                this.parseWSDL(implURI);
            }
            catch (WSDLException wsdle) {
                wsdle.printStackTrace();
            }
        }
    }

    public void init() {
        TypeMappingDelegate tm = DefaultTypeMappingImpl.getSingletonDelegate();
        QName wsdlQName = new QName("http://ep.jaxws.dcbu.cisco.com/", "Wwn");
        tm.register(WwnDO.class, wsdlQName, (SerializerFactory)new BeanSerializerFactory(WwnDO.class, wsdlQName), (DeserializerFactory)new BeanDeserializerFactory(WwnDO.class, wsdlQName));
    }

    public void parseWSDL(String implURI) throws WSDLException {
        Definition wsdlInstance = null;
        String targetNamespace = null;
        String serviceName = null;
        String portName = null;
        String operationName = null;
        try {
            WSDLFactoryImpl factory = new WSDLFactoryImpl();
            WSDLReader reader = factory.newWSDLReader();
            wsdlInstance = reader.readWSDL(null, implURI);
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        if (wsdlInstance == null) {
            throw new WSDLException("OTHER_ERROR", "No WSDL impl definition found.");
        }
        targetNamespace = wsdlInstance.getTargetNamespace();
        Vector<PortType> allPorts = new Vector<PortType>();
        Map ports = wsdlInstance.getPortTypes();
        Set s = ports.keySet();
        for (Object o : s) {
            Object obj = ports.get(o);
            if (!(obj instanceof PortType)) continue;
            allPorts.add((PortType)obj);
        }
        PortType port = (PortType)allPorts.elementAt(0);
        List operations = port.getOperations();
        QName bindingQName = null;
        Map bindings = wsdlInstance.getBindings();
        s = bindings.keySet();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)bindings.get(it.next());
            if (binding.getPortType() != port) continue;
            bindingQName = binding.getQName();
        }
        if (bindingQName == null) {
            throw new WSDLException("OTHER_ERROR", "No binding found for chosen port type.");
        }
        Map implServices = wsdlInstance.getServices();
        s = implServices.keySet();
        it = s.iterator();
        while (it.hasNext()) {
            Service serv = (Service)implServices.get(it.next());
            Map m = serv.getPorts();
            Set set = m.keySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Port p = (Port)m.get(iter.next());
                if (!p.getBinding().getQName().toString().equals(bindingQName.toString())) continue;
                portName = serv.getQName().toString();
                serviceName = p.getName();
                break;
            }
            if (portName == null) continue;
            break;
        }
        for (int i = 0; i < operations.size(); ++i) {
            Operation op = (Operation)operations.get(i);
            operationName = op.getName();
            if (MetaData.isCallExcluded(operationName)) {
                System.out.println("=============");
                System.out.println("This call is excluded from test >>" + operationName + "<<...");
                System.out.println("=============");
                continue;
            }
            this.executeACall(implURI, targetNamespace, serviceName, portName, operationName, op);
        }
    }

    private void executeACall(String implURI, String targetNamespace, String serviceName, String portName, String operationName, Operation op) throws WSDLException {
        boolean isReturnTypeArray = false;
        Message outputs = op.getOutput().getMessage();
        QName oqname = null;
        Map outputParts = outputs.getParts();
        Set so = outputParts.keySet();
        Iterator ost = so.iterator();
        if (ost.hasNext()) {
            Part opart = (Part)outputParts.get(ost.next());
            oqname = opart.getTypeName();
            String olocalPart = oqname.getLocalPart();
            if (olocalPart.endsWith("Array")) {
                isReturnTypeArray = true;
            } else {
                this.registerQName(olocalPart, oqname);
            }
        }
        Message inputs = op.getInput().getMessage();
        Map inputParts = inputs.getParts();
        Object[] inputParams = new Object[inputParts.size()];
        Set s = inputParts.keySet();
        Iterator it = s.iterator();
        int i = s.size() - 1;
        while (it.hasNext()) {
            Part part = (Part)inputParts.get(it.next());
            QName qname = part.getTypeName();
            String paramstr = part.getName();
            String namespace = qname.getNamespaceURI();
            String localPart = qname.getLocalPart();
            Class cl = null;
            cl = this.registerQName(localPart, qname);
            inputParams[i] = cl.cast(MetaData.getDefaultHM().get(operationName + "::" + paramstr));
            if (inputParams[i] == null) {
                inputParams[i] = cl.cast(MetaData.getDefaultHM().get(paramstr));
            }
            if (inputParams[i] == null) {
                if (cl.isPrimitive()) {
                    cl = this.wrapPrimitive(cl);
                    try {
                        Constructor cstr = cl.getConstructor(Class.forName("java.lang.String"));
                        inputParams[i] = cstr.newInstance("" + new Random().nextInt(10));
                    }
                    catch (Exception e) {
                        this._log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    inputParams[i] = cl.cast(MetaData.getDefaultHM().get(cl.getName()));
                    if (inputParams[i] == null) {
                        try {
                            Constructor<?>[] cstrs = cl.getConstructors();
                            Constructor<?> cstr = cstrs[0];
                            Class<?>[] pvec = cstr.getParameterTypes();
                            ArrayList params = new ArrayList();
                            for (int j = 0; j < pvec.length; ++j) {
                                Object tmpParam;
                                if (pvec[j].isPrimitive()) {
                                    pvec[j] = this.wrapPrimitive(pvec[j]);
                                }
                                if ((tmpParam = MetaData.getDefaultHM().get(pvec[j].getName())) == null && pvec[j].getPackage().getName().equals("java.lang")) {
                                    Constructor<?> cspv = pvec[j].getConstructor(Class.forName("java.lang.String"));
                                    tmpParam = cspv.newInstance("" + new Random().nextInt(10));
                                }
                                params.add(pvec[j].cast(tmpParam));
                            }
                            inputParams[i] = cstr.newInstance(params.toArray());
                        }
                        catch (Exception e) {
                            this._log.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            --i;
        }
        System.out.print("\nAxis parameters gathered:\nTargetNamespace = " + targetNamespace + "\n" + "Service Name = " + serviceName + "\n" + "Port Name = " + portName + "\n" + "Operation Name = " + operationName + "\n" + "Input Parameters = ");
        for (i = 0; i < inputParams.length; ++i) {
            System.out.print(inputParams[i]);
            if (inputParams.length == 0 || inputParams.length - 1 <= i) continue;
            System.out.print(", ");
        }
        System.out.println("\n");
        this.axisInvoke(targetNamespace, serviceName, portName, operationName, inputParams, implURI, isReturnTypeArray, oqname);
    }

    private Class registerQName(String localPart, QName wsdlQName) throws WSDLException {
        TypeMappingDelegate tm = DefaultTypeMappingImpl.getSingletonDelegate();
        Class<?> cl = tm.getClassForQName(wsdlQName);
        if (cl == null) {
            try {
                String cname = MetaData.getClassHM().get(localPart);
                if (cname == null) {
                    cname = MetaData.getWSCLASSPATH() + "." + localPart + "DO";
                }
                try {
                    cl = Class.forName(cname);
                    System.out.println(cl.getName());
                }
                catch (ClassNotFoundException e2) {
                    cname = MetaData.getSECWSPACKAGE() + "." + localPart;
                    cl = Class.forName(cname);
                }
                tm.register(cl, wsdlQName, (SerializerFactory)new BeanSerializerFactory(cl, wsdlQName), (DeserializerFactory)new BeanDeserializerFactory(cl, wsdlQName));
            }
            catch (ClassNotFoundException e1) {
                throw new WSDLException("OTHER_ERROR", e1.getMessage());
            }
        }
        return cl;
    }

    public Class wrapPrimitive(Class cl) throws WSDLException {
        String type = cl.getName();
        try {
            if (type.equals("byte")) {
                return Class.forName("java.lang.Byte");
            }
            if (type.equals("char")) {
                return Class.forName("java.lang.Character");
            }
            if (type.equals("short")) {
                return Class.forName("java.lang.Short");
            }
            if (type.equals("int")) {
                return Class.forName("java.lang.Integer");
            }
            if (type.equals("double")) {
                return Class.forName("java.lang.Double");
            }
            if (type.equals("float")) {
                return Class.forName("java.lang.Float");
            }
            if (type.equals("long")) {
                return Class.forName("java.lang.Long");
            }
            if (type.equals("boolean")) {
                return Class.forName("java.lang.Boolean");
            }
            throw new WSDLException("OTHER_ERROR", "Unrecognized primitive type");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void axisInvoke(String targetNamespace, String serviceName, String portName, String operationName, Object[] inputParams, String implURI, boolean isReturnTypeArray, QName returnQname) {
        try {
            Object ret;
            int index = portName.indexOf("}", portName.indexOf("http://") + new String("http://").length());
            String portNamespace = portName.substring(portName.indexOf("{") + 1, index);
            portName = portName.substring(index == 0 ? index : index + 1);
            QName serviceQN = new QName(portNamespace, portName);
            org.apache.axis.client.Service service = new org.apache.axis.client.Service(new URL(implURI), serviceQN);
            QName portQN = new QName(targetNamespace, serviceName);
            Call call = (Call)service.createCall();
            call.addHeader(this.setSoapHeader("tokenthatalwaysworks"));
            System.out.println("Invoking service >> " + serviceName + " <<...");
            call.setOperation(portQN, operationName);
            if (MetaData.isOpReturnArrayType(operationName) || isReturnTypeArray) {
                QName qn = isReturnTypeArray ? returnQname : new QName("http://ep.jaxws.dcbu.cisco.com/", MetaData.getOpsReturnArrayType().get(operationName));
                call.setReturnType(XMLType.SOAP_ARRAY);
                call.setReturnQName(qn);
                Logger.getLogger((String)"org.apache.axis.client.Call").setLevel(Level.FATAL);
            }
            System.out.println((ret = call.invoke(inputParams)) == null ? "Call returned successfully for " + serviceName + " : " + operationName : "Result returned from call to " + serviceName + " : " + operationName + " -- " + ret.toString());
        }
        catch (MalformedURLException e) {
            System.out.println("Error invoking service : " + e);
        }
        catch (ServiceException e2) {
            System.out.println("Error invoking service : " + (Object)((Object)e2));
        }
        catch (RemoteException e3) {
            if (e3.getMessage().contains("No deserializer for {http://www.w3.org/2001/XMLSchema}anyType")) {
                System.out.println("Web service call returned with complex array ");
            }
            System.out.println("Call return with : " + e3);
        }
    }

    private SOAPHeaderElement setSoapHeader(String token) {
        SOAPHeaderElement hdrElement = new SOAPHeaderElement("http://ep.cisco.dcbu.cisco.com", "token");
        hdrElement.setPrefix("m");
        hdrElement.setMustUnderstand(false);
        hdrElement.setValue(token);
        return hdrElement;
    }
}

