/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.admin;

import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.DbRowDOComparator;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.sm.common.dto.SessionDetails;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.PortLogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.security.FMUserFailedAttempts;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.security.UserManager;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.smis.SMISServerImpl;
import java.io.File;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdminServiceHandler {
    private static AdminServiceHandler _Instance = null;
    public static final String EMAIL = "E-Mail";
    public static final String TRAP = "Trap";
    public static final int SNMPTRAP = 1;
    public static final int SYSLOG = 2;
    public static final int EVENT = 4;
    public static final int TRAP_FORWARD = 1;
    public static final int EMAIL_FORWARD = 2;
    private Logger _Logger = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    static final String DataBase = "Database Server";
    static final String SearchIndex = "Search Indexer";
    static final String PM = "Performance Collector";
    static final String SMIS = " SMI-S Agent";
    static final String[] NAMES = new String[]{"Database Server", "Performance Collector", "Search Indexer", " SMI-S Agent"};
    static final String queryEventForward4Fabric = "SELECT EF.ID,EF.TYPE,EF.ADDRESS,AG.NAME,FABRIC.NAME,EF.VSAN_SCOPE,EF.SEVERITY,FABRIC.FID,EF.EVENTTYPE,EF.SUBTYPE,EF.FACILITY,EF.SYSTYPE, EF.desRegx, EF.ISLAN FROM EVENT_FORWARD EF left join FABRIC on EF.FID = FABRIC.FID left join APP_GROUPS AG on EF.PGID=AG.ID where EF.ISLAN=0 UNION SELECT EF.ID,EF.TYPE,EF.ADDRESS,'',NAV_GROUPS.NAME,EF.VSAN_SCOPE,EF.SEVERITY,NAV_GROUPS.ID,EF.EVENTTYPE,EF.SUBTYPE,EF.FACILITY,EF.SYSTYPE, EF.desRegx, EF.ISLAN FROM EVENT_FORWARD EF, NAV_GROUPS WHERE (EF.GID = NAV_GROUPS.ID) AND ( EF.ISLAN > 0 )";

    public static AdminServiceHandler getInstance() {
        if (_Instance == null) {
            _Instance = new AdminServiceHandler();
        }
        return _Instance;
    }

    AdminServiceHandler() {
        this._Name2SqlHash.put("serviceName", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("ServiceName", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("host", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("Host", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("status", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("Status", " ORDER BY ENC.NAME ");
    }

    public String[][] getPmInfo() throws Exception {
        return FMServerImpl.getInstance().getClusterProcessor().getPMInfo();
    }

    public String startAdminService(DbFilterDO dbFilter, String serverIp, String service) {
        try {
            if (service.equals(SearchIndex)) {
                FMServerImpl.getInstance().getClusterProcessor().buildIndex();
            } else if (service.equals(PM)) {
                serverIp = serverIp.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost().getHostAddress() : serverIp;
                FMServerImpl.getInstance().getClusterProcessor().executePM(serverIp, 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._Logger.error((Object)ex);
        }
        return service;
    }

    public String stopAdminService(DbFilterDO dbFilter, String serverIp, String service) {
        if (!service.equals(PM)) {
            return service;
        }
        try {
            serverIp = serverIp.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost().getHostAddress() : serverIp;
            FMServerImpl.getInstance().getClusterProcessor().executePM(serverIp, 2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._Logger.error((Object)ex);
        }
        return service;
    }

    public String restartAdminService(DbFilterDO dbFilter, String service) {
        try {
            String serverIp = service.substring(service.indexOf(45) + 1);
            String string = serverIp = serverIp.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost().getHostAddress() : serverIp;
            if (service.equals(PM)) {
                FMServerImpl.getInstance().getClusterProcessor().executePM(serverIp, 3);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._Logger.error((Object)ex);
        }
        return service;
    }

    public DBEntryDO getServiceList(DbFilterDO dbFilter) {
        this._Logger.info((Object)"getServiceList...");
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
        if (sortSqlSuffix == null) {
            sortSqlSuffix = "";
        }
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"Service", "Host", "Status"});
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        String indexFileName = ClientCache.getInstallLocation() + File.separator + "db" + File.separator + "index" + File.separator + "inv";
        try {
            String[][] pmInfo = this.getPmInfo();
            int startIdx = 0;
            String dbUrl = ConnectionManager.getDbUrl();
            String symbol = "";
            if (dbUrl.indexOf("oracle") != -1) {
                symbol = "@";
                startIdx = dbUrl.indexOf(symbol) + 1;
            } else if (dbUrl.indexOf("postgres") != -1) {
                symbol = "//";
                startIdx = dbUrl.indexOf(symbol) + 2;
            }
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{NAMES[0], this.getDBHosts(startIdx, dbUrl, symbol), SQLLoader.canExecute() ? "Running" : "Down"});
            rList.add(row);
            row = new DBRowDO();
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
            String generationTime = f.format(new Date(new File(indexFileName).lastModified()));
            row.setEntry(new String[]{NAMES[2], "localhost", "Last updated: " + generationTime});
            rList.add(row);
            String localIP = InetAddress.getLocalHost().getHostAddress();
            row = new DBRowDO();
            for (int i = 0; i < pmInfo.length; ++i) {
                if (pmInfo[i] == null || pmInfo[i][0] == null || pmInfo[i][1] == null) continue;
                String host = pmInfo[i][0].equalsIgnoreCase("0.0.0.0") || pmInfo[i][0].equalsIgnoreCase("127.0.0.1") || pmInfo[i][0].equalsIgnoreCase(localIP) ? "localhost" : pmInfo[i][0];
                this._Logger.info((Object)("pm host/status: " + pmInfo[i][0] + "/" + pmInfo[i][1]));
                row = new DBRowDO();
                row.setEntry(new String[]{NAMES[1], host, pmInfo[i][1]});
                rList.add(row);
            }
            File smisdir = new File(ClientCache.getSMISHome());
            if (smisdir.exists()) {
                row = new DBRowDO();
                String smisHost = System.getProperty("server.bindaddrs");
                if (smisHost == null) {
                    smisHost = "localhost";
                }
                row.setEntry(new String[]{NAMES[3], smisHost, SMISServerImpl.isSmisRunning((String)smisHost) ? "Running" : "Stopped"});
                rList.add(row);
            }
        }
        catch (Exception ex) {
            this._Logger.error((Object)ex);
        }
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    public DBEntryDO getEventStatusList() {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"fmServer", "trapServer", "trapStatistics", "syslogServer", "syslogStatistics"});
        try {
            List<String> allServerNodes = ClusterProcessor.getInstance().getAllServerNodes();
            for (String serverIp : allServerNodes) {
                EMRif em = ClusterProcessor.getInstance().getEMByServerIp(serverIp);
                if (em == null) continue;
                DBRowDO row = new DBRowDO();
                InetAddress trapServer = em.getTrapRegAddress();
                InetAddress syslogServer = em.getSyslogAddress();
                StringBuffer sb = new StringBuffer("");
                String trapStatistics = "";
                if (trapServer != null) {
                    sb.append(trapServer.getHostAddress());
                    sb.append(':');
                    sb.append(em.getTrapPort());
                    trapStatistics = em.getTrapStatistics();
                }
                String trapServerPort = sb.toString();
                String syslogStatistics = "";
                sb = new StringBuffer("");
                if (syslogServer != null) {
                    sb.append(syslogServer.getHostAddress());
                    sb.append(':');
                    sb.append(em.getSyslogPort());
                    syslogStatistics = em.getSyslogStatistics();
                }
                String syslogServerPort = sb.toString();
                String serverIpString = allServerNodes.size() > 1 ? serverIp : "-";
                row.setEntry(new String[]{serverIpString, trapServerPort, trapStatistics, syslogServerPort, syslogStatistics});
                rList.add(row);
            }
        }
        catch (Exception e) {
            this._Logger.warn((Object)"DbInventoryWS caught exception in getEventStatusList():", (Throwable)e);
            return new DBEntryDO(1, "Cannot get Event Registration.");
        }
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    public DBEntryDO getEventSourceList() throws SanServiceException {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"fmServer", "fabric", "switch", "host", "receivedTrap", "receivedSyslog", "isDelayLinkEnabled"});
        boolean isFederation = false;
        try {
            List<String> allServerNodes = ClusterProcessor.getInstance().getAllServerNodes();
            isFederation = allServerNodes != null && allServerNodes.size() > 1;
        }
        catch (Exception ex) {
            // empty catch block
        }
        List<FabricPK> fabrics = GlobalFabricManager.getInstance().getAllFabricPKs();
        try {
            for (int i = 0; i < fabrics.size(); ++i) {
                FabricPK fpk = fabrics.get(i);
                EMRif em = null;
                FabricPK pk = new FabricPK(fpk.get_fid());
                em = ClusterProcessor.getInstance().getEMByPK(pk);
                if (em == null) continue;
                String serverIp = ClusterProcessor.getInstance().getServerIpByPK(fpk);
                String fabricIp = fpk.getName();
                InetAddress seedSwIp = GlobalFabricManager.getInstance().getSeedSwitchAddress(pk);
                if (seedSwIp == null) continue;
                String seed = InetAddress.getByAddress(seedSwIp.getAddress()).getHostAddress();
                Object[][] status = em.getSourceState(seed);
                if (status != null) {
                    for (int k = 0; k < status.length; ++k) {
                        InetAddress device = (InetAddress)status[k][0];
                        if (device == null) continue;
                        Boolean receivedTrap = (Boolean)status[k][1];
                        Boolean receivedSyslog = (Boolean)status[k][2];
                        String sysName = (String)status[k][3];
                        Boolean delayLinkEnabled = (Boolean)status[k][4];
                        Boolean receivedSysAccting = (Boolean)status[k][5];
                        DBRowDO row = new DBRowDO();
                        String isTrap = receivedTrap == null || receivedTrap == false ? "No" : "Yes";
                        String isSyslog = receivedSyslog == null || receivedSyslog == false ? "No" : "Yes";
                        String isDelayLinkEnabled = delayLinkEnabled == null || delayLinkEnabled == false ? "No" : "Yes";
                        String isSyslogAccting = receivedSysAccting == null || receivedSysAccting == false ? "No" : "Yes";
                        String serverIpString = isFederation ? serverIp : "-";
                        row.setEntry(new String[]{serverIpString, fabricIp, InetAddress.getByAddress(device.getAddress()).getHostAddress(), isTrap, isSyslog, sysName, isDelayLinkEnabled, isSyslogAccting});
                        rList.add(row);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this._Logger.warn((Object)"DbInventoryWS caught exception in getEvenSourceList():", (Throwable)e);
            throw new SanServiceException("Cannot get event registration sources", (Throwable)e);
        }
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getForwarders() {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"Id", "Type", "Address", "PortGroup", "fabric", "VsanScope", "Severity", "StrType", "StrSeveirty", "facility", "syslogtype", "isDCNM", "ISLAN"});
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryEventForward4Fabric);
            rs = stat.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                int method = rs.getInt(2);
                String address = rs.getString(3);
                String portGroup = rs.getString(4);
                String fabric = rs.getString(5);
                String vsanScope = rs.getString(6);
                int severity = rs.getInt(7);
                long fid = rs.getLong(8);
                String methodType = method == 2 ? EMAIL : TRAP;
                String strSeverity = Severity.valueOf(severity).toString();
                String eventType = LogEventType.toString(rs.getInt(9));
                String isDCNM = rs.getInt(9) == -1 ? "false" : "true";
                String eventSubType = PortLogEventType.toString(rs.getInt(10));
                String facility = rs.getString(11);
                String syslogType = rs.getString(12);
                String descRegex = rs.getString(13);
                String isLAN = rs.getInt(14) == 0 ? "false" : "true";
                DBRowDO row = new DBRowDO();
                row.setEntry(new String[]{Long.toString(id), address, portGroup, fabric, vsanScope, methodType, strSeverity, Long.toString(fid), eventType, eventSubType, facility, syslogType, isDCNM, isLAN, descRegex});
                rList.add(row);
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            dto.setRow(rList.toArray(new DBRowDO[0]));
        }
        catch (SQLException ex) {
            DBEntryDO dBEntryDO;
            try {
                this._Logger.warn((Object)"AdminServiceHandler caught exception in getForwarder():", (Throwable)ex);
                dBEntryDO = new DBEntryDO(1, "Cannot get Forwarders.");
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(rs);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stat);
            DbUtil.close(rs);
            DbUtil.close(con);
            return dBEntryDO;
        }
        DbUtil.close(stat);
        DbUtil.close(rs);
        DbUtil.close(con);
        return dto;
    }

    private String getDBHosts(int startIdx, String dbUrl, String symbol) {
        int idx = dbUrl.indexOf(":", dbUrl.indexOf(symbol));
        if (idx != -1) {
            return dbUrl.substring(startIdx, dbUrl.indexOf(":", idx));
        }
        StringBuffer sb = new StringBuffer();
        int hostIdx = dbUrl.indexOf("host=");
        while (hostIdx != -1) {
            sb.append(dbUrl.substring(hostIdx + 5, dbUrl.indexOf(")", hostIdx)));
            sb.append("\n");
            hostIdx = dbUrl.indexOf("host=", hostIdx + 5);
        }
        return sb.toString();
    }

    public DBEntryDO getClientList(DbFilterDO dbFilter) {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"SessionId", "User", "IpAddress", "Role", "Server", "Login", "LastAccess"});
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        try {
            List<FMServerRif> servers = FMServerImpl.getInstance().getClusterProcessor().getFMServers();
            for (FMServerRif fmserver : servers) {
                String serverIp = fmserver.getCurrentServerIP();
                List<SessionRif> sessions = fmserver.getSessions();
                for (int i = 0; i < sessions.size(); ++i) {
                    SessionDetails details = sessions.get(i).getDetails();
                    DBRowDO row = new DBRowDO();
                    row.setEntry(new String[]{Integer.toString(details._sessionId), details._user, details._client, details._roleName, serverIp, SnmpTimeticks.getDateFormat().format(new Date(details._loginTime)), SnmpTimeticks.getDateFormat().format(new Date(details._lastAccessTime))});
                    rlist.add(row);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._Logger.error((Object)ex);
            return new DBEntryDO(1, "Cannot get client: " + ex);
        }
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getCommunityList(DbFilterDO dbFilter) {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"id", "ipAddress", "Read", "Write"});
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        if (!SQLLoader.canExecute()) {
            return dto;
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = SQLLoader.getSql("CommunitiesAction.ALL_COMMUNITIES");
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                long comId = rs.getLong(1);
                String comAddress = rs.getString(2);
                String commRead = rs.getString(3);
                String commWrite = rs.getString(4);
                DBRowDO row = new DBRowDO();
                row.setEntry(new String[]{Long.toString(comId), comAddress, commRead, commWrite});
                rlist.add(row);
            }
        }
        catch (SQLException ex) {
            DBEntryDO dBEntryDO;
            try {
                dBEntryDO = new DBEntryDO(1, "Cannot get community: " + ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            return dBEntryDO;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        Collections.sort(rlist, new DbRowDOComparator(1));
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    public DBEntryDO getLocalUserList(DbFilterDO dbFilter) {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"userName", "Role", "failedAttempts"});
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        UserManager.getInstance();
        ArrayList users = UserManager.getAllDBUsers();
        if (users == null) {
            return dto;
        }
        try {
            for (int i = 0; i < users.size(); ++i) {
                DBRowDO row = new DBRowDO();
                boolean lockOutEnabled = FMUserFailedAttempts.getInstance().isUserLockoutEnabled();
                int failedAttempt = FMUserFailedAttempts.getInstance().getUserFailedAttempts(((FMUserBase)users.get(i)).getUsername());
                row.setEntry(new String[]{((FMUserBase)users.get(i)).getUsername(), ((FMUserBase)users.get(i)).getRole(), lockOutEnabled ? Integer.toString(failedAttempt) : "N/A"});
                rlist.add(row);
            }
        }
        catch (Exception ex) {
            return new DBEntryDO(1, "Cannot get Users: " + ex);
        }
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    public DBEntryDO getRoles(DbFilterDO dbFilter) {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"role", "access"});
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        try {
            ArrayList<String> roles = UserManager.getAllRoles();
            if (roles == null) {
                return dto;
            }
            for (int i = 0; i < roles.size(); ++i) {
                UserManager.getInstance();
                ArrayList<FabricPK> fabrics = UserManager.getFabricsFromRole(roles.get(i));
                StringBuffer access = new StringBuffer();
                if (fabrics != null) {
                    for (int j = 0; j < fabrics.size(); ++j) {
                        if (j > 0) {
                            access.append(", ");
                        }
                        access.append(fabrics.get(j).toString());
                    }
                }
                DBRowDO row = new DBRowDO();
                row.setEntry(new String[]{roles.get(i), access.toString()});
                rlist.add(row);
            }
        }
        catch (SQLException ex) {
            return new DBEntryDO(1, "Cannot get roles: " + ex);
        }
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    public DBEntryDO getServerProperties(String[] keys) {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"key", "value", "comment"});
        ArrayList<DBRowDO> properties = new ArrayList<DBRowDO>();
        ArrayList<PropertyWrapper> nu = ServerPropertyUtil.readServerProperties();
        for (int i = 0; i < keys.length; ++i) {
            PropertyWrapper property = ServerPropertyUtil.getProperty(keys[i], nu);
            if (property == null) continue;
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{property.getKey(), property.getValue(), property.getComment() == null ? "" : property.getComment().toString()});
            properties.add(row);
        }
        dto.setRow(properties.toArray(new DBRowDO[0]));
        return dto;
    }

    public DBEntryDO getServerProperties(DbFilterDO dbFilter, boolean displayAAA) {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"key", "value", "comment"});
        ArrayList<DBRowDO> properties = new ArrayList<DBRowDO>();
        ArrayList<PropertyWrapper> nu = ServerPropertyUtil.readServerProperties();
        ArrayList<String> filterProperties = new ArrayList<String>();
        DisplayUtil.populateAAAProperties(filterProperties);
        ArrayList<PropertyWrapper> propertiesToDisplay = DisplayUtil.propertyFilter(nu, filterProperties, displayAAA);
        for (int i = 0; i < propertiesToDisplay.size(); ++i) {
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{propertiesToDisplay.get(i).getKey(), propertiesToDisplay.get(i).getValue(), propertiesToDisplay.get(i).getComment().toString()});
            properties.add(row);
        }
        dto.setRow(properties.toArray(new DBRowDO[0]));
        return dto;
    }

    public static void main(String[] args) {
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, -1L, "", "");
        DBEntryDO rstList = AdminServiceHandler.getInstance().getServiceList(dbFilter);
        String service = AdminServiceHandler.getInstance().startAdminService(dbFilter, "localhost", PM);
        service = AdminServiceHandler.getInstance().stopAdminService(dbFilter, "localhost", PM);
        boolean i = false;
    }
}

