/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.cfgdelivery;

import com.cisco.dcbu.dcm.model.cfgdelivery.ConfigDeliveryTaskDeviceDetails;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskDeviceStatus;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryJob;
import com.cisco.dcbu.sm.server.web.cfgtemplates.ConfigTemplateHandler;
import com.cisco.dcbu.sm.server.web.lan.connector.CliCommand;
import com.cisco.dcbu.sm.server.web.lan.connector.Response;
import com.cisco.dcbu.sm.server.web.lan.connector.ResponseVerifier;
import com.cisco.dcbu.sm.server.web.lan.persister.CommonSessionPersisterFactory;
import com.cisco.dcbu.sm.server.web.lan.persister.SessionPersister;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public final class ConfigDeliveryResponseVerifier
implements ResponseVerifier {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigDeliveryResponseVerifier.class);
    ConfigDeliveryJob job;
    String threadName = null;

    public ConfigDeliveryResponseVerifier(ConfigDeliveryJob job) {
        this.job = job;
        this.threadName = job.getName();
    }

    @Override
    public boolean verifyResponse(Response response) {
        if (this.isCancellingRequired()) {
            log.info((Object)(this.threadName + " Cancellation Request Received::"));
            return false;
        }
        if (response == null || response.getData() == null) {
            return false;
        }
        StringBuffer data = response.getData();
        if (data.toString().trim().length() > 0) {
            if (response.getRequest() instanceof CliCommand) {
                log.info((Object)((CliCommand)response.getRequest()).getCliCmd());
            }
            log.info((Object)data);
            if (ConfigTemplateHandler.getInstance().matchesSkipErrorPattern(data.toString())) {
                return true;
            }
        }
        try {
            if (data.toString().contains("% Site Identifier mismatch will prevent  overlays from forwarding traffic")) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean hasError = data.toString().toLowerCase().indexOf("error") != -1 || data.indexOf("%") != -1 && data.indexOf("%Warning") == -1 || data.toString().toLowerCase().indexOf("command failed") != -1 || data.toString().toLowerCase().indexOf("'^'") != -1;
        return !hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancellingRequired() {
        Long rowCount = 0L;
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openReadOnlySession();){
            String propertyName = "configDeliveryTaskDeviceStatus";
            Object restriction = this.job.shouldCancelOtherJobs() ? Restrictions.or((Criterion)Restrictions.eq((String)propertyName, (Object)ConfigDeliveryTaskDeviceStatus.CANCELED), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)propertyName, (Object)ConfigDeliveryTaskDeviceStatus.FAILED), (Criterion)Restrictions.eq((String)propertyName, (Object)ConfigDeliveryTaskDeviceStatus.FAILED_ROLLBACK))) : Restrictions.eq((String)propertyName, (Object)ConfigDeliveryTaskDeviceStatus.CANCELED);
            rowCount = (Long)session.createCriteria(ConfigDeliveryTaskDeviceDetails.class).add((Criterion)Restrictions.like((String)"instanceName", (Object)("%id=" + this.job.getTaskId() + "%"))).add((Criterion)restriction).setProjection(Projections.rowCount()).uniqueResult();
            boolean bl = rowCount != null && rowCount > 0L;
            return bl;
        }
    }
}

