/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.PerfUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class GigEStatHandler {
    private static GigEStatHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;
    private int sanDataLength;
    private int lanDataLength;

    public static GigEStatHandler getInstance() {
        if (_Instance == null) {
            _Instance = new GigEStatHandler();
        }
        return _Instance;
    }

    private GigEStatHandler() {
    }

    public String ifIndexToName(int index, int switchType) {
        if (FRUConstants.isN5K(switchType)) {
            return IfIndexUtil.ifIndexToNameForN5K(index, switchType);
        }
        switch (switchType) {
            case 601: {
                return IfIndexUtil.ifIndexToNameInagua(index);
            }
            case 606: 
            case 773: {
                return IfIndexUtil.ifIndexToNameChester(index);
            }
            case 843: {
                return IfIndexUtil.ifIndexToNameCassino(index);
            }
        }
        return IfIndexUtil.ifIndexToName(index);
    }

    public int getGigEStatDataLength(DbFilterDO dbFilter, String interval) {
        int totalLength = 0;
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("SAN")) {
            this.sanDataLength = this.getSanGigEStatDataLength(dbFilter, interval);
            totalLength += this.sanDataLength;
        }
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("LAN")) {
            this.lanDataLength = this.getLanEthernetStatDataLength(dbFilter, interval);
            totalLength += this.lanDataLength;
        }
        return totalLength;
    }

    public ArrayList<StatisticsDataDO> getGigEStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean calculateLimit) {
        ArrayList<StatisticsDataDO> records;
        String networkType = dbFilter.getNetworkType();
        ArrayList<StatisticsDataDO> totalList = new ArrayList<StatisticsDataDO>();
        int sanStartIdx = 0;
        int lanStartIdx = 0;
        int sanRecordSize = 0;
        int lanRecordSize = 0;
        if (networkType != null && networkType.equals("Data Center")) {
            if (startIdx < this.sanDataLength) {
                sanStartIdx = startIdx;
                int retrieveSize = sanStartIdx + recordSize;
                if (retrieveSize < this.sanDataLength) {
                    sanRecordSize = recordSize;
                } else {
                    sanRecordSize = this.sanDataLength - sanStartIdx;
                    lanRecordSize = recordSize - sanRecordSize;
                    lanStartIdx = 0;
                }
            } else {
                sanStartIdx = this.sanDataLength;
                sanRecordSize = 0;
                lanStartIdx = startIdx - this.sanDataLength;
                lanRecordSize = recordSize;
            }
        } else {
            sanStartIdx = lanStartIdx = startIdx;
            sanRecordSize = lanRecordSize = recordSize;
        }
        if (networkType != null && (networkType.equals("SAN") || networkType.equals("Data Center"))) {
            records = new ArrayList<StatisticsDataDO>();
            this.getSanGigEStatList(records, dbFilter, interval, sanStartIdx, sanRecordSize, false, false);
            totalList.addAll(records);
        }
        if (networkType != null && (networkType.equals("LAN") || networkType.equals("Data Center"))) {
            records = new ArrayList();
            this.getLanEthernetStatList(records, dbFilter, interval, lanStartIdx, lanRecordSize, false, networkType.equals("LAN"), false);
            totalList.addAll(records);
        }
        return totalList;
    }

    public ArrayList<StatisticsDataDO> getSanGigEStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        this.getSanGigEStatList(records, dbFilter, interval, startIdx, recordSize, false, false);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSanGigEStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean lengthOnly, boolean calculateLimit) {
        Connection con = null;
        Statement stmt = null;
        Statement stmtType = null;
        ResultSet rs = null;
        ResultSet rsType = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            String sortString = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval, false);
            int[] indices = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
            String[] columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString};
            String prefix = "PerformanceAction.";
            if (dbFilter.getFabricDbId() != -1L && dbFilter.isGroup() && dbFilter.getGroupId() != -1L) {
                String sqlType = SQLLoader.getSql(prefix + "FIND_GROUP_TYPE_STMT");
                stmtType = con.prepareStatement(sqlType);
                stmtType.setLong(1, dbFilter.getFabricDbId());
                stmtType.setLong(2, dbFilter.getGroupId());
                rsType = SQLLoader.execute((PreparedStatement)stmtType);
                rsType.next();
                int grouptype = rsType.getInt(1);
                if (grouptype == 1) {
                    sql = SQLLoader.getSql(prefix + "GIGE_FABRIC_SW_GROUP_STMT", indices, columns);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, dbFilter.getFabricDbId());
                    stmt.setLong(2, dbFilter.getGroupId());
                } else {
                    sql = SQLLoader.getSql(prefix + "GIGE_FABRIC_EP_GROUP_STMT", indices, columns);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, dbFilter.getFabricDbId());
                    stmt.setLong(2, dbFilter.getGroupId());
                }
            } else if (dbFilter.getFabricDbId() != -1L) {
                sql = SQLLoader.getSql(prefix + "GIGE_FABRIC_STMT", indices, columns);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, dbFilter.getFabricDbId());
            } else {
                String groupFabricFilterSqlSuffix;
                String roleFilter = " 1 = 1 ";
                String filterStr = groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
                int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 99, 9};
                String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString, roleFilter, filterStr};
                sql = SQLLoader.getSql(prefix + "GIGE_STMT", ind, rep);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            }
            rs = SQLLoader.execute((PreparedStatement)stmt);
            if (lengthOnly) {
                rs.last();
                int roleFilter = rs.getRow();
                return roleFilter;
            }
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                double rx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                double tx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                double maxRx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                double maxTx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                String rrd = rs.getString(12);
                String switchSysName = rs.getString(13);
                String ifName = rs.getString(14);
                String name = switchSysName + " " + ifName;
                String displayName = switchSysName + " " + ifName;
                long speed = rs.getLong(15);
                long ifIndex = rs.getLong(16);
                double rxTx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17));
                Timestamp lastUpdated = rs.getTimestamp(19);
                long switchID = rs.getLong(20);
                byte[] wwn = rs.getBytes(21);
                long fid = rs.getLong(22);
                int ifType = rs.getInt(23);
                String ifAlias = rs.getString(24);
                int operMode = -1;
                int rxUtil = -1;
                int txUtil = -1;
                int pRxUtil = -1;
                int pTxUtil = -1;
                StatisticsDataDO wrapper = new StatisticsDataDO(0L, 0L);
                wrapper.setRrdFile(rrd);
                wrapper.setInterval(interval);
                wrapper.setPmtype(6);
                wrapper.setEntityName(name);
                wrapper.setFid(fid);
                wrapper.setIfType(ifType);
                wrapper.setDesc(ifAlias);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                if (speed > 0L) {
                    rx = this.capTrafficWithSpeed(rx, speed / 8L);
                    tx = this.capTrafficWithSpeed(tx, speed / 8L);
                    maxRx = this.capTrafficWithSpeed(maxRx, speed / 8L);
                    maxTx = this.capTrafficWithSpeed(maxTx, speed / 8L);
                    rxUtil = !Double.isNaN(rx) ? (int)(rx / (double)(speed / 8L) * 100.0) : -1;
                    txUtil = !Double.isNaN(tx) ? (int)(tx / (double)(speed / 8L) * 100.0) : -1;
                    pRxUtil = !Double.isNaN(maxRx) ? (int)(maxRx / (double)(speed / 8L) * 100.0) : -1;
                    pTxUtil = !Double.isNaN(maxTx) ? (int)(maxTx / (double)(speed / 8L) * 100.0) : -1;
                }
                wrapper.setSpeed((double)speed / 8.0);
                wrapper.setTitle(displayName);
                wrapper.setFabric(fabric);
                wrapper.setSwitchDbId(switchID);
                wrapper.setIfIndex(ifIndex);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setSpeedStr(speed == 0L ? "n/a" : DisplayUtil.formatSpeed(speed));
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                int threshold = PmCollect._MetaData._thresholdDef._highWaterMark;
                wrapper.setHighThreshold(threshold);
                wrapper.setRxUtil(rxUtil);
                wrapper.setTxUtil(txUtil);
                wrapper.setpRxUtil(pRxUtil);
                wrapper.setpTxUtil(pTxUtil);
                if (calculateLimit) {
                    if (speed > 0L) {
                        double limit = speed / 8L * (long)threshold / 100L;
                        double exceedPct = PerfUtil.getExceedThresholdCoumn(rrd, 6, (int)fid, 1, limit);
                        wrapper.setExceedPct(exceedPct);
                    } else {
                        wrapper.setExceedPct(-1.0);
                    }
                }
                wrapper.setIndex(curIdx + startIdx + 1);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get GigE stat", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmtType != null) {
                    stmtType.close();
                }
                if (rsType != null) {
                    rsType.close();
                }
            }
            catch (Exception ex) {}
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLanEthernetStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean lengthOnly, boolean lanOnly, boolean calculateLimit) {
        if (recordSize == 0) {
            return 0;
        }
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String groupLanFilterSqlSuffix;
            con = ConnectionManager.getConnection();
            String sql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            String sortString = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval, true);
            String prefix = "PerformanceAction.";
            String roleFilter = " 1 = 1 ";
            String filterStr = groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
            int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 99, 9};
            String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString, roleFilter, filterStr};
            sql = SQLLoader.getSql(prefix + "GIGE_LAN_STMT", ind, rep);
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            if (lengthOnly) {
                rs.last();
                int n = rs.getRow();
                return n;
            }
            HashMap swLicMap = new HashMap();
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                double rx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                double tx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                double maxRx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                double maxTx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                String rrd = rs.getString(12);
                String switchSysName = rs.getString(13);
                String ifName = rs.getString(14);
                String name = switchSysName + " " + ifName;
                String displayName = switchSysName + " " + ifName;
                long speed = rs.getLong(15);
                long ifIndex = rs.getLong(16);
                double rxTx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17));
                Timestamp lastUpdated = rs.getTimestamp(19);
                long switchID = rs.getLong(20);
                long fid = rs.getLong(22);
                int ifType = rs.getInt(23);
                String ifAlias = rs.getString(24);
                int rxUtil = -1;
                int txUtil = -1;
                int pRxUtil = -1;
                int pTxUtil = -1;
                StatisticsDataDO wrapper = new StatisticsDataDO(0L, 0L);
                wrapper.setRrdFile(rrd);
                wrapper.setInterval(interval);
                wrapper.setPmtype(11);
                wrapper.setEntityName(name);
                wrapper.setFid(fid);
                wrapper.setIfType(ifType);
                wrapper.setDesc(ifAlias);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                if (speed > 0L) {
                    rx = this.capTrafficWithSpeed(rx, speed / 8L);
                    tx = this.capTrafficWithSpeed(tx, speed / 8L);
                    maxRx = this.capTrafficWithSpeed(maxRx, speed / 8L);
                    maxTx = this.capTrafficWithSpeed(maxTx, speed / 8L);
                    rxUtil = !Double.isNaN(rx) ? (int)(rx / (double)(speed / 8L) * 100.0) : -1;
                    txUtil = !Double.isNaN(tx) ? (int)(tx / (double)(speed / 8L) * 100.0) : -1;
                    pRxUtil = !Double.isNaN(maxRx) ? (int)(maxRx / (double)(speed / 8L) * 100.0) : -1;
                    pTxUtil = !Double.isNaN(maxTx) ? (int)(maxTx / (double)(speed / 8L) * 100.0) : -1;
                }
                wrapper.setSpeed((double)speed / 8.0);
                wrapper.setTitle(displayName);
                wrapper.setFabric(fabric);
                wrapper.setSwitchDbId(switchID);
                wrapper.setIfIndex(ifIndex);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setSpeedStr(speed == 0L ? "n/a" : DisplayUtil.formatSpeed(speed));
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                int threshold = PmCollect._MetaData._thresholdDef._highWaterMark;
                wrapper.setHighThreshold(threshold);
                wrapper.setRxUtil(rxUtil);
                wrapper.setTxUtil(txUtil);
                wrapper.setpRxUtil(pRxUtil);
                wrapper.setpTxUtil(pTxUtil);
                if (calculateLimit) {
                    if (speed > 0L) {
                        double limit = speed / 8L * (long)threshold / 100L;
                        double exceedPct = PerfUtil.getExceedThresholdCoumn(rrd, 11, (int)fid, 1, limit);
                        wrapper.setExceedPct(exceedPct);
                    } else {
                        wrapper.setExceedPct(-1.0);
                    }
                }
                wrapper.setIndex(curIdx + startIdx + 1 + (lanOnly ? 0 : this.sanDataLength));
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get Lan Ethernet stat", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
        }
        return 0;
    }

    public int getLanEthernetStatDataLength(DbFilterDO dbFilter, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getLanEthernetStatList(records, dbFilter, interval, 0, 1, true, true, false);
    }

    public int getSanGigEStatDataLength(DbFilterDO dbFilter, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getSanGigEStatList(records, dbFilter, interval, 0, 1, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StatisticsDataDO> getFcipStats(long switchDbId, int ifIndex, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = null;
            String prefix = "PerformanceAction.";
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            int[] indices = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
            String[] columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, totalCol};
            String roleFilter = " 1 = 1 ";
            int[] ind = new int[]{99};
            String[] rep = new String[]{roleFilter};
            sql = SQLLoader.getSql(prefix + "GIGE_FCIP_STMT", ind, rep);
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.setInt(1, ifIndex);
            stmt.setLong(2, switchDbId);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            double totalRx = 0.0;
            double totalTx = 0.0;
            double totalMaxRx = 0.0;
            double totalMaxTx = 0.0;
            double totalErrors = 0.0;
            double totalDiscards = 0.0;
            double totalRxTx = 0.0;
            long totalSpeed = 0L;
            boolean islExist = false;
            int idx = 1;
            while (rs.next()) {
                String name;
                String fabric = rs.getString(1);
                long fabricID = rs.getLong(2);
                long speed = rs.getLong(3);
                double rx = -1.0;
                double tx = -1.0;
                double maxRx = -1.0;
                double maxTx = -1.0;
                double errors = -1.0;
                double discards = -1.0;
                double rxTx = -1.0;
                String displayName = name = rs.getString(6);
                String xml = null;
                String rrd = null;
                long src_isl_port_id = rs.getLong(4);
                long dst_isl_port_id = rs.getLong(5);
                Timestamp lastUpdated = rs.getTimestamp(7);
                long fid = rs.getLong(8);
                sql = SQLLoader.getSql(prefix + "GIGE_FCIP_STAT_STMT", indices, columns);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, src_isl_port_id);
                stmt.setLong(2, dst_isl_port_id);
                stmt.setLong(3, fabricID);
                rs = SQLLoader.execute((PreparedStatement)stmt);
                if (rs.next()) {
                    islExist = true;
                    rx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 1));
                    tx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 2));
                    maxRx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 3));
                    maxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                    errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                    discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                    rxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                    xml = rs.getString(8);
                    rrd = rs.getString(9);
                    String src = rs.getString(10);
                    String dst = rs.getString(11);
                    int switchType1 = rs.getInt(14);
                    int switchType2 = rs.getInt(15);
                    int index1 = Integer.parseInt(src.substring(src.lastIndexOf(58) + 1).trim());
                    src = src.substring(0, src.lastIndexOf(58)) + " " + DisplayUtil.ifIndexToName(index1, switchType1);
                    int index2 = Integer.parseInt(dst.substring(dst.lastIndexOf(58) + 1).trim());
                    dst = dst.substring(0, dst.lastIndexOf(58)) + " " + DisplayUtil.ifIndexToName(index2, switchType2);
                    if (src != null) {
                        name = dst != null ? src + "<->" + dst : src;
                    }
                    displayName = name;
                    lastUpdated = rs.getTimestamp(13);
                }
                StatisticsDataDO wrapper = new StatisticsDataDO(0L, 0L);
                wrapper.setRrdFile(rrd);
                wrapper.setInterval(interval);
                wrapper.setPmtype(1);
                wrapper.setEntityName(name);
                wrapper.setFid(fid);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                wrapper.setSpeed((double)speed / 8.0);
                wrapper.setTitle(displayName);
                wrapper.setFabric(fabric);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setSpeedStr(speed == 0L ? "n/a" : DisplayUtil.formatSpeed(speed));
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                totalSpeed += speed;
                totalRx += rx == -1.0 ? 0.0 : rx;
                totalTx += tx == -1.0 ? 0.0 : tx;
                totalMaxRx += maxRx == -1.0 ? 0.0 : maxRx;
                totalMaxTx += maxTx == -1.0 ? 0.0 : maxTx;
                totalErrors += errors == -1.0 ? 0.0 : errors;
                totalDiscards += discards == -1.0 ? 0.0 : discards;
                totalRxTx += rxTx == -1.0 ? 0.0 : rxTx;
                wrapper.setIndex(idx++);
                records.add(wrapper);
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get GigE stat", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StatisticsDataDO> getTopLanEthernetStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean calculateLimit) {
        ArrayList<StatisticsDataDO> totalList = new ArrayList<StatisticsDataDO>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String groupLanFilterSqlSuffix;
            con = ConnectionManager.getConnection();
            String sql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            String sortString = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval, true);
            String prefix = "PerformanceAction.";
            String roleFilter = " 1 = 1 ";
            String filterStr = groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
            int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 99, 9};
            String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString, roleFilter, filterStr};
            sql = SQLLoader.getSql(prefix + "GIGE_LAN_STMT", ind, rep);
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            HashMap swLicMap = new HashMap();
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                double rx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                double tx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                double maxRx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                double maxTx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                String rrd = rs.getString(12);
                String switchSysName = rs.getString(13);
                String ifName = rs.getString(14);
                String name = switchSysName + " " + ifName;
                String displayName = switchSysName + " " + ifName;
                long speed = rs.getLong(15);
                long ifIndex = rs.getLong(16);
                double rxTx = DisplayUtil.formatEthPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17));
                Timestamp lastUpdated = rs.getTimestamp(19);
                long switchID = rs.getLong(20);
                long fid = rs.getLong(22);
                int ifType = rs.getInt(23);
                String ifAlias = rs.getString(24);
                int rxUtil = -1;
                int txUtil = -1;
                int pRxUtil = -1;
                int pTxUtil = -1;
                if (ifName.startsWith("Vlan")) continue;
                StatisticsDataDO wrapper = new StatisticsDataDO(0L, 0L);
                wrapper.setRrdFile(rrd);
                wrapper.setInterval(interval);
                wrapper.setPmtype(11);
                wrapper.setEntityName(name);
                wrapper.setFid(fid);
                wrapper.setIfType(ifType);
                wrapper.setDesc(ifAlias);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                if (speed > 0L) {
                    rx = this.capTrafficWithSpeed(rx, speed / 8L);
                    tx = this.capTrafficWithSpeed(tx, speed / 8L);
                    maxRx = this.capTrafficWithSpeed(maxRx, speed / 8L);
                    maxTx = this.capTrafficWithSpeed(maxTx, speed / 8L);
                    rxUtil = !Double.isNaN(rx) ? (int)(rx / (double)(speed / 8L) * 100.0) : -1;
                    txUtil = !Double.isNaN(tx) ? (int)(tx / (double)(speed / 8L) * 100.0) : -1;
                    pRxUtil = !Double.isNaN(maxRx) ? (int)(maxRx / (double)(speed / 8L) * 100.0) : -1;
                    pTxUtil = !Double.isNaN(maxTx) ? (int)(maxTx / (double)(speed / 8L) * 100.0) : -1;
                }
                wrapper.setSpeed((double)speed / 8.0);
                wrapper.setTitle(displayName);
                wrapper.setFabric(fabric);
                wrapper.setSwitchDbId(switchID);
                wrapper.setIfIndex(ifIndex);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setSpeedStr(speed == 0L ? "n/a" : DisplayUtil.formatSpeed(speed));
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                int threshold = PmCollect._MetaData._thresholdDef._highWaterMark;
                wrapper.setHighThreshold(threshold);
                wrapper.setRxUtil(rxUtil);
                wrapper.setTxUtil(txUtil);
                wrapper.setpRxUtil(pRxUtil);
                wrapper.setpTxUtil(pTxUtil);
                if (calculateLimit) {
                    if (speed > 0L) {
                        double limit = speed / 8L * (long)threshold / 100L;
                        double exceedPct = PerfUtil.getExceedThresholdCoumn(rrd, 11, (int)fid, 1, limit);
                        wrapper.setExceedPct(exceedPct);
                    } else {
                        wrapper.setExceedPct(-1.0);
                    }
                }
                wrapper.setIndex(curIdx + 1);
                totalList.add(wrapper);
                if (++curIdx < recordSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get getTopLanEthernetStatList", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
        }
        return totalList;
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    private double capTrafficWithSpeed(double traffic, long speed) {
        double ret = traffic;
        if (traffic > (double)speed) {
            ret = speed;
        }
        return ret;
    }

    private String getSqlSortSuffix(String sortField, String sortType, String interval, boolean isLan) {
        StringBuilder sortStr = new StringBuilder();
        if (sortField.equals("avgRxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getAvgIntervalColumn(interval) + "RX"));
        } else if (sortField.equals("avgTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getAvgIntervalColumn(interval) + "TX"));
        } else if (sortField.equals("maxRxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getMaxIntervalColumn(interval) + "RX"));
        } else if (sortField.equals("maxTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getMaxIntervalColumn(interval) + "TX"));
        } else if (sortField.equals("errorStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getErrorIntervalColumn(interval)));
        } else if (sortField.equals("discardStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getDiscardIntervalColumn(interval)));
        } else if (sortField.equals("rxTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getTotalIntervalColumn(interval)));
        } else if (sortField.equals("speedStr")) {
            sortStr.append("SP.IF_SPEED");
        } else if (sortField.equals("entityName")) {
            if (!isLan) {
                sortStr.append("SWITCH.SYS_NAME " + sortType + ", SP.IF_NAME");
            } else {
                sortStr.append("ETHSWITCH.SYS_NAME " + sortType + ", SP.IF_NAME");
            }
        } else if (sortField.equals("rxUtil")) {
            sortStr.append("RX_UTIL");
        } else if (sortField.equals("txUtil")) {
            sortStr.append("TX_UTIL");
        } else if (sortField.equals("pRxUtil")) {
            sortStr.append("PEAK_RX_UTIL");
        } else if (sortField.equals("pTxUtil")) {
            sortStr.append("PEAK_TX_UTIL");
        } else {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getTotalIntervalColumn(interval)));
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        sortStr.append(" ").append(sortType);
        return sortStr.toString();
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        int length = GigEStatHandler.getInstance().getGigEStatDataLength(dbFilter, "24 Hours");
        System.out.println("length is :" + length);
        ArrayList<StatisticsDataDO> rstList = GigEStatHandler.getInstance().getGigEStatList(dbFilter, "24 Hours", 0, 31, false);
        int count = 0;
        for (StatisticsDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getTitle() + " : " + e.getLastUpdateTimeStr());
        }
        boolean i = false;
    }

    public String printGigEStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = GigEStatHandler.getInstance().getGigEStatList(dbFilter, interval, startIdx, recordSize, false);
        String title = "Performance Ethernet";
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Speed", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg.", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg%", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak%", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxUtil", "rxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "txUtil", "txUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pRxUtil", "pRxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pTxUtil", "pTxUtilStr");
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, columnAlignment, rstList);
    }

    public String exportGigEStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = GigEStatHandler.getInstance().getGigEStatList(dbFilter, interval, startIdx, recordSize, false);
        String title = "Performance Ethernet";
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Speed", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg.", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg%", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak%", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxUtil", "rxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "txUtil", "txUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pRxUtil", "pRxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pTxUtil", "pTxUtilStr");
        boolean unitlessFlag = true;
        String export_unitless = System.getProperties().getProperty("export.unitless");
        if (export_unitless != null) {
            unitlessFlag = Boolean.getBoolean("export.unitless");
        }
        String export_unit = System.getProperties().getProperty("export.unit");
        if (unitlessFlag) {
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "speedStr", "speed");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgRxStr", "lastDayAvgRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgTxStr", "lastDayAvgTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxTxStr", "rxTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxRxStr", "lastDayMaxRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxTxStr", "lastDayMaxTx");
        } else if (export_unit != null) {
            DisplayUtil.convertGigEToExportUnit(rstList, export_unit);
        }
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, columnAlignment, rstList);
    }
}

