/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LicenseHandler {
    private static LicenseHandler _Instance = null;
    private Logger _Logger = Logger.getLogger((String)"fms");
    public static int DAYS_120_SEC = 10368000;
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();

    public static LicenseHandler getInstance() {
        if (_Instance == null) {
            _Instance = new LicenseHandler();
        }
        return _Instance;
    }

    LicenseHandler() {
        this._Name2SqlHash.put("sw", " ORDER BY SYS_NAME ");
        this._Name2SqlHash.put("feature", " ORDER BY  FEATURE_NAME");
        this._Name2SqlHash.put("name", " ORDER BY  NAME");
    }

    public DBEntryDO getList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws Exception {
        return this.getList(dbFilter, startIdx, recordSize, status);
    }

    public DBEntryDO getList(DbFilterDO dbFilter) throws Exception {
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String groupLanFilterSQLSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        if (sortSqlSuffix == null) {
            sortSqlSuffix = "";
        }
        DBEntryDO rstList = this.getList(-1L, -1L, -1L, dbFilter, false, 0, 31, "All", sortSqlSuffix, groupFabricFilterSqlSuffix, groupLanFilterSQLSuffix);
        return rstList;
    }

    public DBEntryDO getList(DbFilterDO dbFilter, int startIdx, int recordSize, String statusFilter) throws Exception {
        boolean isGroup = dbFilter.isGroup();
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        long groupDbId = dbFilter.getGroupId();
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        if (sortSqlSuffix == null) {
            sortSqlSuffix = "";
        }
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String groupLanFilterSQLSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        return this.getList(vsanDbId, fabricDbId, groupDbId, dbFilter, isGroup, startIdx, recordSize, statusFilter, sortSqlSuffix, groupFabricFilterSqlSuffix, groupLanFilterSQLSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getList(long vsanDbId, long fabricDbId, long groupDbId, DbFilterDO dbFilter, boolean isGroup, int startIdx, int recordSize, String statusFilter, String sortSqlSuffix, String sanFilterSuffix, String lanFilterSuffix) throws Exception {
        DBEntryDO dto;
        block36: {
            dto = new DBEntryDO();
            dto.setColumn(new String[]{"Index", "Network", "Group", "Switch", "Feature", "Status", "Type", "Warnings", "SwitchID", "isLAN"});
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
            long switchDbId = dbFilter.getSwitchDbId();
            String networkType = dbFilter.getNetworkType();
            try {
                con = ConnectionManager.getConnection();
                if (vsanDbId > 0L) {
                    sql = SQLLoader.getSql("LicenseAction.VSAN_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                    stmt.setLong(1, vsanDbId);
                } else if (fabricDbId >= 0L) {
                    if (isGroup) {
                        sql = SQLLoader.getSql("LicenseAction.GROUP_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                        stmt.setLong(1, fabricDbId);
                    } else {
                        sql = SQLLoader.getSql("LicenseAction.FABRIC_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                        stmt.setLong(1, fabricDbId);
                    }
                } else if ("LAN".equals(networkType)) {
                    sql = SQLLoader.getSql("LicenseAction.LAN_STMT");
                    if (switchDbId >= 0L) {
                        sql = sql + "AND ETHSWITCH.ID = " + switchDbId;
                    }
                    if (sortSqlSuffix == null) {
                        sortSqlSuffix = "";
                    }
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                } else if (switchDbId >= 0L) {
                    sql = SQLLoader.getSql("LicenseAction.ALL_STMT");
                    sql = sql + "AND SWITCH.ID = " + switchDbId;
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                } else {
                    if (sortSqlSuffix == null) {
                        sortSqlSuffix = "";
                    }
                    String sqlSAN = SQLLoader.getSql("LicenseAction.SAN_STMT") + sanFilterSuffix;
                    String sqlLAN = SQLLoader.getSql("LicenseAction.LAN_STMT") + lanFilterSuffix;
                    sql = "(" + sqlSAN + ") UNION (" + sqlLAN + ") " + sortSqlSuffix;
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                }
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                boolean getAllForWarning = false;
                while (rs.next()) {
                    String status;
                    String fabric = rs.getString(1);
                    String sw = rs.getString(2);
                    String feature = rs.getString(3);
                    int type = rs.getInt(4);
                    byte[] flag = rs.getBytes(5);
                    int max = rs.getInt(6);
                    int missing = rs.getInt(7);
                    int current = rs.getInt(8);
                    long expire = rs.getLong(9);
                    int grace = rs.getInt(10);
                    Timestamp scanTime = rs.getTimestamp(11);
                    long switchId = rs.getLong(12);
                    int isLan = rs.getInt(13);
                    byte[] exp = null;
                    if (expire != -1L) {
                        Calendar cal = GregorianCalendar.getInstance();
                        cal.setTimeInMillis(expire);
                        exp = SnmpDateAndTime.toBytes(cal);
                    }
                    LicenseInfo info = new LicenseInfo(null, flag[0], current, max, missing, exp, grace);
                    DBRowDO row = new DBRowDO();
                    StringBuilder strError = new StringBuilder();
                    StringBuffer strType = new StringBuffer();
                    if (info.isDemo()) {
                        strType.append("Demo License ");
                        if (info.getExpDate() != null) {
                            strError.append("Expires on ").append(SnmpTimeticks.getDateFormat().format(info.getExpDate().getTime()));
                        } else {
                            strError.append("Expired");
                        }
                    }
                    if (info.isPermanent()) {
                        strType.append("Permanent License ");
                    }
                    if ((flag[0] & 0x10) != 0) {
                        strType.append("Unlicensed ");
                    }
                    if ((flag[0] & 8) != 0) {
                        int left;
                        if (grace == 0 || (left = grace - (int)(System.currentTimeMillis() - scanTime.getTime()) / 1000) <= 0) {
                            grace = 0;
                            strError.append("Grace Period Expired");
                        } else {
                            if (current == 0) {
                                left = grace;
                            }
                            if (grace < DAYS_120_SEC) {
                                strError.append("Grace Period: ");
                                int secs = left % 60;
                                int mins = left / 60;
                                int hours = mins / 60;
                                int days = hours / 24;
                                strError.append(days > 0 ? days + " days " : "").append(hours > 0 ? (hours %= 24) + " hours " : "").append(mins > 0 ? (mins %= 60) + " mins " : "").append(secs > 0 ? secs + " seconds " : "");
                            }
                        }
                    }
                    if (missing > 0) {
                        strError.append(strError.toString().trim().length() > 0 ? ", " + missing + " License(s) Missing" : missing + " License(s) Missing");
                    }
                    String network = "LAN";
                    String index = curIdx + startIdx + 1 + "";
                    String string = status = current == 0 ? "Unused" : "In Use";
                    if (feature.equalsIgnoreCase("FM_SERVER_PKG") && info.isPermanent() && current == 0) {
                        status = "";
                    }
                    row.setEntry(new String[]{index, network, fabric, sw, feature, status, strType.toString(), strError.toString(), switchId + "", isLan + ""});
                    if (statusFilter != null && statusFilter.trim().equalsIgnoreCase("warning")) {
                        if (!strError.toString().trim().equals("")) {
                            rList.add(row);
                            ++curIdx;
                            getAllForWarning = true;
                        }
                    } else {
                        rList.add(row);
                        ++curIdx;
                    }
                    if (getAllForWarning || recordSize <= 0 || curIdx <= 0 || curIdx < recordSize) continue;
                    break;
                }
                dto.setRow(rList.toArray(new DBRowDO[0]));
                ConnectionManager.returnConnection(con);
            }
            catch (SQLException ex) {
                this._Logger.error((Object)ex);
                break block36;
            }
            finally {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        return dto;
    }

    public int getDataLength(DbFilterDO dbFilter, String statusFilter) throws Exception {
        int recordSize = -1;
        DBEntryDO result = this.getList(dbFilter, 0, recordSize, statusFilter);
        return result.getRowSize();
    }

    private String getSortStmt(DbFilterDO dbFilter) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField());
        if (sortSqlSuffix != null) {
            sortSqlSuffix = sortSqlSuffix + " " + dbFilter.getSortType();
        }
        return sortSqlSuffix;
    }

    public static Wwn getWwn(byte[] w) {
        if (w != null) {
            return new Wwn(w);
        }
        return null;
    }

    public String printLicenseTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        DBEntryDO dbEntryDO = this.getList(dbFilter, startIdx, recordSize, status);
        return JasperPrintGenerator.getInstance().generatePrintReport("Licenses", columnHeader, dbEntryDO);
    }

    public String exportLicenseTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        DBEntryDO dbEntryDO = this.getList(dbFilter, startIdx, recordSize, status);
        return JasperPrintGenerator.getInstance().generateExcelReport("Licenses", columnHeader, dbEntryDO);
    }
}

