/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.PerfUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SwitchBandwidthHandler {
    private static SwitchBandwidthHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;

    public static SwitchBandwidthHandler getInstance() {
        if (_Instance == null) {
            _Instance = new SwitchBandwidthHandler();
        }
        return _Instance;
    }

    private SwitchBandwidthHandler() {
    }

    public ArrayList<StatisticsDataDO> getSwitchBandwidthStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        this.getSwitchBandwidthStatList(records, dbFilter, interval, startIdx, recordSize, false);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSwitchBandwidthStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean lengthOnly) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            String sortString = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval);
            int[] indices = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
            String[] columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString};
            String prefix = "PerformanceAction.";
            if (dbFilter.getFabricDbId() != -1L) {
                sql = SQLLoader.getSql(prefix + "SWITCH_BANDWIDTH_FABRIC_STMT", indices, columns);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, dbFilter.getFabricDbId());
            } else {
                String groupFabricFilterSqlSuffix;
                String filterStr = groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
                int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
                String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString, filterStr};
                sql = SQLLoader.getSql(prefix + "SWITCH_BANDWIDTH_STMT", ind, rep);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            }
            int operMode = -1;
            rs = SQLLoader.execute((PreparedStatement)stmt);
            if (lengthOnly) {
                rs.last();
                int filterStr = rs.getRow();
                return filterStr;
            }
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                long swId = rs.getLong(2);
                double rx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                double tx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                double maxRx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                double maxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                String sw_sys_name = rs.getString(10);
                double rxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 13));
                int stat_type = rs.getInt(14);
                int vsanId = rs.getInt(11);
                Timestamp lastUpdated = rs.getTimestamp(15);
                byte[] wwn = rs.getBytes(16);
                boolean utzn = false;
                StatisticsDataDO wrapper = null;
                wrapper = new StatisticsDataDO(0L, 0L);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                wrapper.setEntityName(sw_sys_name);
                wrapper.setTitle(sw_sys_name);
                wrapper.setFabric(fabric);
                wrapper.setSwitchDbId(swId);
                wrapper.setPmtype(stat_type);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                if (vsanId != 0) {
                    ArrayList<String> l1 = new ArrayList<String>();
                    l1.add(vsanId + (operMode == 12 ? " (Trunked)" : ""));
                }
                wrapper.setIndex(curIdx + startIdx + 1);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get Switch Bandwidth stat", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
        }
        return 0;
    }

    public int getSwitchBandwidthStatDataLength(DbFilterDO dbFilter, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getSwitchBandwidthStatList(records, dbFilter, interval, 0, 1, true);
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    private String getSqlSortSuffix(String sortField, String sortType, String interval) {
        StringBuilder sortStr = new StringBuilder();
        if (sortField.equals("avgRxStr")) {
            sortStr.append(PerfUtil.getAvgIntervalColumn(interval)).append("RX");
        } else if (sortField.equals("avgTxStr")) {
            sortStr.append(PerfUtil.getAvgIntervalColumn(interval)).append("TX");
        } else if (sortField.equals("maxRxStr")) {
            sortStr.append(PerfUtil.getMaxIntervalColumn(interval)).append("RX");
        } else if (sortField.equals("maxTxStr")) {
            sortStr.append(PerfUtil.getMaxIntervalColumn(interval)).append("TX");
        } else if (sortField.equals("errorStr")) {
            sortStr.append(PerfUtil.getErrorIntervalColumn(interval));
        } else if (sortField.equals("discardStr")) {
            sortStr.append(PerfUtil.getDiscardIntervalColumn(interval));
        } else if (sortField.equals("rxTxStr")) {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        } else {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        sortStr.append(" ").append(sortType);
        return sortStr.toString();
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        int length = SwitchBandwidthHandler.getInstance().getSwitchBandwidthStatDataLength(dbFilter, "24 Hours");
        System.out.println("length is :" + length);
        ArrayList<StatisticsDataDO> rstList = SwitchBandwidthHandler.getInstance().getSwitchBandwidthStatList(dbFilter, "24 Hours", 0, 31);
        int count = 0;
        for (StatisticsDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getTitle() + " : " + e.getLastUpdateTimeStr());
        }
        boolean i = false;
    }

    public String printSwitchBandwidthStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = SwitchBandwidthHandler.getInstance().getSwitchBandwidthStatList(dbFilter, interval, startIdx, recordSize);
        String title = "Performance Switch Traffic";
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Avg. Rx", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg. Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak Rx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, columnAlignment, rstList);
    }

    public String exportSwitchBandwidthStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = SwitchBandwidthHandler.getInstance().getSwitchBandwidthStatList(dbFilter, interval, startIdx, recordSize);
        String title = "Performance Switch Traffic";
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Avg. Rx", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg. Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak Rx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        boolean unitlessFlag = true;
        String export_unitless = System.getProperties().getProperty("export.unitless");
        if (export_unitless != null) {
            unitlessFlag = Boolean.getBoolean("export.unitless");
        }
        String export_unit = System.getProperties().getProperty("export.unit");
        if (unitlessFlag) {
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgRxStr", "lastDayAvgRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgTxStr", "lastDayAvgTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxTxStr", "rxTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxRxStr", "lastDayMaxRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxTxStr", "lastDayMaxTx");
        } else if (export_unit != null) {
            DisplayUtil.convertToExportUnit(rstList, export_unit);
        }
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, columnAlignment, rstList);
    }
}

