/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.BladeDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchNameDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.NameValueDO;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SwitchHandler {
    private static SwitchHandler _Instance = null;
    public static final int CONN_UNIT_WARNING = 4;
    private Logger _Log = Logger.getLogger((String)"fms");
    private int sanDataLength = 0;
    private int lanDataLength = 0;
    static final String SQL_Query_all_san_switch = "select sw.sys_name, sw.ip_address, sw.type, sw.is_managable,sw.wwn, sw.is_mds, f.fid, snU.version, sw.id, sw.fabric_id  from switch sw, fabric f, snmpuser snU where sw.fabric_id=f.id AND f.fmuser_id=snU.id";
    static final String SQL_Query_all_lan_switch = "select nav_groups.name, ethswitch.id, ip_address, model_name, sys_name, sys_contact, sys_location, version, serial_number, sys_uptime,vendor,num_ports,is_present,is_manageable, unmanageable_cause, is_vdc, vdc_id, vdc_name,fcoe_enabled, cpu_usage, mem_usage, ethswitch.last_scan_time, vdc_mac, is_fex, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, primary_ip from ethswitch, nav_group_member, nav_groups where ethswitch.id=nav_group_member.mem_dbid and ethswitch.is_fex=false and nav_group_member.group_id=nav_groups.id; ";
    static final String SQL_Query_all_lan_switch_capacity = "select nav_groups.name, ethswitch.id, ip_address, model_name, sys_name, sys_contact, sys_location, version, serial_number, sys_uptime,vendor,num_ports,is_present,is_manageable, unmanageable_cause, is_vdc, vdc_id, vdc_name,fcoe_enabled, cpu_usage, mem_usage, ethswitch.last_scan_time, vdc_mac, is_fex, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, primary_ip, cap.health from ethswitch left outer join capacity_data cap on cap.time_id=? and cap.switch_id=ethswitch.id join nav_group_member on ethswitch.id=nav_group_member.mem_dbid and ethswitch.is_fex=false join nav_groups on nav_group_member.group_id=nav_groups.id";
    static final String SQL_Query_swith_managing_server = "select ps.ip_addr, etsw.sys_name, etsw.ip_address, etsw.is_manageable from physical_logicsvr ps, logicsvr_fabric ls, lanswitch_map lm, lan l, ethswitch etsw  where lm.lan_id=l.id AND l.lan_id=ls.f_id AND ls.lsvr_id=ps.lsvr_id AND etsw.id=lm.id AND lm.id=?";

    public static SwitchHandler getInstance() {
        if (_Instance == null) {
            _Instance = new SwitchHandler();
        }
        return _Instance;
    }

    private SwitchHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] getSwitchFabricOrLanID(long switchDbID, boolean isLan) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block4: {
            Long[] longArray;
            String sqlFabric = "SELECT f.id, f.fid FROM switch sw, fabric f Where f.id=sw.fabric_id AND sw.id = ?";
            String sqlLan = "select nav.group_id from NAV_GROUP_MEMBER nav where nav.mem_dbid=?";
            con = null;
            stmt = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, isLan ? sqlLan : sqlFabric, 1004, 1007);
                stmt.setLong(1, switchDbID);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                Long[] rst = new Long[2];
                rst[0] = rs.getLong(1);
                longArray = rst;
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
            return longArray;
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return new Long[0];
    }

    public ArrayList<SwitchDO> getSwitchList(DbFilterDO dbFilter, String swStatus, int startIdx, int recordSize) {
        String sortSqlSuffix;
        String networkType = dbFilter.getNetworkType();
        ArrayList<SwitchDO> totalList = new ArrayList<SwitchDO>();
        int sanStartIdx = 0;
        int lanStartIdx = 0;
        int sanRecordSize = 0;
        int lanRecordSize = 0;
        if (networkType != null && networkType.equals("Data Center")) {
            if (startIdx < this.sanDataLength) {
                sanStartIdx = startIdx;
                int retrieveSize = sanStartIdx + recordSize;
                if (retrieveSize < this.sanDataLength) {
                    sanRecordSize = recordSize;
                } else {
                    sanRecordSize = this.sanDataLength - sanStartIdx;
                    lanRecordSize = recordSize - sanRecordSize;
                    lanStartIdx = 0;
                }
            } else {
                sanStartIdx = this.sanDataLength;
                sanRecordSize = 0;
                lanStartIdx = startIdx - this.sanDataLength;
                lanRecordSize = recordSize;
            }
        } else {
            sanStartIdx = lanStartIdx = startIdx;
            sanRecordSize = lanRecordSize = recordSize;
        }
        if (networkType != null && (networkType.equals("SAN") || networkType.equals("Data Center"))) {
            String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
            sortSqlSuffix = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), false);
            totalList.addAll(this.getSanSwitchList(dbFilter, swStatus, sanStartIdx, sanRecordSize, groupFabricFilterSqlSuffix + sortSqlSuffix));
        }
        if (networkType != null && (networkType.equals("LAN") || networkType.equals("Data Center"))) {
            String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
            if (groupLanFilterSqlSuffix != null && groupLanFilterSqlSuffix.length() > 0) {
                groupLanFilterSqlSuffix = " where ethswitch.id in (" + groupLanFilterSqlSuffix + ")";
            }
            sortSqlSuffix = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), true);
            totalList.addAll(this.getLanSwitchList(lanStartIdx, swStatus, lanRecordSize, groupLanFilterSqlSuffix + sortSqlSuffix, networkType.equals("LAN")));
        }
        return totalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchDO[] getOtherVDCList(long switchDbId, String serialNumber) {
        String sql = "SELECT S1.is_vdc, S1.vdc_id, S1.vdc_name, S1.id, S1.ip_address, S1.sys_name FROM ethswitch S1 Where S1.serial_number = ? AND S1.ID != ?";
        ArrayList<SwitchDO> vdcList = new ArrayList<SwitchDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            con.prepareStatement(sql);
            stmt.setString(1, serialNumber);
            stmt.setLong(2, switchDbId);
            rs = stmt.executeQuery();
            int curIdx = 0;
            while (rs.next()) {
                boolean isVdc = rs.getBoolean(1);
                int vdcId = rs.getInt(2);
                String vdcName = rs.getString(3);
                long switchDbID = rs.getLong(4);
                byte[] ipAddress = rs.getBytes(5);
                String sys_name = rs.getString(6);
                SwitchDO wrapper = new SwitchDO();
                wrapper.setSwitchDbID(switchDbID);
                wrapper.setLogicalName(sys_name);
                wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                wrapper.setNetwork("LAN");
                wrapper.setupMapping();
                if (isVdc) {
                    wrapper.setVdcId(vdcId);
                    wrapper.setVdcName(vdcName);
                } else {
                    wrapper.setVdcId(-1);
                    wrapper.setVdcName("");
                }
                vdcList.add(wrapper);
                ++curIdx;
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return vdcList.toArray(new SwitchDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BladeDO[] getBlades(long switchDbId) {
        String sql = "SELECT ucs.admin_power, ucs.admin_state, ucs.assigned_to_dn, ucs.association,  ucs.availability, ucs.available_memory, ucs.chassis_id, ucs.descr, ucs.dn, ucs.low_voltage_memory, ucs.managing_inst, ucs.memory_speed, ucs.model, ucs.name, ucs.num_of_adaptors, ucs.num_of_cores, ucs.num_of_cores_enabled, ucs.num_of_cpus, ucs.num_of_eth_host_ifs, ucs.num_of_fc_host_ifs, ucs.num_of_threads, ucs.oper_power, ucs.oper_qualifier, ucs.oper_state, ucs.operability, ucs.original_uuid, ucs.presence, ucs.revision, ucs.serial, ucs.server_id, ucs.slot_id, ucs.total_memory, ucs.uuid, ucs.vendor, ucs.created_time, ucs.last_update_time, ucs_mgmt.ip FROM ucs_blade ucs LEFT JOIN ucs_blade_mgmt_if ucs_mgmt ON ucs.id = ucs_mgmt.blade_id WHERE ucs.switch_id = ?";
        HashMap<String, BladeDO> blades = new HashMap<String, BladeDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            con.prepareStatement(sql);
            stmt.setLong(1, switchDbId);
            rs = stmt.executeQuery();
            int curIdx = 0;
            while (rs.next()) {
                String adminPower = rs.getString(1);
                String adminState = rs.getString(2);
                String assignedToDN = rs.getString(3);
                String association = rs.getString(4);
                String availability = rs.getString(5);
                long availMemory = rs.getLong(6);
                String description = rs.getString(8);
                String destination = rs.getString(9);
                String lowVoltageMemory = rs.getString(10);
                int memorySpeed = rs.getInt(12);
                String model = rs.getString(13);
                String name = rs.getString(14);
                int numAdaptors = rs.getInt(15);
                int numCores = rs.getInt(16);
                int numCoresEnabled = rs.getInt(17);
                int numCPUs = rs.getInt(18);
                int numEthHostIfs = rs.getInt(19);
                int numFCHostIfs = rs.getInt(20);
                int numThreads = rs.getInt(21);
                String operPower = rs.getString(22);
                String operQualifier = rs.getString(23);
                String operState = rs.getString(24);
                String operability = rs.getString(25);
                String originalUUID = rs.getString(26);
                String presence = rs.getString(27);
                int revision = rs.getInt(28);
                String serial = rs.getString(29);
                String serverId = rs.getString(30);
                int slotId = rs.getInt(31);
                long totalMemory = rs.getLong(32);
                String uuid = rs.getString(33);
                String vendor = rs.getString(34);
                long lastUpdateTime = rs.getLong(36);
                String ipAddress = rs.getString(37);
                BladeDO bladeDO = (BladeDO)blades.get(destination);
                if (bladeDO != null) {
                    String ipAdd = bladeDO.getIpAddress();
                    bladeDO.setIpAddress(ipAdd + ", " + ipAddress);
                    blades.put(destination, bladeDO);
                    continue;
                }
                BladeDO wrapper = new BladeDO();
                wrapper.setAdminPower(adminPower);
                wrapper.setAdminState(adminState);
                wrapper.setAssignedToDN(assignedToDN);
                wrapper.setAssociated(association);
                wrapper.setAvailability(availability);
                wrapper.setAvailmemory(availMemory);
                wrapper.setDescription(description);
                wrapper.setDestination(destination);
                wrapper.setLowVoltageMemory(lowVoltageMemory);
                wrapper.setMemorySpeed(memorySpeed);
                wrapper.setModel(model);
                wrapper.setName(name);
                wrapper.setNumAdaptors(numAdaptors);
                wrapper.setNumCores(numCoresEnabled);
                wrapper.setNumCoresEnabled(numCoresEnabled);
                wrapper.setNumCPUs(numCPUs);
                wrapper.setNumEthHostIf(numEthHostIfs);
                wrapper.setNumFCHostIf(numFCHostIfs);
                wrapper.setNumThreads(numThreads);
                wrapper.setOperability(operability);
                wrapper.setOperPower(operPower);
                wrapper.setOperQualifier(operQualifier);
                wrapper.setOperState(operState);
                wrapper.setRevision(revision);
                wrapper.setSerial(serial);
                wrapper.setSlotId(slotId);
                wrapper.setTotalMemory(totalMemory);
                wrapper.setUuid(uuid);
                wrapper.setVendor(vendor);
                wrapper.setIpAddress(ipAddress);
                blades.put(destination, wrapper);
                ++curIdx;
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return blades.values().toArray(new BladeDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValueDO[] getFeatures(long switchDbId, boolean isLAN) {
        String sql = "SELECT S1.features_string FROM switch S1 Where S1.id = ?";
        if (isLAN) {
            sql = "SELECT S1.features_string FROM ethswitch S1 Where S1.id = ?";
        }
        ArrayList<NameValueDO> enabledFeatures = new ArrayList<NameValueDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.setLong(1, switchDbId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String featureString = rs.getString(1);
                for (int i = 0; i < featureString.length(); ++i) {
                    String featureName = AbstractSwitchBase.Feature.getFeatureByFlag(i).toString();
                    enabledFeatures.add(new NameValueDO(featureName, "" + featureString.charAt(i)));
                }
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return enabledFeatures.toArray(new NameValueDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSnmpUsername(long switchDbId, boolean isLAN) {
        String sqlSAN = "select sn.user_name from snmpuser sn, fabric f, switch sw where f.id = sw.fabric_id and sn.id = f.fmuser_id and sw.id = ?";
        String sqlLAN = "select sn.user_name from snmpuser sn, cdp_seed seed, ethswitch_seed es where seed.id = es.seed_id and sn.id = seed.cred_id and es.switch_id = ?";
        String user = "admin";
        String sql = isLAN ? sqlLAN : sqlSAN;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            con.prepareStatement(sql);
            stmt.setLong(1, switchDbId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                user = rs.getString(1);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return user;
    }

    public ArrayList<SwitchDO> getLanSwitchListByGroupId(long groupId) {
        return this.getLanSwitchList(0, "All", -1, ", nav_group_member ngm where ngm.mem_dbid = ethswitch.id and ngm.group_id=" + groupId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<SwitchDO> getLanSwitchList(int startIdx, String swStatus, int recordSize, String sortSql, boolean lanOnly) {
        ArrayList<SwitchDO> lanList = new ArrayList<SwitchDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean hasCapData = false;
            int maxTimeId = this.getMaxTimeIdFromCapacity();
            if (maxTimeId != -1) {
                hasCapData = true;
            }
            con = ConnectionManager.getConnection();
            HashMap<Long, Integer> usedPortHash = SwitchHandler.getAllUsedPorts(con, "LAN");
            HashMap<Long, Long> lanIdHash = SwitchHandler.getLanIdSwitchMap(con);
            if (hasCapData) {
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, PersistentHelper.getHelper().getQueryString(SQL_Query_all_lan_switch_capacity + sortSql), 1004, 1007);
                stmt.setInt(1, maxTimeId);
                rs = stmt.executeQuery();
            } else {
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, PersistentHelper.getHelper().getQueryString(SQL_Query_all_lan_switch + sortSql), 1004, 1007);
                rs = stmt.executeQuery();
            }
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            FileLicensingHelper flHelper = FileLicensingHelper.getInstance();
            while (rs.next()) {
                String groupName = rs.getString(1);
                long switchDbID = rs.getLong(2);
                byte[] ipAddress = rs.getBytes(3);
                String model = rs.getString(4);
                String sys_name = rs.getString(5);
                String sys_contact = rs.getString(6);
                String sys_location = rs.getString(7);
                String version = rs.getString(8);
                String serialNo = rs.getString(9);
                long sysUpTime = rs.getLong(10);
                String vendor = rs.getString(11);
                int num_ports = rs.getInt(12);
                boolean is_present = rs.getBoolean(13);
                boolean isManagable = rs.getBoolean(14);
                String unmanagableCause = rs.getString(15);
                boolean isVdc = rs.getBoolean(16);
                int vdcId = rs.getInt(17);
                String vdcName = rs.getString(18);
                boolean isFcoeEnabled = rs.getBoolean(19);
                int cpuUsage = rs.getInt(20);
                int memoryUsage = rs.getInt(21);
                long lastScanTime = rs.getLong(22);
                String vdcMac = rs.getString(23);
                boolean isFex = rs.getBoolean(24);
                int num_1gports = rs.getInt(25);
                int num_2gports = rs.getInt(26);
                int num_4gports = rs.getInt(27);
                int num_8gports = rs.getInt(28);
                int num_10gports = rs.getInt(29);
                int num_16gports = rs.getInt(30);
                int num_40gports = rs.getInt(31);
                int num_100gports = rs.getInt(32);
                int totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                String primaryIP = rs.getString(33);
                int health = -1;
                if (hasCapData) {
                    double health_double = rs.getDouble(34);
                    if (!rs.wasNull()) {
                        health = (int)(health_double * 100.0);
                    }
                }
                SwitchAssignedLicenseInfo assignedLicenseInfo = flHelper.getLanLicenseInfoSwitchAssignment(switchDbID);
                SwitchDO wrapper = new SwitchDO();
                wrapper.setSwitchDbID(switchDbID);
                wrapper.setLogicalName(sys_name);
                wrapper.setSwWwnName(serialNo);
                wrapper.setSerialNumber(serialNo);
                if (ipAddress != null) {
                    wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                }
                wrapper.setModel(model);
                wrapper.setNonMdsModel(model);
                wrapper.setManagable(isManagable);
                wrapper.setUnmanagableCause(unmanagableCause);
                wrapper.setNetwork("LAN");
                wrapper.setFabricName(groupName);
                wrapper.setNumberOfPorts(totalPorts);
                wrapper.setVendor(vendor);
                wrapper.setRelease(version);
                wrapper.setLocation(sys_location);
                wrapper.setContact(sys_contact);
                wrapper.setPresent(is_present);
                wrapper.setLastScanTime(lastScanTime);
                wrapper.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed((System.currentTimeMillis() - sysUpTime) / 10L) : "");
                wrapper.setStatus(DisplayUtil.getEthSwitchStatus(wrapper));
                wrapper.setIndex(curIdx + startIdx + 1 + (lanOnly ? 0 : this.sanDataLength));
                wrapper.setupMapping();
                wrapper.setFid(lanIdHash.get(switchDbID).longValue());
                wrapper.setPrimaryIP(primaryIP);
                wrapper.setUsedPorts(usedPortHash.containsKey(switchDbID) && totalPorts > 0 ? usedPortHash.get(switchDbID) : 0);
                if (ipAddress != null) {
                    wrapper.setUsername(this.getSnmpUsername(switchDbID, true));
                }
                if (assignedLicenseInfo != null) {
                    if (assignedLicenseInfo.isEval()) {
                        wrapper.setLicenseDetail(assignedLicenseInfo.getLicenseState() + " - " + assignedLicenseInfo.getExpireDateStr());
                    } else {
                        wrapper.setLicenseDetail(assignedLicenseInfo.getLicenseState());
                    }
                }
                if (isVdc) {
                    wrapper.setVdcId(vdcId);
                    wrapper.setVdcName(vdcName);
                    wrapper.setVdcMac(vdcMac);
                } else {
                    wrapper.setVdcId(-1);
                }
                wrapper.setFcoeEnabled(isFcoeEnabled);
                wrapper.setCpuUsage(cpuUsage);
                wrapper.setMemoryUsage(memoryUsage);
                wrapper.setFex(isFex);
                if (health != -1) {
                    wrapper.setHealth(health);
                }
                if (!swStatus.equals("All") && !SwitchHandler.getSwitchStatusType(wrapper).equals(swStatus)) continue;
                lanList.add(wrapper);
                if (recordSize <= 0 || ++curIdx < recordSize || swStatus != null && (swStatus == null || swStatus.equalsIgnoreCase("Warning"))) continue;
                break;
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return lanList;
    }

    public ArrayList<SwitchDO> getSanSwitchList(DbFilterDO dbFilter, String swStatus, int startIdx, int recordSize, String sortSqlSuffix) {
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        long groupDbId = dbFilter.getGroupId();
        return this.getSanSwitchList(vsanDbId, fabricDbId, groupDbId, swStatus, startIdx, recordSize, sortSqlSuffix);
    }

    public ArrayList<SwitchDO> getSwitchList(long switchId, long fid) {
        ArrayList<SwitchDO> rstList;
        String sqlSuffix = " AND SWITCH.ID =" + switchId;
        if (fid != -1L) {
            sqlSuffix = sqlSuffix + " AND FABRIC.FID = " + fid;
        }
        if ((rstList = this.getSanSwitchList(-1L, -1L, -1L, "All", 0, 31, sqlSuffix)).size() == 0) {
            sqlSuffix = " AND ethswitch.id =" + switchId;
            rstList = this.getLanSwitchList(0, "All", 31, sqlSuffix, true);
        }
        return rstList;
    }

    public ArrayList<SwitchDO> getLanSwitchList(long switchId, long lanId) {
        String sqlSuffix = " Where ethswitch.id =" + switchId;
        ArrayList<SwitchDO> rstList = this.getLanSwitchList(0, "All", 31, sqlSuffix, true);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwitchDO> getSanSwitchList(long vsanDbId, long fabricDbId, long groupDbId, String swStatus, int startIdx, int recordSize, String sqlSuffix) {
        ArrayList<SwitchDO> resultList = new ArrayList<SwitchDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            boolean hasCapData = false;
            int maxTimeId = this.getMaxTimeIdFromCapacity();
            if (maxTimeId != -1) {
                hasCapData = true;
            }
            con = ConnectionManager.getConnection();
            HashMap<Long, Integer> usedPortHash = SwitchHandler.getAllUsedPorts(con, "SAN");
            if (vsanDbId != -1L) {
                sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_VSAN_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                stmt.setLong(1, fabricDbId);
                stmt.setLong(2, vsanDbId);
            } else if (fabricDbId != -1L) {
                if (groupDbId != -1L) {
                    int groupType = DisplayUtil.getGroupType(con, groupDbId);
                    sql = groupType == 1 ? SQLLoader.getSqlStmt("SwitchAction.SWITCH_GROUP_STMT") : SQLLoader.getSqlStmt("SwitchAction.NX_PORT_GROUP_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                    stmt.setLong(1, groupDbId);
                } else {
                    sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_FABRIC_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                    stmt.setLong(1, fabricDbId);
                }
            } else if (hasCapData) {
                sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_CAPACITY_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                stmt.setInt(1, maxTimeId);
            } else {
                sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
            }
            rs = SQLLoader.execute(stmt);
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            FileLicensingHelper flHelper = FileLicensingHelper.getInstance();
            while (rs.next()) {
                int num_100gports;
                int num_40gports;
                int num_16gports;
                int num_10gports;
                int num_8gports;
                int num_4gports;
                int num_2gports;
                int num_1gports;
                String fabric = rs.getString(1);
                boolean isPresent = rs.getBoolean(2);
                byte[] wwn = rs.getBytes(4);
                byte[] ipAddress = rs.getBytes(5);
                boolean isMds = rs.getBoolean(6);
                int type = rs.getInt(7);
                boolean isManagable = rs.getBoolean(8);
                String nonMdsModel = rs.getString(9);
                String sysName = rs.getString(10);
                String sysContact = rs.getString(11);
                String sysLocation = rs.getString(12);
                long sysUpTime = rs.getLong(13);
                int activeSupSlot = rs.getInt(14);
                int standbySupState = rs.getInt(15);
                int connUnitStatus = rs.getInt(16);
                String version = rs.getString(17);
                boolean isLicenseViolation = rs.getBoolean(18);
                String unmanagableCause = rs.getString(19);
                long lastScanTime = rs.getLong(20);
                int numberOfPorts = rs.getInt(21);
                long id = rs.getLong(22);
                int domain = -1;
                byte[] swwn = null;
                int totalPorts = 0;
                boolean isVdc = rs.getBoolean(23);
                int vdcId = rs.getInt(24);
                boolean isFcoeEnabled = rs.getBoolean(25);
                int cpuUsage = 0;
                int memoryUsage = 0;
                long fid = 0L;
                String primaryIP = "";
                String serialNumber = "";
                SwitchAssignedLicenseInfo assignedLicenseInfo = flHelper.getSanLicenseInfoSwitchAssignment(id);
                if (vsanDbId != -1L) {
                    domain = rs.getInt(26);
                    swwn = rs.getBytes(27);
                    cpuUsage = rs.getInt(28);
                    memoryUsage = rs.getInt(29);
                    serialNumber = rs.getString(30);
                    num_1gports = rs.getInt(31);
                    num_2gports = rs.getInt(32);
                    num_4gports = rs.getInt(33);
                    num_8gports = rs.getInt(34);
                    num_10gports = rs.getInt(35);
                    num_16gports = rs.getInt(36);
                    num_40gports = rs.getInt(37);
                    num_100gports = rs.getInt(38);
                    totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                    fid = rs.getLong(39);
                    primaryIP = rs.getString(40);
                } else {
                    cpuUsage = rs.getInt(26);
                    memoryUsage = rs.getInt(27);
                    serialNumber = rs.getString(28);
                    num_1gports = rs.getInt(29);
                    num_2gports = rs.getInt(30);
                    num_4gports = rs.getInt(31);
                    num_8gports = rs.getInt(32);
                    num_10gports = rs.getInt(33);
                    num_16gports = rs.getInt(34);
                    num_40gports = rs.getInt(35);
                    num_100gports = rs.getInt(36);
                    totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                    fid = rs.getLong(37);
                    primaryIP = rs.getString(38);
                }
                int health = -1;
                if (hasCapData) {
                    double health_double = rs.getDouble(39);
                    if (!rs.wasNull()) {
                        health = (int)(health_double * 100.0);
                    }
                }
                SwitchDO switchDo = new SwitchDO();
                switchDo.setFabricName(fabric);
                if (ipAddress != null) {
                    switchDo.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                }
                switchDo.setLogicalName(sysName);
                switchDo.setSwitchDbID(id);
                switchDo.setFid(fid);
                switchDo.setRelease(version);
                switchDo.setLocation(sysLocation);
                switchDo.setContact(sysContact);
                switchDo.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed((System.currentTimeMillis() - sysUpTime) / 10L) : "");
                switchDo.setUpTimeNumber(3);
                switchDo.setPresent(isPresent);
                switchDo.setNetwork("SAN");
                switchDo.setLicenseViolation(isLicenseViolation);
                switchDo.setManagable(isManagable);
                switchDo.setMds(isMds);
                switchDo.setModelType(type);
                switchDo.setNonMdsModel(nonMdsModel);
                switchDo.setConnUnitStatus(connUnitStatus);
                switchDo.setStandbySupState(standbySupState);
                switchDo.setActiveSupSlot(activeSupSlot);
                switchDo.setUnmanagableCause(unmanagableCause);
                switchDo.setLastScanTime(lastScanTime);
                switchDo.setNumberOfPorts(totalPorts);
                switchDo.setUsedPorts(usedPortHash.containsKey(id) && totalPorts > 0 ? usedPortHash.get(id) : 0);
                if (ipAddress != null) {
                    switchDo.setUsername(this.getSnmpUsername(id, true));
                }
                if (assignedLicenseInfo != null) {
                    if (assignedLicenseInfo.isEval()) {
                        switchDo.setLicenseDetail(assignedLicenseInfo.getLicenseState() + " - " + assignedLicenseInfo.getExpireDateStr());
                    } else {
                        switchDo.setLicenseDetail(assignedLicenseInfo.getLicenseState());
                    }
                }
                if (vsanDbId != -1L) {
                    switchDo.setVsanWwn(new WwnDO(wwn));
                    switchDo.setVsanWwnName(SnmpString.toHexString(wwn));
                    switchDo.setDomain("0x" + Integer.toHexString(domain) + "(" + domain + ")");
                    if (DisplayUtil.equal(swwn, wwn)) {
                        switchDo.setPrincipal("self");
                    } else {
                        switchDo.setPrincipal(DisplayUtil.getWwn(swwn).toString());
                    }
                }
                switchDo.setSwWwn(new WwnDO(wwn));
                switchDo.setSwWwnName(SnmpString.toHexString(wwn));
                switchDo.setModel(DisplayUtil.getSwitchModel(switchDo));
                switchDo.setStatus(SwitchHandler.getSwitchStatus(switchDo));
                switchDo.setVendor(DisplayUtil.getSwitchVendor(switchDo));
                switchDo.setIndex(curIdx + startIdx + 1);
                switchDo.setupMapping();
                if (isVdc) {
                    switchDo.setVdcId(vdcId);
                } else {
                    switchDo.setVdcId(-1);
                }
                switchDo.setFcoeEnabled(isFcoeEnabled);
                switchDo.setCpuUsage(cpuUsage);
                switchDo.setMemoryUsage(memoryUsage);
                switchDo.setSerialNumber(serialNumber);
                if (health != -1) {
                    switchDo.setHealth(health);
                }
                switchDo.setPrimaryIP(primaryIP);
                if (!swStatus.equals("All") && !SwitchHandler.getSwitchStatusType(switchDo).equals(swStatus)) continue;
                resultList.add(switchDo);
                if (++curIdx < recordSize || swStatus != null && (swStatus == null || swStatus.equalsIgnoreCase("Warning"))) continue;
                break;
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getMaxTimeIdFromCapacity() {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        int ret;
        block6: {
            ret = -1;
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                String sql = SQLLoader.getSqlStmt("SwitchAction.MAX_TIME_CAPACITY_STMT");
                stat = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = SQLLoader.execute(stat);
                if (!rs.next()) break block6;
                ret = rs.getInt(1);
            }
            catch (SQLException e) {
                this._Log.warn((Object)"getMaxTimeIdFromCapacity: caught exception", (Throwable)e);
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                {
                    catch (Throwable throwable) {
                        DbUtil.close(rs);
                        DbUtil.close(stat);
                        DbUtil.close(con);
                        throw throwable;
                    }
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Long, Long> getLanIdSwitchMap(Connection con) {
        HashMap<Long, Long> idHash;
        block6: {
            idHash = new HashMap<Long, Long>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                String sql = "SELECT MAP.id, LAN.lan_id FROM LAN LAN, LANSWITCH_MAP MAP WHERE LAN.id = MAP.lan_id";
                stmt = con.prepareStatement(sql);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long switchDbId = rs.getLong(1);
                    long lanId = rs.getLong(2);
                    idHash.put(switchDbId, lanId);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
        return idHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Long, Integer> getAllUsedPorts(Connection con, String networktype) {
        HashMap<Long, Integer> portHash;
        block6: {
            portHash = new HashMap<Long, Integer>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                String sql = networktype.equals("LAN") ? SQLLoader.getSqlStmt("SwitchAction.GET_USED_LAN_PORTS") : SQLLoader.getSqlStmt("SwitchAction.GET_USED_SAN_PORTS");
                stmt = con.prepareStatement(sql);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long switchDbId = rs.getLong(1);
                    int count = rs.getInt(2);
                    int curCnt = portHash.containsKey(switchDbId) ? portHash.get(switchDbId) : 0;
                    portHash.put(switchDbId, count + curCnt);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
        return portHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Integer> getUsedPortInfo(Connection con, long vsanDbId, long fabricDbId) {
        HashMap<String, Integer> portHash;
        block10: {
            portHash = new HashMap<String, Integer>();
            String[] sqls = new String[]{"SwitchAction.FC_PORT_VSAN_STMT", "SwitchAction.FC_PORT_FABRIC_STMT", "SwitchAction.FC_PORT_STMT"};
            PreparedStatement stmt = null;
            String sql = null;
            ResultSet rs = null;
            try {
                if (vsanDbId != -1L) {
                    sql = SQLLoader.getSqlStmt(sqls[0]);
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, fabricDbId);
                    stmt.setLong(2, vsanDbId);
                    stmt.setLong(3, fabricDbId);
                    stmt.setLong(4, vsanDbId);
                    stmt.setLong(5, fabricDbId);
                    stmt.setLong(6, vsanDbId);
                } else if (fabricDbId != -1L) {
                    sql = SQLLoader.getSqlStmt(sqls[1]);
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, fabricDbId);
                    stmt.setLong(2, fabricDbId);
                    stmt.setLong(3, fabricDbId);
                } else {
                    sql = SQLLoader.getSqlStmt(sqls[2]);
                    stmt = con.prepareStatement(sql);
                }
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    int cnt1 = rs.getInt(1);
                    int cnt2 = rs.getInt(2);
                    String s1SysName = rs.getString(3);
                    String s2SysName = rs.getString(4);
                    int curCnt = portHash.containsKey(s1SysName) ? portHash.get(s1SysName) : 0;
                    portHash.put(s1SysName, cnt1 + curCnt);
                    if (s1SysName.equalsIgnoreCase(s2SysName)) continue;
                    curCnt = portHash.containsKey(s2SysName) ? portHash.get(s2SysName) : 0;
                    portHash.put(s2SysName, cnt2 + curCnt);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
        return portHash;
    }

    public List<SwitchDO> getCliSwitches(DbFilterDO dbFilter) {
        String[] lanSwIdArr;
        ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
        String fidsInStr = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 0);
        String[] fidArr = fidsInStr.split(",");
        long swId = -1L;
        for (String fidStr : fidArr) {
            swId = Long.parseLong(fidStr);
            if (swId < 0L) continue;
            rstList.addAll(NavigationUtil.getInstance().getSwitchList(swId));
        }
        String lanSwIdsInStr = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
        for (String lanSwId : lanSwIdArr = lanSwIdsInStr.split(",")) {
            swId = Long.parseLong(lanSwId);
            if (swId < 0L) continue;
            rstList.add(NavigationUtil.getInstance().getLanSwitchDetail(swId));
        }
        return rstList;
    }

    public int getSwitchDataLength(DbFilterDO dbFilter, String swStatus) {
        int totalLength = 0;
        if (swStatus == null) {
            swStatus = "All";
        }
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("SAN")) {
            this.sanDataLength = this.getSanSwitchDataLength(dbFilter, swStatus);
            totalLength += this.sanDataLength;
        }
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("LAN")) {
            this.lanDataLength = this.getLanSwitchDataLength(dbFilter, swStatus);
            totalLength += this.lanDataLength;
        }
        return totalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSanSwitchDataLength(DbFilterDO dbFilter, String swStatus) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int dataLength;
        block16: {
            int groupType;
            block15: {
                dataLength = 0;
                con = null;
                stmt = null;
                rs = null;
                String sql = null;
                try {
                    String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
                    con = ConnectionManager.getConnection();
                    long vsanDbId = dbFilter.getVsanDbId();
                    long fabricDbId = dbFilter.getFabricDbId();
                    long groupDbId = dbFilter.getGroupId();
                    if (vsanDbId != -1L) {
                        sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_VSAN_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + groupFabricFilterSqlSuffix, 1004, 1007);
                        stmt.setLong(1, fabricDbId);
                        stmt.setLong(2, vsanDbId);
                    } else if (fabricDbId >= 0L) {
                        if (groupDbId != -1L) {
                            groupType = DisplayUtil.getGroupType(con, groupDbId);
                            sql = groupType == 1 ? SQLLoader.getSqlStmt("SwitchAction.SWITCH_GROUP_STMT") : SQLLoader.getSqlStmt("SwitchAction.NX_PORT_GROUP_STMT");
                            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + groupFabricFilterSqlSuffix, 1004, 1007);
                            stmt.setLong(1, groupDbId);
                        } else {
                            sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_FABRIC_STMT");
                            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + groupFabricFilterSqlSuffix, 1004, 1007);
                            stmt.setLong(1, fabricDbId);
                        }
                    } else {
                        sql = SQLLoader.getSqlStmt("SwitchAction.SWITCH_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + groupFabricFilterSqlSuffix, 1004, 1007);
                    }
                    rs = SQLLoader.execute(stmt);
                    if (swStatus.equals("All")) {
                        rs.last();
                        groupType = rs.getRow();
                        DbUtil.close(rs);
                        break block15;
                    }
                    while (rs.next()) {
                        boolean isPresent = rs.getBoolean(2);
                        int type = rs.getInt(7);
                        boolean isManagable = rs.getBoolean(8);
                        int standbySupState = rs.getInt(15);
                        int connUnitStatus = rs.getInt(16);
                        boolean isLicenseViolation = rs.getBoolean(18);
                        SwitchDO switchDo = new SwitchDO();
                        switchDo.setPresent(isPresent);
                        switchDo.setLicenseViolation(isLicenseViolation);
                        switchDo.setManagable(isManagable);
                        switchDo.setConnUnitStatus(connUnitStatus);
                        switchDo.setStandbySupState(standbySupState);
                        switchDo.setModelType(type);
                        if (!SwitchHandler.getSwitchStatusType(switchDo).equals(swStatus)) continue;
                        ++dataLength;
                    }
                    DbUtil.close(rs);
                    break block16;
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    return dataLength;
                }
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
            return groupType;
        }
        DbUtil.close(stmt);
        DbUtil.close(con);
        return dataLength;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
    }

    private void updateSwitchLicenseInfo(List<SwitchAssignedLicenseInfo> swLcns, SwitchNameDO swDo, long switchDbId) {
        if (swLcns != null) {
            for (int i = 0; i < swLcns.size(); ++i) {
                SwitchAssignedLicenseInfo swAsLn = swLcns.get(i);
                if (swAsLn == null || switchDbId != swAsLn.getDbID()) continue;
                swDo.setLicensed(swAsLn.isLicensed());
            }
        }
    }

    private void updateSwitchLicenseInfo(List<SwitchAssignedLicenseInfo> swLcns, SwitchDO swDo, long switchDbId) {
        if (swLcns != null) {
            for (int i = 0; i < swLcns.size(); ++i) {
                SwitchAssignedLicenseInfo swAsLn = swLcns.get(i);
                if (swAsLn == null || switchDbId != swAsLn.getDbID()) continue;
                swDo.setLicenseViolation(!swAsLn.isLicensed());
            }
        }
    }

    public Object[] getFMSManagingLanSwitch(long swDbID) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block4: {
            Object[] objectArray;
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(SQL_Query_swith_managing_server);
                stat.setLong(1, swDbID);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                objectArray = new Object[]{new SnmpIpAddress(rs.getBytes(1)).toString(), rs.getString(2), new SnmpIpAddress(rs.getBytes(3)).toString(), rs.getBoolean(4)};
            }
            catch (SQLException e) {
                try {
                    this._Log.warn((Object)"getFMSManagingLanSwitch: caught exception", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return objectArray;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return null;
    }

    public List<SwitchNameDO> getAllSwitches() throws SQLException {
        ArrayList<SwitchNameDO> ret = new ArrayList<SwitchNameDO>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            List<SwitchAssignedLicenseInfo> swLcns = FileLicensingHelper.getInstance().getLicenseInfoSwitchAssignment();
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_all_san_switch);
            rs = stat.executeQuery();
            while (rs.next()) {
                String swIpAddress = new SnmpIpAddress(rs.getBytes(2)).toString();
                String swName = rs.getString(1) == null ? swIpAddress : rs.getString(1);
                SwitchNameDO swdo = new SwitchNameDO(swName, swIpAddress, rs.getInt(3));
                swdo.isManageble = rs.getBoolean(4);
                swdo.wwn = rs.getBytes(5);
                swdo.isMds = rs.getBoolean(6);
                swdo.colId = rs.getLong(7);
                swdo.isV3 = rs.getInt(8) == 3;
                swdo.swDbId = rs.getLong(9);
                swdo.colDBId = rs.getLong(10);
                this.updateSwitchLicenseInfo(swLcns, swdo, swdo.swDbId);
                ret.add(swdo);
            }
            ArrayList<SwitchDO> rstList = this.getLanSwitchList(0, "All", -1, "", true);
            HashMap swDbIdToCdpMap = GlobalDCManager.getInstance().querCdpIdLanIdBySwitchDbId();
            for (int i = 0; i < rstList.size(); ++i) {
                SwitchDO swDOi = rstList.get(i);
                String swName = swDOi.getLogicalName() == null ? swDOi.getIpAddress() : swDOi.getLogicalName();
                SwitchNameDO swdo = new SwitchNameDO(swName, swDOi.getIpAddress(), 0, swDOi.getModelType());
                swdo.wwn = null;
                swdo.isMds = false;
                swdo.isLanSwitch = true;
                swdo.swDbId = swDOi.getSwitchDbID();
                swdo.isManageble = swDOi.isManagable();
                swdo.swDbId = swDOi.getSwitchDbID();
                long[] rsP = (long[])swDbIdToCdpMap.get(swDOi.getSwitchDbID());
                if (rsP != null) {
                    long cdpCredID = rsP[2];
                    SnmpUser credential = SwitchHandler.getSnmpUser(rsP[2]);
                    swdo.isV3 = credential != null && credential.getSecurityModel() == 3;
                }
                swdo.isLicensed = !swDOi.isLicenseViolation();
                this.updateSwitchLicenseInfo(swLcns, swdo, swDOi.getSwitchDbID());
                ret.add(swdo);
            }
        }
        catch (SQLException e) {
            try {
                this._Log.warn((Object)"GlobalFabricManager->findFabricPK(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public static SnmpUser getSnmpUser(long crId) {
        SnmpUser credential = null;
        try {
            credential = SnmpUserImpl.loadFromDB(crId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<SwitchDO> getLanSwitchListForLanId(int startIdx, String swStatus, int recordSize, String sortSql, boolean lanOnly, long lanId) {
        ArrayList<SwitchDO> lanList;
        block12: {
            lanList = new ArrayList<SwitchDO>();
            String lanSql = "select sw.id, sw.ip_address, sw.model_name, sw.sys_name, sw.sys_contact, sw.sys_location, sw.version, sw.serial_number, sw.sys_uptime,sw.vendor,sw.num_ports,sw.is_present,sw.is_manageable, sw.unmanageable_cause, sw.is_vdc, sw.vdc_id, sw.vdc_name,sw.fcoe_enabled, sw.cpu_usage, sw.mem_usage, sw.last_scan_time, sw.vdc_mac, sw.num_1g_port, sw.num_2g_port, sw.num_4g_port, sw.num_8g_port, sw.num_10g_port, sw.num_16g_port, sw.num_40g_port, sw.num_100g_port from ethswitch sw, nav_group_member ngm where sw.id = ngm.mem_dbid AND ngm.group_id = ? and is_fex = false";
            Connection con = null;
            PreparedStatement stmt = null;
            String sql = lanSql;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                HashMap<Long, Integer> usedPortHash = SwitchHandler.getAllUsedPorts(con, "LAN");
                sql = PersistentHelper.getHelper().getQueryString(lanSql);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSql, 1004, 1007);
                con.prepareStatement(sql);
                stmt.setLong(1, lanId);
                rs = stmt.executeQuery();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long switchDbID = rs.getLong(1);
                    byte[] ipAddress = rs.getBytes(2);
                    String model = rs.getString(3);
                    String sys_name = rs.getString(4);
                    String sys_contact = rs.getString(5);
                    String sys_location = rs.getString(6);
                    String version = rs.getString(7);
                    String serialNo = rs.getString(8);
                    long sysUpTime = rs.getLong(9);
                    String vendor = rs.getString(10);
                    int num_ports = rs.getInt(11);
                    boolean is_present = rs.getBoolean(12);
                    boolean isManagable = rs.getBoolean(13);
                    String unmanagableCause = rs.getString(14);
                    boolean isVdc = rs.getBoolean(15);
                    int vdcId = rs.getInt(16);
                    String vdcName = rs.getString(17);
                    boolean isFcoeEnabled = rs.getBoolean(18);
                    int cpuUsage = rs.getInt(19);
                    int memoryUsage = rs.getInt(20);
                    long lastScanTime = rs.getLong(21);
                    String vdcMac = rs.getString(22);
                    int num_1gports = rs.getInt(23);
                    int num_2gports = rs.getInt(24);
                    int num_4gports = rs.getInt(25);
                    int num_8gports = rs.getInt(26);
                    int num_10gports = rs.getInt(27);
                    int num_16gports = rs.getInt(28);
                    int num_40gports = rs.getInt(29);
                    int num_100gports = rs.getInt(30);
                    int totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                    SwitchDO wrapper = new SwitchDO();
                    wrapper.setSwitchDbID(switchDbID);
                    if (unmanagableCause == null || !unmanagableCause.contains("Unreachable")) {
                        wrapper.setLinkName("#Modules_" + switchDbID);
                    }
                    wrapper.setLogicalName(sys_name);
                    wrapper.setSwWwnName(serialNo);
                    wrapper.setSerialNumber(serialNo);
                    if (ipAddress != null) {
                        wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                    }
                    wrapper.setModel(model);
                    wrapper.setNonMdsModel(model);
                    wrapper.setManagable(isManagable);
                    wrapper.setUnmanagableCause(unmanagableCause);
                    wrapper.setNetwork("LAN");
                    wrapper.setNumberOfPorts(totalPorts);
                    int usedPorts = usedPortHash.containsKey(switchDbID) && totalPorts > 0 ? usedPortHash.get(switchDbID) : 0;
                    wrapper.setUsedPorts(usedPorts);
                    wrapper.setAvailPorts(totalPorts - usedPorts);
                    wrapper.setVendor(vendor);
                    wrapper.setRelease(version);
                    wrapper.setLocation(sys_location);
                    wrapper.setContact(sys_contact);
                    wrapper.setPresent(is_present);
                    wrapper.setLastScanTime(lastScanTime);
                    wrapper.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed((System.currentTimeMillis() - sysUpTime) / 10L) : "");
                    wrapper.setStatus(DisplayUtil.getEthSwitchStatus(wrapper));
                    wrapper.setIndex(curIdx + startIdx + 1 + (lanOnly ? 0 : this.sanDataLength));
                    wrapper.setupMapping();
                    if (ipAddress != null) {
                        wrapper.setUsername(this.getSnmpUsername(switchDbID, true));
                    }
                    if (isVdc) {
                        wrapper.setVdcId(vdcId);
                        wrapper.setVdcName(vdcName);
                        wrapper.setVdcMac(vdcMac);
                    } else {
                        wrapper.setVdcId(-1);
                    }
                    wrapper.setFcoeEnabled(isFcoeEnabled);
                    wrapper.setCpuUsage(cpuUsage);
                    wrapper.setMemoryUsage(memoryUsage);
                    if (!swStatus.equals("All") && !SwitchHandler.getSwitchStatusType(wrapper).equals(swStatus)) continue;
                    lanList.add(wrapper);
                    if (recordSize <= 0 || ++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block12;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return lanList;
    }

    public ArrayList<SwitchDO> getLanSwitchListForGroupId(long groupId) {
        ArrayList<SwitchDO> rstList = this.getLanSwitchListForGroupId(0, "All", -1, "", true, groupId);
        return rstList;
    }

    public SwitchNameDO[] getAllLanSwitchesForGroupID(long lid) throws Exception {
        ArrayList<SwitchDO> swLst = SwitchHandler.getInstance().getLanSwitchListForGroupId(lid);
        HashMap swDbIdToCdpMap = GlobalDCManager.getInstance().querCdpIdLanIdBySwitchDbId();
        Collections.sort(swLst);
        SwitchDO[] swDo = swLst.toArray(new SwitchDO[swLst.size()]);
        if (swDo != null) {
            SwitchNameDO[] swNmDO = new SwitchNameDO[swDo.length];
            for (int i = 0; i < swDo.length; ++i) {
                swNmDO[i] = new SwitchNameDO();
                swNmDO[i].name = swDo[i].getLogicalName();
                swNmDO[i].isFex = swDo[i].isFex();
                swNmDO[i].ipAddress = swDo[i].getIpAddress();
                if (swNmDO[i].name == null) {
                    swNmDO[i].name = swNmDO[i].getIpAddress();
                }
                swNmDO[i].isLicensed = !swDo[i].isLicenseViolation();
                swNmDO[i].isManageble = swDo[i].isManagable();
                WwnDO swWWN = swDo[i].getWwn();
                swNmDO[i].wwn = swWWN == null || swWWN.toString().trim().length() == 0 ? new byte[]{} : swWWN.toWwn().getValue();
                swNmDO[i].isMds = swDo[i].getModel() != null && swDo[i].getModel().toUpperCase().indexOf("DS") != -1;
                swNmDO[i].colId = lid;
                swNmDO[i].swDbId = swDo[i].getSwitchDbID();
                long[] rsP = (long[])swDbIdToCdpMap.get(swDo[i].getSwitchDbID());
                if (rsP != null) {
                    SnmpUser credential = SwitchHandler.getSnmpUser(rsP[2]);
                    swNmDO[i].isV3 = credential != null && credential.getSecurityModel() == 3;
                }
                swNmDO[i].isLanSwitch = true;
                swNmDO[i].isCat = swDo[i].getModel() != null && swDo[i].getModel().toUpperCase().indexOf("WS-C") != -1;
            }
            return swNmDO;
        }
        return new SwitchNameDO[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<SwitchDO> getLanSwitchListForGroupId(int startIdx, String swStatus, int recordSize, String sortSql, boolean lanOnly, long groupId) {
        ArrayList<SwitchDO> lanList;
        block12: {
            lanList = new ArrayList<SwitchDO>();
            String lanSql = "select sw.id, sw.ip_address, sw.model_name, sw.sys_name, sw.sys_contact, sw.sys_location, sw.version, sw.serial_number, sw.sys_uptime,sw.vendor,sw.num_ports,sw.is_present,sw.is_manageable, sw.unmanageable_cause, sw.is_vdc, sw.vdc_id, sw.vdc_name,sw.fcoe_enabled, sw.cpu_usage, sw.mem_usage, sw.last_scan_time, sw.vdc_mac, nv.group_id, sw.num_1g_port, sw.num_2g_port, sw.num_4g_port, sw.num_8g_port, sw.num_10g_port, sw.num_16g_port, sw.num_40g_port, sw.num_100g_port  from ethswitch sw,  nav_group_member nv where  sw.id = nv.mem_dbid";
            lanSql = lanSql + (groupId != -1L ? "  AND nv.group_id = ? " : "");
            Connection con = null;
            PreparedStatement stmt = null;
            String sql = lanSql;
            ResultSet rs = null;
            try {
                List<SwitchAssignedLicenseInfo> swLcns = FileLicensingHelper.getInstance().getLicenseInfoSwitchAssignment();
                con = ConnectionManager.getConnection();
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSql, 1004, 1007);
                con.prepareStatement(sql);
                if (groupId != -1L) {
                    stmt.setLong(1, groupId);
                }
                rs = stmt.executeQuery();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long switchDbID = rs.getLong(1);
                    byte[] ipAddress = rs.getBytes(2);
                    String model = rs.getString(3);
                    String sys_name = rs.getString(4);
                    String sys_contact = rs.getString(5);
                    String sys_location = rs.getString(6);
                    String version = rs.getString(7);
                    String serialNo = rs.getString(8);
                    long sysUpTime = rs.getLong(9);
                    String vendor = rs.getString(10);
                    int num_ports = rs.getInt(11);
                    boolean is_present = rs.getBoolean(12);
                    boolean isManagable = rs.getBoolean(13);
                    String unmanagableCause = rs.getString(14);
                    boolean isVdc = rs.getBoolean(15);
                    int vdcId = rs.getInt(16);
                    String vdcName = rs.getString(17);
                    boolean isFcoeEnabled = rs.getBoolean(18);
                    int cpuUsage = rs.getInt(19);
                    int memoryUsage = rs.getInt(20);
                    long lastScanTime = rs.getLong(21);
                    String vdcMac = rs.getString(22);
                    long colId = rs.getLong(23);
                    int num_1gports = rs.getInt(24);
                    int num_2gports = rs.getInt(25);
                    int num_4gports = rs.getInt(26);
                    int num_8gports = rs.getInt(27);
                    int num_10gports = rs.getInt(28);
                    int num_16gports = rs.getInt(29);
                    int num_40gports = rs.getInt(30);
                    int num_100gports = rs.getInt(31);
                    int totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                    SwitchDO wrapper = new SwitchDO();
                    wrapper.setSwitchDbID(switchDbID);
                    wrapper.setLogicalName(sys_name);
                    wrapper.setSwWwnName(serialNo);
                    wrapper.setSerialNumber(serialNo);
                    if (ipAddress != null) {
                        wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                    }
                    wrapper.setColDBId(colId);
                    wrapper.setModel(model);
                    wrapper.setNonMdsModel(model);
                    wrapper.setManagable(isManagable);
                    wrapper.setUnmanagableCause(unmanagableCause);
                    wrapper.setNetwork("LAN");
                    wrapper.setNumberOfPorts(totalPorts);
                    wrapper.setVendor(vendor);
                    wrapper.setRelease(version);
                    wrapper.setLocation(sys_location);
                    wrapper.setContact(sys_contact);
                    wrapper.setPresent(is_present);
                    wrapper.setLastScanTime(lastScanTime);
                    wrapper.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed((System.currentTimeMillis() - sysUpTime) / 10L) : "");
                    wrapper.setStatus(DisplayUtil.getEthSwitchStatus(wrapper));
                    wrapper.setIndex(curIdx + startIdx + 1 + (lanOnly ? 0 : this.sanDataLength));
                    wrapper.setupMapping();
                    if (ipAddress != null) {
                        wrapper.setUsername(this.getSnmpUsername(switchDbID, true));
                    }
                    if (isVdc) {
                        wrapper.setVdcId(vdcId);
                        wrapper.setVdcName(vdcName);
                        wrapper.setVdcMac(vdcMac);
                    } else {
                        wrapper.setVdcId(-1);
                    }
                    wrapper.setFcoeEnabled(isFcoeEnabled);
                    wrapper.setCpuUsage(cpuUsage);
                    wrapper.setMemoryUsage(memoryUsage);
                    this.updateSwitchLicenseInfo(swLcns, wrapper, wrapper.getSwitchDbID());
                    if (!SQLLoader.isKeywordPresent(wrapper.getStatus(), swStatus)) continue;
                    lanList.add(wrapper);
                    if (recordSize <= 0 || ++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block12;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return lanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwitchDO> getPMCollectedLanSwitchListForGroupId(long groupId) {
        ArrayList<SwitchDO> lanList;
        block11: {
            lanList = new ArrayList<SwitchDO>();
            String lanSql = "select sw.id, sw.ip_address, sw.model_name, sw.sys_name, sw.sys_contact, sw.sys_location, sw.version, sw.serial_number, sw.sys_uptime,sw.vendor,sw.num_ports,sw.is_present,sw.is_manageable, sw.unmanageable_cause, sw.is_vdc, sw.vdc_id, sw.vdc_name,sw.fcoe_enabled, sw.cpu_usage, sw.mem_usage, sw.last_scan_time, sw.vdc_mac, nv.group_id, sw.num_1g_port, sw.num_2g_port, sw.num_4g_port, sw.num_8g_port, sw.num_10g_port, sw.num_16g_port, sw.num_40g_port, sw.num_100g_port  from ethswitch sw,  nav_group_member nv where  sw.id = nv.mem_dbid AND sw.is_pm_collect = true";
            lanSql = lanSql + (groupId != -99L ? "  AND nv.group_id = ? " : "");
            Connection con = null;
            PreparedStatement stmt = null;
            String sql = PersistentHelper.getHelper().getQueryString(lanSql);
            ResultSet rs = null;
            try {
                List<SwitchAssignedLicenseInfo> swLcns = FileLicensingHelper.getInstance().getLicenseInfoSwitchAssignment();
                con = ConnectionManager.getConnection();
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                con.prepareStatement(sql);
                if (groupId != -99L) {
                    stmt.setLong(1, groupId);
                }
                rs = stmt.executeQuery();
                int curIdx = 0;
                while (rs.next()) {
                    long switchDbID = rs.getLong(1);
                    byte[] ipAddress = rs.getBytes(2);
                    String model = rs.getString(3);
                    String sys_name = rs.getString(4);
                    String sys_contact = rs.getString(5);
                    String sys_location = rs.getString(6);
                    String version = rs.getString(7);
                    String serialNo = rs.getString(8);
                    long sysUpTime = rs.getLong(9);
                    String vendor = rs.getString(10);
                    int num_ports = rs.getInt(11);
                    boolean is_present = rs.getBoolean(12);
                    boolean isManagable = rs.getBoolean(13);
                    String unmanagableCause = rs.getString(14);
                    boolean isVdc = rs.getBoolean(15);
                    int vdcId = rs.getInt(16);
                    String vdcName = rs.getString(17);
                    boolean isFcoeEnabled = rs.getBoolean(18);
                    int cpuUsage = rs.getInt(19);
                    int memoryUsage = rs.getInt(20);
                    long lastScanTime = rs.getLong(21);
                    String vdcMac = rs.getString(22);
                    long colId = rs.getLong(23);
                    int num_1gports = rs.getInt(24);
                    int num_2gports = rs.getInt(25);
                    int num_4gports = rs.getInt(26);
                    int num_8gports = rs.getInt(27);
                    int num_10gports = rs.getInt(28);
                    int num_16gports = rs.getInt(29);
                    int num_40gports = rs.getInt(30);
                    int num_100gports = rs.getInt(31);
                    int totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                    SwitchDO wrapper = new SwitchDO();
                    wrapper.setSwitchDbID(switchDbID);
                    wrapper.setLogicalName(sys_name);
                    wrapper.setSwWwnName(serialNo);
                    wrapper.setSerialNumber(serialNo);
                    if (ipAddress != null) {
                        wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                    }
                    wrapper.setColDBId(colId);
                    wrapper.setModel(model);
                    wrapper.setNonMdsModel(model);
                    wrapper.setManagable(isManagable);
                    wrapper.setUnmanagableCause(unmanagableCause);
                    wrapper.setNetwork("LAN");
                    wrapper.setNumberOfPorts(totalPorts);
                    wrapper.setVendor(vendor);
                    wrapper.setRelease(version);
                    wrapper.setLocation(sys_location);
                    wrapper.setContact(sys_contact);
                    wrapper.setPresent(is_present);
                    wrapper.setLastScanTime(lastScanTime);
                    wrapper.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed((System.currentTimeMillis() - sysUpTime) / 10L) : "");
                    wrapper.setStatus(DisplayUtil.getEthSwitchStatus(wrapper));
                    wrapper.setIndex(curIdx);
                    wrapper.setupMapping();
                    if (ipAddress != null) {
                        wrapper.setUsername(this.getSnmpUsername(switchDbID, true));
                    }
                    if (isVdc) {
                        wrapper.setVdcId(vdcId);
                        wrapper.setVdcName(vdcName);
                        wrapper.setVdcMac(vdcMac);
                    } else {
                        wrapper.setVdcId(-1);
                    }
                    wrapper.setFcoeEnabled(isFcoeEnabled);
                    wrapper.setCpuUsage(cpuUsage);
                    wrapper.setMemoryUsage(memoryUsage);
                    this.updateSwitchLicenseInfo(swLcns, wrapper, wrapper.getSwitchDbID());
                    lanList.add(wrapper);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block11;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return lanList;
    }

    private String getSnmpUsername(String ipAddress, boolean isLAN) {
        String username = "admin";
        try {
            InetAddress inet = InetAddress.getByName(ipAddress);
            SnmpPeer peer = null;
            if (isLAN) {
                EthSwitchImpl ethSw = DCManager.getInstance().findEthSwitchBySwIp(inet);
                if (ethSw != null) {
                    peer = ethSw.getPeerWithoutCreate();
                }
            } else {
                SwitchImpl sw = SanManager.getInstance().findSwitchByIP(inet);
                if (sw != null) {
                    peer = sw.getPeerWithoutCreate();
                }
            }
            if (peer != null) {
                username = peer.getUserName();
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)("Could not get SNMP username for switch " + ipAddress + ":" + ex));
        }
        return username;
    }

    public ArrayList<SwitchDO> getLanSwitchList(long lanId) {
        ArrayList<SwitchDO> rstList = this.getLanSwitchListForLanId(0, "All", -1, "", true, lanId);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLanSwitchDataLength(DbFilterDO dbFilter, String swStatus) {
        int dataLength;
        block15: {
            String groupLanFilterSqlSuffix;
            block16: {
                dataLength = 0;
                groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
                if (groupLanFilterSqlSuffix != null && groupLanFilterSqlSuffix.length() > 0) {
                    groupLanFilterSqlSuffix = " and ethswitch.id in (" + groupLanFilterSqlSuffix + ")";
                }
                if (swStatus != null && !swStatus.equals("All")) break block16;
                String lanSql = "select count(*) from ethswitch where ethswitch.is_fex=false ";
                Connection con = null;
                PreparedStatement stmt = null;
                String sql = lanSql;
                ResultSet rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement(PersistentHelper.getHelper().getQueryString(sql + groupLanFilterSqlSuffix));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        dataLength = rs.getInt(1);
                    }
                    DbUtil.close(rs);
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex);
                    break block15;
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                }
                DbUtil.close(stmt);
                DbUtil.close(con);
                break block15;
            }
            String lanSql = "select ethswitch.id, ip_address, model_name, sys_name, sys_contact, sys_location, version, serial_number, sys_uptime,vendor,num_ports,is_present,is_manageable, unmanageable_cause, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port  from ethswitch where ethswitch.is_fex=false ";
            Connection con = null;
            PreparedStatement stmt = null;
            String sql = lanSql;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement(PersistentHelper.getHelper().getQueryString(sql + groupLanFilterSqlSuffix));
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long switchDbId = rs.getLong(1);
                    byte[] ipAddress = rs.getBytes(2);
                    String model = rs.getString(3);
                    String sys_name = rs.getString(4);
                    String sys_contact = rs.getString(5);
                    String sys_location = rs.getString(6);
                    String version = rs.getString(7);
                    String serialNo = rs.getString(8);
                    long sysUpTime = rs.getLong(9);
                    String vendor = rs.getString(10);
                    int num_ports = rs.getInt(11);
                    boolean is_present = rs.getBoolean(12);
                    boolean isManagable = rs.getBoolean(13);
                    String unmanagableCause = rs.getString(14);
                    int num_1gports = rs.getInt(15);
                    int num_2gports = rs.getInt(16);
                    int num_4gports = rs.getInt(17);
                    int num_8gports = rs.getInt(18);
                    int num_10gports = rs.getInt(19);
                    int num_16gports = rs.getInt(20);
                    int num_40gports = rs.getInt(21);
                    int num_100gports = rs.getInt(22);
                    int totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports + num_16gports + num_40gports + num_100gports;
                    SwitchDO wrapper = new SwitchDO();
                    wrapper.setLogicalName(sys_name);
                    wrapper.setSwWwnName(serialNo);
                    if (ipAddress != null) {
                        wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                    }
                    wrapper.setModel(model);
                    wrapper.setNonMdsModel(model);
                    wrapper.setManagable(isManagable);
                    wrapper.setUnmanagableCause(unmanagableCause);
                    wrapper.setNetwork("LAN");
                    wrapper.setNumberOfPorts(totalPorts);
                    wrapper.setVendor(vendor);
                    wrapper.setRelease(version);
                    wrapper.setLocation(sys_location);
                    wrapper.setContact(sys_contact);
                    wrapper.setPresent(is_present);
                    wrapper.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed(sysUpTime) : "");
                    wrapper.setStatus(DisplayUtil.getEthSwitchStatus(wrapper));
                    if (ipAddress != null) {
                        wrapper.setUsername(this.getSnmpUsername(switchDbId, true));
                    }
                    wrapper.setupMapping();
                    if (!swStatus.equals("All") && !SwitchHandler.getSwitchStatusType(wrapper).equals(swStatus)) continue;
                    ++dataLength;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block15;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return dataLength;
    }

    public static String getSwitchStatusType(SwitchDO switchDo) {
        String statusType = "All";
        if (!switchDo.isPresent() || !switchDo.isManagable()) {
            return "Unmanaged";
        }
        if (DisplayUtil.isMdsDirector(switchDo) && !DisplayUtil.isHotStandby(switchDo)) {
            return "Warning";
        }
        if (switchDo.getConnUnitStatus() == 4) {
            return "Warning";
        }
        if (switchDo.isLicenseViolation()) {
            return "Warning";
        }
        return "All";
    }

    public static String getSwitchStatus(SwitchDO switchDo) {
        String status = "";
        if (!switchDo.isPresent()) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(switchDo.getLastScanTime()));
        }
        if (!switchDo.isManagable()) {
            if (switchDo.getIpAddress() == null) {
                return "No IP Address";
            }
            if (switchDo.getUnmanagableCause() != null) {
                return switchDo.getUnmanagableCause();
            }
            return "Unreachable";
        }
        StringBuffer sb = new StringBuffer();
        if (DisplayUtil.isMdsDirector(switchDo) && !DisplayUtil.isHotStandby(switchDo)) {
            sb.append("No Hot Standby,");
        }
        if (switchDo.getConnUnitStatus() == 4) {
            sb.append(switchDo.isMds() ? "Module Warning," : "Warning,");
        }
        if (switchDo.isLicenseViolation()) {
            sb.append("License Violation,");
        }
        if (sb.length() > 0) {
            if (switchDo.getLastScanTime() > 0L) {
                sb.setLength(sb.length() - 1);
            }
            status = sb.toString();
            return status;
        }
        status = "ok";
        return status;
    }

    private String getSqlSortSuffix(String sortField, String sortType, boolean forLAN) {
        StringBuilder sortStr = new StringBuilder(" ORDER BY ");
        if (sortField.equals("logicalName")) {
            sortStr.append("SYS_NAME ");
        } else if (sortField.equals("Name")) {
            sortStr.append("SYS_NAME ");
        } else if (sortField.equals("release")) {
            sortStr.append("VERSION ");
        } else if (sortField.equals("serialNumber")) {
            sortStr.append("serial_number ");
        } else if (sortField.equals("nonMdsModel")) {
            if (forLAN) {
                sortStr.append("MODEL_NAME ");
            } else {
                sortStr.append("NON_MDS_MODEL ");
            }
        } else {
            sortStr.append("SYS_NAME ");
        }
        sortStr.append(sortType);
        return sortStr.toString();
    }

    public static void main(String[] args) {
        DbFilterDO dbFilter = new DbFilterDO();
        dbFilter.setSortField("Name");
        dbFilter.setSortType("ASC");
        dbFilter.setNetworkType("SAN");
        SwitchHandler.getInstance().getSwitchDataLength(dbFilter, "All");
        ArrayList<SwitchDO> rstList = SwitchHandler.getInstance().getSwitchList(dbFilter, "All", 0, 31);
        boolean i = false;
    }

    public String printSwitchTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<SwitchDO> rstList = SwitchHandler.getInstance().getSwitchList(dbFilter, status, startIdx, recordSize);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "health", "healthStr");
        return JasperPrintGenerator.getInstance().generatePrintReport("Switches", columnHeader, rstList);
    }

    public String exportSwitchTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<SwitchDO> rstList = SwitchHandler.getInstance().getSwitchList(dbFilter, status, startIdx, recordSize);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "health", "healthStr");
        return JasperPrintGenerator.getInstance().generateExcelReport("Switches", columnHeader, rstList);
    }
}

