/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.VsanDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.web.client.util.LogService;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class VsanHandler {
    private static VsanHandler _Instance = null;
    public static final int CONN_UNIT_WARNING = 4;
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();

    public static VsanHandler getInstance() {
        if (_Instance == null) {
            _Instance = new VsanHandler();
        }
        return _Instance;
    }

    private VsanHandler() {
        this.initSqlSortSuffix();
    }

    public ArrayList<VsanDO> getVsanList(DbFilterDO dbFilter, String swStatus, int startIdx, int recordSize) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        long groupDbId = dbFilter.getGroupId();
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        return this.getVsanList(vsanDbId, fabricDbId, groupDbId, swStatus, startIdx, recordSize, groupFabricFilterSqlSuffix + (sortSqlSuffix == null ? "" : sortSqlSuffix));
    }

    public ArrayList<VsanDO> getVsanList(long vsanDbId) {
        String sqlSuffix = " AND VSAN.ID =" + vsanDbId;
        return this.getVsanList(-1L, -1L, -1L, "All", 0, 31, sqlSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<VsanDO> getVsanList(long vsanDbId, long fabricDbId, long groupDbId, String swStatus, int startIdx, int recordSize, String sqlSuffix) {
        ArrayList<VsanDO> resultList;
        block18: {
            resultList = new ArrayList<VsanDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                if (vsanDbId != -1L) {
                    sql = SQLLoader.getSqlStmt("VsanAction.VSAN_VSAN_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                    stmt.setLong(1, fabricDbId);
                    stmt.setLong(2, vsanDbId);
                } else if (fabricDbId != -1L) {
                    if (groupDbId != -1L) {
                        int groupType = DisplayUtil.getGroupType(con, groupDbId);
                        if (groupType == 1) {
                            sql = SQLLoader.getSqlStmt("VsanAction.VSAN_GROUP_STMT");
                        }
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                        stmt.setLong(1, groupDbId);
                    } else {
                        sql = SQLLoader.getSqlStmt("VsanAction.VSAN_FABRIC_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                        stmt.setLong(1, fabricDbId);
                    }
                } else {
                    sql = SQLLoader.getSqlStmt("VsanAction.VSAN_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                }
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    String fabric = rs.getString(1);
                    String name = rs.getString(2);
                    long vsanId = rs.getLong(3);
                    boolean isUp = rs.getBoolean(4);
                    boolean isDisjoint = rs.getBoolean(5);
                    String zoneset = rs.getString(7);
                    long when = rs.getLong(8);
                    long vDbid = rs.getLong(10);
                    VsanDO vsanDo = new VsanDO();
                    vsanDo.setFabricName(fabric);
                    vsanDo.setVsanId((int)vsanId);
                    vsanDo.setName(name);
                    vsanDo.setNetwork("SAN");
                    String s = "";
                    s = isUp ? s + "Up" : s + "Down";
                    if (isDisjoint) {
                        s = s + ", Segmented";
                    }
                    vsanDo.setStatus(s);
                    if (zoneset != null) {
                        String str = zoneset;
                        if (when != -1L) {
                            str = str + ", ";
                            GregorianCalendar gc = new GregorianCalendar();
                            gc.setTimeInMillis(when);
                            str = str + SnmpTimeticks.getDateFormat().format(new Date(when));
                        }
                        vsanDo.setActZset(str);
                    } else {
                        vsanDo.setActZset("none");
                    }
                    vsanDo.setIndex(curIdx + startIdx + 1);
                    vsanDo.setupMapping();
                    String switchesInStr = this.getMemSwitches(vDbid);
                    vsanDo.setMemSwitches(switchesInStr);
                    if (!SQLLoader.isKeywordPresent(vsanDo.getVsanStatus(), swStatus)) continue;
                    resultList.add(vsanDo);
                    if (++curIdx < recordSize || swStatus != null && (swStatus == null || swStatus.equalsIgnoreCase("Warning"))) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block18;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMemSwitches(long vsanDbId) {
        String membersInStr = "";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = "SELECT  SYS_NAME FROM SWITCH, VSAN, VSAN_DOMAIN_INFO INFO  WHERE (VSAN.ID = INFO.VSAN_ID) AND (INFO.SWITCH_ID = SWITCH.ID)  AND (VSAN.ID=?)";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, vsanDbId);
            rs = SQLLoader.execute(stmt);
            int modCnt = 1;
            while (rs.next()) {
                String swName = rs.getString(1);
                membersInStr = membersInStr + swName;
                membersInStr = membersInStr + (modCnt % 4 == 0 ? "\n" : "  ");
                ++modCnt;
            }
        }
        catch (SQLException ex) {
            try {
                LogService.log((Level)LogService._SEVERE, (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        if (membersInStr.length() > 0) {
            membersInStr = membersInStr.substring(0, membersInStr.length());
        }
        return membersInStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVsanDataLength(DbFilterDO dbFilter, String swStatus) {
        int dataLength;
        block14: {
            dataLength = 0;
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
            try {
                con = ConnectionManager.getConnection();
                long vsanDbId = dbFilter.getVsanDbId();
                long fabricDbId = dbFilter.getFabricDbId();
                long groupDbId = dbFilter.getGroupId();
                if (vsanDbId != -1L) {
                    sql = SQLLoader.getSqlStmt("VsanAction.VSAN_VSAN_STMT");
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, fabricDbId);
                    stmt.setLong(2, vsanDbId);
                } else if (fabricDbId >= 0L) {
                    if (dbFilter.isGroup()) {
                        int groupType = DisplayUtil.getGroupType(con, groupDbId);
                        if (groupType == 1) {
                            sql = SQLLoader.getSqlStmt("VsanAction.VSAN_GROUP_STMT");
                        }
                        stmt = con.prepareStatement(sql);
                        stmt.setLong(1, groupDbId);
                    } else {
                        sql = SQLLoader.getSqlStmt("VsanAction.VSAN_FABRIC_STMT");
                        stmt = con.prepareStatement(sql);
                        stmt.setLong(1, fabricDbId);
                    }
                } else {
                    sql = SQLLoader.getSqlStmt("VsanAction.VSAN_STMT");
                    stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                }
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    boolean isUp = rs.getBoolean(4);
                    boolean isDisjoint = rs.getBoolean(5);
                    VsanDO vsanDo = new VsanDO();
                    String s = "";
                    s = isUp ? s + "Up" : s + "Down";
                    if (isDisjoint) {
                        s = s + ", Segmented";
                    }
                    vsanDo.setStatus(s);
                    if (!SQLLoader.isKeywordPresent(vsanDo.getVsanStatus(), swStatus)) continue;
                    ++dataLength;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block14;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return dataLength;
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("Name", " ORDER BY VSAN.NAME ");
        this._Name2SqlHash.put("name", " ORDER BY VSAN.NAME ");
        this._Name2SqlHash.put("vsanId", " ORDER BY VSAN.VSAN_ID ");
    }

    public static void main(String[] args) {
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        int size = VsanHandler.getInstance().getVsanDataLength(dbFilter, "All");
        boolean i = false;
    }

    public String printVsanTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<VsanDO> rstList = VsanHandler.getInstance().getVsanList(dbFilter, status, startIdx, recordSize);
        return JasperPrintGenerator.getInstance().generatePrintReport("Vsans", columnHeader, rstList);
    }

    public String exportVsanTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<VsanDO> rstList = VsanHandler.getInstance().getVsanList(dbFilter, status, startIdx, recordSize);
        return JasperPrintGenerator.getInstance().generateExcelReport("Vsans", columnHeader, rstList);
    }
}

