/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.san.wo.EndPortDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.jnm.WwnVendor;
import com.cisco.dcbu.lib.mds.zm.ZoneMemberFormat;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.common.model.FilterTreeWrapper;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import com.cisco.dcbu.sm.server.web.wrapper.ZoneMemberDbWrapper;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZoneHandler {
    private static ZoneHandler _Instance = null;
    public static final int CONN_UNIT_WARNING = 4;
    private static final String WWN_DA_SQL = "select wwn from device_alias where alias=?";
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    private Map<String, String> _FilterHash = new HashMap<String, String>();

    public static ZoneHandler getInstance() {
        if (_Instance == null) {
            _Instance = new ZoneHandler();
        }
        return _Instance;
    }

    private ZoneHandler() {
        this.initSqlSortSuffix();
    }

    public ArrayList<ZoneDO> getZoneList(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isIvr) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField()) != null ? this._Name2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType() : "";
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash);
        return this.getZoneList(vsanDbId, fabricDbId, startIdx, recordSize, groupFabricFilterSqlSuffix + colFilterSqlSuffix + sortSqlSuffix, isIvr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ZoneDO> getZoneListByZoneNameAndParentId(String zoneName, long parentID, boolean isIvr) {
        long zoneID;
        Connection con;
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            String sql = "SELECT ZONE.ID FROM ZONE_MEMBER, ZONE WHERE ZONE_MEMBER.ZONE_ID = ZONE.ID AND ZONE.NAME='" + zoneName + "' AND ZONE.PARENT_ID=" + parentID;
            stmt = null;
            rs = null;
            con = null;
            zoneID = -1L;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement(sql);
                rs = SQLLoader.execute(stmt);
                if (!rs.next()) break block5;
                zoneID = rs.getLong(1);
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        if (zoneID > 0L) {
            String sqlSuffix = " AND ZONE.ID =" + zoneID;
            return this.getZoneList(-1L, -1L, 0, 500, sqlSuffix, isIvr);
        }
        return new ArrayList<ZoneDO>();
    }

    public ArrayList<ZoneDO> getZoneList(long zoneDbId, boolean isIvr) {
        String sqlSuffix = " AND ZONE.ID =" + zoneDbId;
        return this.getZoneList(-1L, -1L, 0, 31, sqlSuffix, isIvr);
    }

    public ArrayList<ZoneDO> getZoneList(long vsanDbId, long fabricDbId, int startIdx, int recordSize, String sqlSuffix, boolean isIvr) {
        List<byte[]> memWwnList;
        ArrayList<ZoneDO> resultList = this.getSanZoneList(vsanDbId, fabricDbId, startIdx, recordSize, sqlSuffix, isIvr);
        if (resultList.size() != 0 && (memWwnList = this.getMembers(resultList)).size() != 0) {
            Hashtable<String, EndPortDO> nports = this.getNPorts(memWwnList);
            this.populateZoneMember(nports, resultList);
        }
        return resultList;
    }

    private void populateZoneMember(Hashtable<String, EndPortDO> nports, ArrayList<ZoneDO> resultList) {
        Hashtable domainInfo = this.getDomainInfo();
        for (ZoneDO zoneDo : resultList) {
            this.constructWrapper(nports, domainInfo, zoneDo);
        }
    }

    private void constructWrapper(Hashtable nports, Hashtable domainInfo, ZoneDO wrapper) {
        int vsanId = wrapper.getVsanId();
        boolean isIvr = wrapper.isIvr();
        int memberType = wrapper.getMemberType();
        byte[] memberId = wrapper.getMemberId();
        try {
            wrapper.setVsanIdStr(isIvr ? "IVR" : vsanId + "");
            wrapper.setMemberTypeStr(ZoneMemberFormat.getTypeName(memberType));
            wrapper.setFcIdstr(DisplayUtil.getZoneMemberFcId(memberType, memberId, nports));
            wrapper.setMemberWwn(DisplayUtil.getZoneMemberWwn(vsanId, memberType, memberId, nports));
            wrapper.setSwitchInterface(DisplayUtil.getZoneMemberSwitchInterface(memberType, memberId, nports, vsanId, domainInfo));
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex);
        }
    }

    private List<byte[]> getMembers(ArrayList<ZoneDO> resultList) {
        ArrayList<byte[]> memWwnList = new ArrayList<byte[]>();
        for (ZoneDO zoneDo : resultList) {
            String wwnStr = DisplayUtil.getZoneMemberId(zoneDo.getMemberType(), zoneDo.getMemberId());
            try {
                byte[] memWwn = SnmpString.fromHexString(wwnStr);
                memWwnList.add(memWwn);
            }
            catch (Exception ex) {}
        }
        return memWwnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, EndPortDO> getNPorts(List<byte[]> memWwnList) {
        Hashtable<String, EndPortDO> nports;
        block10: {
            StringBuffer sb = new StringBuffer();
            sb.append(" AND NPORTS.WWN IN ( ");
            for (int i = 0; i < memWwnList.size(); ++i) {
                sb.append("?,");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(" )");
            String sqlSuffix = sb.toString();
            nports = new Hashtable<String, EndPortDO>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection con = null;
            try {
                con = ConnectionManager.getConnection();
                String sql = null;
                sql = SQLLoader.getSql("ZoneAction.NPORT_STMT");
                stmt = con.prepareStatement(sql + sqlSuffix);
                int idx = 0;
                for (byte[] memWwn : memWwnList) {
                    stmt.setBytes(++idx, memWwn);
                }
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    int vsanId = rs.getInt(2);
                    String encName = rs.getString(3);
                    byte[] b1 = rs.getBytes(4);
                    String alias = rs.getString(5);
                    byte[] b2 = rs.getBytes(6);
                    int rawFcId = rs.getInt(7);
                    String fcid = Integer.toHexString(rawFcId);
                    int switchIf = rs.getInt(8);
                    int status = rs.getInt(9);
                    boolean isPresent = rs.getBoolean(11);
                    byte[] b3 = rs.getBytes(12);
                    String sysName = rs.getString(13);
                    int switchType = rs.getInt(14);
                    String deviceAlias = rs.getString(16);
                    String ifDeviceName = rs.getString(17);
                    EndPortDO wrapper = new EndPortDO();
                    wrapper.setVsanId(String.valueOf(vsanId));
                    wrapper.setEnclosure(encName);
                    if (b1 != null && b1.length == 4) {
                        wrapper.setEnclosureIp(InetAddress.getByAddress(b1));
                    }
                    wrapper.setAlias(alias);
                    wrapper.setDeviceAlias(deviceAlias);
                    Wwn obj = DisplayUtil.getWwn(b2);
                    wrapper.setPortWwn(obj != null ? ((Object)obj).toString() : "");
                    wrapper.setFcIdStr("0x" + fcid);
                    wrapper.setRawFcid(rawFcId + "");
                    String ip = "";
                    if (b3 != null && b3.length == 4) {
                        ip = InetAddress.getByAddress(b3).getHostAddress();
                    }
                    String switchDisplayName = sysName != null ? sysName : ip;
                    wrapper.setSwitchInterface(switchDisplayName == null || switchDisplayName.length() == 0 ? "" : switchDisplayName + " " + ifDeviceName);
                    wrapper.setLinkStatus(DisplayUtil.getEndPortStatus(isPresent, status));
                    if (obj == null) continue;
                    nports.put(SnmpString.toHexString(b2), wrapper);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return nports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ZoneDO> getSanZoneList(long vsanDbId, long fabricDbId, int startIdx, int recordSize, String sqlSuffix, boolean isIvr) {
        ArrayList<ZoneDO> resultList;
        block15: {
            resultList = new ArrayList<ZoneDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                if (vsanDbId != -1L) {
                    sql = SQLLoader.getSqlStmt("ZoneAction.ZONE_VSAN_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, PersistentHelper.getHelper().getQueryString(sql + sqlSuffix), 1004, 1007);
                    stmt.setBoolean(1, isIvr);
                    stmt.setLong(2, fabricDbId);
                    stmt.setLong(3, vsanDbId);
                } else if (fabricDbId != -1L) {
                    sql = isIvr ? SQLLoader.getSqlStmt("ZoneAction.IVR_ZONE_FABRIC_STMT") : SQLLoader.getSqlStmt("ZoneAction.ZONE_FABRIC_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, PersistentHelper.getHelper().getQueryString(sql + sqlSuffix), 1004, 1007);
                    stmt.setLong(1, fabricDbId);
                } else {
                    sql = isIvr ? SQLLoader.getSqlStmt("ZoneAction.IVR_ZONE_STMT") : SQLLoader.getSqlStmt("ZoneAction.ZONE_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, PersistentHelper.getHelper().getQueryString(sql + sqlSuffix), 1004, 1007);
                }
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    String fabric = rs.getString(1);
                    int vsanId = rs.getInt(2);
                    boolean ivrBool = rs.getBoolean(4);
                    String name = rs.getString(6);
                    int memberType = rs.getInt(8);
                    byte[] memberId = rs.getBytes(9);
                    long[] luns = PersistentHelper.getHelper().getLongArray(rs, 10);
                    String zoneset = rs.getString(12);
                    String memberName = rs.getString(13);
                    ZoneDO zoneDo = new ZoneDO();
                    ArrayList<Long> l = new ArrayList<Long>();
                    if (luns != null) {
                        Arrays.sort(luns);
                    }
                    if (luns != null) {
                        for (int i = 0; i < luns.length; ++i) {
                            long lun = luns[i];
                            l.add(new Long(lun));
                        }
                    }
                    if ((zoneset == null || zoneset.length() < 1) && isIvr) {
                        zoneset = rs.getString(14);
                    }
                    zoneDo.setZoneSet(zoneset);
                    zoneDo.setFabricName(fabric);
                    zoneDo.setVsanId(vsanId);
                    zoneDo.setIvr(isIvr);
                    zoneDo.setName(name);
                    zoneDo.setMemberType(memberType);
                    zoneDo.setMemberId(memberId);
                    zoneDo.setLunId(l);
                    zoneDo.setNetwork("SAN");
                    zoneDo.setMemberName(memberName);
                    zoneDo.setIndex(curIdx + startIdx + 1);
                    resultList.add(zoneDo);
                    if (++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block15;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZoneDataLength(DbFilterDO dbFilter, boolean isIvr) {
        int dataLength;
        block10: {
            dataLength = 0;
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
            String colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash);
            try {
                con = ConnectionManager.getConnection();
                long vsanDbId = dbFilter.getVsanDbId();
                long fabricDbId = dbFilter.getFabricDbId();
                if (vsanDbId != -1L) {
                    sql = SQLLoader.getSqlStmt("ZoneAction.ZONE_VSAN_STMT");
                    stmt = con.prepareStatement(sql);
                    stmt.setBoolean(1, isIvr);
                    stmt.setLong(2, fabricDbId);
                    stmt.setLong(3, vsanDbId);
                } else if (fabricDbId != -1L) {
                    sql = isIvr ? SQLLoader.getSqlStmt("ZoneAction.IVR_ZONE_FABRIC_STMT") : SQLLoader.getSqlStmt("ZoneAction.ZONE_FABRIC_STMT");
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, fabricDbId);
                } else {
                    sql = isIvr ? SQLLoader.getSqlStmt("ZoneAction.IVR_ZONE_STMT") : SQLLoader.getSqlStmt("ZoneAction.ZONE_STMT");
                    stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix + colFilterSqlSuffix);
                }
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    ++dataLength;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDomainInfo() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        Connection con = null;
        String sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSql("ZoneAction.DOMAIN_STMT");
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                int vsan = rs.getInt(1);
                int domainId = rs.getInt(2);
                byte[] addr = rs.getBytes(4);
                String ipAddress = null;
                if (addr != null) {
                    ipAddress = InetAddress.getByAddress(addr).getHostAddress();
                }
                if (ipAddress == null) continue;
                info.put(vsan + ":" + domainId, ipAddress);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return info;
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("Name", " ORDER BY ZONE.NAME ");
        this._Name2SqlHash.put("name", " ORDER BY ZONE.NAME ");
        this._Name2SqlHash.put("fabricName", " ORDER BY FABRIC.NAME ");
        this._Name2SqlHash.put("vsan", " ORDER BY VSAN.VSAN_ID ");
        this._Name2SqlHash.put("vsanId", " ORDER BY VSAN.VSAN_ID ");
        this._Name2SqlHash.put("memberName", " ORDER BY ZONE_MEMBER.NAME ");
        this._FilterHash.put("vsanId", " VSAN.VSAN_ID = ");
        this._FilterHash.put("zoneSet", " ENF_ZONESET_NAME like ");
        this._FilterHash.put("name", " ZONE.NAME like ");
    }

    public HashMap getNpvLinkpWWNfWWNData(HashMap epMap) throws Exception {
        HashMap<Object, Object[]> npvFWWN2NpWWN = new HashMap<Object, Object[]>();
        if (!SQLLoader.canExecute()) {
            return npvFWWN2NpWWN;
        }
        Connection con = null;
        Object sql = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String npvSqlStmt = "select DISTINCT ep.id, swP.switch_id from  END_PORT ep, SWITCH_PORT swP,npv_link npv where npv.np_switch_id=swP.switch_id AND  swP.id=ep.switch_port_id ORDER BY ep.id";
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, npvSqlStmt, 1004, 1007);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            while (rs.next()) {
                Object[] vData = new Object[5];
                vData[0] = rs.getLong(1);
                vData[1] = rs.getLong(2);
                npvFWWN2NpWWN.put(vData[0], vData);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
        }
        catch (SQLException ex) {
            this._Log.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            ConnectionManager.returnConnection(con);
        }
        return npvFWWN2NpWWN;
    }

    public HashMap getZoneMemberInfoDB(long fabricId, long vsanId, long grpId) throws SQLException, Exception {
        return (HashMap)this.getZoneMemberAndUsedEndPortInfoInfo(fabricId, vsanId, grpId)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getWWNForDeviceAlias(String devicealias) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            con = null;
            stmt = null;
            rs = null;
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement(WWN_DA_SQL);
            stmt.setString(1, devicealias);
            rs = SQLLoader.execute(stmt);
            if (!rs.next()) break block5;
            byte[] byArray = rs.getBytes(1);
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            return byArray;
        }
        try {
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
        }
        catch (Exception ex) {
            try {
                this._Log.error((Object)("Failed to get WWN for " + devicealias + "  " + ex.getMessage()));
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return null;
    }

    public Object[] getZoneMemberAndUsedEndPortInfoInfo(FilterTreeWrapper selected) throws SQLException, Exception {
        long fabricId = selected.getFabricId();
        long vsanId = selected.getVsanId();
        long grpId = selected.getNavGroupId();
        return this.getZoneMemberAndUsedEndPortInfoInfo(fabricId, vsanId, grpId);
    }

    public Object[] getZoneMemberAndUsedEndPortInfoInfo(long fabricId, long vsanId) throws SQLException, Exception {
        return this.getZoneMemberAndUsedEndPortInfoInfo(fabricId, vsanId, -1L);
    }

    public Object[] getZoneMemberAndUsedEndPortInfoInfo(long fabricId, long vsanId, long grpId) throws SQLException, Exception {
        Statement stmt;
        Connection con;
        HashMap epMap;
        HashMap data;
        block22: {
            boolean groupScope = grpId > 0L;
            boolean vsanScope = !groupScope && vsanId > 0L;
            boolean fabricScope = !groupScope && fabricId != -1L && vsanId <= 0L;
            data = new HashMap();
            epMap = null;
            if (!SQLLoader.canExecute()) {
                return new Object[]{data, epMap};
            }
            con = null;
            String sql = null;
            stmt = null;
            ResultSet rs = null;
            try {
                ArrayList fabLst = null;
                if (groupScope) {
                    ArrayList gnGm = NavigationUtil.getInstance().buildGrpIdLists();
                    NavigationUtil.NavGroupMember theGrp = null;
                    if (gnGm != null && gnGm.size() > 0) {
                        NavigationUtil.NavGroupMember sanGrp = (NavigationUtil.NavGroupMember)gnGm.get(0);
                        theGrp = NavigationUtil.findNaveGroup(sanGrp, grpId);
                        fabLst = NavigationUtil.getAllFabricsInGroup(grpId, sanGrp);
                    }
                    if (fabLst == null || fabLst.size() == 0) {
                        this._Log.error((Object)("The group with ID " + grpId + ", " + (theGrp != null ? theGrp.mem_name : "") + " contains no SAN Fabrics."));
                        throw new Exception("The group with ID " + grpId + ", " + (theGrp != null ? theGrp.mem_name : "") + " contains no SAN Fabrics.");
                    }
                }
                String sqlStatements2 = "ZoneAction.ZONE_INFO_STMT_ALL_ZONE_MEMBERS";
                String sqlStatements3 = "ZoneAction.ZONE_INFO_STMT_VSAN_FABRIC";
                con = ConnectionManager.getConnection();
                Object[] ePortsData = this.getAllEndPortsMapsDB();
                epMap = ePortsData.length < 1 ? new HashMap() : (HashMap)ePortsData[0];
                HashMap spMap = ePortsData.length < 2 ? new HashMap() : (HashMap)ePortsData[1];
                HashMap<Long, Object[]> vsanMap = new HashMap<Long, Object[]>();
                sql = SQLLoader.getSql(sqlStatements3);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = SQLLoader.execute((PreparedStatement)stmt);
                while (rs.next()) {
                    Object[] vData = new Object[5];
                    vData[0] = rs.getLong(2);
                    vData[1] = rs.getInt(3);
                    vData[2] = rs.getString(4);
                    if (vData[2] == null) {
                        vData[2] = "";
                    }
                    vData[3] = rs.getString(5);
                    vsanMap.put(rs.getLong(1), vData);
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
                sql = SQLLoader.getSql(sqlStatements2);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = SQLLoader.execute((PreparedStatement)stmt);
                long epId = -1L;
                long spId = -1L;
                while (rs.next()) {
                    long rsZoneDbId;
                    ArrayList<ZoneMemberDbWrapper> obList;
                    boolean isIvr = rs.getBoolean(4);
                    long zoneParentDbId = rs.getLong(3);
                    if (vsanScope && rs.getLong(3) != vsanId) continue;
                    long selFabricId = fabricId;
                    if (fabricScope && isIvr && zoneParentDbId != selFabricId) continue;
                    Object[] vData = (Object[])vsanMap.get(zoneParentDbId);
                    if (!isIvr && fabricScope && selFabricId != (Long)vData[0] || isIvr && fabricScope && selFabricId != zoneParentDbId) continue;
                    if (groupScope) {
                        boolean foundFabric = false;
                        for (int f = 0; f < fabLst.size(); ++f) {
                            NavigationUtil.NavGroupMember nmm = (NavigationUtil.NavGroupMember)fabLst.get(f);
                            if ((!isIvr || zoneParentDbId != nmm.mem_dbid) && (isIvr || vData == null || (Long)vData[0] != nmm.mem_dbid)) continue;
                            foundFabric = true;
                            selFabricId = nmm.mem_dbid;
                            break;
                        }
                        if (!foundFabric) continue;
                    }
                    if ((obList = (ArrayList<ZoneMemberDbWrapper>)data.get(rsZoneDbId = rs.getLong(1))) == null) {
                        obList = new ArrayList<ZoneMemberDbWrapper>();
                    }
                    epId = rs.getLong(10);
                    spId = rs.getLong(8);
                    Object[] epData = (Object[])epMap.get(epId);
                    ZoneMemberDbWrapper zmDb = this.buildZnMemDataWrapper(rs, vsanMap, epData, vData);
                    zmDb.zoneMemParentDBID = zoneParentDbId;
                    if (epId != -1L) {
                        if (epData == null) continue;
                        zmDb.zoneMemIsHost = ((Integer)epData[1] & 2) > 0;
                        zmDb.zoneMemIsStorage = ((Integer)epData[1] & 1) > 0;
                        zmDb.zoneMemEncName = epData[2].toString();
                        zmDb.epVsanName = epData[4].toString();
                        zmDb.epVsanDbIndex = (Long)epData[3];
                        Object[] epVData = (Object[])vsanMap.get(zmDb.epVsanDbIndex);
                        zmDb.epVsanIndex = (Integer)epVData[1];
                        zmDb.epVsanName = epVData[2].toString();
                        zmDb.zoneMemName = epData[5].toString();
                        zmDb.slot = (Short)epData[13];
                        zmDb.switchDbId = (Long)epData[14];
                        zmDb.isNpy = (Boolean)epData[15];
                        if (zmDb.zoneMemIsIVR && (long)zmDb.epVsanIndex == zmDb.zoneMemIvrVsanIndex) {
                            zmDb.zoneMemIvrVsanDbId = zmDb.epVsanDbIndex;
                        }
                        epData[11] = Boolean.TRUE;
                        obList.add(zmDb);
                        data.put(rsZoneDbId, obList);
                        continue;
                    }
                    if (spId != -1L) {
                        ArrayList epDataLst = (ArrayList)spMap.get(spId);
                        if (epDataLst == null) continue;
                        for (int ii = 0; ii < epDataLst.size(); ++ii) {
                            Object[] spEpData = (Object[])epDataLst.get(ii);
                            ZoneMemberDbWrapper zmDbSp = this.buildZnMemDataWrapper(rs, vsanMap, spEpData, vData);
                            spEpData[11] = Boolean.TRUE;
                            obList.add(zmDbSp);
                        }
                        data.put(rsZoneDbId, obList);
                        continue;
                    }
                    if (zmDb.zoneMemType != 1 && zmDb.zoneMemType != 10) continue;
                    if (zmDb.zoneMemType == 1) {
                        WwnVendor wVen = WwnDictionary.getWwnVendor(zmDb.zonememId);
                        zmDb.zoneMemIsHost = wVen != null ? wVen.isHost() || wVen.isCisco() : true;
                        zmDb.zoneMemIsStorage = !zmDb.zoneMemIsHost;
                        zmDb.zoneMemEncName = zmDb.zoneMemName;
                        zmDb.zonememWWN = zmDb.zonememId;
                        obList.add(zmDb);
                        data.put(rsZoneDbId, obList);
                        continue;
                    }
                    if (zmDb.zoneMemType != 10) continue;
                    zmDb.zoneMemIsHost = true;
                    zmDb.zoneMemIsStorage = !zmDb.zoneMemIsHost;
                    zmDb.zoneMemEncName = new String(zmDb.zonememId);
                    zmDb.zonememWWN = this.getWWNForDeviceAlias(zmDb.zoneMemEncName);
                    obList.add(zmDb);
                    data.put(rsZoneDbId, obList);
                }
                if (rs == null) break block22;
            }
            catch (SQLException ex) {
                try {
                    this._Log.error((Object)ex.getMessage());
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    ConnectionManager.returnConnection(con);
                    throw throwable;
                }
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        ConnectionManager.returnConnection(con);
        return new Object[]{data, epMap};
    }

    private ZoneMemberDbWrapper buildZnMemDataWrapper(ResultSet rs, HashMap vsanMap, Object[] epData, Object[] zoneVsanData) throws Exception {
        Object[] epVData;
        ZoneMemberDbWrapper zmDbSp = new ZoneMemberDbWrapper();
        zmDbSp.zoneDbId = rs.getLong(1);
        zmDbSp.zoneName = rs.getString(2);
        zmDbSp.zonememId = rs.getBytes(5);
        zmDbSp.zoneMemIsIVR = rs.getBoolean(4);
        zmDbSp.ivrRegionId = rs.getInt(12);
        zmDbSp.zoneMemIvrVsanIndex = rs.getInt(11);
        zmDbSp.zoneMemSwInterface = rs.getString(9);
        zmDbSp.zoneMemType = rs.getInt(6);
        zmDbSp.zoneMemName = rs.getString(7);
        zmDbSp.zoneMemParentDBID = rs.getLong(3);
        if (epData != null) {
            zmDbSp.zoneMemName = epData[5].toString();
            zmDbSp.zoneMemIsHost = ((Integer)epData[1] & 2) > 0;
            zmDbSp.zoneMemIsStorage = ((Integer)epData[1] & 1) > 0;
            zmDbSp.zoneMemEncName = epData[2].toString();
            zmDbSp.epVsanName = epData[4].toString();
            zmDbSp.epVsanDbIndex = (Long)epData[3];
            zmDbSp.zonememWWN = (byte[])epData[10];
            zmDbSp.slot = (Short)epData[13];
            zmDbSp.switchDbId = (Long)epData[14];
            zmDbSp.isNpy = (Boolean)epData[15];
        }
        if ((epVData = (Object[])vsanMap.get(zmDbSp.epVsanDbIndex)) != null) {
            zmDbSp.epVsanIndex = (Integer)epVData[1];
            zmDbSp.epVsanName = epVData[2].toString();
        }
        if (!zmDbSp.zoneMemIsIVR) {
            zmDbSp.zoneVsanIndex = (Integer)zoneVsanData[1];
            zmDbSp.zoneVsanName = zoneVsanData[2].toString();
            zmDbSp.fabricName = zoneVsanData[3].toString();
        } else {
            long zoneParentDbId = rs.getLong(3);
            for (Map.Entry obEntry : vsanMap.entrySet()) {
                long vDbId = (Long)obEntry.getKey();
                Object[] vsanDataMore = (Object[])obEntry.getValue();
                if (zoneParentDbId != (Long)vsanDataMore[0]) continue;
                zmDbSp.fabricName = (String)vsanDataMore[3];
                if (zmDbSp.zoneMemIvrVsanIndex != (long)((Integer)vsanDataMore[1]).intValue()) continue;
                zmDbSp.ivrVsanName = (String)vsanDataMore[2];
                zmDbSp.zoneMemIvrVsanDbId = vDbId;
            }
        }
        return zmDbSp;
    }

    public Object[] getAllEndPortsMapsDB() throws SQLException, Exception {
        if (!SQLLoader.canExecute()) {
            return null;
        }
        Connection con = null;
        String sql = null;
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<Long, Object[]> epMap = new HashMap<Long, Object[]>();
        HashMap<Long, ArrayList<Object[]>> spMap = new HashMap<Long, ArrayList<Object[]>>();
        try {
            HashMap npvMap = this.getNpvLinkpWWNfWWNData(epMap);
            String sqlStatements1 = "ZoneAction.ZONE_INFO_STMT_END_PORTS_EXT";
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSql(sqlStatements1);
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            while (rs.next()) {
                Object[] epData;
                epData = new Object[]{rs.getLong(2), rs.getInt(3), rs.getString(4), rs.getLong(5), rs.getString(6), rs.getString(7), rs.getLong(1), rs.getLong(8), rs.getString(9), rs.getString(10), rs.getBytes(11), Boolean.FALSE, rs.getString(12), rs.getShort(13), rs.getLong(14), npvMap.get(epData[6]) != null};
                if (epData[5] == null || epData[5].toString().trim().length() == 0) {
                    epData[5] = WwnDictionary.getWwnAlias((byte[])epData[10]);
                }
                epMap.put(rs.getLong(1), epData);
                long spid = rs.getLong(2);
                ArrayList<Object[]> epLst = (ArrayList<Object[]>)spMap.get(spid);
                if (epLst == null) {
                    epLst = new ArrayList<Object[]>();
                }
                epLst.add(epData);
                spMap.put(spid, epLst);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
        }
        catch (SQLException ex) {
            this._Log.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            ConnectionManager.returnConnection(con);
        }
        return new Object[]{epMap, spMap};
    }

    public static void main(String[] args) {
        DbFilterDO dbFilter = new DbFilterDO();
        dbFilter.setSortField("Name");
        dbFilter.setSortType("ASC");
        ArrayList<ZoneDO> rstList = ZoneHandler.getInstance().getZoneList(dbFilter, 0, 31, true);
        boolean i = false;
    }

    public String printZoneTable(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isIvr, String[] columnHeader) {
        ArrayList<ZoneDO> rstList = ZoneHandler.getInstance().getZoneList(dbFilter, startIdx, recordSize, isIvr);
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("VSAN", HorizontalAlign.RIGHT);
        return JasperPrintGenerator.getInstance().generatePrintReport("Zones", columnHeader, columnAlignment, rstList);
    }

    public String exportZoneTable(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isIvr, String[] columnHeader) {
        ArrayList<ZoneDO> rstList = ZoneHandler.getInstance().getZoneList(dbFilter, startIdx, recordSize, isIvr);
        return JasperPrintGenerator.getInstance().generateExcelReport("Zones", columnHeader, rstList);
    }
}

