/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.util.Filter;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.inventory.GigEStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.OidStatHandler;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.report.LanDetailReport;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LanPerformanceReport
extends ReportInfo {
    private Collection detailList;
    private Logger _Log = Logger.getLogger((String)"fms.lanReport");
    protected Collection<ColumnSet> columnSets = null;
    private Collection statsTableColumns = null;
    private Collection cpuTableColumns = null;
    private Collection memoryTableColumns = null;

    public LanPerformanceReport(String reportName) {
        super(reportName);
    }

    public LanPerformanceReport(String reportName, boolean showDetails) {
        super(reportName);
    }

    @Override
    public int getReportType() {
        return 4;
    }

    @Override
    public Collection getDataList() {
        if (this.dataList == null) {
            try {
                this.dataList = new ArrayList();
                this.detailList = new ArrayList();
                this.populateDetailList();
                ArrayList<String[]> tocList = new ArrayList<String[]>();
                String[] tocEntry = new String[]{"1  Performance", null, "1"};
                tocList.add(tocEntry);
                for (Object nextReport : this.detailList) {
                    LanDetailReport next = (LanDetailReport)nextReport;
                    if (next.getAnchor() == null) continue;
                    tocEntry = new String[]{next.getName(), next.getAnchor(), "2"};
                    tocList.add(tocEntry);
                }
                if (tocList.size() > 0) {
                    this.tocContent = tocList;
                }
            }
            catch (Exception e) {
                this._Log.warn((Object)e.getMessage(), (Throwable)e);
                this.handleException(e);
                this.dataList = new ArrayList();
            }
        }
        return this.dataList;
    }

    @Override
    public List<String[]> getTocContent() {
        this.getDataList();
        return this.tocContent;
    }

    private Collection getStatsColumns() {
        if (this.statsTableColumns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("", "index"), new TableColumn("Name", "entityName"), new TableColumn("Speed/sec", "speedStr"), new TableColumn("Avg. Rx/sec", "avgRxStr"), new TableColumn("Avg. Tx/sec", "avgTxStr"), new TableColumn("(Rx+Tx)/sec", "rxTxStr"), new TableColumn("Peak Rx/sec", "maxRxStr"), new TableColumn("Peak Tx/sec", "maxTxStr"), new TableColumn("Errors", "errorStr"), new TableColumn("Discards", "discardStr"), new TableColumn("Last Updated", "lastUpdateTimeStr")};
            this.statsTableColumns = Arrays.asList(tCols);
        }
        return this.statsTableColumns;
    }

    private Collection getTopCPUColumns() {
        if (this.cpuTableColumns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("", "index"), new TableColumn("Switch", "entityName"), new TableColumn("CPU Name", "title"), new TableColumn("Avg %", "avgTxStr"), new TableColumn("Peak %", "maxRxStr"), new TableColumn("Last Updated", "lastUpdateTimeStr")};
            this.cpuTableColumns = Arrays.asList(tCols);
        }
        return this.cpuTableColumns;
    }

    private Collection getTopMemoryColumns() {
        if (this.memoryTableColumns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("", "index"), new TableColumn("Switch", "entityName"), new TableColumn("Memory Name", "title"), new TableColumn("Avg %", "avgTxStr"), new TableColumn("Peak %", "maxRxStr"), new TableColumn("Last Updated", "lastUpdateTimeStr")};
            this.memoryTableColumns = Arrays.asList(tCols);
        }
        return this.memoryTableColumns;
    }

    private void populateDetailList() throws Exception {
        long lanGroupId = (Long)this.getFilterValue("Lan_Group_Id");
        String scopeXML = (String)this.getFilterValue("Scope_XML");
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, lanGroupId, "", "");
        dbFilter.setNetworkType("LAN");
        dbFilter.setGroupFilterXml(scopeXML);
        dbFilter.setLimit(20);
        ArrayList<StatisticsDataDO> topISLs = IslStatHandler.getInstance().getIslStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), false);
        List<String[]> charts = null;
        if (topISLs.isEmpty()) {
            StatisticsDataDO noRecordStat = new StatisticsDataDO(-1L, -1L);
            noRecordStat.setEntityName("No Records");
            topISLs.add(noRecordStat);
        } else {
            charts = this.getCharts(topISLs);
        }
        LanDetailReport reportHolder = new LanDetailReport(new Object[]{"#ISLs_Trunks", "1.1  ISLs/Trunks -  Filtered on  No. of Records=20, interval=24 Hours", topISLs, ""});
        reportHolder.setHeaders(this.getStatsColumns());
        if (charts != null) {
            reportHolder.setCharts(charts);
        }
        this.detailList.add(reportHolder);
        charts = null;
        ArrayList<StatisticsDataDO> statList = GigEStatHandler.getInstance().getGigEStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), false);
        if (statList.isEmpty()) {
            StatisticsDataDO noRecordStat = new StatisticsDataDO(-1L, -1L);
            noRecordStat.setEntityName("No Records");
            statList.add(noRecordStat);
        } else {
            charts = this.getCharts(statList);
        }
        reportHolder = new LanDetailReport(new Object[]{"#Ethernet", "1.2  Ethernet -  Filtered on  No. of Records=20, interval=24 Hours", statList, ""});
        reportHolder.setHeaders(this.getStatsColumns());
        if (charts != null) {
            reportHolder.setCharts(charts);
        }
        this.detailList.add(reportHolder);
        charts = null;
        int why = OidStatHandler.getInstance().getOidStatDataLength(dbFilter, "24 Hours", OidStatHandler.TYPE_CPU);
        ArrayList<StatisticsDataDO> topCPUs = OidStatHandler.getInstance().getOidStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), OidStatHandler.TYPE_CPU);
        if (topCPUs.isEmpty()) {
            StatisticsDataDO noRecordStat = new StatisticsDataDO(-1L, -1L);
            noRecordStat.setEntityName("No Records");
            topCPUs.add(noRecordStat);
        } else {
            charts = this.getChartsForOid(topCPUs, OidStatHandler.TYPE_CPU);
        }
        reportHolder = new LanDetailReport(new Object[]{"#CPU", "1.3  CPU -  Filtered on  No. of Records=20, interval=24 Hours", topCPUs, ""});
        reportHolder.setHeaders(this.getTopCPUColumns());
        if (charts != null) {
            reportHolder.setCharts(charts);
        }
        this.detailList.add(reportHolder);
        charts = null;
        int butWhy = OidStatHandler.getInstance().getOidStatDataLength(dbFilter, "24 Hours", OidStatHandler.TYPE_MEMORY);
        ArrayList<StatisticsDataDO> topMemorys = OidStatHandler.getInstance().getOidStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), OidStatHandler.TYPE_MEMORY);
        if (topMemorys.isEmpty()) {
            StatisticsDataDO noRecordStat = new StatisticsDataDO(-1L, -1L);
            noRecordStat.setEntityName("No Records");
            topMemorys.add(noRecordStat);
        } else {
            charts = this.getChartsForOid(topMemorys, OidStatHandler.TYPE_MEMORY);
        }
        reportHolder = new LanDetailReport(new Object[]{"#Memory", "1.4  Memory -  Filtered on  No. of Records=20, interval=24 Hours", topMemorys, ""});
        reportHolder.setHeaders(this.getTopMemoryColumns());
        if (charts != null) {
            reportHolder.setCharts(charts);
        }
        this.detailList.add(reportHolder);
    }

    @Override
    public Collection getDetails() {
        return this.detailList;
    }

    @Override
    public String getNote() {
        return null;
    }

    @Override
    public boolean getShowFilter() {
        return true;
    }

    @Override
    public Collection getColumnSets() {
        if (this.columnSets == null) {
            if (this.columns == null) {
                this.getColumns();
            }
            this.columnSets = new ArrayList<ColumnSet>();
            ColumnSet set = null;
            Iterator itr = this.columns.iterator();
            set = DisplayUtil.initSet(itr, this.columns.size(), "");
            this.columnSets.add(set);
        }
        return this.columnSets;
    }

    private List<String[]> getCharts(List<StatisticsDataDO> dataList) {
        if (dataList == null) {
            return null;
        }
        ArrayList<String[]> charts = new ArrayList<String[]>();
        String toFile = (String)this.getFilterValue(Filter.TOFILE);
        File op = new File(toFile);
        for (StatisticsDataDO nextData : dataList) {
            try {
                long fid = nextData.getFid();
                PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK((int)fid));
                Map<String, byte[]> chartFromServer = pmRif.getPmCharts(nextData.getRrdFile(), nextData.getPmtype(), 1, 0L, System.currentTimeMillis() / 1000L, 0.0, 0.0, -1.0, -1.0);
                charts.add(this.saveChart(op, chartFromServer, nextData.getEntityName()));
            }
            catch (Exception e) {
                this._Log.error((Object)("LAN Performance Report - Error in processing rrd file: " + nextData.getRrdFile() + " error:" + e));
                this.handleException(e);
            }
        }
        return charts;
    }

    private List<String[]> getChartsForOid(List<StatisticsDataDO> dataList, int type) {
        if (dataList == null) {
            return null;
        }
        ArrayList<String[]> charts = new ArrayList<String[]>();
        String toFile = (String)this.getFilterValue(Filter.TOFILE);
        File op = new File(toFile);
        for (StatisticsDataDO nextData : dataList) {
            try {
                long fid = nextData.getFid();
                PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK((int)fid));
                Map<String, byte[]> chartFromServer = pmRif.getPmCharts(nextData.getRrdFile(), nextData.getPmtype(), 1, 0L, System.currentTimeMillis() / 1000L, 0.0, 0.0, -1.0, -1.0);
                if (type == OidStatHandler.TYPE_CPU) {
                    charts.add(this.saveChart(op, chartFromServer, "CPU " + nextData.getEntityName()));
                    continue;
                }
                charts.add(this.saveChart(op, chartFromServer, "Memory " + nextData.getEntityName()));
            }
            catch (Exception e) {
                this._Log.error((Object)("LAN Performance Report - Error in processing rrd file: " + nextData.getRrdFile() + " error:" + e));
                this.handleException(e);
            }
        }
        return charts;
    }

    protected String[] saveChart(File op, Map<String, byte[]> fromServer, String name) {
        String gFileRelative;
        String dir = op.getParent();
        String relativeDir = REPORT_DIR + dir.substring(dir.indexOf("reports") + 7);
        String relativeUri = relativeDir.replaceAll(Pattern.quote(File.separator), "/");
        String opFile = op.getName();
        String fileSuffix = "_day.png";
        String[] rv = new String[]{"", "No Errors or Discards found."};
        String gFile = dir + File.separator + opFile.substring(0, opFile.lastIndexOf(46)) + "_" + name.hashCode() + fileSuffix;
        rv[0] = gFileRelative = relativeUri + "/" + opFile.substring(0, opFile.lastIndexOf(46)) + "_" + name.hashCode() + fileSuffix;
        String eFile = dir + File.separator + opFile.substring(0, opFile.lastIndexOf(46)) + "_" + name.hashCode() + "_err" + fileSuffix;
        String eFileRelative = relativeUri + "/" + opFile.substring(0, opFile.lastIndexOf(46)) + "_" + name.hashCode() + "_err" + fileSuffix;
        for (String key : fromServer.keySet()) {
            if (key.indexOf("err") >= 0) {
                rv[1] = eFileRelative;
                this.saveImage(eFile, fromServer.get(key));
                continue;
            }
            this.saveImage(gFile, fromServer.get(key));
        }
        return rv;
    }

    protected void saveImage(String fileName, byte[] content) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            fout.write(content);
            fout.flush();
            fout.close();
        }
        catch (FileNotFoundException ef) {
            String dir = fileName.substring(0, fileName.lastIndexOf(File.separator));
            File dirF = new File(dir);
            if (!dirF.exists()) {
                boolean ret = dirF.mkdir();
                if (!ret) {
                    this._Log.error((Object)("SaveImage can not create directory: " + dir));
                } else {
                    this._Log.info((Object)("SaveImage create directory: " + dir));
                    try {
                        fout = new FileOutputStream(fileName);
                        fout.write(content);
                        fout.flush();
                        fout.close();
                    }
                    catch (Exception e) {
                        this._Log.error((Object)("Error to create image: " + e));
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

