/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.sm.common.util.Filter;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ReportGroup {
    private HashMap<String, Filter> filters = new HashMap();
    private LinkedList<ReportInfo> reportInfos = new LinkedList();
    private String name;
    private boolean showName = true;

    public ReportGroup(String groupName) {
        this.name = groupName;
    }

    public List<ReportInfo> getReports() {
        return this.reportInfos;
    }

    public void addFilter(String filterName, Object filterValue) {
        Filter filter = new Filter(filterName, filterValue);
        this.addFilter(filter);
    }

    public void addFilter(Filter filter) {
        this.filters.put(filter.getFilterKey(), filter);
        for (ReportInfo report : this.reportInfos) {
            report.addFilter(filter);
        }
    }

    public void addAll(HashMap<String, Filter> filters) {
        filters.putAll(filters);
        for (ReportInfo report : this.reportInfos) {
            report.addAll(filters);
        }
    }

    public void addReport(ReportInfo report) {
        this.reportInfos.add(report);
        report.addAll(this.filters);
    }

    public void addReport(String report) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
    }
}

