/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.common.util.Filter;
import com.cisco.dcbu.sm.server.web.admin.PerformanceHandler;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.report.LanSwitchDetailReport;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.wrapper.DataStatisticsWrapper;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class VLanTrafficReport
extends ReportInfo {
    private Collection detailList;
    private Logger _Log = Logger.getLogger((String)"fms.lanReport");
    protected Collection<ColumnSet> columnSets = null;
    private Collection detailStatsColumns = null;

    public VLanTrafficReport(String reportName) {
        super(reportName);
    }

    public VLanTrafficReport(String reportName, boolean showDetails) {
        super(reportName);
    }

    @Override
    public int getReportType() {
        return 1;
    }

    @Override
    public Collection getDataList() {
        if (this.dataList == null) {
            try {
                long lanGroupId = (Long)this.getFilterValue("Lan_Group_Id");
                this.dataList = PerformanceHandler.getInstance().getVlanListByLanGroupId(lanGroupId);
                ArrayList<Object[]> w = new ArrayList<Object[]>();
                this.detailList = new ArrayList();
                if (this.dataList.size() > 0) {
                    for (Object vlans : this.dataList) {
                        DataStatisticsWrapper vlan = (DataStatisticsWrapper)vlans;
                        String vlanName = vlan.getName();
                        if (!(vlan.getRxTx() > 0.0)) continue;
                        w.add(new Object[]{vlanName, vlan.getRxTx()});
                    }
                    if (w.size() > 0) {
                        String chartFl = this.createBarChart("(Rx+Tx)/sec", "Top 10 VLANs (Rx + Tx)", "VLAN", w);
                        String[] vlanListCharts = new String[]{chartFl, ""};
                        if (this.charts == null) {
                            this.charts = new ArrayList();
                        }
                        this.charts.add(vlanListCharts);
                    }
                    this.populateDetailList();
                }
            }
            catch (Exception e) {
                this._Log.warn((Object)e.getMessage(), (Throwable)e);
                this.handleException(e);
                this.dataList = new ArrayList();
            }
        }
        return this.dataList;
    }

    @Override
    public List<String[]> getTocContent() {
        this.getDataList();
        return this.tocContent;
    }

    @Override
    public Collection getColumns() {
        if (this.columns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("VLAN Name", "name"), new TableColumn("Avg. Rx/sec", "avgRxStr"), new TableColumn("Avg. Tx/sec", "avgTxStr"), new TableColumn("(Rx+Tx)/sec", "rxTxStr"), new TableColumn("Peak Rx/sec", "maxRxStr"), new TableColumn("Peak Tx/sec", "maxTxStr"), new TableColumn("Errors", "errorStr"), new TableColumn("Discards", "discardStr")};
            this.columns = Arrays.asList(tCols);
        }
        return this.columns;
    }

    private Collection getDetailStatsColumns() {
        if (this.detailStatsColumns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("", "index"), new TableColumn("Switch Name", "name"), new TableColumn("Avg. Rx/sec", "avgRxStr"), new TableColumn("Avg. Tx/sec", "avgTxStr"), new TableColumn("(Rx+Tx)/sec", "rxTxStr"), new TableColumn("Peak Rx/sec", "maxRxStr"), new TableColumn("Peak Tx/sec", "maxTxStr"), new TableColumn("Errors", "errorStr"), new TableColumn("Discards", "discardStr"), new TableColumn("Last Updated", "lastUpdateTimeStr")};
            this.detailStatsColumns = Arrays.asList(tCols);
        }
        return this.detailStatsColumns;
    }

    private void populateDetailList() throws Exception {
        for (Object vlans : this.dataList) {
            DataStatisticsWrapper vlan = (DataStatisticsWrapper)vlans;
            String vlanName = vlan.getName();
            ArrayList<DataStatisticsWrapper> data = PerformanceHandler.getInstance().getVlanStatsInSWByVlanName(vlanName);
            if (data.isEmpty()) continue;
            LanSwitchDetailReport reportHolder = new LanSwitchDetailReport(new Object[]{"#Vlan_" + vlanName, "Top 20 Switches in " + vlanName, data, ""});
            reportHolder.setHeaders(this.getDetailStatsColumns());
            this.detailList.add(reportHolder);
        }
    }

    @Override
    public Collection getDetails() {
        return this.detailList;
    }

    @Override
    public String getNote() {
        return null;
    }

    @Override
    public boolean getShowFilter() {
        return true;
    }

    @Override
    public Collection getColumnSets() {
        if (this.columnSets == null) {
            if (this.columns == null) {
                this.getColumns();
            }
            this.columnSets = new ArrayList<ColumnSet>();
            ColumnSet set = null;
            Iterator itr = this.columns.iterator();
            set = DisplayUtil.initSet(itr, this.columns.size(), "");
            this.columnSets.add(set);
        }
        return this.columnSets;
    }

    public String createBarChart(String cat, String themeName, String xChart, ArrayList w) throws Exception {
        String op = (String)this.getFilterValue(Filter.TOFILE);
        File opFile = new File(op);
        String dir1 = opFile.getParent();
        File vF = new File(dir1);
        File f = File.createTempFile("VLanStat" + new SimpleDateFormat("yyMMdd-HHmmss").format(new Date()), ".png", vF);
        f.deleteOnExit();
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        if (w != null && w.size() > 0) {
            int maxVal = w.size() > 11 ? 11 : w.size();
            for (int i = 0; i < maxVal; ++i) {
                Object[] rowData = (Object[])w.get(i);
                data.setValue(((Double)rowData[1]).doubleValue(), (Comparable)((Object)cat), (Comparable)((Object)((String)rowData[0])));
            }
        }
        JFreeChart chart = ChartFactory.createBarChart((String)themeName, (String)xChart, (String)cat, (CategoryDataset)data, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)true);
        CategoryPlot crt = chart.getCategoryPlot();
        CategoryAxis axis = crt.getDomainAxis();
        CategoryPlot plot = chart.getCategoryPlot();
        int maxVal = w.size() > 11 ? 11 : w.size();
        for (int i = 0; i < maxVal; ++i) {
            if (i % 2 == 0) {
                plot.getRenderer().setSeriesPaint(i, (Paint)new Color(0, 128, 0));
                continue;
            }
            plot.getRenderer().setSeriesPaint(i, (Paint)new Color(0, 0, 255));
        }
        ChartUtilities.saveChartAsPNG((File)f, (JFreeChart)chart, (int)800, (int)300);
        String dir = f.getParent();
        String relativeDir = REPORT_DIR + dir.substring(dir.indexOf("reports") + 7) + File.separator + f.getName();
        String relativeUri = relativeDir.replaceAll(Pattern.quote(File.separator), "/");
        return relativeUri;
    }
}

