/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.topology;

import com.cisco.dcbu.jaxws.san.wo.IslDO;
import com.cisco.dcbu.jaxws.san.wo.NpvLinkDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.TopoDO;
import com.cisco.dcbu.jaxws.san.wo.TopoEdgeLinkDO;
import com.cisco.dcbu.jaxws.san.wo.TopoIslDO;
import com.cisco.dcbu.jaxws.san.wo.TopoNodeDO;
import com.cisco.dcbu.jaxws.san.wo.TopoPathDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.common.topology.layout.ILogGraph;
import com.cisco.dcbu.sm.common.topology.layout.ILogLink;
import com.cisco.dcbu.sm.common.topology.layout.ILogNode;
import com.cisco.dcbu.sm.common.topology.layout.ILogNodeIf;
import com.cisco.dcbu.sm.common.topology.layout.ShortestPathAlgorithm;
import com.cisco.dcbu.sm.common.topology.layout.ShortestPathLinkIf;
import com.cisco.dcbu.sm.common.topology.layout.ShortestPathNodeIf;
import com.cisco.dcbu.sm.common.topology.layout.SpringHierarchicalLayoutServer;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.HostMapImpl;
import com.cisco.dcbu.sm.server.web.inventory.IslHandler;
import com.cisco.dcbu.sm.server.web.inventory.NpvLinkHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.web.topology.TopoPath;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class HostEnclTopology {
    private static HostEnclTopology _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    public static final String UNKNOWN = "n/a";
    static final String IS_LAN = "IS_LAN";
    static final String IS_SAN = "IS_SAN";
    public static final int CONN_UNIT_WARNING = 4;
    static final String SQL_Query_all_lan_switch = "select ethswitch.id, ip_address, model_name, sys_name, sys_contact, sys_location, version, serial_number, sys_uptime,vendor,num_ports,is_present,is_manageable, unmanageable_cause, is_vdc, vdc_id, vdc_name,fcoe_enabled, cpu_usage, mem_usage, ethswitch.last_scan_time, vdc_mac, is_fex, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port from ethswitch ";
    static final String QueryFexNameSQL = "select fs.id, fs.sys_name from ethswitch s, ethswitch fs, ethswitch_fex f where s.id=? and f.switch_id=s.id and fs.id=f.fex_id";

    public static HostEnclTopology getInstance() {
        if (_Instance == null) {
            _Instance = new HostEnclTopology();
        }
        return _Instance;
    }

    private HostEnclTopology() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopoDO getHostOrStorageEnclGraph(String[] enclosureNames, Long[] enclosureIDs, Long[] hostIDs, Long[] vhostIDs, long width, long height, boolean isHost) {
        long fStart = System.currentTimeMillis();
        TopoPath topoPath = new TopoPath();
        ArrayList<TopoNodeDO> nodeList = new ArrayList<TopoNodeDO>();
        Connection con = null;
        long start = 0L;
        long end = 0L;
        try {
            int i;
            con = ConnectionManager.getConnection();
            ArrayList<String> enclosureNameList = new ArrayList<String>();
            ArrayList<Long> enclosureIdList = new ArrayList<Long>();
            ArrayList<Long> vhostIdList = new ArrayList<Long>();
            ArrayList<Long> lanHostIdList = new ArrayList<Long>();
            if (isHost) {
                for (i = 0; i < hostIDs.length; ++i) {
                    List<HostMapImpl> hostMapImpls;
                    HostImpl hostImpl = HostManager.getInstance().getHostById(hostIDs[i]);
                    if (hostImpl == null || (hostMapImpls = hostImpl.getHostMaps()) == null) continue;
                    HostMapImpl hostMapImpl = null;
                    for (int j = 0; j < hostMapImpls.size(); ++j) {
                        hostMapImpl = hostMapImpls.get(j);
                        if (hostMapImpl == null) continue;
                        enclosureNameList.add(enclosureNames[i]);
                        enclosureIdList.add(new Long(hostMapImpl.getEnclosureId()));
                        vhostIdList.add(new Long(hostMapImpl.getVhostId()));
                        lanHostIdList.add(new Long(hostMapImpl.getLanHostId()));
                    }
                }
            } else {
                for (i = 0; i < enclosureNames.length; ++i) {
                    enclosureNameList.add(enclosureNames[i]);
                    enclosureIdList.add(enclosureIDs[i]);
                    vhostIdList.add(vhostIDs[i]);
                    lanHostIdList.add(hostIDs[i]);
                }
            }
            for (i = 0; i < enclosureNameList.size(); ++i) {
                TopoPath tp = new TopoPath();
                String encName = (String)enclosureNameList.get(i);
                long encId = (Long)enclosureIdList.get(i);
                long vhostId = (Long)vhostIdList.get(i);
                long lanHostId = (Long)lanHostIdList.get(i);
                start = 0L;
                end = 0L;
                start = System.currentTimeMillis();
                this.getVmInfo(encId, vhostId, encName, con, tp);
                end = System.currentTimeMillis();
                this.timer(start, end, "getVmInfo()");
                tp.maxVertCnt = tp.maxVertCnt < tp.vmList.size() ? tp.vmList.size() : tp.maxVertCnt;
                try {
                    if (encId > 0L) {
                        start = System.currentTimeMillis();
                        this.getep2SwitchMapping(encId, con, isHost, tp, encName);
                        end = System.currentTimeMillis();
                        this.timer(start, end, "getep2SwitchMapping()");
                    }
                    if (lanHostId > 0L) {
                        start = System.currentTimeMillis();
                        this.getLanHost2LanSwitchMapping(lanHostId, con, tp, encName);
                        end = System.currentTimeMillis();
                        this.timer(start, end, "getLanHost2LanSwitchMapping()");
                    }
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                TopoNodeDO hostTopoNodeDO = null;
                hostTopoNodeDO = new TopoNodeDO(encName, 0, encName, new String[]{"Enclosure: " + encName + "\n" + this.getEnclToolTip(tp)});
                tp.hostEnclList.add(hostTopoNodeDO);
                for (String hostKey : tp.hostList) {
                    String[] hostInfo = hostKey.split(";");
                    long hostId = Long.parseLong(hostInfo[0]);
                    String hostSvcProfile = hostInfo[6];
                    String wwn = hostInfo[7];
                    String encNameFromHostKey = hostInfo[8];
                    String isLan = hostInfo[9];
                    String isVdc = hostInfo[10];
                    String swName = tp.ep2SwitchMap.get(hostKey);
                    String toolTip = tp.hostEdgeLinkTipMap.get(hostKey);
                    hostTopoNodeDO.setWwn(wwn);
                    TopoNodeDO srcSwNode = this.locateNode(tp.srcSwitchList, swName);
                    if (srcSwNode == null) {
                        srcSwNode = new TopoNodeDO(swName, 1, encName, new String[]{toolTip});
                        tp.edgeSwitchMap.put(swName, srcSwNode);
                        srcSwNode.setEntityTip(tp.sw2tipMap.get(swName));
                        srcSwNode.setSvcProfile(hostSvcProfile);
                        srcSwNode.setWwn(new WwnDO(wwn).getValue());
                        tp.srcSwitchList.add(srcSwNode);
                    } else {
                        srcSwNode.setToolTip(HostEnclTopology.add2Array(srcSwNode.getToolTip(), toolTip));
                    }
                    srcSwNode.setPortAlias(HostEnclTopology.add2Array(srcSwNode.getPortAlias(), hostInfo[1] + ";" + hostId, true));
                    srcSwNode.setHostVsan(HostEnclTopology.add2Array(srcSwNode.getHostVsan(), hostInfo[2], true));
                    srcSwNode.setSwIfNames(HostEnclTopology.add2Array(srcSwNode.getSwIfNames(), hostInfo[3], true));
                    srcSwNode.setZoneIdArr(HostEnclTopology.add2Array(srcSwNode.getZoneIdArr(), hostInfo[4], true));
                    srcSwNode.setZoneNameArr(HostEnclTopology.add2Array(srcSwNode.getZoneNameArr(), hostInfo[5], true));
                    if (isLan != null && isLan.equalsIgnoreCase(IS_LAN)) {
                        srcSwNode.setLan(true);
                    }
                    srcSwNode.setVdc(Boolean.valueOf(isVdc).booleanValue());
                    TopoEdgeLinkDO edgeLink = new TopoEdgeLinkDO();
                    edgeLink.setEnclosureName(encNameFromHostKey);
                    edgeLink.setSwitchName(swName);
                    edgeLink.setWwn(wwn);
                    edgeLink.setEntityTip(toolTip);
                    tp.edgeLinkList.add(edgeLink);
                }
                tp.maxVertCnt = tp.maxVertCnt < tp.srcSwitchList.size() ? tp.srcSwitchList.size() : tp.maxVertCnt;
                start = System.currentTimeMillis();
                for (String hostKey : tp.hostList) {
                    this.getHostOrStg2SwitchMapping(hostKey, con, nodeList, isHost, tp);
                }
                end = System.currentTimeMillis();
                this.timer(start, end, "getHostOrStg2SwitchMapping()");
                for (String ep_enclName : tp.stg2SwitchMap.keySet()) {
                    String enclName = ep_enclName.split(";")[1];
                    String swIfName = tp.stg2SwitchMap.get(ep_enclName);
                    String swWwn = tp.stg2SwitchWwnMap.get(ep_enclName);
                    String toolTip = this.getStgEnclToolTip(enclName, tp);
                    TopoNodeDO stgNode = this.locateNode(tp.stgEnclList, enclName);
                    if (stgNode == null) {
                        stgNode = this.locateNode(tp.hostEnclList, enclName);
                    }
                    if (stgNode == null) {
                        stgNode = new TopoNodeDO(enclName, 4, swIfName, new String[]{"Enclosure:" + enclName + "\n" + toolTip});
                        tp.stgEnclList.add(stgNode);
                        stgNode.setWwn(swWwn);
                    } else {
                        stgNode.setFromLink(stgNode.getFromLink() + ";" + swIfName);
                    }
                    stgNode.setLinkTip(tp.stg2tipMap.get(ep_enclName));
                    TopoEdgeLinkDO edgeLink = new TopoEdgeLinkDO();
                    edgeLink.setEnclosureName(enclName);
                    edgeLink.setSwitchName(swIfName.split(" ")[0]);
                    edgeLink.setWwn(swWwn);
                    edgeLink.setEntityTip(tp.stg2tipMap.get(ep_enclName));
                    tp.edgeLinkList.add(edgeLink);
                }
                tp.maxVertCnt = tp.maxVertCnt < tp.stgEnclList.size() ? tp.stgEnclList.size() : tp.maxVertCnt;
                topoPath.append(tp);
            }
            if (topoPath.fabricVsanMap != null) {
                int i2;
                String swName;
                for (String s : topoPath.fabricVsanMap.keySet()) {
                    if (s == null) continue;
                    try {
                        String fabricIdS = s.substring(0, s.indexOf(58));
                        String vsanIdS = s.substring(s.indexOf(58) + 1);
                        long fdbid = Long.parseLong(fabricIdS);
                        long vdbid = Long.parseLong(vsanIdS);
                        this.getCoreSwitches(fdbid, vdbid, topoPath);
                        this.getIsls(fdbid, vdbid, topoPath);
                        this.getNpvLinks(fdbid, vdbid, topoPath);
                    }
                    catch (Exception ex) {
                        this._Log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                this.setSwitchType(topoPath.allPathsSwitchList, topoPath);
                int numSwitchesRemoved = 0;
                do {
                    numSwitchesRemoved = this.removeDeadEndSwitches(topoPath);
                } while ((numSwitchesRemoved += this.removeSwitchOnlyLoops(topoPath)) > 0);
                Set<String> keys = topoPath.edgeSwitchMap.keySet();
                if (keys != null) {
                    for (String swName2 : keys) {
                        TopoNodeDO edgeSwitch = topoPath.edgeSwitchMap.get(swName2);
                        TopoNodeDO coreSwitch = topoPath.coreSwitchMap.get(swName2);
                        if (edgeSwitch == null || coreSwitch == null) continue;
                        edgeSwitch.setPresent(coreSwitch.isPresent());
                        edgeSwitch.setManagable(coreSwitch.isManagable());
                        edgeSwitch.setMinorFault(coreSwitch.isMinorFault());
                        edgeSwitch.setStatus(coreSwitch.getStatus());
                        edgeSwitch.setEntityTip(coreSwitch.getEntityTip());
                        edgeSwitch.setDbID(coreSwitch.getDbID());
                    }
                }
                for (TopoNodeDO edgeSwitch : topoPath.srcSwitchList) {
                    swName = edgeSwitch.getNodeLabel();
                    TopoNodeDO coreSwitch = topoPath.coreSwitchMap.get(swName);
                    if (edgeSwitch == null || coreSwitch == null) continue;
                    edgeSwitch.setPresent(coreSwitch.isPresent());
                    edgeSwitch.setManagable(coreSwitch.isManagable());
                    edgeSwitch.setMinorFault(coreSwitch.isMinorFault());
                    edgeSwitch.setStatus(coreSwitch.getStatus());
                    edgeSwitch.setEntityTip(coreSwitch.getEntityTip());
                    edgeSwitch.setDbID(coreSwitch.getDbID());
                }
                for (TopoNodeDO edgeSwitch : topoPath.dstSwitchList) {
                    swName = edgeSwitch.getNodeLabel();
                    TopoNodeDO coreSwitch = topoPath.coreSwitchMap.get(swName);
                    if (edgeSwitch == null || coreSwitch == null) continue;
                    edgeSwitch.setPresent(coreSwitch.isPresent());
                    edgeSwitch.setManagable(coreSwitch.isManagable());
                    edgeSwitch.setMinorFault(coreSwitch.isMinorFault());
                    edgeSwitch.setStatus(coreSwitch.getStatus());
                    edgeSwitch.setEntityTip(coreSwitch.getEntityTip());
                    edgeSwitch.setDbID(coreSwitch.getDbID());
                }
                HashedArrayList<ShortestPathNodeIf> allNodes = new HashedArrayList<ShortestPathNodeIf>();
                HashMap<PKIf, ShortestPathLinkIf> shortestLinks = new HashMap<PKIf, ShortestPathLinkIf>();
                HashedArrayList<TopoNodeDO> allSwitchList = new HashedArrayList<TopoNodeDO>();
                allSwitchList.addAll(topoPath.allPathsSwitchList);
                ShortestPathAlgorithm shortestPathAlgorithm = new ShortestPathAlgorithm();
                for (TopoNodeDO sourceSwitch : topoPath.srcSwitchList) {
                    for (TopoNodeDO targetSwitch : topoPath.dstSwitchList) {
                        HashMap<PKIf, ShortestPathLinkIf> shortestFcLinksHashMap;
                        ArrayList<ShortestPathNodeIf> shortestPath;
                        TopoNodeDO nodeDO = this.locateNode(topoPath.allPathsSwitchList, sourceSwitch.getNodeLabel());
                        if (nodeDO != null) {
                            sourceSwitch = nodeDO;
                        }
                        if ((nodeDO = this.locateNode(topoPath.allPathsSwitchList, targetSwitch.getNodeLabel())) != null) {
                            targetSwitch = nodeDO;
                        }
                        if (!allSwitchList.contains(sourceSwitch)) {
                            allSwitchList.add(sourceSwitch);
                        }
                        if (!allSwitchList.contains(targetSwitch)) {
                            allSwitchList.add(targetSwitch);
                        }
                        if ((shortestPath = shortestPathAlgorithm.findShortestPath((ShortestPathNodeIf[])allSwitchList.toArray(new TopoNodeDO[]{new TopoNodeDO()}), (ShortestPathLinkIf[])topoPath.allPathsIslList.toArray(new TopoIslDO[]{new TopoIslDO()}), (ShortestPathNodeIf)sourceSwitch, (ShortestPathNodeIf)targetSwitch)) != null) {
                            for (int i3 = 0; i3 < shortestPath.size(); ++i3) {
                                if (allNodes.contains(shortestPath.get(i3))) continue;
                                allNodes.add(shortestPath.get(i3));
                            }
                        }
                        if ((shortestFcLinksHashMap = shortestPathAlgorithm.getShortestFcLinksHashMap()) == null) continue;
                        shortestLinks.putAll(shortestFcLinksHashMap);
                    }
                }
                topoPath.shortestPathSwitchList.clear();
                topoPath.shortestPathIslList.clear();
                HashMap<String, TopoNodeDO> shortestPathSwitchMap = new HashMap<String, TopoNodeDO>();
                for (i2 = 0; i2 < allNodes.size(); ++i2) {
                    TopoNodeDO clone = (TopoNodeDO)((TopoNodeDO)allNodes.get(i2)).clone();
                    topoPath.shortestPathSwitchList.add(clone);
                    shortestPathSwitchMap.put(clone.getWwn(), clone);
                    if (this.locateNode(topoPath.srcSwitchList, clone.getNodeLabel()) != null || this.locateNodeByWwn(topoPath.srcSwitchList, clone.getWwn()) != null) {
                        clone.setType(1);
                        continue;
                    }
                    if (this.locateNode(topoPath.dstSwitchList, clone.getNodeLabel()) != null || this.locateNodeByWwn(topoPath.dstSwitchList, clone.getWwn()) != null) {
                        clone.setType(3);
                        continue;
                    }
                    clone.setType(6);
                }
                for (i2 = 0; i2 < topoPath.allPathsIslList.size(); ++i2) {
                    TopoIslDO topoIslDO = topoPath.allPathsIslList.get(i2);
                    if (topoIslDO == null || shortestLinks.get(topoIslDO.getPK()) == null || shortestPathSwitchMap.get(topoIslDO.getWwn1()) == null || shortestPathSwitchMap.get(topoIslDO.getWwn2()) == null) continue;
                    topoPath.shortestPathIslList.add(topoIslDO);
                }
            }
            if (topoPath.lanSwitchList.size() > 0) {
                int i4;
                for (i4 = 0; i4 < topoPath.lanSwitchList.size(); ++i4) {
                    topoPath.shortestPathSwitchList.add((TopoNodeDO)topoPath.lanSwitchList.get(i4).clone());
                    topoPath.allPathsSwitchList.add((TopoNodeDO)topoPath.lanSwitchList.get(i4).clone());
                }
                for (i4 = 0; i4 < topoPath.lanIslList.size(); ++i4) {
                    topoPath.shortestPathIslList.add(topoPath.lanIslList.get(i4));
                    topoPath.allPathsIslList.add(topoPath.lanIslList.get(i4));
                }
            }
            for (int i5 = 0; i5 < topoPath.allPathsIslList.size(); ++i5) {
                TopoIslDO topoIslDO = topoPath.allPathsIslList.get(i5);
                String switch1Name = topoIslDO.getSwitch1Name();
                String switch2Name = topoIslDO.getSwitch2Name();
                TopoNodeDO edgeSwitch1 = topoPath.edgeSwitchMap.get(switch1Name);
                TopoNodeDO edgeSwitch2 = topoPath.edgeSwitchMap.get(switch2Name);
                if (edgeSwitch1 != null && edgeSwitch2 != null) {
                    topoPath.edge2edgeIslList.add(topoIslDO);
                    continue;
                }
                if (edgeSwitch1 == null && edgeSwitch2 == null) continue;
                topoPath.edge2coreIslList.add(topoIslDO);
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            DbUtil.close(con);
        }
        start = System.currentTimeMillis();
        this.positionNodes(nodeList, (int)width, (int)height, topoPath);
        end = System.currentTimeMillis();
        this.timer(start, end, "positionNodes()");
        try {
            TopoNodeDO clone;
            TopoNodeDO node;
            int i;
            for (i = 0; i < topoPath.hostEnclList.size(); ++i) {
                node = topoPath.hostEnclList.get(i);
                clone = null;
                clone = (TopoNodeDO)node.clone();
                topoPath.allPathsEnclosureList.add(clone);
                topoPath.allPathsHostEnclosureList.add(clone);
                clone = (TopoNodeDO)node.clone();
                topoPath.shortestPathsEnclosureList.add(clone);
                topoPath.shortestPathsHostEnclosureList.add(clone);
            }
            for (i = 0; i < topoPath.stgEnclList.size(); ++i) {
                node = topoPath.stgEnclList.get(i);
                clone = null;
                clone = (TopoNodeDO)node.clone();
                topoPath.allPathsEnclosureList.add(clone);
                topoPath.allPathsStorageEnclosureList.add(clone);
                clone = (TopoNodeDO)node.clone();
                topoPath.shortestPathsEnclosureList.add(clone);
                topoPath.shortestPathsStorageEnclosureList.add(clone);
            }
            try {
                this.layout(topoPath.allPathsSwitchList, topoPath.allPathsIslList, topoPath.allPathsEnclosureList, (int)width, (int)height);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                this.layout(topoPath.shortestPathSwitchList, topoPath.shortestPathIslList, topoPath.shortestPathsEnclosureList, (int)width, (int)height);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (CloneNotSupportedException ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        if (!isHost) {
            this.flipX(nodeList);
            this.flipX(topoPath.allPathsSwitchList);
            this.flipX(topoPath.shortestPathSwitchList);
            this.flipX(topoPath.allPathsHostEnclosureList);
            this.flipX(topoPath.allPathsStorageEnclosureList);
            this.flipX(topoPath.shortestPathsHostEnclosureList);
            this.flipX(topoPath.shortestPathsStorageEnclosureList);
        }
        TopoDO rstObj = new TopoDO();
        rstObj.setTopoNodeArr(nodeList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoPathArr(this.getPathInfo(topoPath).toArray(new TopoPathDO[0]));
        rstObj.setTopoEdgeLinkArr(topoPath.edgeLinkList.toArray(new TopoEdgeLinkDO[0]));
        rstObj.setTopoAllPathsSwitchArr(topoPath.allPathsSwitchList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoAllPathsIslArr(topoPath.allPathsIslList.toArray(new TopoIslDO[0]));
        rstObj.setTopoShortestPathSwitchArr(topoPath.shortestPathSwitchList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoShortestPathIslArr(topoPath.shortestPathIslList.toArray(new TopoIslDO[0]));
        rstObj.setTopoEdge2EdgeIslArr(topoPath.edge2edgeIslList.toArray(new TopoIslDO[0]));
        rstObj.setTopoEdge2CoreIslArr(topoPath.edge2coreIslList.toArray(new TopoIslDO[0]));
        rstObj.setTopoAllPathsEnclosureArr(topoPath.allPathsEnclosureList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoAllPathsHostEnclosureArr(topoPath.allPathsHostEnclosureList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoAllPathsStorageEnclosureArr(topoPath.allPathsStorageEnclosureList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoShortestPathsEnclosureArr(topoPath.shortestPathsEnclosureList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoShortestPathsHostEnclosureArr(topoPath.shortestPathsHostEnclosureList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoShortestPathsStorageEnclosureArr(topoPath.shortestPathsStorageEnclosureList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoLanSwitchArr(topoPath.lanSwitchList.toArray(new TopoNodeDO[0]));
        rstObj.setTopoLanIslArr(topoPath.lanIslList.toArray(new TopoIslDO[0]));
        rstObj.setTopoHostPortGroupArr(topoPath.hostPortGroupList.toArray(new String[0]));
        rstObj.setTopoIslPortGroupArr(topoPath.islPortGroupList.toArray(new String[0]));
        rstObj.setTopoStoragePortGroupArr(topoPath.storagePortGroupList.toArray(new String[0]));
        long fStop = System.currentTimeMillis();
        this.timer(fStart, fStop, "getHostOrStorageEnclGraph()");
        return rstObj;
    }

    private void flipX(List<TopoNodeDO> topoNodeArr) {
        if (topoNodeArr == null || topoNodeArr.size() == 0) {
            return;
        }
        for (int i = 0; i < topoNodeArr.size(); ++i) {
            topoNodeArr.get(i).setX_cord(topoNodeArr.get(i).getX_cord() * -1);
        }
    }

    private int removeSwitchOnlyLoops(TopoPath topoPath) {
        HashedArrayList sws;
        int numSwitchesRemoved = 0;
        HashMap<String, ArrayList<String>> connectedSwitch = new HashMap<String, ArrayList<String>>();
        List<TopoIslDO> isls = topoPath.allPathsIslList;
        if (isls != null) {
            TopoIslDO isl = null;
            for (int i = 0; i < isls.size(); ++i) {
                isl = isls.get(i);
                if (isl == null) continue;
                this.addSwitch(isl.getWwn1(), isl.getWwn2(), connectedSwitch);
                this.addSwitch(isl.getWwn2(), isl.getWwn1(), connectedSwitch);
            }
        }
        HashMap<String, String> endPortSwitch = new HashMap<String, String>();
        List<TopoNodeDO> switchList = topoPath.allPathsSwitchList;
        if (switchList != null) {
            TopoNodeDO sw = null;
            for (int i = 0; i < switchList.size(); ++i) {
                sw = switchList.get(i);
                if (sw == null || sw.getType() != 1 && sw.getType() != 3) continue;
                endPortSwitch.put(sw.getWwn(), sw.getWwn());
            }
        }
        if ((sws = new HashedArrayList(connectedSwitch.keySet())) != null) {
            String swPK = null;
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < sws.size(); ++i) {
                ArrayList<String> sw2pks;
                swPK = (String)sws.get(i);
                if (swPK == null || endPortSwitch.get(swPK) != null || (sw2pks = connectedSwitch.get(swPK)) == null || sw2pks.size() != 2) continue;
                map.put(swPK, swPK);
            }
            HashedArrayList linearConnectedSwitch = new HashedArrayList(map.keySet());
            if (linearConnectedSwitch != null) {
                for (int i = 0; i < linearConnectedSwitch.size(); ++i) {
                    ArrayList<String> circle = this.getCircularSwitchPath((String)linearConnectedSwitch.get(i), connectedSwitch);
                    if (circle == null || circle.size() <= 0) continue;
                    for (int j = 0; j < circle.size(); ++j) {
                        swPK = circle.get(j);
                        this.removeSwitchByWwn(swPK, topoPath.allPathsSwitchList);
                    }
                    if (numSwitchesRemoved <= 0) continue;
                    this.removeDeadEndIsls(topoPath);
                    return numSwitchesRemoved;
                }
            }
        }
        return numSwitchesRemoved;
    }

    ArrayList<String> getCircularSwitchPath(String sw1PK, HashMap<String, ArrayList<String>> connectedSwitch) {
        if (sw1PK == null || connectedSwitch == null) {
            return null;
        }
        ArrayList<String> sw2pks = connectedSwitch.get(sw1PK);
        if (sw2pks == null || sw2pks.size() != 2) {
            return null;
        }
        if (sw2pks.get(0) == null || sw2pks.get(1) == null) {
            return null;
        }
        ArrayList<String> circularSwitchPathA = this.getLinearSwitchPath(sw2pks.get(0), connectedSwitch);
        ArrayList<String> circularSwitchPathB = this.getLinearSwitchPath(sw2pks.get(1), connectedSwitch);
        if (circularSwitchPathA == null || circularSwitchPathA.size() == 0) {
            return null;
        }
        if (circularSwitchPathB == null || circularSwitchPathB.size() == 0) {
            return null;
        }
        String swPK_a = circularSwitchPathA.get(circularSwitchPathA.size() - 1);
        String swPK_b = circularSwitchPathB.get(circularSwitchPathB.size() - 1);
        if (swPK_a == null || swPK_b == null) {
            return null;
        }
        if (!swPK_a.equals(swPK_b)) {
            return null;
        }
        circularSwitchPathA.remove(circularSwitchPathA.size() - 1);
        circularSwitchPathB.remove(circularSwitchPathB.size() - 1);
        circularSwitchPathA.addAll(circularSwitchPathB);
        return circularSwitchPathA;
    }

    ArrayList<String> getLinearSwitchPath(String swpk, HashMap<String, ArrayList<String>> connectedSwitch) {
        ArrayList<String> sw2pks;
        ArrayList<String> linearSwitchPath = new ArrayList<String>();
        String swpkNext = null;
        while ((swpkNext = this.getOtherSwitch(swpk, connectedSwitch)) != null && (sw2pks = connectedSwitch.get(swpkNext)) != null && sw2pks.size() == 2) {
            linearSwitchPath.add(swpkNext);
            swpk = swpkNext;
        }
        return linearSwitchPath;
    }

    String getOtherSwitch(String sw1PK, HashMap<String, ArrayList<String>> connectedSwitch) {
        if (sw1PK == null || connectedSwitch == null) {
            return null;
        }
        ArrayList<String> sw2pks = connectedSwitch.get(sw1PK);
        if (sw2pks == null || sw2pks.size() != 2) {
            return null;
        }
        if (sw2pks.get(0) != null && sw2pks.get(0).equals(sw1PK)) {
            return sw2pks.get(1);
        }
        if (sw2pks.get(1) != null && sw2pks.get(1).equals(sw1PK)) {
            return sw2pks.get(0);
        }
        return null;
    }

    private int removeDeadEndSwitches(TopoPath topoPath) {
        HashedArrayList sws;
        int numSwitchesRemoved = 0;
        HashMap<String, ArrayList<String>> connectedSwitch = new HashMap<String, ArrayList<String>>();
        List<TopoIslDO> isls = topoPath.allPathsIslList;
        if (isls != null) {
            TopoIslDO isl = null;
            for (int i = 0; i < isls.size(); ++i) {
                isl = isls.get(i);
                if (isl == null) continue;
                this.addSwitch(isl.getWwn1(), isl.getWwn2(), connectedSwitch);
                this.addSwitch(isl.getWwn2(), isl.getWwn1(), connectedSwitch);
            }
        }
        HashMap<String, String> endPortSwitch = new HashMap<String, String>();
        List<TopoNodeDO> switchList = topoPath.allPathsSwitchList;
        if (switchList != null) {
            TopoNodeDO sw = null;
            for (int i = 0; i < switchList.size(); ++i) {
                sw = switchList.get(i);
                if (sw == null || sw.getType() != 1 && sw.getType() != 3) continue;
                endPortSwitch.put(sw.getWwn(), sw.getWwn());
            }
        }
        if ((sws = new HashedArrayList(connectedSwitch.keySet())) != null) {
            String swPK = null;
            for (int i = 0; i < sws.size(); ++i) {
                ArrayList<String> sw2pks;
                swPK = (String)sws.get(i);
                if (swPK == null || endPortSwitch.get(swPK) != null || (sw2pks = connectedSwitch.get(swPK)) == null || sw2pks.size() > 1) continue;
                this.removeSwitchByWwn(swPK, topoPath.allPathsSwitchList);
                this.removeDeadEndIsls(topoPath);
                ++numSwitchesRemoved;
                break;
            }
        }
        return numSwitchesRemoved;
    }

    private void removeDeadEndIsls(TopoPath topoPath) {
        List<TopoIslDO> isls = topoPath.allPathsIslList;
        if (isls != null) {
            TopoIslDO isl = null;
            for (int i = 0; i < isls.size(); ++i) {
                isl = isls.get(i);
                if (isl == null || this.getSwitchByWwn(isl.getWwn1(), topoPath.allPathsSwitchList) != null && this.getSwitchByWwn(isl.getWwn2(), topoPath.allPathsSwitchList) != null) continue;
                topoPath.allPathsIslList.remove(i);
            }
        }
    }

    private void addSwitch(String wwn1, String wwn2, HashMap<String, ArrayList<String>> hashMap) {
        if (wwn1 == null || wwn2 == null || hashMap == null) {
            return;
        }
        ArrayList<String> arrayList = hashMap.get(wwn1);
        if (arrayList == null) {
            arrayList = new HashedArrayList<String>();
            hashMap.put(wwn1, arrayList);
        }
        if (!arrayList.contains(wwn2)) {
            arrayList.add(wwn2);
        }
    }

    private boolean removeSwitchByWwn(String wwn, List<TopoNodeDO> allPathsSwitchList) {
        if (wwn == null || wwn.length() == 0 || allPathsSwitchList == null || allPathsSwitchList.size() == 0) {
            return false;
        }
        for (int i = 0; i < allPathsSwitchList.size(); ++i) {
            TopoNodeDO sw = allPathsSwitchList.get(i);
            if (!wwn.equals(sw.getWwn())) continue;
            allPathsSwitchList.remove(i);
            return true;
        }
        return false;
    }

    private TopoNodeDO getSwitchByWwn(String wwn, List<TopoNodeDO> allPathsSwitchList) {
        if (wwn == null || wwn.length() == 0 || allPathsSwitchList == null || allPathsSwitchList.size() == 0) {
            return null;
        }
        for (int i = 0; i < allPathsSwitchList.size(); ++i) {
            TopoNodeDO sw = allPathsSwitchList.get(i);
            if (!wwn.equals(sw.getWwn())) continue;
            return sw;
        }
        return null;
    }

    private void setSwitchType(List<TopoNodeDO> nodeList, TopoPath topoPath) {
        for (int i = 0; i < nodeList.size(); ++i) {
            TopoNodeDO node = nodeList.get(i);
            if (this.locateNode(topoPath.srcSwitchList, node.getNodeLabel()) != null || this.locateNodeByWwn(topoPath.srcSwitchList, node.getWwn()) != null) {
                node.setType(1);
                continue;
            }
            if (this.locateNode(topoPath.dstSwitchList, node.getNodeLabel()) != null || this.locateNodeByWwn(topoPath.dstSwitchList, node.getWwn()) != null) {
                node.setType(3);
                continue;
            }
            node.setType(6);
        }
    }

    private void layout(List<TopoNodeDO> switchList, List<TopoIslDO> islList, List<TopoNodeDO> enclosureList, int width, int height) throws Exception {
        ILogNode ilogNode;
        TopoNodeDO topoNode;
        int i;
        ILogNode ilogNode2;
        TopoNodeDO topoNode2;
        int i2;
        long fStart = System.currentTimeMillis();
        ILogGraph ilogGraph = new ILogGraph();
        HashMap<String, TopoNodeDO> topoNodeHashMap = new HashMap<String, TopoNodeDO>();
        HashMap<String, ILogNode> ilogNodeHashMap = new HashMap<String, ILogNode>();
        HashedArrayList<ILogNode> srcDstSwitchList = new HashedArrayList<ILogNode>();
        HashedArrayList<ILogNode> hostEnclosureList = new HashedArrayList<ILogNode>();
        HashedArrayList<ILogNode> storageEnclosureList = new HashedArrayList<ILogNode>();
        block9: for (i2 = 0; i2 < switchList.size(); ++i2) {
            topoNode2 = switchList.get(i2);
            ilogNode2 = new ILogNode();
            ilogNode2.setVisible(true);
            ilogNode2.setHost(false);
            ilogNode2.setStorage(false);
            ilogNode2.setNodeLabel(topoNode2.getNodeLabel());
            ilogNode2.setWwn(topoNode2.getWwn());
            topoNodeHashMap.put(topoNode2.getWwn(), topoNode2);
            ilogNodeHashMap.put(topoNode2.getWwn(), ilogNode2);
            ilogGraph.addNode(ilogNode2);
            switch (topoNode2.getType()) {
                case 1: {
                    srcDstSwitchList.add(ilogNode2);
                    continue block9;
                }
                case 3: {
                    srcDstSwitchList.add(ilogNode2);
                }
            }
        }
        for (i2 = 0; i2 < islList.size(); ++i2) {
            TopoIslDO topoIsl = islList.get(i2);
            ILogLink ilogLink = new ILogLink();
            if (ilogNodeHashMap.get(topoIsl.getWwn1()) != null && ilogNodeHashMap.get(topoIsl.getWwn2()) != null) {
                ilogLink.setSourceNode((ILogNodeIf)ilogNodeHashMap.get(topoIsl.getWwn1()));
                ilogLink.setTargetNode((ILogNodeIf)ilogNodeHashMap.get(topoIsl.getWwn2()));
                ilogGraph.addLink(ilogLink);
                continue;
            }
            if (ilogNodeHashMap.get(topoIsl.getSwitch1Name()) == null || ilogNodeHashMap.get(topoIsl.getSwitch2Name()) == null) continue;
            ilogLink.setSourceNode((ILogNodeIf)ilogNodeHashMap.get(topoIsl.getSwitch1Name()));
            ilogLink.setTargetNode((ILogNodeIf)ilogNodeHashMap.get(topoIsl.getSwitch2Name()));
            ilogGraph.addLink(ilogLink);
        }
        block11: for (i2 = 0; i2 < enclosureList.size(); ++i2) {
            topoNode2 = enclosureList.get(i2);
            ilogNode2 = new ILogNode();
            ilogNode2.setVisible(true);
            ilogNode2.setHost(false);
            ilogNode2.setStorage(false);
            ilogNode2.setNodeLabel(topoNode2.getNodeLabel());
            ilogNode2.setWwn(topoNode2.getWwn());
            switch (topoNode2.getType()) {
                case 4: {
                    storageEnclosureList.add(ilogNode2);
                    ilogNode2.setStorage(true);
                    ilogNode2.setHost(false);
                    break;
                }
                case 0: {
                    hostEnclosureList.add(ilogNode2);
                }
                case 5: {
                    ilogNode2.setHost(true);
                    ilogNode2.setStorage(false);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            topoNodeHashMap.put(topoNode2.getNodeLabel(), topoNode2);
            ilogNodeHashMap.put(topoNode2.getNodeLabel(), ilogNode2);
            ilogGraph.addNode(ilogNode2);
            ILogLink ilogLink = new ILogLink();
            if (ilogNodeHashMap.get(topoNode2.getNodeLabel()) == null || ilogNodeHashMap.get(topoNode2.getWwn()) == null) continue;
            ilogLink.setSourceNode((ILogNodeIf)ilogNodeHashMap.get(topoNode2.getNodeLabel()));
            ilogLink.setTargetNode((ILogNodeIf)ilogNodeHashMap.get(topoNode2.getWwn()));
            ilogGraph.addLink(ilogLink);
        }
        SpringHierarchicalLayoutServer layoutServer = new SpringHierarchicalLayoutServer();
        layoutServer.setSize(width, height);
        layoutServer.layout(ilogGraph, 0, true);
        layoutServer.findSwitchBounds(ilogGraph);
        layoutServer.fitHostEnclosures(ilogGraph, width, height, srcDstSwitchList, hostEnclosureList);
        layoutServer.fitStorageEnclosures(ilogGraph, width, height, srcDstSwitchList, storageEnclosureList);
        layoutServer.fitNodesToBounds(ilogGraph, width, height);
        for (i = 0; i < switchList.size(); ++i) {
            topoNode = switchList.get(i);
            ilogNode = (ILogNode)ilogNodeHashMap.get(topoNode.getWwn());
            if (ilogNode == null) continue;
            topoNode.setX_cord((int)ilogNode.getIconCenterX());
            topoNode.setY_cord((int)ilogNode.getIconCenterY());
        }
        for (i = 0; i < enclosureList.size(); ++i) {
            topoNode = enclosureList.get(i);
            ilogNode = (ILogNode)ilogNodeHashMap.get(topoNode.getNodeLabel());
            if (ilogNode == null) continue;
            topoNode.setX_cord((int)ilogNode.getIconCenterX());
            topoNode.setY_cord((int)ilogNode.getIconCenterY());
        }
        long fStop = System.currentTimeMillis();
        this.timer(fStart, fStop, "layout()");
    }

    private TopoNodeDO locateNodeByWwn(List<TopoNodeDO> list, String wwn) {
        for (TopoNodeDO node : list) {
            if (node.getWwn() == null || !node.getWwn().equals(wwn)) continue;
            return node;
        }
        return null;
    }

    private TopoNodeDO locateNode(List<TopoNodeDO> list, String name) {
        for (TopoNodeDO node : list) {
            if (!node.getNodeLabel().equals(name)) continue;
            return node;
        }
        return null;
    }

    private TopoIslDO locateIsl(List<TopoIslDO> list, String label) {
        for (TopoIslDO isl : list) {
            if (!isl.getLabel().equals(label)) continue;
            return isl;
        }
        return null;
    }

    private List<TopoPathDO> getPathInfo(TopoPath topoPath) {
        ArrayList<TopoPathDO> topoPathList = new ArrayList<TopoPathDO>();
        try {
            for (int i = 0; i < topoPath.srcSwitchList.size(); ++i) {
                TopoNodeDO srcSwNode = topoPath.srcSwitchList.get(i);
                String srcSwitchName = srcSwNode.getNodeLabel();
                for (int m = 0; m < srcSwNode.getSwIfNames().length; ++m) {
                    String hostPortName = srcSwNode.getPortAlias()[m];
                    String hostVsanId = srcSwNode.getHostVsan()[m];
                    String hostSwIf = srcSwNode.getSwIfNames()[m];
                    String zoneName = srcSwNode.getZoneNameArr()[m];
                    String zoneIdStr = srcSwNode.getZoneIdArr()[m];
                    if (topoPath.dstSwitchList.size() < 1) {
                        TopoPathDO pathToEnclosureDo = new TopoPathDO(hostPortName, hostVsanId, srcSwitchName + ":" + hostSwIf, "", "", "", "", "");
                        topoPathList.add(pathToEnclosureDo);
                        pathToEnclosureDo.setSrcSwitchWwn(srcSwNode.getWwn());
                        pathToEnclosureDo.setDstSwitchWwn(hostPortName);
                        pathToEnclosureDo.setLan(srcSwNode.isLan());
                    }
                    for (int j = 0; j < topoPath.dstSwitchList.size(); ++j) {
                        TopoNodeDO dstSwNode = topoPath.dstSwitchList.get(j);
                        String fName = dstSwNode.getFromLink();
                        String dstSwitchName = dstSwNode.getNodeLabel();
                        if (this.locateNode(topoPath.fabricList, fName) == null && topoPath.fabricList.size() > 0 && !dstSwitchName.equals(srcSwitchName)) continue;
                        String[] stgPortArr = dstSwNode.getToLink();
                        for (int k = 0; k < stgPortArr.length; ++k) {
                            String stgPortName = stgPortArr[k];
                            if (!stgPortName.split(";")[1].equals(zoneIdStr)) continue;
                            TopoPathDO pathDo = new TopoPathDO(hostPortName, hostVsanId, srcSwitchName + " " + hostSwIf, fName, dstSwitchName + " " + dstSwNode.getSwIfNames()[k], dstSwNode.getEncls()[k], stgPortName.split(";")[0] + ";" + stgPortName.split(";")[2], topoPath.stg2VmMap.get(dstSwNode.getEncls()[k] + "--" + stgPortName.split(";")[0]));
                            pathDo.setZoneName(zoneName);
                            pathDo.setSrcSwitchWwn(srcSwNode.getWwn());
                            pathDo.setDstSwitchWwn(dstSwNode.getWwn());
                            if (!topoPathList.contains(pathDo)) {
                                topoPathList.add(pathDo);
                            }
                            this._Log.debug((Object)("host=" + hostPortName + "vsan=" + hostVsanId + "swch=" + srcSwitchName + " " + hostSwIf + "fabr=" + fName + "zone=" + zoneName + "swch=" + dstSwitchName + " " + dstSwNode.getSwIfNames()[k] + "stor=" + stgPortName.split(";")[0] + ";" + stgPortName.split(";")[2]));
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex);
        }
        return topoPathList;
    }

    private void positionNodes(List<TopoNodeDO> nodeList, int width, int height, TopoPath topoPath) {
        TopoNodeDO switchDO;
        int i;
        if (topoPath.vmList.size() > 0) {
            this.updatePositionVertically(topoPath.vmList, -350, width, height);
            nodeList.addAll(topoPath.vmList);
        }
        this.updateListPosition(topoPath.srcSwitchList, -80);
        nodeList.addAll(topoPath.srcSwitchList);
        this.updateListPosition(this.getHubList(topoPath), 0);
        nodeList.addAll(topoPath.fabricList);
        this.updateListPosition(topoPath.dstSwitchList, 80);
        nodeList.addAll(topoPath.dstSwitchList);
        HashedArrayList<TopoNodeDO> srcDstSwitchList = new HashedArrayList<TopoNodeDO>();
        for (i = 0; i < topoPath.srcSwitchList.size(); ++i) {
            switchDO = topoPath.srcSwitchList.get(i);
            if (srcDstSwitchList.contains(switchDO)) continue;
            srcDstSwitchList.add(switchDO);
        }
        for (i = 0; i < topoPath.dstSwitchList.size(); ++i) {
            switchDO = topoPath.dstSwitchList.get(i);
            if (srcDstSwitchList.contains(switchDO)) continue;
            srcDstSwitchList.add(switchDO);
        }
        topoPath.stgEnclList = this.reorderListPosition(srcDstSwitchList, topoPath.stgEnclList);
        this.updatePositionVertically(topoPath.stgEnclList, 100, width, height);
        nodeList.addAll(topoPath.stgEnclList);
        topoPath.hostEnclList = this.reorderListPosition(srcDstSwitchList, topoPath.hostEnclList);
        this.updatePositionVertically(topoPath.hostEnclList, -240, width, height);
        nodeList.addAll(topoPath.hostEnclList);
        this.updatePositionCentered(nodeList);
    }

    private void updatePositionCentered(List<TopoNodeDO> nodeList) {
        if (nodeList != null) {
            TopoNodeDO node;
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int i = 0; i < nodeList.size(); ++i) {
                node = nodeList.get(i);
                if (node == null) continue;
                int x = node.getX_cord();
                int y = node.getY_cord();
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
            int translateX = (maxX + minX) / 2;
            for (int i = 0; i < nodeList.size(); ++i) {
                node = nodeList.get(i);
                if (node == null) continue;
                node.setX_cord(node.getX_cord() - translateX);
            }
        }
    }

    private ArrayList<TopoNodeDO> reorderListPosition(List<TopoNodeDO> switchList, List<TopoNodeDO> enclList) {
        int i;
        HashedArrayList hashedEnclList;
        TopoNodeDO enclNode;
        if (switchList.size() > 2) {
            Collections.sort(switchList, new Comparator<TopoNodeDO>(){

                @Override
                public int compare(TopoNodeDO arg0, TopoNodeDO arg1) {
                    if (arg0.getY_cord() == arg1.getY_cord()) {
                        return 0;
                    }
                    if (arg0.getY_cord() > arg1.getY_cord()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        HashMap<String, HashedArrayList> enclosureBySwitch = new HashMap<String, HashedArrayList>();
        for (int i2 = 0; i2 < enclList.size(); ++i2) {
            enclNode = enclList.get(i2);
            String swWWn = enclNode.getWwn();
            hashedEnclList = (HashedArrayList)enclosureBySwitch.get(swWWn);
            if (hashedEnclList == null) {
                hashedEnclList = new HashedArrayList();
                enclosureBySwitch.put(swWWn, hashedEnclList);
            }
            hashedEnclList.add(enclNode);
        }
        HashedArrayList<TopoNodeDO> sortedEnclList = new HashedArrayList<TopoNodeDO>();
        for (i = 0; i < switchList.size(); ++i) {
            hashedEnclList = (HashedArrayList)enclosureBySwitch.get(switchList.get(i).getWwn());
            if (hashedEnclList == null) continue;
            if (hashedEnclList.size() > 2) {
                Collections.sort(hashedEnclList, new Comparator<TopoNodeDO>(){

                    @Override
                    public int compare(TopoNodeDO arg0, TopoNodeDO arg1) {
                        return arg0.getNodeLabel().compareTo(arg1.getNodeLabel());
                    }
                });
            }
            for (int j = 0; j < hashedEnclList.size(); ++j) {
                enclNode = (TopoNodeDO)hashedEnclList.get(j);
                if (sortedEnclList.contains(enclNode)) continue;
                sortedEnclList.add(enclNode);
            }
        }
        for (i = 0; i < enclList.size(); ++i) {
            enclNode = enclList.get(i);
            if (sortedEnclList.contains(enclNode)) continue;
            sortedEnclList.add(enclNode);
        }
        return sortedEnclList;
    }

    private List<TopoNodeDO> getHubList(TopoPath topoPath) {
        ArrayList<TopoNodeDO> hubList = new ArrayList<TopoNodeDO>();
        for (TopoNodeDO swNode : topoPath.srcSwitchList) {
            if (!swNode.isHub()) continue;
            hubList.add(swNode);
        }
        hubList.addAll(topoPath.fabricList);
        return hubList;
    }

    private void updatePositionVertically(List<TopoNodeDO> dataList, int x_cord, int width, int height) {
        if (dataList.size() == 0) {
            return;
        }
        int minIncrementY = 12;
        int maxIncrementY = 48;
        int yIncrement = height / dataList.size();
        if (yIncrement > maxIncrementY) {
            yIncrement = maxIncrementY;
        } else if (yIncrement < minIncrementY) {
            yIncrement = minIncrementY;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            TopoNodeDO curNode = dataList.get(i);
            curNode.setX_cord(x_cord + 80);
            curNode.setY_cord(yIncrement * i - yIncrement * (dataList.size() - 1) / 2);
        }
    }

    private void updateListPosition(List<TopoNodeDO> dataList, int x_cord) {
        TopoNodeDO curNode;
        int y_center = 0;
        int startIdx = 0;
        int i = 0;
        int count = 1;
        boolean y_cord = false;
        int initVlu = 0;
        int curVlu = 0;
        if (dataList.size() > 2) {
            Collections.sort(dataList, new Comparator<TopoNodeDO>(){

                @Override
                public int compare(TopoNodeDO arg0, TopoNodeDO arg1) {
                    return arg0.getFromLink().toString().compareTo(arg1.getFromLink().toString());
                }
            });
        }
        if (dataList.size() % 2 != 0) {
            curNode = dataList.get(startIdx++);
            curNode.setY_cord(y_center);
            curNode.setX_cord(curNode.getType() == 1 && curNode.isHub() ? x_cord - 50 : x_cord);
        }
        boolean toIncre = true;
        for (i = startIdx; i < dataList.size(); ++i) {
            curNode = dataList.get(i);
            curVlu = toIncre ? initVlu - 30 * count : initVlu + 30 * count++;
            toIncre = !toIncre;
            curNode.setY_cord(curVlu);
            curNode.setX_cord(curNode.getType() == 1 && curNode.isHub() ? x_cord - 50 : x_cord);
        }
    }

    private TopoIslDO createIsl(String fromSwitch, String toSwitch, int fromInterfaceIndex, int toInterfaceIndex, long speed, String speedStr, String status, String ifName1, String ifName2) {
        TopoIslDO topoIslDo = new TopoIslDO(fromSwitch, toSwitch);
        topoIslDo.setIfIndex1(fromInterfaceIndex);
        topoIslDo.setIfIndex2(toInterfaceIndex);
        topoIslDo.setSpeed(speed);
        topoIslDo.setSpeedStr(speedStr);
        topoIslDo.setStatus(status);
        topoIslDo.setIfName1(ifName1);
        topoIslDo.setIfName2(ifName2);
        topoIslDo.setWwn1(fromSwitch);
        topoIslDo.setWwn2(toSwitch);
        return topoIslDo;
    }

    private TopoIslDO createIsl(IslDO islDO) {
        TopoIslDO topoIslDo = new TopoIslDO(islDO.getFromSwitch(), islDO.getToSwitch());
        if (islDO.getSw1Wwn() != null) {
            topoIslDo.setWwn1(islDO.getSw1Wwn().getValue());
        }
        if (islDO.getSw2Wwn() != null) {
            topoIslDo.setWwn2(islDO.getSw2Wwn().getValue());
        }
        topoIslDo.setIfIndex1(islDO.getFromInterfaceIndex());
        topoIslDo.setIfIndex2(islDO.getToInterfaceIndex());
        topoIslDo.setSpeed(islDO.getSpeed());
        topoIslDo.setSpeedStr(islDO.getSpeedStr());
        topoIslDo.setStatus(islDO.getStatus());
        topoIslDo.setIfName1(islDO.getFromInterface());
        topoIslDo.setIfName2(islDO.getToInterface());
        topoIslDo.setFabricName(islDO.getFabricName());
        return topoIslDo;
    }

    private TopoIslDO createNpvLink(NpvLinkDO npvLinkDO) {
        TopoIslDO topoNpvLinkDo = new TopoIslDO(npvLinkDO.getCoreSwitch().getName(), npvLinkDO.getEdgeSwitch().getName());
        topoNpvLinkDo.setWwn1(npvLinkDO.getCoreSwWwn().getValue());
        topoNpvLinkDo.setWwn2(npvLinkDO.getEdgeSwWwn().getValue());
        topoNpvLinkDo.setIfIndex1(npvLinkDO.getFromInterfaceIndex());
        topoNpvLinkDo.setIfIndex2(npvLinkDO.getToInterfaceIndex());
        topoNpvLinkDo.setSpeed(npvLinkDO.getSpeed());
        topoNpvLinkDo.setSpeedStr(npvLinkDO.getSpeedStr());
        topoNpvLinkDo.setStatus(npvLinkDO.getStatus());
        topoNpvLinkDo.setIfName1(npvLinkDO.getFromInterface());
        topoNpvLinkDo.setIfName2(npvLinkDO.getToInterface());
        topoNpvLinkDo.setFabricName(npvLinkDO.getFabricKey().getName());
        return topoNpvLinkDo;
    }

    private TopoNodeDO createSwitch(SwitchDO switchDO, TopoPath topoPath) {
        String[] toolTip = new String[]{switchDO.getIpAddress(), switchDO.getModel(), switchDO.getRelease()};
        TopoNodeDO topoNodeDo = new TopoNodeDO(switchDO.getLogicalName(), 3, switchDO.getFabricName(), toolTip);
        String swIP = switchDO.getIpAddress();
        String swModel = switchDO.getModel();
        String swVer = switchDO.getRelease();
        String entityTip = "IP:" + (swIP == null ? "" : swIP) + "\n" + "Model:" + (swModel == null ? UNKNOWN : swModel) + "\n" + "Version:" + (swVer == null ? UNKNOWN : swVer + "\n" + "Status:" + switchDO.getStatus());
        topoNodeDo.setIp(swIP);
        topoNodeDo.setModelName(swModel);
        topoNodeDo.setVersion(swVer);
        topoNodeDo.setEntityTip(entityTip);
        topoNodeDo.setDbID(switchDO.getSwitchDbID());
        if (switchDO.getSwWwn() != null) {
            String wwn = switchDO.getSwWwn().getValue();
            topoNodeDo.setWwn(wwn);
            TopoNodeDO a = this.getSwitchByWwn(wwn, topoPath.dstSwitchList);
            if (a != null) {
                topoNodeDo.setToolTip(a.getToolTip());
            } else {
                a = this.getSwitchByWwn(wwn, topoPath.srcSwitchList);
                if (a != null) {
                    topoNodeDo.setToolTip(a.getToolTip());
                }
            }
        }
        int _type = switchDO.getModelType();
        topoNodeDo.setPresent(switchDO.isPresent());
        topoNodeDo.setManagable(switchDO.isManagable());
        topoNodeDo.setMinorFault(switchDO.getConnUnitStatus() == 4 || switchDO.isLicenseViolation() || !DisplayUtil.isHotStandby(switchDO) && DisplayUtil.isMdsDirector(switchDO));
        topoNodeDo.setStatus(switchDO.getStatus());
        topoNodeDo.setVdc(switchDO.getVdcId() > -1);
        return topoNodeDo;
    }

    private void getCoreSwitches(long fdbid, long vdbid, TopoPath topoPath) {
        DbFilterDO dbFilter = new DbFilterDO(fdbid, vdbid, "Name", "ASC");
        dbFilter.setNetworkType("SAN");
        String status = "All";
        int startIdx = 0;
        try {
            int recordSize = SwitchHandler.getInstance().getSwitchDataLength(dbFilter, status);
            ArrayList<SwitchDO> switchList = SwitchHandler.getInstance().getSwitchList(dbFilter, status, startIdx, recordSize);
            if (switchList.size() < recordSize) {
                recordSize = switchList.size();
            }
            for (int i = 0; i < recordSize; ++i) {
                SwitchDO switchDo = switchList.get(i);
                TopoNodeDO topoNodeDo = this.locateNode(topoPath.allPathsSwitchList, switchDo.getLogicalName());
                if (topoNodeDo != null) continue;
                topoNodeDo = this.createSwitch(switchDo, topoPath);
                topoPath.allPathsSwitchList.add(topoNodeDo);
                topoPath.coreSwitchMap.put(switchDo.getLogicalName(), topoNodeDo);
            }
        }
        catch (Throwable e) {
            this._Log.warn((Object)"HostEnclTopology caught exception in getSwitchList():", e);
        }
    }

    private void getIsls(long fdbid, long vdbid, TopoPath topoPath) {
        DbFilterDO dbFilter = new DbFilterDO(fdbid, vdbid, "Name", "ASC");
        dbFilter.setNetworkType("SAN");
        String status = "All";
        int startIdx = 0;
        try {
            int recordSize = IslHandler.getInstance().getSanIslDataLength(dbFilter, status);
            ArrayList<IslDO> islList = IslHandler.getInstance().getIslList(dbFilter, status, startIdx, recordSize);
            if (islList.size() < recordSize) {
                recordSize = islList.size();
            }
            for (int i = 0; i < recordSize; ++i) {
                IslDO islDo = islList.get(i);
                TopoIslDO topoIslDo = this.locateIsl(topoPath.allPathsIslList, islDo.getFromSwitch() + "," + islDo.getFromInterfaceIndex() + "<->" + islDo.getToSwitch() + "," + islDo.getToInterfaceIndex());
                if (topoIslDo != null) continue;
                this.addPortGroupItem(topoPath.islPortGroupList, islDo.getSw1Id(), islDo.getSwitchPort1Id(), "SAN");
                this.addPortGroupItem(topoPath.islPortGroupList, islDo.getSw2Id(), islDo.getSwitchPort2Id(), "SAN");
                topoPath.allPathsIslList.add(this.createIsl(islDo));
            }
        }
        catch (Throwable e) {
            this._Log.warn((Object)"HostEnclTopology caught exception in getIslList():", e);
        }
    }

    private void getNpvLinks(long fdbid, long vdbid, TopoPath topoPath) {
        DbFilterDO dbFilter = new DbFilterDO(fdbid, vdbid, "coreSwitch", "ASC");
        dbFilter.setNetworkType("SAN");
        String status = "All";
        int startIdx = 0;
        try {
            int recordSize = NpvLinkHandler.getInstance().getDataLength(dbFilter, status);
            List<NpvLinkDO> npvLinkList = NpvLinkHandler.getInstance().getList(dbFilter, status, startIdx, recordSize);
            if (npvLinkList.size() < recordSize) {
                recordSize = npvLinkList.size();
            }
            for (int i = 0; i < recordSize; ++i) {
                NpvLinkDO npvLinkDo = npvLinkList.get(i);
                TopoIslDO topoIslDo = this.locateIsl(topoPath.allPathsIslList, npvLinkDo.getCoreSwitch().getName() + "," + npvLinkDo.getFromInterfaceIndex() + "<->" + npvLinkDo.getEdgeSwitch().getName() + "," + npvLinkDo.getToInterfaceIndex());
                if (topoIslDo != null) continue;
                this.addPortGroupItem(topoPath.islPortGroupList, npvLinkDo.getSw1Id(), npvLinkDo.getSwitchPort1Id(), "SAN");
                this.addPortGroupItem(topoPath.islPortGroupList, npvLinkDo.getSw2Id(), npvLinkDo.getSwitchPort2Id(), "SAN");
                topoPath.allPathsIslList.add(this.createNpvLink(npvLinkDo));
            }
        }
        catch (Throwable e) {
            this._Log.warn((Object)"HostEnclTopology caught exception in getNpvLinkList():", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getVmInfo(long encId, long vhId, String encName, Connection con, TopoPath topoPath) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            if (encId == 0L && vhId != 0L) {
                sql = SQLLoader.getSqlStmt("HostEnclTopology.VM_FOR_VHOST_STMT");
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, vhId);
            } else {
                sql = SQLLoader.getSqlStmt("HostEnclTopology.VM_STMT");
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, encId);
            }
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                String vmName = rs.getString(2);
                String stgName = rs.getString(3);
                String enclName = rs.getString(4);
                long memSize = rs.getLong(5);
                int cpuCnt = rs.getInt(6);
                String osType = rs.getString(7);
                byte[] ipByte = rs.getBytes(8);
                Long vhostId = rs.getLong(10);
                String swName = rs.getString(11);
                TopoNodeDO node = new TopoNodeDO(vmName, 5);
                String memSizeStr = !Double.isNaN(memSize) ? DefaultSnmpNumberRenderer.formatLong(memSize * 1000000L) + "B" : UNKNOWN;
                String ipStr = ipByte == null ? "" : InetAddress.getByAddress(ipByte).getHostAddress();
                String toolTip = "Name:\t" + vmName + "\nMemory:\t" + memSizeStr + "\n#CPUs:\t" + cpuCnt + "\nOS:\t" + osType + "\nIP:\t" + ipStr;
                node.setVmInfo(enclName + "--" + stgName + "--" + swName);
                String vmMapVlu = topoPath.stg2VmMap.get(enclName + "--" + stgName);
                vmName = vmName + ";" + vhostId;
                topoPath.stg2VmMap.put(enclName + "--" + stgName, vmMapVlu == null ? vmName : vmMapVlu + "," + vmName);
                node.setToolTip(HostEnclTopology.add2Array(node.getToolTip(), toolTip));
                node.setLinkTip(encName);
                topoPath.vmList.add(node);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    private void addPortGroupItem(List<String> portGroupList, long switchId, long switchPortId, String network) {
        String key = switchId + ";" + switchPortId + ";" + network;
        if (portGroupList == null) {
            return;
        }
        if (portGroupList.contains(key)) {
            return;
        }
        portGroupList.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHostOrStg2SwitchMapping(String hostKey, Connection con, List<TopoNodeDO> nodeList, boolean isHost, TopoPath topoPath) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        long zoneId = Long.parseLong(hostKey.split(";")[4]);
        String srcSwitch = topoPath.ep2SwitchMap.get(hostKey);
        long start = 0L;
        long end = 0L;
        try {
            start = System.currentTimeMillis();
            sql = SQLLoader.getSqlStmt("HostStorageEnclTopology.HOST_OR_STG_2_SWITCH_STMT");
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, zoneId);
            rs = SQLLoader.execute(stmt);
            end = System.currentTimeMillis();
            this.timer(start, end, "getHostOrStg2SwitchMapping() Sql Execution");
            while (rs.next()) {
                long epId = rs.getLong(1);
                String epAlias = rs.getString(2);
                byte[] epWwn = rs.getBytes(3);
                int flags = rs.getInt(4);
                String swName = rs.getString(5);
                String enclName = rs.getString(6);
                String fname = rs.getString(7);
                String ifName = rs.getString(8);
                long ifSpeed = rs.getLong(9);
                int fcid = rs.getInt(10);
                int vsanId = rs.getInt(11);
                double rx = PersistentHelper.getHelper().getPmDouble(rs, 12);
                double tx = PersistentHelper.getHelper().getPmDouble(rs, 13);
                int pmType = rs.getInt(14);
                double rxtx = PersistentHelper.getHelper().getPmDouble(rs, 15);
                long swId = rs.getLong(16);
                byte[] ipByte = rs.getBytes(17);
                String swModel = rs.getString(18);
                String swVer = rs.getString(19);
                long fabricDbId = rs.getLong(20);
                long vsanDbId = rs.getLong(21);
                byte[] wwn = rs.getBytes(22);
                boolean isPresent = rs.getBoolean(23);
                long lastScanTime = rs.getLong(24);
                int operStatusCause = rs.getInt(25);
                long spId = rs.getLong(26);
                String network = "SAN";
                topoPath.fabricNameMap.put(fabricDbId, fname);
                if ((isHost && pmType != 4 || !isHost && pmType != 3) && pmType != 0 || isHost && !this.isStorage(flags, epWwn) || !isHost && !this.isInitiator(flags, epWwn) || !isHost && this.isBoth(flags, epWwn)) continue;
                String avgRx = !Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) + "B" : UNKNOWN;
                String avgTx = !Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) + "B" : UNKNOWN;
                String avgRxTx = !Double.isNaN(rxtx) ? DefaultSnmpNumberRenderer.formatLong((long)rxtx) + "B/s" : UNKNOWN;
                String fabricVsan = fabricDbId + ":" + vsanDbId;
                topoPath.fabricVsanMap.put(fabricVsan, fabricVsan);
                epAlias = epAlias == null || epAlias.length() == 0 ? SnmpString.toHexString(epWwn) : epAlias;
                String entityTip = "IP:" + (ipByte == null ? "" : InetAddress.getByAddress(ipByte).getHostAddress()) + "\n" + "Model:" + (swModel == null ? UNKNOWN : swModel) + "\n" + "Version:" + (swVer == null ? UNKNOWN : swVer);
                topoPath.sw2tipMap.put(swName, entityTip);
                String toolTip = epAlias + "<->" + swName + " " + ifName + ", FCID " + DisplayUtil.getFormattedFcId(fcid) + ", VSAN " + vsanId + (ifSpeed > 0L ? ", " + DisplayUtil.formatSpeed(ifSpeed) : "") + (avgRxTx.equals(UNKNOWN) ? "" : ", Rx+Tx " + avgRxTx);
                if (!isPresent) {
                    toolTip = toolTip + ", last seen " + SnmpTimeticks.getDateFormat().format(new Date(lastScanTime));
                } else if (operStatusCause != 2) {
                    toolTip = toolTip + " " + MibVariableFormat.toCauseString(operStatusCause) + " " + SnmpTimeticks.getDateFormat().format(new Date(lastScanTime));
                }
                String epName = epAlias;
                topoPath.stg2tipMap.put(epName + ";" + enclName, toolTip);
                topoPath.stg2SwitchMap.put(epName + ";" + enclName, swName + " " + ifName);
                topoPath.stg2SwitchWwnMap.put(epName + ";" + enclName, new WwnDO(wwn).getValue());
                String srcEntity = "";
                String npvTooltip = null;
                if (swName.equals(srcSwitch)) {
                    this.setHub(srcSwitch, topoPath.srcSwitchList);
                } else {
                    Long npId = topoPath.core2npMap.get(swId);
                    if (npId != null) {
                        String[] npvRst = this.getNpvInfo(con, npId, swId);
                        srcEntity = npvRst[0];
                        npvTooltip = npvRst[1];
                    } else {
                        srcEntity = fname;
                        TopoNodeDO fabricNode = this.locateNode(topoPath.fabricList, fname);
                        if (fabricNode == null) {
                            fabricNode = new TopoNodeDO(fname, 2, srcSwitch);
                            topoPath.fabricList.add(fabricNode);
                        } else if (fabricNode.getFromLink().indexOf(srcSwitch) < 0) {
                            fabricNode.setFromLink(fabricNode.getFromLink() + ";" + srcSwitch);
                        }
                    }
                }
                TopoNodeDO dstSwNode = this.locateNode(topoPath.dstSwitchList, swName);
                if (dstSwNode == null) {
                    if (srcEntity == null || srcEntity.length() == 0) {
                        srcEntity = fname;
                    }
                    dstSwNode = new TopoNodeDO(swName, 3, srcEntity, new String[]{toolTip});
                    topoPath.edgeSwitchMap.put(swName, dstSwNode);
                    dstSwNode.setEntityTip(topoPath.sw2tipMap.get(swName));
                    dstSwNode.setNpvTooltip(npvTooltip);
                    dstSwNode.setWwn(new WwnDO(wwn).getValue());
                    dstSwNode.setDbID(swId);
                } else {
                    dstSwNode.setToolTip(HostEnclTopology.add2Array(dstSwNode.getToolTip(), toolTip));
                }
                int dstSwIdx = topoPath.dstSwitchList.indexOf(dstSwNode);
                if (dstSwIdx < 0) {
                    dstSwNode.setToLink(HostEnclTopology.add2Array(dstSwNode.getToLink(), epName + ";" + zoneId + ";" + epId));
                    dstSwNode.setSwIfNames(HostEnclTopology.add2Array(dstSwNode.getSwIfNames(), ifName));
                    dstSwNode.setEncls(HostEnclTopology.add2Array(dstSwNode.getEncls(), enclName, true));
                    topoPath.dstSwitchList.add(dstSwNode);
                } else {
                    topoPath.dstSwitchList.get(dstSwIdx).setToLink(HostEnclTopology.add2Array(topoPath.dstSwitchList.get(dstSwIdx).getToLink(), epName + ";" + zoneId + ";" + epId));
                    topoPath.dstSwitchList.get(dstSwIdx).setSwIfNames(HostEnclTopology.add2Array(topoPath.dstSwitchList.get(dstSwIdx).getSwIfNames(), ifName, true));
                    topoPath.dstSwitchList.get(dstSwIdx).setEncls(HostEnclTopology.add2Array(topoPath.dstSwitchList.get(dstSwIdx).getEncls(), enclName, true));
                }
                if (isHost) {
                    this.addPortGroupItem(topoPath.storagePortGroupList, swId, spId, network);
                    continue;
                }
                this.addPortGroupItem(topoPath.hostPortGroupList, swId, spId, network);
            }
            topoPath.maxVertCnt = topoPath.maxVertCnt < topoPath.dstSwitchList.size() ? topoPath.dstSwitchList.size() : topoPath.maxVertCnt;
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNpvInfo(Connection con, long npId, long swId) {
        String npvName;
        String npvTooltip;
        block6: {
            String sql = "\tselect sw1.sys_name, sp1.if_name, sw2.sys_name, sp2.if_name from npv_link npl, switch sw1, \tswitch sw2, switch_port sp1, switch_port sp2 \twhere npl.np_switch_id = sw1.id and npl.core_switch_id = sw2.id and npl.np_port_index = sp1.if_index \tand npl.f_port_index = sp2.if_index and sw1.id = ? and sw2.id = ?";
            PreparedStatement stmt = null;
            ResultSet rs = null;
            npvTooltip = "";
            npvName = "";
            try {
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, npId);
                stmt.setLong(2, swId);
                rs = SQLLoader.execute(stmt);
                if (rs.next()) {
                    npvName = rs.getString(1);
                    String npIf = rs.getString(2);
                    String coreName = rs.getString(3);
                    String coreIf = rs.getString(4);
                    npvTooltip = npvName + " " + npIf + "<->" + coreName + " " + coreIf;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
        return new String[]{npvName, npvTooltip};
    }

    private boolean containLabel(List<TopoNodeDO> tgeist, TopoNodeDO tgtNode) {
        for (TopoNodeDO item : tgeist) {
            if (!item.getNodeLabel().equals(tgtNode.getNodeLabel())) continue;
            return true;
        }
        return false;
    }

    public static String[] add2Array(String[] toLink, String[] entity) {
        if (entity == null || entity.length == 0) {
            return toLink;
        }
        String[] newToLink = toLink;
        for (int i = 0; i < entity.length; ++i) {
            newToLink = HostEnclTopology.add2Array(newToLink, entity[i], true);
        }
        return newToLink;
    }

    public static String[] add2Array(String[] toLink, String entity) {
        return HostEnclTopology.add2Array(toLink, entity, false);
    }

    public static String[] add2Array(String[] toLink, String entity, boolean allowDup) {
        if (!allowDup) {
            for (String tl : toLink) {
                if (!tl.equals(entity)) continue;
                return toLink;
            }
        }
        String[] ans = new String[toLink.length + 1];
        System.arraycopy(toLink, 0, ans, 0, toLink.length);
        ans[ans.length - 1] = entity;
        return ans;
    }

    private void setHub(String srcSwitch, List<TopoNodeDO> nodeList) {
        for (TopoNodeDO node : nodeList) {
            if (!node.getNodeLabel().equals(srcSwitch) || node.getType() != 1) continue;
            node.setHub(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEthIslAndOtherSwitch(long ethSwId, Connection con, TopoPath topoPath) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String swStatus = null;
            int startIdx = 0;
            String sortSql = " AND ((S1.ID = " + ethSwId + ") OR (S2.ID = " + ethSwId + ")) ";
            int recordSize = 128;
            ArrayList<IslDO> lanIslList = IslHandler.getInstance().getLanIslList(startIdx, swStatus, recordSize, sortSql, true);
            if (lanIslList != null) {
                for (int i = 0; i < lanIslList.size(); ++i) {
                    SwitchDO lanSwitchDO;
                    ArrayList<Object> lanSwitches;
                    IslDO islDO = lanIslList.get(i);
                    this.addPortGroupItem(topoPath.islPortGroupList, islDO.getSw1Id(), islDO.getSwitchPort1Id(), "LAN");
                    this.addPortGroupItem(topoPath.islPortGroupList, islDO.getSw2Id(), islDO.getSwitchPort2Id(), "LAN");
                    topoPath.lanIslList.add(this.createIsl(islDO));
                    String swName = islDO.getFromSwitch();
                    long swId = islDO.getSw1Id();
                    TopoNodeDO topoNodeDo = this.locateNode(topoPath.lanSwitchList, swName);
                    if (topoNodeDo == null) {
                        lanSwitches = new ArrayList();
                        lanSwitches = this.getLanSwitchList(swId, 0L);
                        if (lanSwitches != null && lanSwitches.size() > 0 && (lanSwitchDO = (SwitchDO)lanSwitches.get(0)) != null) {
                            topoNodeDo = this.createSwitch(lanSwitchDO, topoPath);
                            topoPath.lanSwitchList.add(topoNodeDo);
                            topoNodeDo.setLan(true);
                            if (swId == ethSwId) {
                                topoNodeDo.setType(1);
                            } else {
                                topoNodeDo.setType(3);
                            }
                        }
                    }
                    swName = islDO.getToSwitch();
                    swId = islDO.getSw2Id();
                    topoNodeDo = this.locateNode(topoPath.lanSwitchList, swName);
                    if (topoNodeDo != null) continue;
                    lanSwitches = new ArrayList();
                    lanSwitches = this.getLanSwitchList(swId, 0L);
                    if (lanSwitches == null || lanSwitches.size() <= 0 || (lanSwitchDO = (SwitchDO)lanSwitches.get(0)) == null) continue;
                    topoNodeDo = this.createSwitch(lanSwitchDO, topoPath);
                    topoPath.lanSwitchList.add(topoNodeDo);
                    if (swId == ethSwId) {
                        topoNodeDo.setType(1);
                        continue;
                    }
                    topoNodeDo.setType(3);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFexIslAndOtherSwitch(long fexSwId, String fexSwName, String fexIfName, Connection con, TopoPath topoPath) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(" SELECT SWITCH_ID FROM ETHSWITCH_FEX WHERE FEX_ID = ?");
            stmt.setLong(1, fexSwId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                TopoNodeDO topoNodeDo;
                SwitchDO lanSwitchDO;
                long swId = rs.getLong(1);
                if (swId <= 0L) continue;
                ArrayList<Object> lanSwitches = new ArrayList();
                lanSwitches = this.getLanSwitchList(swId, 0L);
                if (lanSwitches == null || lanSwitches.size() <= 0 || (lanSwitchDO = (SwitchDO)lanSwitches.get(0)) == null) continue;
                String swStatus = null;
                int startIdx = 0;
                String sortSql = " AND ((S1.ID = " + fexSwId + " AND S2.ID = " + lanSwitchDO.getSwitchDbID() + ") OR (S1.ID = " + lanSwitchDO.getSwitchDbID() + " AND S2.ID = " + fexSwId + ")) ";
                int recordSize = 128;
                ArrayList<IslDO> lanIslList = IslHandler.getInstance().getLanIslList(startIdx, swStatus, recordSize, sortSql, true);
                int numIslAdded = 0;
                if (lanIslList != null) {
                    for (int i = 0; i < lanIslList.size(); ++i) {
                        IslDO islDO = lanIslList.get(i);
                        this.addPortGroupItem(topoPath.islPortGroupList, islDO.getSw1Id(), islDO.getSwitchPort1Id(), "LAN");
                        this.addPortGroupItem(topoPath.islPortGroupList, islDO.getSw2Id(), islDO.getSwitchPort2Id(), "LAN");
                        topoPath.lanIslList.add(this.createIsl(islDO));
                        ++numIslAdded;
                    }
                }
                if ((topoNodeDo = this.locateNode(topoPath.lanSwitchList, lanSwitchDO.getLogicalName())) != null || numIslAdded <= 0) continue;
                topoNodeDo = this.createSwitch(lanSwitchDO, topoPath);
                topoPath.lanSwitchList.add(topoNodeDo);
                topoNodeDo.setLan(true);
                topoNodeDo.setType(3);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLanHost2LanSwitchMapping(long hostId, Connection con, TopoPath topoPath, String encName) {
        block13: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                sql = "SELECT ETH_SWITCH_ID, ETH_IFNAME, NAME, ETHSWITCH_PORT_ID, VLAN, IF_SPEED, TOTAL_RXTX FROM LAN_HOST LEFT JOIN ETHSWITCH_PORT ON ETHSWITCH_PORT.ID = ETHSWITCH_PORT_ID LEFT JOIN STATISTICS  ON STATISTICS.SRC_ID = ETHSWITCH_PORT.ID WHERE LAN_HOST.ID = ?";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, hostId);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long swId = rs.getLong(1);
                    String ifName = rs.getString(2);
                    String hostName = rs.getString(3);
                    String swName = UNKNOWN;
                    long spId = rs.getLong(4);
                    int vlanId = rs.getInt(5);
                    long ifSpeed = rs.getLong(6);
                    String zName = UNKNOWN;
                    long zoneId = 0L;
                    String swModel = UNKNOWN;
                    String swVer = UNKNOWN;
                    String ipString = UNKNOWN;
                    double rxtx = PersistentHelper.getHelper().getPmDouble(rs, 7);
                    String avgRxTx = !Double.isNaN(rxtx) ? DefaultSnmpNumberRenderer.formatLong((long)rxtx) + "B/s" : UNKNOWN;
                    String network = "LAN";
                    if (swId <= 0L) continue;
                    SwitchDO lanSwitchDO = null;
                    ArrayList<Object> lanSwitches = new ArrayList();
                    lanSwitches = this.getLanSwitchList(swId, 0L);
                    if (lanSwitches != null && lanSwitches.size() > 0 && (lanSwitchDO = (SwitchDO)lanSwitches.get(0)) != null) {
                        swName = lanSwitchDO.getLogicalName();
                        ipString = lanSwitchDO.getIpAddress();
                        swModel = lanSwitchDO.getModel();
                        swVer = lanSwitchDO.getRelease();
                        TopoNodeDO topoNodeDo = this.locateNode(topoPath.lanSwitchList, lanSwitchDO.getLogicalName());
                        if (topoNodeDo == null) {
                            topoNodeDo = this.createSwitch(lanSwitchDO, topoPath);
                            topoPath.lanSwitchList.add(topoNodeDo);
                        }
                        topoNodeDo.setLan(true);
                        topoNodeDo.setType(1);
                        if (lanSwitchDO.isFex()) {
                            this.getFexIslAndOtherSwitch(swId, swName, ifName, con, topoPath);
                        } else if (lanSwitchDO.getModel().equals("Nexus1000V") || lanSwitchDO.getModel().equals("Nexus1010")) {
                            this.getEthIslAndOtherSwitch(swId, con, topoPath);
                        }
                        String entityTip = "IP:" + ipString + "\n" + "Model:" + (swModel == null ? UNKNOWN : swModel) + "\n" + "Version:" + (swVer == null ? UNKNOWN : swVer);
                        if (swName != null) {
                            topoPath.sw2tipMap.put(swName, entityTip);
                        }
                        topoPath.host2tipMap.put(hostId, hostName + "<->" + swName + " " + ifName + ", VLAN " + vlanId + (ifSpeed <= 0L ? "" : ", " + DisplayUtil.formatSpeed(ifSpeed)) + (avgRxTx.equals(UNKNOWN) ? "" : ", Rx+Tx " + avgRxTx));
                        String hostKey = hostId + ";" + hostName + ";" + vlanId + ";" + ifName + ";" + zoneId + ";" + zName + ";" + topoPath.svcProfile + ";" + swName + ";" + encName + ";" + IS_LAN + ";" + Boolean.toString(lanSwitchDO != null && lanSwitchDO.getVdcId() != -1);
                        topoPath.hostEdgeLinkTipMap.put(hostKey, hostName + "<->" + swName + " " + ifName + ", VLAN " + vlanId + (ifSpeed <= 0L ? "" : ", " + DisplayUtil.formatSpeed(ifSpeed)) + (avgRxTx.equals(UNKNOWN) ? "" : ", Rx+Tx " + avgRxTx));
                        topoPath.hostList.add(hostKey);
                        if (swName != null) {
                            topoPath.ep2SwitchMap.put(hostKey, swName);
                        }
                    }
                    this.addPortGroupItem(topoPath.hostPortGroupList, swId, spId, network);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block13;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
    }

    public static String formatMacAddr(String mac) {
        if (mac == null) {
            return mac;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(mac, ":");
        int count = 0;
        while (tokenizer.hasMoreElements()) {
            String t = tokenizer.nextToken();
            ++count;
            if (t.length() != 2) {
                return mac;
            }
            if (count == 2 || count == 4) {
                sb.append(t).append(".");
                continue;
            }
            sb.append(t);
        }
        return sb.toString();
    }

    private ArrayList<SwitchDO> getLanSwitchList(long switchId, long lanId) {
        String sqlSuffix = " Where ethswitch.id =" + switchId;
        DbFilterDO dbFilter = new DbFilterDO();
        dbFilter.setNetworkType("LAN");
        String status = "All";
        int recordSize = SwitchHandler.getInstance().getLanSwitchDataLength(dbFilter, status);
        ArrayList<SwitchDO> rstList = this.getLanSwitchList(0, "All", recordSize, sqlSuffix, true);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<SwitchDO> getLanSwitchList(int startIdx, String swStatus, int recordSize, String sortSql, boolean lanOnly) {
        ArrayList<SwitchDO> lanList;
        block13: {
            lanList = new ArrayList<SwitchDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                boolean hasCapData = false;
                con = ConnectionManager.getConnection();
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, SQL_Query_all_lan_switch + sortSql, 1004, 1007);
                rs = stmt.executeQuery();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long switchDbID = rs.getLong(1);
                    byte[] ipAddress = rs.getBytes(2);
                    String model = rs.getString(3);
                    String sys_name = rs.getString(4);
                    String sys_contact = rs.getString(5);
                    String sys_location = rs.getString(6);
                    String version = rs.getString(7);
                    String serialNo = rs.getString(8);
                    long sysUpTime = rs.getLong(9);
                    String vendor = rs.getString(10);
                    int num_ports = rs.getInt(11);
                    boolean is_present = rs.getBoolean(12);
                    boolean isManagable = rs.getBoolean(13);
                    String unmanagableCause = rs.getString(14);
                    boolean isVdc = rs.getBoolean(15);
                    int vdcId = rs.getInt(16);
                    String vdcName = rs.getString(17);
                    boolean isFcoeEnabled = rs.getBoolean(18);
                    int cpuUsage = rs.getInt(19);
                    int memoryUsage = rs.getInt(20);
                    long lastScanTime = rs.getLong(21);
                    String vdcMac = rs.getString(22);
                    boolean isFex = rs.getBoolean(23);
                    int num_1gports = rs.getInt(24);
                    int num_2gports = rs.getInt(25);
                    int num_4gports = rs.getInt(26);
                    int num_8gports = rs.getInt(27);
                    int num_10gports = rs.getInt(28);
                    int totalPorts = num_1gports + num_2gports + num_4gports + num_8gports + num_10gports;
                    int health = -1;
                    if (hasCapData) {
                        double health_double = rs.getDouble(29);
                        if (!rs.wasNull()) {
                            health = (int)(health_double * 100.0);
                        }
                    }
                    SwitchDO wrapper = new SwitchDO();
                    wrapper.setLan(true);
                    wrapper.setSwitchDbID(switchDbID);
                    wrapper.setLogicalName(sys_name);
                    wrapper.setSwWwnName(serialNo);
                    wrapper.setSerialNumber(serialNo);
                    if (ipAddress != null) {
                        wrapper.setIpAddress(InetAddress.getByAddress(ipAddress).getHostAddress());
                    }
                    wrapper.setModel(model);
                    wrapper.setNonMdsModel(model);
                    wrapper.setManagable(isManagable);
                    wrapper.setUnmanagableCause(unmanagableCause);
                    wrapper.setNetwork("LAN");
                    wrapper.setNumberOfPorts(totalPorts);
                    wrapper.setVendor(vendor);
                    wrapper.setRelease(version);
                    wrapper.setLocation(sys_location);
                    wrapper.setContact(sys_contact);
                    wrapper.setPresent(is_present);
                    wrapper.setLastScanTime(lastScanTime);
                    wrapper.setUpTimeStr(sysUpTime != 0L ? SnmpTimeticks.formatTimeElapsed((System.currentTimeMillis() - sysUpTime) / 10L) : "");
                    wrapper.setStatus(DisplayUtil.getEthSwitchStatus(wrapper));
                    wrapper.setIndex(0);
                    wrapper.setupMapping();
                    if (isVdc) {
                        wrapper.setVdcId(vdcId);
                        wrapper.setVdcName(vdcName);
                        wrapper.setVdcMac(vdcMac);
                    } else {
                        wrapper.setVdcId(-1);
                    }
                    wrapper.setFcoeEnabled(isFcoeEnabled);
                    wrapper.setCpuUsage(cpuUsage);
                    wrapper.setMemoryUsage(memoryUsage);
                    wrapper.setFex(isFex);
                    if (health != -1) {
                        wrapper.setHealth(health);
                    }
                    if (!SQLLoader.isKeywordPresent(wrapper.getStatus(), swStatus)) continue;
                    lanList.add(wrapper);
                    if (swStatus.equalsIgnoreCase("Warning") || recordSize <= 0 || ++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block13;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return lanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Long> getVmIdsForVhost(long vhostId, Connection con) {
        ResultSet rs;
        PreparedStatement stmt;
        ArrayList<Long> vmIdList;
        block5: {
            vmIdList = new ArrayList<Long>();
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(" select id from vm where vhost_id = ?");
                stmt.setLong(1, vhostId);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long vmId = rs.getLong(1);
                    vmIdList.add(vmId);
                }
                if (vmIdList.size() != 0) break block5;
                this._Log.warn((Object)("No results at getVmIdsForVhost() for:  select id from vm where vhost_id = " + vhostId));
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return vmIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getMacsForVm(long vmId, Connection con) {
        ResultSet rs;
        PreparedStatement stmt;
        ArrayList<String> macList;
        block5: {
            macList = new ArrayList<String>();
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(" select mac from vnic where vm_id = ?");
                stmt.setLong(1, vmId);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    String mac = rs.getString(1);
                    macList.add(HostEnclTopology.formatMacAddr(mac.toUpperCase()));
                }
                if (macList.size() != 0) break block5;
                this._Log.warn((Object)("No results at getMacsForVm() for:  select mac from vnic where vm_id = " + vmId));
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return macList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getMacsForVhost(long vhost_id, Connection con) {
        String mac;
        ResultSet rs;
        PreparedStatement stmt;
        ArrayList<String> macList;
        block13: {
            macList = new ArrayList<String>();
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(" select mac from phynic where vhost_id = ?");
                stmt.setLong(1, vhost_id);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    mac = rs.getString(1);
                    macList.add(HostEnclTopology.formatMacAddr(mac.toUpperCase()));
                }
                if (macList.size() != 0) break block13;
                this._Log.warn((Object)("No results at getMacsForVhost() for:  select mac from phynic where vhost_id = " + vhost_id));
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        try {
            stmt = con.prepareStatement(" select mac_address from vhost where id = ?");
            stmt.setLong(1, vhost_id);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                mac = rs.getString(1);
                StringTokenizer tokenizer = new StringTokenizer(mac, ",");
                while (tokenizer.hasMoreElements()) {
                    String t = tokenizer.nextToken();
                    macList.add(HostEnclTopology.formatMacAddr(t.toUpperCase()));
                }
            }
            if (macList.size() == 0) {
                this._Log.warn((Object)("No results at getMacsForVhost() for:  select mac_address from vhost where id = " + vhost_id));
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        return macList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Long> getPhysicalPortIdsForMac(String mac, Connection con) {
        ResultSet rs;
        PreparedStatement stmt;
        ArrayList<Long> physicalPortIdList;
        block5: {
            physicalPortIdList = new ArrayList<Long>();
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(" select n.physicalport_id, n.macaddress from networkinterface n left join abstractcomputersystem a on a.instanceclassid=n.abstractcomputersystem_id where n.abstractcomputersystem_id is not null and n.physicalport_id is not null and n.macaddress is not null and  n.macaddress = '" + mac + "'");
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long physicalPortId = rs.getLong(1);
                    physicalPortIdList.add(physicalPortId);
                }
                if (physicalPortIdList.size() != 0) break block5;
                this._Log.warn((Object)("No results at getPhysicalPortIdsForMac() for:  select n.physicalport_id, n.macaddress from networkinterface n left join abstractcomputersystem a on a.instanceclassid=n.abstractcomputersystem_id where n.abstractcomputersystem_id is not null and n.physicalport_id is not null and n.macaddress is not null and  n.macaddress = '" + mac + "'"));
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return physicalPortIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLanVhost2LanSwitchMapping(long vhostId, String hostName, Connection con, TopoPath topoPath, String encName) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement queryStat2 = null;
        ResultSet rs2 = null;
        try {
            ArrayList<String> macList = this.getMacsForVhost(vhostId, con);
            ArrayList<Long> vmIdList = this.getVmIdsForVhost(vhostId, con);
            for (int i = 0; i < vmIdList.size(); ++i) {
                long vmId = vmIdList.get(i);
                macList.addAll(this.getMacsForVm(vmId, con));
            }
            ArrayList<Long> portList = new ArrayList<Long>();
            for (int j = 0; j < macList.size(); ++j) {
                String mac = macList.get(j);
                portList.addAll(this.getPhysicalPortIdsForMac(mac, con));
            }
            for (int k = 0; k < portList.size(); ++k) {
                try {
                    long physicalPortId = (Long)portList.get(k);
                    stmt = con.prepareStatement("select distinct es.id, es.sys_name, n.name from ethswitch es, physicalport b left join networkinterface n on b.networkinterface_id=n.instanceclassid where es.serial_number in (select b.serialnumber from physicalport a where a.port_link_id = b.port_link_id and a.hardware_id = ? and b.hardware_id != ?)");
                    stmt.setLong(1, physicalPortId);
                    stmt.setLong(2, physicalPortId);
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        StringTokenizer tokenizer;
                        long swId = rs.getLong(1);
                        String swName = rs.getString(2);
                        String ifName = rs.getString(3);
                        int vsanId = 0;
                        long ifSpeed = 0L;
                        String zName = UNKNOWN;
                        long zoneId = 0L;
                        String swModel = UNKNOWN;
                        String swVer = UNKNOWN;
                        String ipString = UNKNOWN;
                        SwitchDO lanSwitchDO = null;
                        if (ifName.startsWith("Eth") && (tokenizer = new StringTokenizer(ifName, "/")).hasMoreElements()) {
                            int fexId;
                            String temp = null;
                            if (ifName.startsWith("Ethernet")) {
                                temp = ((String)tokenizer.nextElement()).substring("Ethernet".length());
                            } else if (ifName.startsWith("Eth")) {
                                temp = ((String)tokenizer.nextElement()).substring("Eth".length());
                            }
                            if (temp != null && !temp.equals("") && (fexId = Integer.parseInt(temp)) >= 100) {
                                block22: {
                                    try {
                                        queryStat2 = con.prepareStatement(QueryFexNameSQL);
                                        queryStat2.setLong(1, swId);
                                        rs2 = queryStat2.executeQuery();
                                        if (!rs2.next()) break block22;
                                        swId = rs2.getLong(1);
                                        swName = rs2.getString(2);
                                    }
                                    catch (Throwable throwable) {
                                        DbUtil.close(rs2);
                                        DbUtil.close(queryStat2);
                                        throw throwable;
                                    }
                                }
                                DbUtil.close(rs2);
                                DbUtil.close(queryStat2);
                            }
                        }
                        if (swId > 0L) {
                            ArrayList<Object> lanSwitches = new ArrayList();
                            lanSwitches = this.getLanSwitchList(swId, 0L);
                            if (lanSwitches != null && lanSwitches.size() > 0 && (lanSwitchDO = (SwitchDO)lanSwitches.get(0)) != null) {
                                ipString = lanSwitchDO.getIpAddress();
                                swModel = lanSwitchDO.getModel();
                                swVer = lanSwitchDO.getRelease();
                                TopoNodeDO topoNodeDo = this.locateNode(topoPath.lanSwitchList, lanSwitchDO.getLogicalName());
                                if (topoNodeDo == null) {
                                    topoNodeDo = this.createSwitch(lanSwitchDO, topoPath);
                                    topoPath.lanSwitchList.add(topoNodeDo);
                                }
                                topoNodeDo.setLan(true);
                                topoNodeDo.setType(1);
                                if (lanSwitchDO.isFex()) {
                                    this.getFexIslAndOtherSwitch(swId, swName, ifName, con, topoPath);
                                } else if (lanSwitchDO.getModel().equals("Nexus1000V") || lanSwitchDO.getModel().equals("Nexus1010")) {
                                    this.getEthIslAndOtherSwitch(swId, con, topoPath);
                                }
                            }
                        }
                        String avgRxTx = UNKNOWN;
                        String entityTip = "IP:" + ipString + "\n" + "Model:" + (swModel == null ? UNKNOWN : swModel) + "\n" + "Version:" + (swVer == null ? UNKNOWN : swVer);
                        if (swName != null) {
                            topoPath.sw2tipMap.put(swName, entityTip);
                        }
                        topoPath.host2tipMap.put(vhostId, hostName + "<->" + swName + " " + ifName + (ifSpeed <= 0L ? "" : ", " + DisplayUtil.formatSpeed(ifSpeed)) + (avgRxTx.equals(UNKNOWN) ? "" : ", Rx+Tx " + avgRxTx));
                        String hostKey = vhostId + ";" + hostName + ";" + vsanId + ";" + ifName + ";" + zoneId + ";" + zName + ";" + topoPath.svcProfile + ";" + swName + ";" + encName + ";" + IS_LAN + ";" + Boolean.toString(lanSwitchDO != null && lanSwitchDO.getVdcId() != -1);
                        topoPath.hostEdgeLinkTipMap.put(hostKey, hostName + "<->" + swName + " " + ifName + (ifSpeed <= 0L ? "" : ", " + DisplayUtil.formatSpeed(ifSpeed)) + (avgRxTx.equals(UNKNOWN) ? "" : ", Rx+Tx " + avgRxTx));
                        topoPath.hostList.add(hostKey);
                        if (swName == null) continue;
                        topoPath.ep2SwitchMap.put(hostKey, swName);
                    }
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getep2SwitchMapping(long encId, Connection con, boolean isHost, TopoPath topoPath, String encName) {
        block12: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                long start = 0L;
                long end = 0L;
                start = System.currentTimeMillis();
                sql = SQLLoader.getSqlStmt(isHost ? "HostEnclTopology.HOST_2_SWITCH_STMT" : "StorageEnclTopology.STORAGE_2_SWITCH_STMT");
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, encId);
                rs = SQLLoader.execute(stmt);
                end = System.currentTimeMillis();
                this.timer(start, end, "getep2SwitchMapping() Sql Execution");
                while (rs.next()) {
                    long epId = rs.getLong(1);
                    String swName = rs.getString(2);
                    String epAlias = rs.getString(3);
                    String ifName = rs.getString(4);
                    long ifSpeed = rs.getLong(5);
                    int fcid = rs.getInt(6);
                    int vsanId = rs.getInt(7);
                    long swId = rs.getLong(8);
                    double rx = PersistentHelper.getHelper().getPmDouble(rs, 9);
                    double tx = PersistentHelper.getHelper().getPmDouble(rs, 10);
                    int pmType = rs.getInt(11);
                    long zoneId = rs.getLong(12);
                    double rxtx = PersistentHelper.getHelper().getPmDouble(rs, 13);
                    long coreId = rs.getLong(14);
                    byte[] ipByte = rs.getBytes(15);
                    String swModel = rs.getString(16);
                    String swVer = rs.getString(17);
                    String zName = rs.getString(18);
                    long cfsRegionId = rs.getLong(19);
                    byte[] epWwn = rs.getBytes(20);
                    topoPath.svcProfile = rs.getString(21);
                    topoPath.svrBlade = rs.getString(22);
                    long fabricDbId = rs.getLong(23);
                    long vsanDbId = rs.getLong(24);
                    byte[] wwn = rs.getBytes(25);
                    boolean isPresent = rs.getBoolean(26);
                    long lastScanTime = rs.getLong(27);
                    int operStatusCause = rs.getInt(28);
                    boolean isVdc = rs.getBoolean(29);
                    long spId = rs.getLong(30);
                    String network = "SAN";
                    String string = zName = cfsRegionId == -1L ? zName : zName + "(" + cfsRegionId + ")";
                    if ((isHost && pmType != 3 || !isHost && pmType != 4) && pmType != 0) continue;
                    if (epAlias == null || epAlias.length() == 0) {
                        epAlias = new Wwn(epWwn).toString();
                    }
                    String avgRx = !Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) + "b" : UNKNOWN;
                    String avgTx = !Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) + "b" : UNKNOWN;
                    String avgRxTx = !Double.isNaN(rxtx) ? DefaultSnmpNumberRenderer.formatLong((long)rxtx) + "B/s" : UNKNOWN;
                    String fabricVsan = fabricDbId + ":" + vsanDbId;
                    topoPath.fabricVsanMap.put(fabricVsan, fabricVsan);
                    String entityTip = "IP:" + (ipByte == null ? "" : InetAddress.getByAddress(ipByte).getHostAddress()) + "\n" + "Model:" + (swModel == null ? UNKNOWN : swModel) + "\n" + "Version:" + (swVer == null ? UNKNOWN : swVer);
                    topoPath.sw2tipMap.put(swName, entityTip);
                    String toolTip = epAlias + "<->" + swName + " " + ifName + ", FCID " + DisplayUtil.getFormattedFcId(fcid) + ", VSAN " + vsanId + (ifSpeed <= 0L ? "" : ", " + DisplayUtil.formatSpeed(ifSpeed)) + (avgRxTx.equals(UNKNOWN) ? "" : ", Rx+Tx " + avgRxTx);
                    if (!isPresent) {
                        toolTip = toolTip + ", last seen " + SnmpTimeticks.getDateFormat().format(new Date(lastScanTime));
                    } else if (operStatusCause != 2) {
                        toolTip = toolTip + " " + MibVariableFormat.toCauseString(operStatusCause) + " " + SnmpTimeticks.getDateFormat().format(new Date(lastScanTime));
                    }
                    topoPath.host2tipMap.put(epId, toolTip);
                    if (coreId > 0L) {
                        topoPath.core2npMap.put(coreId, swId);
                    }
                    String hostKey = epId + ";" + epAlias + ";" + vsanId + ";" + ifName + ";" + zoneId + ";" + zName + ";" + topoPath.svcProfile + ";" + new WwnDO(wwn).getValue() + ";" + encName + ";" + IS_SAN + ";" + isVdc;
                    topoPath.hostEdgeLinkTipMap.put(hostKey, toolTip);
                    topoPath.hostList.add(hostKey);
                    topoPath.ep2SwitchMap.put(hostKey, swName);
                    if (isHost) {
                        this.addPortGroupItem(topoPath.hostPortGroupList, swId, spId, network);
                        continue;
                    }
                    this.addPortGroupItem(topoPath.storagePortGroupList, swId, spId, network);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block12;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
    }

    private String getEnclToolTip(TopoPath topoPath) {
        Iterator<Long> epItr = topoPath.host2tipMap.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("Members:");
        ArrayList<String> edgeLinks = new ArrayList<String>();
        while (epItr.hasNext()) {
            Long epId = epItr.next();
            String edgeLink = topoPath.host2tipMap.get(epId).split(";")[0];
            edgeLinks.add(edgeLink);
        }
        Object[] sortedEdgeLinks = edgeLinks.toArray(new String[edgeLinks.size()]);
        Arrays.sort(sortedEdgeLinks);
        for (Object edgeLink : sortedEdgeLinks) {
            String toolTip = ((String)edgeLink).split("<->")[0];
            if (((String)edgeLink).contains("last seen")) {
                toolTip = toolTip + ", " + ((String)edgeLink).substring(((String)edgeLink).indexOf("last seen"));
            }
            sb.append("\n\t" + toolTip);
        }
        if (topoPath.svrBlade != null && topoPath.svrBlade.length() > 0) {
            sb.append("\n");
            sb.append("Blade:");
            sb.append(topoPath.svrBlade + "\n");
            sb.append("Service Profile:");
            sb.append(topoPath.svcProfile);
        }
        return sb.toString();
    }

    private String getStgEnclToolTip(String enclName, TopoPath topoPath) {
        Iterator<String> epItr = topoPath.stg2tipMap.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("Members:");
        while (epItr.hasNext()) {
            String key = epItr.next();
            if (!key.split(";")[1].equals(enclName)) continue;
            String edgeLink = topoPath.stg2tipMap.get(key).split(";")[0];
            String toolTip = edgeLink.split("<->")[0];
            if (edgeLink.contains("last seen")) {
                toolTip = toolTip + ", " + edgeLink.substring(edgeLink.indexOf("last seen"));
            }
            sb.append("\n\t" + toolTip);
        }
        return sb.toString();
    }

    private boolean isStorage(int flags, byte[] wwn) {
        return !SQLLoader.isHost(flags) && (SQLLoader.isTarget(flags) || SQLLoader.isUnknownStorage(flags, wwn));
    }

    private boolean isHost(int flags, byte[] wwn) {
        return SQLLoader.isHost(flags);
    }

    private boolean isInitiator(int flag, byte[] wwn) {
        return SQLLoader.isInitiator(flag);
    }

    private boolean isBoth(int flag, byte[] wwn) {
        return SQLLoader.isInitiator(flag) && SQLLoader.isTarget(flag);
    }

    private void timer(long start, long end, String name) {
        long duration = end - start;
        if (duration < 10L) {
            this._Log.info((Object)("   " + duration + " ms " + name));
        } else if (duration < 100L) {
            this._Log.info((Object)("  " + duration + " ms " + name));
        } else if (duration < 1000L) {
            this._Log.info((Object)(" " + duration + " ms " + name));
        } else {
            this._Log.info((Object)(duration + " ms " + name));
        }
    }
}

