/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.util;

import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PerfUtil {
    public static final String UNKNOWN = "n/a";
    public static final String DEFAULT_SORT_COLUMN = "rxTx";
    public static final double initDouble = -1.0;
    public static final double MB = 1000000.0;
    static Logger _Logger = LogManager.getLogger((String)"fms.ws");

    private PerfUtil() {
    }

    public static String[] getIntervals() {
        String[] intervals = new String[]{"24 Hours", "Week", "Month", "Year"};
        return intervals;
    }

    public static String getAvgIntervalColumn(String interval) {
        String col = "STAT.AVG_";
        if (interval.trim().equals(PerfUtil.getIntervals()[0])) {
            return col;
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[1])) {
            return "LAST_WEEK_AVG_";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[2])) {
            return "LAST_MONTH_AVG_";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[3])) {
            return "LAST_YEAR_AVG_";
        }
        return col;
    }

    public static String getMaxIntervalColumn(String interval) {
        String col = "STAT.MAX_";
        if (interval.trim().equals(PerfUtil.getIntervals()[0])) {
            return col;
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[1])) {
            return "LAST_WEEK_MAX_";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[2])) {
            return "LAST_MONTH_MAX_";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[3])) {
            return "LAST_YEAR_MAX_";
        }
        return col;
    }

    public static String getErrorIntervalColumn(String interval) {
        String col = "STAT.TOTAL_ERR";
        if (interval.trim().equals(PerfUtil.getIntervals()[0])) {
            return col;
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[1])) {
            return "LAST_WEEK_TOTAL_ERR";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[2])) {
            return "LAST_MONTH_TOTAL_ERR";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[3])) {
            return "LAST_YEAR_TOTAL_ERR";
        }
        return col;
    }

    public static String getDiscardIntervalColumn(String interval) {
        String col = "STAT.TOTAL_DISCARD";
        if (interval.trim().equals(PerfUtil.getIntervals()[0])) {
            return col;
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[1])) {
            return "LAST_WEEK_TOTAL_DISCARD";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[2])) {
            return "LAST_MONTH_TOTAL_DISCARD";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[3])) {
            return "LAST_YEAR_TOTAL_DISCARD";
        }
        return col;
    }

    public static String getTotalIntervalColumn(String interval) {
        String col = "STAT.TOTAL_RXTX";
        if (interval.trim().equals(PerfUtil.getIntervals()[0])) {
            return col;
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[1])) {
            return "LAST_WEEK_TOTAL_RXTX";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[2])) {
            return "LAST_MONTH_TOTAL_RXTX";
        }
        if (interval.trim().equals(PerfUtil.getIntervals()[3])) {
            return "LAST_YEAR_TOTAL_RXTX";
        }
        return col;
    }

    public static String xssReformat(String encode) {
        String result = encode;
        if (encode.charAt(encode.length() - 1) == '%') {
            result = encode.substring(0, encode.length() - 1);
        }
        return result;
    }

    public static double getExceedThresholdCoumn(String rrdFile, int pmType, int fid, int interval, double limit) {
        double ret = -1.0;
        try {
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(fid));
            double[][] rxtx = pmRif.getPmChartData(rrdFile, pmType, interval);
            if (rxtx != null) {
                int totalCount = rxtx.length;
                int exceedCount = 0;
                for (int i = 0; i < rxtx.length; ++i) {
                    double rx = rxtx[i][0];
                    double tx = rxtx[i][1];
                    if (!(rx > limit) && !(tx > limit)) continue;
                    ++exceedCount;
                }
                ret = (double)((int)((double)exceedCount / (double)totalCount * 10000.0)) / 100.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

