/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.util;

import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.util.WebResourceLoader;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class SQLLoader {
    static boolean allowUnLicensedFabrics = true;
    static WebResourceLoader sql = null;
    static final String REPLACE_CHAR = "%";
    static final String LOCAL_HOST = "127.0.0.1";
    static Logger _Log = Logger.getLogger((String)"fms");
    static final int FLAG_UNKNOWN = 0;
    static final int FLAG_TARGET = 1;
    static final int FLAG_INITIATOR = 2;
    static final int FLAG_FICON_CUP = 4;
    static final int FLAG_FICON_CU = 8;
    static final int FLAG_FICON_CH = 16;
    static final int FLAG_VIRTUAL_INITIATOR = 32;
    static final int FLAG_IPFC = 64;

    public static String getSql(String key) {
        if (allowUnLicensedFabrics) {
            return SQLLoader.getSqlWithoutLicensingCheck(key);
        }
        String roleFilter = "";
        roleFilter = "FABRIC.LICENSE_ID > 1 ";
        int[] ind = new int[]{99};
        String[] rep = new String[]{roleFilter};
        return SQLLoader.getSql(key, ind, rep);
    }

    public static String getSqlWithoutLicensingCheck(String key) {
        String roleFilter = "";
        roleFilter = "TRUE=TRUE";
        int[] ind = new int[]{99};
        String[] rep = new String[]{roleFilter};
        return SQLLoader.getSql(key, ind, rep);
    }

    public static String getSqlStmt(String key) {
        return SQLLoader.getSqlStmt(key, true);
    }

    public static String getSqlStmt(String key, boolean doFilter) {
        if (sql == null) {
            _Log.warn((Object)"SQL Statement are not loaded.");
        }
        String stmt = sql.get(key);
        if (doFilter) {
            stmt = PersistentHelper.getHelper().getQueryString(stmt);
        }
        return stmt;
    }

    public static String getSql(String key, int[] indices, String[] columns) {
        String stmt = null;
        if (sql != null) {
            stmt = sql.get(key);
            if (indices != null && columns != null && indices.length == columns.length) {
                for (int i = 0; i < indices.length; ++i) {
                    int indexNo = indices[i];
                    String colName = columns[i];
                    String expr = REPLACE_CHAR + indexNo;
                    stmt = stmt.replaceAll(expr, colName);
                }
            }
            if (stmt == null) {
                _Log.warn((Object)("SQL Statement not found :" + key));
            } else {
                _Log.debug((Object)(key + ":" + stmt));
            }
        } else {
            _Log.warn((Object)"SQL Statement are not loaded.");
        }
        stmt = PersistentHelper.getHelper().getQueryString(stmt);
        return stmt;
    }

    public static ResultSet execute(PreparedStatement sql) throws SQLException {
        Date start = new Date();
        sql.setFetchSize(50);
        ResultSet rs = sql.executeQuery();
        Date end = new Date();
        long time = end.getTime() - start.getTime();
        _Log.debug((Object)("SQL execution took " + (time < 1000L ? time + " msecs." : time / 1000L + " secs.")));
        return rs;
    }

    public static int executeUpdate(PreparedStatement sql) throws SQLException {
        Date start = new Date();
        int result = sql.executeUpdate();
        Date end = new Date();
        long time = end.getTime() - start.getTime();
        _Log.debug((Object)("SQL execution took " + (time < 1000L ? time + " msecs." : time / 1000L + " secs.")));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canExecute() {
        Connection conn = null;
        try {
            conn = ConnectionManager.getConnection();
            ConnectionManager.returnConnection(conn);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            if (!Service.isRunning((String)"FMPersist")) {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
            } else {
                _Log.warn((Object)"Database Server Error: ", (Throwable)ex);
            }
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isKeywordPresent(String data, String word) {
        boolean present = false;
        if (word == null || word.trim().length() == 0) {
            return true;
        }
        if (data == null || data.trim().length() == 0) {
            return false;
        }
        String str = data.toLowerCase();
        boolean ok = str.indexOf("ok") != -1;
        boolean up = str.indexOf("up") != -1;
        boolean down = str.indexOf("down") != -1;
        boolean exists = str.indexOf("last seen") == -1;
        boolean segmented = str.indexOf("segmented") != -1;
        boolean na = str.indexOf("n/a") != -1;
        boolean unlicensed = str.indexOf("unlicensed") != -1;
        boolean disabled = str.indexOf("disabled") != -1;
        boolean boot = str.indexOf("boot") != -1;
        boolean selfTest = str.indexOf("selfTest") != -1;
        boolean on = str.indexOf("on") != -1;
        boolean offAdmin = str.indexOf("offAdmin") != -1;
        _Log.debug((Object)("Filtering on " + data + "[" + ok + ":" + up + ":" + down + ":" + exists + ":" + segmented + "]"));
        if (word.equals("All")) {
            return true;
        }
        if (word.equals("Warning")) {
            return !ok && !up && !na && !disabled && !boot && !selfTest && !on && !offAdmin || segmented;
        }
        if (word.equals("Unlicensed")) {
            return unlicensed;
        }
        return false;
    }

    public static boolean isInitiator(int flag) {
        return (flag & 2) == 2;
    }

    public static boolean isHost(int flag) {
        return (flag & 2) == 2 && (flag & 1) != 1;
    }

    public static boolean isTarget(int flag) {
        return (flag & 1) == 1;
    }

    public static boolean isUnknownHost(int flag, byte[] wwn) {
        if (wwn == null) {
            return false;
        }
        if (WwnDictionary.getWwnVendor(wwn) == null) {
            return false;
        }
        return WwnDictionary.getWwnVendor(wwn).isHost();
    }

    public static boolean isUnknownStorage(int flag, byte[] wwn) {
        if (wwn == null) {
            return false;
        }
        if (WwnDictionary.getWwnVendor(wwn) == null) {
            return false;
        }
        return WwnDictionary.getWwnVendor(wwn).isStorage();
    }

    public static boolean isFicon(int flag) {
        return SQLLoader.isFiconCup(flag) || SQLLoader.isFiconCU(flag) || SQLLoader.isFiconCH(flag);
    }

    public static boolean isVirtualInitiator(int flag) {
        return (flag & 0x20) == 32;
    }

    public static boolean isIPFCPort(int flag) {
        return (flag & 0x40) == 64;
    }

    public static boolean isFiconCup(int flag) {
        return (flag & 4) == 4;
    }

    public static boolean isFiconCU(int flag) {
        return (flag & 8) == 8;
    }

    public static boolean isFiconCH(int flag) {
        return (flag & 0x10) == 16;
    }

    public static boolean isIscsi(byte[] type) {
        return Fc4Decoder.isFc4TypeSet(SQLLoader.getIntArray(type), 225);
    }

    public static boolean isSvc(byte[] type) {
        return Fc4Decoder.isFc4TypeSet(SQLLoader.getIntArray(type), 226);
    }

    public static boolean isVirtual(int flag) {
        return (flag & 0x20) == 32;
    }

    public static int[] getIntArray(byte[] b) {
        if (b == null) {
            return new int[0];
        }
        int[] nu = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            nu[i] = b[i];
        }
        return nu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream in = null;
        try {
            GenUtil.loadServerProperties(null);
            String allow = System.getProperty("web.allowUnLicensedFabrics");
            if (allow != null && allow.trim().length() > 0 && "true".equals(allow)) {
                allowUnLicensedFabrics = true;
            }
            String path = ClientCache.getConfDir();
            sql = new WebResourceLoader("Statements.properties");
            sql.load();
            if (ConnectionManager.getDbDriver().startsWith("oracle")) {
                sql.overload("Statements_orcl.properties");
            } else if (ConnectionManager.getDbDriver().indexOf("postgresql") > 0) {
                sql.overload("Statements_postgres.properties");
            }
        }
        catch (Exception ex) {
            _Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ec) {
                _Log.warn((Object)ec.getMessage(), (Throwable)ec);
            }
        }
    }
}

