/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.wrapper;

import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class CollectionFabrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long _id;
    public String _name;
    public int fid = -1;
    static Logger logger = Logger.getLogger((String)"fms");

    public CollectionFabrics(long id, String name) {
        this._id = id;
        this._name = name;
    }

    public CollectionFabrics(long id, String name, int fid) {
        this(id, name);
        this.fid = fid;
    }

    public String getName() {
        return this._name;
    }

    public long getId() {
        return this._id;
    }

    public String toString() {
        return this.getName();
    }

    public static CollectionFabrics findById(ArrayList fab, int id) {
        for (int k = 0; k < fab.size(); ++k) {
            CollectionFabrics f = (CollectionFabrics)fab.get(k);
            if (f.getFid() != id) continue;
            return f;
        }
        return null;
    }

    public static CollectionFabrics findByDBId(ArrayList fab, long dbId) {
        for (int k = 0; k < fab.size(); ++k) {
            CollectionFabrics f = (CollectionFabrics)fab.get(k);
            if (f.getId() != dbId) continue;
            return f;
        }
        return null;
    }

    public static CollectionFabrics findByFid(List fabs, String fid) {
        if (fabs == null || fabs.size() == 0) {
            return null;
        }
        for (int i = 0; i < fabs.size(); ++i) {
            CollectionFabrics temp;
            Object o = fabs.get(i);
            if (o == null || !(o instanceof CollectionFabrics) || (temp = (CollectionFabrics)o).getFid() != Integer.parseInt(fid)) continue;
            return temp;
        }
        return null;
    }

    public int getFid() {
        return this.fid;
    }

    public static CollectionFabrics findByName(ArrayList fab, String name) {
        for (int k = 0; k < fab.size(); ++k) {
            CollectionFabrics f = (CollectionFabrics)fab.get(k);
            if (!f._name.equals(name)) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getFaricToSwitchHash(ArrayList fab) throws Exception {
        if (!SQLLoader.canExecute()) {
            return null;
        }
        Hashtable fabricToSwitch = new Hashtable();
        String roleFilter = "";
        String[] rep = new String[1];
        String switchIP = null;
        Connection con = null;
        String sql = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            for (int k = 0; k < fab.size(); ++k) {
                CollectionFabrics f = (CollectionFabrics)fab.get(k);
                rep[0] = roleFilter = "FABRIC.ID = " + String.valueOf(f._id);
                int[] ind = new int[]{99};
                sql = SQLLoader.getSql("OidsAction.FABRICS_TO_SWITCH", ind, rep);
                try {
                    stmt = con.prepareStatement(sql);
                    rs = SQLLoader.execute((PreparedStatement)stmt);
                    ArrayList<String> switchIPList = new ArrayList<String>();
                    while (rs.next()) {
                        rs.getInt(1);
                        rs.getBytes(2);
                        switchIP = InetAddress.getByAddress(rs.getBytes(2)).getHostAddress();
                        switchIPList.add(switchIP);
                    }
                    fabricToSwitch.put(new Long(f._id), switchIPList);
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    rs = null;
                    stmt = null;
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            ConnectionManager.returnConnection(con);
        }
        return fabricToSwitch;
    }
}

