/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.vi.discover;

import com.cisco.dcbu.vi.discover.DiscProc;
import com.cisco.dcbu.vi.discover.WorkerCallbackIf;
import com.cisco.dcbu.vi.discover.WorkerIf;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

abstract class AbstractVmWareWorker
implements WorkerIf {
    protected AtomicInteger _status = new AtomicInteger(0);
    protected WorkerCallbackIf _observer;

    AbstractVmWareWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() == 1) {
                this._status.set(2);
                this._status.notifyAll();
            }
        }
    }

    @Override
    public int getStatus() {
        return this._status.get();
    }

    @Override
    public String getStatusDescr() {
        return AbstractVmWareWorker.toStatusDescr(this._status.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            this._status.set(1);
            this.exec();
            this._status.compareAndSet(1, 5);
        }
        catch (Exception ex) {
            this._status.set(3);
            _Log.log((Priority)Level.WARN, (Object)(this + " aborted: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.sendUpdate(null);
            _Log.debug((Object)(this + " " + this.getStatusDescr() + " in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
    }

    protected void sendUpdate(DiscProc proc) {
        if (this._observer != null) {
            try {
                this._observer.update(this, proc, this._status.get());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected abstract void exec() throws Exception;

    static String toStatusDescr(int status) {
        switch (status) {
            case 0: {
                return "idle";
            }
            case 1: {
                return "discovering";
            }
            case 2: {
                return "interrupted";
            }
            case 3: {
                return "aborted";
            }
            case 4: {
                return "timed out";
            }
            case 5: {
                return "finished";
            }
        }
        return "internal error";
    }
}

