/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper;

import com.cisco.nm.esper.GraphPrintJobAttributes;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.BoundsDouble;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class GraphPrinter
implements Printable {
    private Graph graph;
    private Bounds bounds;
    private GraphPrintJobAttributes attrs;

    public GraphPrinter(Graph graph, GraphPrintJobAttributes graphPrintJobAttributes) {
        this(graph, null, graphPrintJobAttributes);
    }

    public GraphPrinter(Graph graph, Bounds bounds, GraphPrintJobAttributes graphPrintJobAttributes) {
        this.graph = graph;
        this.attrs = graphPrintJobAttributes == null ? new GraphPrintJobAttributes() : graphPrintJobAttributes;
        this.bounds = bounds == null ? null : new BoundsDouble(bounds);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.bounds != null) {
            return this.printRect(graphics, pageFormat, n);
        }
        return this.printPage(graphics, pageFormat, n);
    }

    protected int printPage(Graphics graphics, PageFormat pageFormat, int n) {
        Object object;
        Object object2;
        Object object3;
        FontMetrics fontMetrics;
        int n2;
        Bounds bounds = this.graph.getBounds();
        double d = bounds.getLeft();
        double d2 = bounds.getRight();
        double d3 = bounds.getBottom();
        double d4 = bounds.getTop();
        int n3 = (int)Math.floor(pageFormat.getImageableWidth());
        int n4 = (int)Math.floor(pageFormat.getImageableHeight());
        int n5 = this.attrs.getTopMargin();
        int n6 = this.attrs.getBottomMargin();
        int n7 = this.attrs.getLeftMargin();
        int n8 = this.attrs.getRightMargin();
        int n9 = n3 - n7 - n8;
        int n10 = n4 - n5 - n6;
        double d5 = (double)n9 / 1.0;
        double d6 = (double)n10 / 1.0;
        int n11 = (int)Math.ceil((d4 - d3) / d6);
        int n12 = n11 * (n2 = (int)Math.ceil((d2 - d) / d5));
        if (n >= n12) {
            return 1;
        }
        int n13 = n / n11;
        int n14 = n % n11;
        double d7 = ((double)n2 * d5 - d2 + d) / 2.0;
        double d8 = ((double)n11 * d6 - d4 + d3) / 2.0;
        int n15 = n7 - 1;
        int n16 = n3 - n8;
        int n17 = n5 - 1;
        int n18 = n4 - n6;
        int n19 = this.attrs.getCropMarkLength();
        int n20 = this.attrs.getCropMarkLength() / 3;
        Polygon polygon = null;
        Polygon polygon2 = null;
        Polygon polygon3 = null;
        Polygon polygon4 = null;
        if (this.attrs.isAdjacentPageNbrPrinted() && n12 > 1) {
            fontMetrics = graphics.getFontMetrics(this.attrs.getAdjacentPageNbrFont());
            int n21 = fontMetrics.stringWidth(Integer.toString(n12));
            int n22 = fontMetrics.getMaxAscent();
            int n23 = Math.max(20, Math.max(n21, n22));
            int n24 = Math.max(20, Math.max(n21, n22));
            object3 = new int[4];
            object2 = new int[4];
            object3[0] = n7 - n23;
            object2[0] = n5 + n10 / 2 + n24 / 2;
            object3[1] = n7;
            object2[1] = n5 + n10 / 2 + 5 * n24 / 6;
            object3[2] = n7;
            object2[2] = n5 + n10 / 2 - 5 * n24 / 6;
            object3[3] = n7 - n23;
            object2[3] = n5 + n10 / 2 - n24 / 2;
            polygon = new Polygon((int[])object3, (int[])object2, 4);
            object3[0] = n3 - n8 + n23;
            object3[1] = n3 - n8;
            object3[2] = n3 - n8;
            object3[3] = n3 - n8 + n23;
            polygon2 = new Polygon((int[])object3, (int[])object2, 4);
            object3[0] = n7 + n9 / 2 - n23 / 2;
            object2[0] = n4 - n6 + n24;
            object3[1] = n7 + n9 / 2 + n23 / 2;
            object2[1] = n4 - n6 + n24;
            object3[2] = n7 + n9 / 2 + 5 * n23 / 6;
            object2[2] = n4 - n6;
            object3[3] = n7 + n9 / 2 - 5 * n23 / 6;
            object2[3] = n4 - n6;
            polygon4 = new Polygon((int[])object3, (int[])object2, 4);
            object2[0] = n5 - n24;
            object2[1] = n5 - n24;
            object2[2] = n5;
            object2[3] = n5;
            polygon3 = new Polygon((int[])object3, (int[])object2, 4);
        }
        double d9 = d4 + d8 - d6 * (double)n13;
        double d10 = d - d7 + d5 * (double)n14;
        object3 = new BoundsDouble(d10, d9 - d6, d10 + d5, d9);
        if (n13 == 0 && this.attrs.getHeader() != null) {
            graphics.setFont(this.attrs.getHeaderFont());
            graphics.setColor(this.attrs.getHeaderColor());
            fontMetrics = graphics.getFontMetrics();
            if (0 == this.attrs.getHeaderAlignment()) {
                if (n14 == 0) {
                    graphics.drawString(this.attrs.getHeader(), n7, n5 - fontMetrics.getMaxDescent() - fontMetrics.getLeading());
                }
            } else if (n14 == n2 - 1) {
                graphics.drawString(this.attrs.getHeader(), n3 - n8 - fontMetrics.stringWidth(this.attrs.getHeader()), n5 - fontMetrics.getMaxDescent() - fontMetrics.getLeading());
            }
        }
        if (n13 == n11 - 1 && this.attrs.getFooter() != null) {
            graphics.setFont(this.attrs.getFooterFont());
            graphics.setColor(this.attrs.getFooterColor());
            fontMetrics = graphics.getFontMetrics();
            if (0 == this.attrs.getFooterAlignment()) {
                if (n14 == 0) {
                    graphics.drawString(this.attrs.getFooter(), n7, n4 - n6 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
                }
            } else if (n14 == n2 - 1) {
                graphics.drawString(this.attrs.getFooter(), n3 - n8 - fontMetrics.stringWidth(this.attrs.getFooter()), n4 - n6 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
            }
        }
        if (this.attrs.isCropMarked()) {
            graphics.setColor(this.attrs.getCropMarkColor());
            graphics.drawLine(n15, n17 - n20, n15, n17 + n19);
            graphics.drawLine(n15 - n20, n17, n15 + n19, n17);
            graphics.drawLine(n16 - n19, n17, n16 + n20, n17);
            graphics.drawLine(n16, n17 - n20, n16, n17 + n19);
            graphics.drawLine(n15, n18 - n19, n15, n18 + n20);
            graphics.drawLine(n15 - n20, n18, n15 + n19, n18);
            graphics.drawLine(n16 - n19, n18, n16 + n20, n18);
            graphics.drawLine(n16, n18 - n19, n16, n18 + n20);
        }
        graphics.setFont(this.attrs.getPageNumberFont());
        graphics.setColor(this.attrs.getPageNumberColor());
        fontMetrics = graphics.getFontMetrics();
        object2 = this.attrs.getPageNumberText(n + 1, n13, n14, n12);
        graphics.drawString((String)object2, n7 + (n9 - fontMetrics.stringWidth((String)object2)) / 2, n4 - (n6 - fontMetrics.getHeight()) / 2 - fontMetrics.getMaxDescent());
        if (n12 > 1 && this.attrs.isAdjacentPageNbrPrinted()) {
            graphics.setFont(this.attrs.getAdjacentPageNbrFont());
            fontMetrics = graphics.getFontMetrics();
            if (n14 > 0) {
                object = Integer.toString(n);
                graphics.setColor(this.attrs.getAdjacentPageMarkerColor());
                graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 4);
                graphics.setColor(this.attrs.getAdjacentPageNbrColor());
                graphics.drawString((String)object, n7 - fontMetrics.stringWidth((String)object), n5 + (n10 + fontMetrics.getMaxAscent()) / 2);
            }
            if (n14 < n2 - 1) {
                object = Integer.toString(n + 2);
                graphics.setColor(this.attrs.getAdjacentPageMarkerColor());
                graphics.fillPolygon(polygon2.xpoints, polygon2.ypoints, 4);
                graphics.setColor(this.attrs.getAdjacentPageNbrColor());
                graphics.drawString((String)object, n3 - n8, n5 + (n10 + fontMetrics.getMaxAscent()) / 2);
            }
            if (n13 > 0) {
                object = Integer.toString(n - n2 + 1);
                graphics.setColor(this.attrs.getAdjacentPageMarkerColor());
                graphics.fillPolygon(polygon3.xpoints, polygon3.ypoints, 4);
                graphics.setColor(this.attrs.getAdjacentPageNbrColor());
                graphics.drawString((String)object, n7 + (n9 - fontMetrics.stringWidth((String)object)) / 2, n5);
            }
            if (n13 < n11 - 1) {
                object = Integer.toString(n + n2 + 1);
                graphics.setColor(this.attrs.getAdjacentPageMarkerColor());
                graphics.fillPolygon(polygon4.xpoints, polygon4.ypoints, 4);
                graphics.setColor(this.attrs.getAdjacentPageNbrColor());
                graphics.drawString((String)object, n7 + (n9 - fontMetrics.stringWidth((String)object)) / 2, n4 - n6 + fontMetrics.getMaxAscent());
            }
        }
        graphics.setClip(n15 + 1, n17 + 1, n9, n10);
        graphics.translate(n15 + 1, n17 + 1);
        object = new Transform();
        double d11 = Math.min((double)n10 / object3.getHeight(), (double)n9 / object3.getWidth());
        ((com.cisco.nm.esper.shape.Transform)object).setScaleX(d11);
        ((com.cisco.nm.esper.shape.Transform)object).setScaleY(-d11);
        ((com.cisco.nm.esper.shape.Transform)object).setOffsetX(-d11 * object3.getLeft() + ((double)n9 - d11 * object3.getWidth()) / 2.0);
        ((com.cisco.nm.esper.shape.Transform)object).setOffsetY(d11 * object3.getTop() + ((double)n10 - d11 * object3.getHeight()) / 2.0);
        this.graph.paint(graphics, (Transform)object);
        graphics.translate(-n15 - 1, -n17 - 1);
        return 0;
    }

    protected int printRect(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        FontMetrics fontMetrics;
        if (n > 0) {
            return 1;
        }
        int n3 = (int)Math.floor(pageFormat.getImageableWidth());
        int n4 = (int)Math.floor(pageFormat.getImageableHeight());
        int n5 = this.attrs.getTopMargin();
        int n6 = this.attrs.getBottomMargin();
        int n7 = this.attrs.getLeftMargin();
        int n8 = this.attrs.getRightMargin();
        int n9 = n7 - 1;
        int n10 = n3 - n8;
        int n11 = n5 - 1;
        int n12 = n4 - n6;
        int n13 = this.attrs.getCropMarkLength();
        int n14 = this.attrs.getCropMarkLength() / 3;
        int n15 = n3 - n7 - n8;
        int n16 = n4 - n5 - n6;
        if (this.attrs.isCropMarked()) {
            graphics.setColor(this.attrs.getCropMarkColor());
            graphics.drawLine(n9, n11 - n14, n9, n11 + n13);
            graphics.drawLine(n9 - n14, n11, n9 + n13, n11);
            graphics.drawLine(n10 - n13, n11, n10 + n14, n11);
            graphics.drawLine(n10, n11 - n14, n10, n11 + n13);
            graphics.drawLine(n9, n12 - n13, n9, n12 + n14);
            graphics.drawLine(n9 - n14, n12, n9 + n13, n12);
            graphics.drawLine(n10 - n13, n12, n10 + n14, n12);
            graphics.drawLine(n10, n12 - n13, n10, n12 + n14);
        }
        if (this.attrs.getHeader() != null) {
            graphics.setFont(this.attrs.getHeaderFont());
            graphics.setColor(this.attrs.getHeaderColor());
            fontMetrics = graphics.getFontMetrics();
            if (this.attrs.getHeaderAlignment() == 0) {
                graphics.drawString(this.attrs.getHeader(), n7, n5 - fontMetrics.getMaxDescent() - fontMetrics.getLeading());
            } else {
                n2 = fontMetrics.stringWidth(this.attrs.getHeader());
                if (this.attrs.getHeaderAlignment() == 2) {
                    graphics.drawString(this.attrs.getHeader(), n3 - n8 - n2, n5 - fontMetrics.getMaxDescent() - fontMetrics.getLeading());
                } else {
                    graphics.drawString(this.attrs.getHeader(), (n15 - n2) / 2 + n7, n5 - fontMetrics.getMaxDescent() - fontMetrics.getLeading());
                }
            }
        }
        if (this.attrs.getFooter() != null) {
            graphics.setFont(this.attrs.getFooterFont());
            graphics.setColor(this.attrs.getFooterColor());
            fontMetrics = graphics.getFontMetrics();
            if (this.attrs.getFooterAlignment() == 0) {
                graphics.drawString(this.attrs.getFooter(), n7, n4 - n6 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
            } else {
                n2 = fontMetrics.stringWidth(this.attrs.getFooter());
                if (this.attrs.getFooterAlignment() == 2) {
                    graphics.drawString(this.attrs.getFooter(), n3 - n8 - n2, n4 - n6 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
                } else {
                    graphics.drawString(this.attrs.getFooter(), (n15 - n2) / 2 + n7, n4 - n6 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
                }
            }
        }
        Transform transform = new Transform();
        double d = Math.min((double)n16 / this.bounds.getHeight(), (double)n15 / this.bounds.getWidth());
        transform.setScaleX(d);
        transform.setScaleY(-d);
        transform.setOffsetX(-d * this.bounds.getLeft() + ((double)n15 - d * this.bounds.getWidth()) / 2.0);
        transform.setOffsetY(d * this.bounds.getTop() + ((double)n16 - d * this.bounds.getHeight()) / 2.0);
        graphics.setClip(n9 + 1, n11 + 1, n10 - n9 - 1, n12 - n11 - 1);
        graphics.translate(n9 + 1, n11 + 1);
        this.graph.paint(graphics, transform);
        graphics.translate(-n9 - 1, -n11 - 1);
        return 0;
    }
}

