/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper;

import com.cisco.nm.lib.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class GraphScrollPaneLayout
implements LayoutManager2 {
    public static final String VERTICAL_SCROLL = "vs";
    public static final String HORIZONTAL_SCROLL = "hs";
    public static final String CANVAS = "vw";
    public static final String OVERVIEW = "ov";
    private Component vScroll;
    private Component hScroll;
    private Component view;
    private Component overview;
    private Container parent;
    private int xOff = -16;
    private int yOff = -16;

    public GraphScrollPaneLayout(Container container) {
        this.parent = container;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (VERTICAL_SCROLL.equals(object)) {
            this.vScroll = component;
        } else if (HORIZONTAL_SCROLL.equals(object)) {
            this.hScroll = component;
        } else if (CANVAS.equals(object)) {
            this.view = component;
        } else if (OVERVIEW.equals(object)) {
            this.overview = component;
        } else {
            throw new IllegalArgumentException("Invalid constraint ".concat(String.valueOf(String.valueOf(object))));
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.vScroll) {
            this.vScroll = null;
        } else if (component == this.hScroll) {
            this.hScroll = null;
        } else if (component == this.view) {
            this.view = null;
        } else {
            Debug.println(10, "Removing unknown component ".concat(String.valueOf(String.valueOf(component.getName()))));
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(116, 116);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void setOverviewOffsetX(int n) {
        this.setOverviewOffsets(n, this.yOff);
    }

    public void setOverviewOffsetY(int n) {
        this.setOverviewOffsets(this.xOff, n);
    }

    public void setOverviewOffsets(int n, int n2) {
        this.xOff = n;
        this.yOff = n2;
    }

    public int getOverviewOffsetX() {
        return this.xOff;
    }

    public int getOverviewOffsetY() {
        return this.yOff;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n = 0;
        if (this.vScroll != null && this.vScroll.isVisible()) {
            n = Math.max(16, this.vScroll.getPreferredSize().width);
        }
        int n2 = 0;
        if (this.hScroll != null && this.hScroll.isVisible()) {
            n2 = Math.max(16, this.hScroll.getPreferredSize().height);
        }
        this.view.setBounds(insets.left, insets.top, dimension.width - n, dimension.height - n2);
        if (this.vScroll != null && this.vScroll.isVisible()) {
            this.vScroll.setBounds(dimension.width - n, insets.top, n, dimension.height - n2);
        }
        if (this.hScroll != null && this.hScroll.isVisible()) {
            this.hScroll.setBounds(insets.left, dimension.height - n2, dimension.width - n, n2);
        }
        if (this.overview != null && this.overview.isVisible()) {
            int n3 = dimension.width / 3;
            int n4 = dimension.height / 3;
            int n5 = this.xOff < 0 ? dimension.width - n3 - n + this.xOff : this.xOff;
            int n6 = this.yOff < 0 ? dimension.height - n4 - n2 + this.yOff : this.yOff;
            this.overview.setBounds(n5, n6, n3, n4);
            this.overview.validate();
        }
    }

    static {
        VERTICAL_SCROLL = VERTICAL_SCROLL;
        HORIZONTAL_SCROLL = HORIZONTAL_SCROLL;
        CANVAS = CANVAS;
        OVERVIEW = OVERVIEW;
    }
}

