/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper;

import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.lib.algs.EmptyList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class HitTestWorker {
    private static final RectPool RECT_POOL = RectPool.INSTANCE;
    private int _hitTolerance;
    private int _hitDepth;
    private Transform transform;

    public HitTestWorker() {
        this.setHitTestDepth(2);
        this.setHitTolerance(2);
    }

    public Transform getTransform() {
        return this.transform;
    }

    protected void setTransform(Transform transform) {
        this.transform = transform;
    }

    public int getHitTolerance() {
        return this._hitTolerance;
    }

    public void setHitTolerance(int n) {
        this._hitTolerance = Math.max(0, n);
    }

    public int getHitTestDepth() {
        return this._hitDepth;
    }

    public void setHitTestDepth(int n) {
        this._hitDepth = Math.max(1, n);
    }

    public Graph getActiveGraph(Graph graph, int n, int n2) {
        return graph == null ? null : this.getActiveSubGraph(graph, n, n2);
    }

    private Graph getActiveSubGraph(Graph graph, int n, int n2) {
        Graph graph2 = null;
        Rectangle rectangle = RectPool.INSTANCE.checkRectOut();
        Rectangle rectangle2 = this.borrowHitRect(n, n2);
        Object object = graph.graphs().iterator();
        while (object.hasNext()) {
            Graph graph3 = (Graph)object.next();
            graph3.getPainter().getBounds(graph3, this.transform, rectangle);
            if (!graph3.isExpanded()) {
                if (!rectangle.contains(n, n2)) continue;
                graph2 = graph3;
                continue;
            }
            if (rectangle.x > n || n > rectangle.x + rectangle.width || rectangle.y > n2 || n2 > rectangle.y + rectangle.height) continue;
            boolean bl = graph3.getPainter().intersects(graph3, rectangle2, this.transform);
            if (!bl) {
                graph2 = graph3;
                continue;
            }
            RectPool.INSTANCE.checkRectIn(rectangle);
            this.returnHitRect(rectangle2);
            return graph;
        }
        RectPool.INSTANCE.checkRectIn(rectangle);
        this.returnHitRect(rectangle2);
        if (graph2 == null || !graph2.isExpanded()) {
            return graph;
        }
        object = this.getActiveSubGraph(graph2, n, n2);
        return object != null ? object : graph2;
    }

    public GraphMember getTopObjectAt(Graph graph, int n, int n2) {
        BaseObject baseObject = null;
        baseObject = this.getTopGraphAt(graph, n, n2);
        if (baseObject == null && (baseObject = this.getTopEdgeLabelAt(graph, n, n2)) == null && (baseObject = this.getTopNodeLabelAt(graph, n, n2)) == null && (baseObject = this.getTopNodeAt(graph, n, n2)) == null && (baseObject = this.getTopEdgeAt(graph, n, n2)) == null) {
            baseObject = this.getTopBendAt(graph, n, n2);
        }
        return baseObject;
    }

    public Graph getTopGraphAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Transform transform = this.getTransform();
        Rectangle rectangle = this.borrowHitRect(n, n2);
        ListIterator listIterator = graph.graphs().listIterator(graph.graphs().size());
        while (listIterator.hasPrevious()) {
            Graph graph2 = (Graph)listIterator.previous();
            if (!graph2.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return graph2;
        }
        this.returnHitRect(rectangle);
        return null;
    }

    public List getGraphsAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return EmptyList.INSTANCE;
        }
        Transform transform = this.getTransform();
        Rectangle rectangle = this.borrowHitRect(n, n2);
        ArrayList<Graph> arrayList = null;
        Iterator iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph.intersects(rectangle, transform)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Graph>(5);
            }
            arrayList.add(graph2);
        }
        this.returnHitRect(rectangle);
        return arrayList == null ? EmptyList.INSTANCE : arrayList;
    }

    public Node getTopNodeAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Transform transform = this.getTransform();
        Rectangle rectangle = this.borrowHitRect(n, n2);
        ListIterator listIterator = graph.nodes().listIterator(graph.nodes().size());
        while (listIterator.hasPrevious()) {
            Node node = (Node)listIterator.previous();
            if (!node.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return node;
        }
        this.returnHitRect(rectangle);
        return null;
    }

    public List getNodesAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return EmptyList.INSTANCE;
        }
        Transform transform = this.getTransform();
        Rectangle rectangle = this.borrowHitRect(n, n2);
        ArrayList<Node> arrayList = null;
        Iterator iterator = graph.nodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.intersects(rectangle, transform)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Node>(5);
            }
            arrayList.add(node);
        }
        this.returnHitRect(rectangle);
        return arrayList == null ? EmptyList.INSTANCE : arrayList;
    }

    public NodeLabel getTopNodeLabelAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        NodeLabel nodeLabel = null;
        Iterator iterator = graph.nodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.labels().iterator();
            while (iterator2.hasNext()) {
                NodeLabel nodeLabel2 = (NodeLabel)iterator2.next();
                if (!nodeLabel2.intersects(rectangle, transform)) continue;
                nodeLabel = nodeLabel2;
            }
        }
        this.returnHitRect(rectangle);
        return nodeLabel;
    }

    public List getNodeLabelsAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return EmptyList.INSTANCE;
        }
        ArrayList<NodeLabel> arrayList = null;
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        Iterator iterator = graph.nodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.labels().iterator();
            while (iterator2.hasNext()) {
                NodeLabel nodeLabel = (NodeLabel)iterator2.next();
                if (!nodeLabel.intersects(rectangle, transform)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<NodeLabel>(5);
                }
                arrayList.add(nodeLabel);
            }
        }
        this.returnHitRect(rectangle);
        return arrayList == null ? EmptyList.INSTANCE : arrayList;
    }

    public Edge getTopEdgeAt(Graph graph, int n, int n2) {
        Edge edge;
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        ListIterator listIterator = graph.edges(2).listIterator(graph.edges(2).size());
        while (listIterator.hasPrevious()) {
            edge = (Edge)listIterator.previous();
            if (!edge.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return edge;
        }
        listIterator = graph.edges(1).listIterator(graph.edges(1).size());
        while (listIterator.hasPrevious()) {
            edge = (Edge)listIterator.previous();
            if (!edge.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return edge;
        }
        this.returnHitRect(rectangle);
        return null;
    }

    public List getEdgesAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return EmptyList.INSTANCE;
        }
        ArrayList<Edge> arrayList = null;
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        for (int i = 1; i <= 2; ++i) {
            Iterator iterator = graph.edges(i).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (!edge.intersects(rectangle, transform)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Edge>(5);
                }
                arrayList.add(edge);
            }
        }
        this.returnHitRect(rectangle);
        return arrayList == null ? EmptyList.INSTANCE : arrayList;
    }

    public EdgeLabel getTopEdgeLabelAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        EdgeLabel edgeLabel = null;
        for (int i = 1; i <= 2; ++i) {
            Iterator iterator = graph.edges(i).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Iterator iterator2 = edge.labels().iterator();
                while (iterator2.hasNext()) {
                    EdgeLabel edgeLabel2 = (EdgeLabel)iterator2.next();
                    if (!edgeLabel2.intersects(rectangle, transform)) continue;
                    edgeLabel = edgeLabel2;
                }
            }
        }
        this.returnHitRect(rectangle);
        return edgeLabel;
    }

    public List getEdgeLabelsAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return EmptyList.INSTANCE;
        }
        ArrayList<EdgeLabel> arrayList = null;
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        for (int i = 1; i <= 2; ++i) {
            Iterator iterator = graph.edges(i).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Iterator iterator2 = edge.labels().iterator();
                while (iterator2.hasNext()) {
                    EdgeLabel edgeLabel = (EdgeLabel)iterator2.next();
                    if (!edgeLabel.intersects(rectangle, transform)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<EdgeLabel>(5);
                    }
                    arrayList.add(edgeLabel);
                }
            }
        }
        this.returnHitRect(rectangle);
        return arrayList == null ? EmptyList.INSTANCE : arrayList;
    }

    public Bend getTopBendAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Bend bend = null;
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        for (int i = 1; i <= 2; ++i) {
            Iterator iterator = graph.edges(i).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Iterator iterator2 = edge.bends().iterator();
                while (iterator2.hasNext()) {
                    Bend bend2 = (Bend)iterator2.next();
                    if (!bend2.intersects(rectangle, transform)) continue;
                    bend = bend2;
                }
            }
        }
        this.returnHitRect(rectangle);
        return bend;
    }

    public List getBendsAt(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return EmptyList.INSTANCE;
        }
        ArrayList<Bend> arrayList = null;
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        Iterator iterator = graph.edges().iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Iterator iterator2 = edge.bends().iterator();
            while (iterator2.hasNext()) {
                Bend bend = (Bend)iterator2.next();
                if (!bend.intersects(rectangle, transform)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Bend>(5);
                }
                arrayList.add(bend);
            }
        }
        this.returnHitRect(rectangle);
        return arrayList == null ? EmptyList.INSTANCE : arrayList;
    }

    public boolean isOverNode(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        Iterator iterator = graph.nodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return true;
        }
        this.returnHitRect(rectangle);
        return false;
    }

    public boolean isOverGraph(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        Iterator iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph2.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return true;
        }
        this.returnHitRect(rectangle);
        return false;
    }

    public boolean isOverEdge(Graph graph, int n, int n2) {
        Edge edge;
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        Iterator iterator = graph.edges(2).iterator();
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            if (!edge.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return true;
        }
        iterator = graph.edges(1).iterator();
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            if (!edge.intersects(rectangle, transform)) continue;
            this.returnHitRect(rectangle);
            return true;
        }
        this.returnHitRect(rectangle);
        return false;
    }

    public boolean isOverEdgeLabel(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        for (int i = 1; i <= 2; ++i) {
            Iterator iterator = graph.edges(i).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Iterator iterator2 = edge.labels().iterator();
                while (iterator2.hasNext()) {
                    EdgeLabel edgeLabel = (EdgeLabel)iterator2.next();
                    if (!edgeLabel.intersects(rectangle, transform)) continue;
                    this.returnHitRect(rectangle);
                    return true;
                }
            }
        }
        this.returnHitRect(rectangle);
        return false;
    }

    public boolean isOverNodeLabel(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        Rectangle rectangle = this.borrowHitRect(n, n2);
        Transform transform = this.getTransform();
        Iterator iterator = graph.nodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.labels().iterator();
            while (iterator2.hasNext()) {
                NodeLabel nodeLabel = (NodeLabel)iterator2.next();
                if (!nodeLabel.intersects(rectangle, transform)) continue;
                this.returnHitRect(rectangle);
                return true;
            }
        }
        this.returnHitRect(rectangle);
        return false;
    }

    public int getOnNodeLocation(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return -1;
        }
        Transform transform = this.getTransform();
        Iterator iterator = graph.nodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            int n3 = node.getHitCode(n, n2, transform);
            if (n3 == -1) continue;
            return n3;
        }
        return -1;
    }

    public int getOnGraphLocation(Graph graph, int n, int n2) {
        if (graph == null || this.getTransform() == null) {
            return -1;
        }
        Transform transform = this.getTransform();
        Iterator iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            int n3 = graph2.getHitCode(n, n2, transform);
            if (n3 == -1) continue;
            return n3;
        }
        return -1;
    }

    protected Rectangle borrowHitRect(int n, int n2) {
        Rectangle rectangle = RECT_POOL.checkRectOut();
        rectangle.setBounds(n - this.getHitTolerance() / 2, n2 - this.getHitTolerance() / 2, this.getHitTolerance(), this.getHitTolerance());
        return rectangle;
    }

    protected void returnHitRect(Rectangle rectangle) {
        RECT_POOL.checkRectIn(rectangle);
    }
}

