/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.action;

import com.cisco.nm.esper.action.GraphComponentAction;
import com.cisco.nm.esper.overview.OverviewCanvas;
import com.cisco.nm.lib.winkit.BasicContainer;
import com.cisco.nm.lib.winkit.Border;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public abstract class AbstractOverviewAction
extends GraphComponentAction {
    public static final String OVERVIEW_ACTION = "overview";
    public static final int DIALOG_WIDTH = 200;
    public static final int DIALOG_HEIGHT = 300;
    private Dialog dialog;
    private String title;
    private DialogWatch watch;
    private BasicContainer holder;
    private Border border;
    private boolean detached;

    public AbstractOverviewAction() {
        this.setOverviewTitle("Overview");
        Border.Solid solid = new Border.Solid(2);
        solid.setLineColor(RichColor.steelblue);
        this.setBorder(solid);
    }

    public boolean isAbleToHandle(ActionEvent actionEvent) {
        return actionEvent != null && OVERVIEW_ACTION.equals(actionEvent.getActionCommand());
    }

    protected void execute(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (OVERVIEW_ACTION.equals(string)) {
            if (this.isDetached()) {
                if (this.getOverviewDialog() == null) {
                    this.dialog = this.newOverviewDialog();
                    Point point = this.getGraphComponent().asContainer().getLocationOnScreen();
                    ((Component)this.dialog).setBounds(point.x + this.getGraphComponent().getWidth() - 16 - 200, point.y + this.getGraphComponent().getHeight() - 16 - 300, 200, 300);
                    this.dialog.addWindowListener(this.getDialogWatch());
                    ((Component)this.dialog).setVisible(false);
                }
                ((Component)this.getOverviewDialog()).setVisible(!this.getOverviewDialog().isVisible());
            } else {
                if (this.holder == null) {
                    this.holder = new BasicContainer(this.getBorder());
                    this.holder.setLayout(new BorderLayout());
                    this.holder.add((Component)new OverviewCanvas(this.getGraphComponent()), "Center");
                    this.getGraphComponent().asContainer().getParent().add(this.holder, "ov", 0);
                    this.holder.setVisible(false);
                }
                this.holder.setVisible(!this.holder.isVisible());
                this.getGraphComponent().asContainer().getParent().doLayout();
            }
        } else {
            this.cannotHandle(actionEvent);
        }
    }

    public Dialog getOverviewDialog() {
        return this.dialog;
    }

    public String getOverviewTitle() {
        return this.title;
    }

    public void setOverviewTitle(String string) {
        this.title = string;
        if (this.getOverviewDialog() != null) {
            this.getOverviewDialog().setTitle(string);
        }
    }

    public void setDetached(boolean bl) {
        this.detached = bl;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    protected abstract Dialog newOverviewDialog();

    private DialogWatch getDialogWatch() {
        if (this.watch == null) {
            this.watch = new DialogWatch();
        }
        return this.watch;
    }

    protected void cleanup() {
        if (this.dialog != null) {
            this.dialog.removeWindowListener(this.getDialogWatch());
            this.dialog = null;
        }
    }

    static {
        OVERVIEW_ACTION = OVERVIEW_ACTION;
        DIALOG_WIDTH = 200;
        DIALOG_HEIGHT = 300;
    }

    private class DialogWatch
    extends WindowAdapter {
        private DialogWatch() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (windowEvent.getWindow() == AbstractOverviewAction.this.dialog) {
                AbstractOverviewAction.this.cleanup();
            }
        }
    }
}

