/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib;

import com.cisco.nm.lib.Debug;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Vector;

public class FontRepository {
    public static final FontRepository INSTANCE = new FontRepository();
    private Hashtable[] styles;
    private Hashtable families;
    private char[] chr = new char[256];

    public FontRepository() {
        this.styles = new Hashtable[4];
        for (int i = 0; i < this.styles.length; ++i) {
            this.styles[i] = new Hashtable(37);
        }
    }

    public Font getScaleFont(Font font, double d) {
        int n = (int)Math.round((double)font.getSize() * d);
        if (font.getSize() == n) {
            return font;
        }
        if (n < 4) {
            return null;
        }
        Hashtable hashtable = this.getStyleContainer(font.getStyle());
        Vector<Font> vector = (Vector<Font>)hashtable.get(font.getFamily());
        Font font2 = null;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Font font3 = (Font)vector.elementAt(i);
                if (font3.getSize() != n) continue;
                font2 = font3;
                break;
            }
        }
        if (font2 == null) {
            if (d == 1.0) {
                font2 = font;
            } else {
                font2 = new Font(font.getFamily(), font.getStyle(), n);
                Debug.println("Creating new font");
            }
            if (vector == null) {
                vector = new Vector<Font>(10, 10);
            }
            vector.addElement(font2);
            hashtable.put(font.getFamily(), vector);
        }
        return font2;
    }

    public int getStringWidth(String string, Font font) {
        int n = 0;
        if (font != null) {
            n = this.getStringWidth(string, Toolkit.getDefaultToolkit().getFontMetrics(font));
        }
        return n;
    }

    public int getStringWidth(String string, FontMetrics fontMetrics) {
        int n = 0;
        if (string != null && string.length() > 0) {
            if (string.length() > this.chr.length) {
                n = fontMetrics.stringWidth(string);
            } else {
                string.getChars(0, string.length(), this.chr, 0);
                n = fontMetrics.charsWidth(this.chr, 0, string.length());
            }
        }
        return n;
    }

    public int getStringWidth(String string, int n, int n2, FontMetrics fontMetrics) {
        int n3 = 0;
        if (string != null) {
            if (n < 0 || n2 < n || n2 > string.length()) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("substring(").append(n).append(", ").append(n2).append(") of string(").append(string.length()).append(")"))));
            }
            if (n < n2) {
                if (n2 - n >= this.chr.length) {
                    n3 = fontMetrics.stringWidth(string.substring(n, n2));
                } else {
                    string.getChars(n, n2, this.chr, 0);
                    n3 = fontMetrics.charsWidth(this.chr, 0, n2 - n);
                }
            }
        }
        return n3;
    }

    protected Hashtable getStyleContainer(int n) {
        return this.styles[n];
    }
}

