/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib;

import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.lib.algs.EmptyIterator;
import com.cisco.nm.lib.algs.EmptyListIterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OwnedArrayList
implements OwnedList {
    public static final int DEFAULT_CAPACITY = 10;
    private Object[] data;
    private int size;

    public OwnedArrayList() {
        this(10);
    }

    public OwnedArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative capacity ".concat(String.valueOf(String.valueOf(n))));
        }
        this.data = new Object[n];
        this.size = 0;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("index ".concat(String.valueOf(String.valueOf(n))));
        }
        return this.data[n];
    }

    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return this.size <= 0 ? EmptyIterator.INSTANCE : new ArrayIterator(0);
    }

    public ListIterator listIterator() {
        return this.size <= 0 ? EmptyListIterator.INSTANCE : new ArrayIterator(0);
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("index ".concat(String.valueOf(String.valueOf(n))));
        }
        return this.size <= 0 ? EmptyListIterator.INSTANCE : new ArrayIterator(n);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        this.add(this.size, object);
        return true;
    }

    public void add(int n, Object object) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer("index: ").append(n).append(", size: ").append(this.size))));
        }
        this.ensureCapacity(this.size + 1);
        if (n < this.size) {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = object;
        ++this.size;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Object remove(int n) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer("index: ").append(n).append(", size: ").append(this.size))));
        }
        Object object = this.data[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.data, n + 1, this.data, n, n2);
        }
        this.data[--this.size] = null;
        return object;
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        Object object2 = this.data[n];
        this.data[n] = object;
        return object2;
    }

    public void ensureCapacity(int n) {
        if (n > this.data.length) {
            int n2 = this.data.length * 3 / 2 + 1;
            if (n2 < n) {
                n2 = n;
            }
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            Object object = this.data[i];
            if (object == null) continue;
            n ^= object.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OwnedList)) {
            return false;
        }
        OwnedList ownedList = (OwnedList)object;
        if (this.size() != ownedList.size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ownedList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            if (!(e == null ? e2 != null : !e.equals(e2))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            OwnedArrayList ownedArrayList = (OwnedArrayList)super.clone();
            ownedArrayList.size = 0;
            ownedArrayList.data = new Object[this.size];
            OwnedArrayList ownedArrayList2 = ownedArrayList;
            return ownedArrayList2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Cloning error ".concat(String.valueOf(String.valueOf(cloneNotSupportedException.getMessage()))));
        }
    }

    static {
        DEFAULT_CAPACITY = 10;
    }

    class ArrayIterator
    implements ListIterator {
        int index;

        public ArrayIterator(int n) {
            this.index = n;
        }

        public boolean hasNext() {
            return this.index < OwnedArrayList.this.size();
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(String.valueOf(String.valueOf(new StringBuffer("index: ").append(this.index).append(", size: ").append(OwnedArrayList.this.size))));
            }
            return OwnedArrayList.this.get(this.index++);
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException(String.valueOf(String.valueOf(new StringBuffer("index: ").append(this.index).append(", size: ").append(OwnedArrayList.this.size))));
            }
            return OwnedArrayList.this.get(--this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("ListIterator::remove");
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("ListIterator::set");
        }

        public void add(Object object) {
            throw new UnsupportedOperationException("ListIterator::add");
        }
    }
}

