/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib;

import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.lib.algs.EmptyListIterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OwnedLinkedList
implements Cloneable,
OwnedList {
    private transient Cell head = null;
    private transient Cell tail = null;
    private transient int length = 0;

    public boolean add(Object object) {
        this.insertObject(this.tail, object);
        return true;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (n == 0) {
            this.insertObject(null, object);
        } else if (n == this.size()) {
            this.insertObject(this.tail, object);
        } else {
            this.insertObject(this.getCellAt(n - 1), object);
        }
    }

    public void clear() {
        for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
            cell.setObject(null);
        }
        this.tail = null;
        this.head = null;
        this.length = 0;
    }

    public boolean contains(Object object) {
        return this.getCellWith(object) != null;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.getCellAt(n).getObject();
    }

    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
                if (cell.getObject() == null) {
                    return n;
                }
                ++n;
            }
        } else {
            for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
                if (object.equals(cell.getObject())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size();
        if (object == null) {
            for (Cell cell = this.tail; cell != null; cell = cell.getPrevious()) {
                if (cell.getObject() == null) {
                    return n;
                }
                --n;
            }
        } else {
            for (Cell cell = this.tail; cell != null; cell = cell.getPrevious()) {
                if (object.equals(cell.getObject())) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index ".concat(String.valueOf(String.valueOf(n))));
        }
        return this.size() <= 0 ? EmptyListIterator.INSTANCE : new Iter(n);
    }

    public boolean remove(Object object) {
        Cell cell = this.getCellWith(object);
        if (cell == null) {
            return false;
        }
        this.removeCell(cell);
        return true;
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        Cell cell = this.getCellAt(n);
        Object object = cell.getObject();
        this.removeCell(cell);
        return object;
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        Cell cell = this.getCellAt(n);
        Object object2 = cell.getObject();
        cell.setObject(object);
        return object2;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public int size() {
        return this.length;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
            objectArray[n++] = cell.getObject();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        int n = 0;
        for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
            objectArray[n++] = cell.getObject();
        }
        if (objectArray.length > this.size()) {
            objectArray[this.size()] = null;
        }
        return objectArray;
    }

    public int hashCode() {
        int n = 0;
        for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
            if (cell.getObject() == null) continue;
            n ^= cell.getObject().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OwnedList)) {
            return false;
        }
        OwnedList ownedList = (OwnedList)object;
        if (this.size() != ownedList.size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ownedList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            if (!(e == null ? e2 != null : !e.equals(e2))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            OwnedLinkedList ownedLinkedList = (OwnedLinkedList)super.clone();
            ownedLinkedList.tail = null;
            ownedLinkedList.head = null;
            ownedLinkedList.length = 0;
            OwnedLinkedList ownedLinkedList2 = ownedLinkedList;
            return ownedLinkedList2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Cloning error ".concat(String.valueOf(String.valueOf(cloneNotSupportedException.getMessage()))));
        }
    }

    public int move(Object object, OwnedLinkedList ownedLinkedList) {
        return this.move(ownedLinkedList.size(), object, ownedLinkedList);
    }

    public int move(int n, Object object, OwnedLinkedList ownedLinkedList) {
        Cell cell = this.getCellWith(object);
        if (cell == null) {
            return -1;
        }
        this.removeCell(cell);
        int n2 = Math.max(0, Math.min(ownedLinkedList.size(), n - 1));
        ownedLinkedList.insertCell(ownedLinkedList.getCellAt(n2), cell);
        return n2;
    }

    protected Cell getHead() {
        return this.head;
    }

    protected Cell setHead(Cell cell) {
        this.head = cell;
        return this.head;
    }

    protected Cell getTail() {
        return this.tail;
    }

    protected Cell setTail(Cell cell) {
        this.tail = cell;
        return this.tail;
    }

    protected Cell insertObject(Cell cell, Object object) {
        return this.insertCell(cell, new Cell(object));
    }

    protected Cell insertCell(Cell cell, Cell cell2) {
        cell2.setPrevious(cell);
        if (cell == null) {
            cell2.setNext(this.head);
            if (this.head != null) {
                this.head.setPrevious(cell2);
            }
            this.head = cell2;
            if (this.tail != null) {
                ++this.length;
            } else {
                this.tail = cell2;
                this.length = 1;
            }
        } else {
            cell2.setNext(cell.getNext());
            if (cell.getNext() == null) {
                this.tail = cell2;
            } else {
                cell.getNext().setPrevious(cell2);
            }
            cell.setNext(cell2);
            ++this.length;
        }
        return cell2;
    }

    protected Cell removeCell(Cell cell) {
        if (cell.getPrevious() == null) {
            this.head = cell.getNext();
        } else {
            cell.getPrevious().setNext(cell.getNext());
        }
        if (cell.getNext() == null) {
            this.tail = cell.getPrevious();
        } else {
            cell.getNext().setPrevious(cell.getPrevious());
        }
        cell.setNext(null);
        cell.setPrevious(null);
        --this.length;
        return cell;
    }

    protected Cell getCellWith(Object object) {
        if (object == null) {
            for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
                if (cell.getObject() != null) continue;
                return cell;
            }
        } else {
            for (Cell cell = this.head; cell != null; cell = cell.getNext()) {
                if (!object.equals(cell.getObject())) continue;
                return cell;
            }
        }
        return null;
    }

    protected Cell getCellAt(int n) {
        Cell cell;
        if (n < 0 || n >= this.size()) {
            cell = null;
        } else if (n == 0) {
            cell = this.head;
        } else if (n == this.length - 1) {
            cell = this.tail;
        } else if (n < this.length / 2) {
            cell = this.head;
            for (int i = 0; i < n; ++i) {
                cell = cell.getNext();
            }
        } else {
            cell = this.tail;
            for (int i = this.length - 1; i > n; --i) {
                cell = cell.getPrevious();
            }
        }
        return cell;
    }

    private class Iter
    implements ListIterator {
        private int index;
        private Cell cell;

        public Iter(int n) {
            this.index = n;
            this.cell = OwnedLinkedList.this.getCellAt(n);
        }

        public boolean hasNext() {
            return this.cell != null;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(String.valueOf(String.valueOf(new StringBuffer("index: ").append(this.index).append(", size: ").append(OwnedLinkedList.this.size()))));
            }
            Object object = this.cell.getObject();
            this.cell = this.cell.getNext();
            ++this.index;
            return object;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException(String.valueOf(String.valueOf(new StringBuffer("index: ").append(this.index).append(", size: ").append(OwnedLinkedList.this.size()))));
            }
            this.cell = this.index == OwnedLinkedList.this.size() ? OwnedLinkedList.this.getTail() : this.cell.getPrevious();
            --this.index;
            return this.cell.getObject();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("ListIterator::remove");
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("ListIterator::set");
        }

        public void add(Object object) {
            throw new UnsupportedOperationException("ListIterator::add");
        }
    }

    public static class Cell
    implements Cloneable {
        private Object object;
        private transient Cell next;
        private transient Cell prev;

        public Cell() {
            this(null, null, null);
        }

        public Cell(Object object) {
            this(null, object, null);
        }

        public Cell(Object object, Cell cell) {
            this(null, object, cell);
        }

        public Cell(Cell cell, Object object, Cell cell2) {
            this.prev = cell;
            this.object = object;
            this.next = cell2;
        }

        public Object clone() {
            return new Cell(this.getObject());
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return String.valueOf(this.getObject());
        }

        public Cell getNext() {
            return this.next;
        }

        public Cell setNext(Cell cell) {
            this.next = cell;
            return this.next;
        }

        public Cell getPrevious() {
            return this.prev;
        }

        public Cell setPrevious(Cell cell) {
            this.prev = cell;
            return this.prev;
        }

        public Object getObject() {
            return this.object;
        }

        public Object setObject(Object object) {
            this.object = object;
            return this.object;
        }
    }
}

