/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.graphics.Line;
import com.cisco.nm.esper.lib.graphics.LinePool;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Geometry {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public static final int NO_INTERSECTION = 0;
    public static final int PROPER_INTERSECTION = 1;
    public static final int PARALLEL_INTERSECTION = 2;

    private Geometry() {
    }

    public static boolean intersects(Line line, Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty() || line == null) {
            return false;
        }
        int n = line.getX1();
        int n2 = line.getY1();
        int n3 = line.getX2();
        int n4 = line.getY2();
        int n5 = Geometry.outcode(n, n2, rectangle);
        int n6 = Geometry.outcode(n3, n4, rectangle);
        while ((n5 & n6) == 0) {
            int n7;
            if (n5 == 0) {
                if (n6 == 0) {
                    return true;
                }
                n7 = n;
                n = n3;
                n3 = n7;
                n7 = n2;
                n2 = n4;
                n4 = n7;
                n7 = n5;
                n5 = n6;
                n6 = n7;
            }
            if ((n5 & 5) != 0) {
                n7 = rectangle.x;
                if ((n5 & 4) != 0) {
                    n7 += rectangle.width;
                }
                n2 += (n7 - n) * (n4 - n2) / (n3 - n);
                n = n7;
            } else if ((n5 & 0xA) != 0) {
                n7 = rectangle.y;
                if ((n5 & 8) != 0) {
                    n7 += rectangle.height;
                }
                n += (n7 - n2) * (n3 - n) / (n4 - n2);
                n2 = n7;
            }
            n5 = Geometry.outcode(n, n2, rectangle);
        }
        return false;
    }

    public static int outcode(int n, int n2, Rectangle rectangle) {
        int n3 = 0;
        if (n < rectangle.x) {
            n3 = 1;
        } else if (n > rectangle.x + rectangle.width) {
            n3 = 4;
        }
        if (n2 < rectangle.y) {
            n3 |= 2;
        } else if (n2 > rectangle.y + rectangle.height) {
            n3 |= 8;
        }
        return n3;
    }

    public static Point intersection(Line line, Rectangle rectangle) {
        return Geometry.intersection(line, rectangle, new Point());
    }

    public static Point intersection(Line line, Rectangle rectangle, Point point) {
        double d;
        double d2;
        double d3;
        double d4;
        if (rectangle == null || rectangle.isEmpty() || line == null) {
            return null;
        }
        if (point == null) {
            point = new Point();
        }
        int n = Geometry.outcode(line.getX1(), line.getY1(), rectangle);
        int n2 = Geometry.outcode(line.getX2(), line.getY2(), rectangle);
        if (n == 0 && n2 == 0) {
            return null;
        }
        if ((n & n2) != 0) {
            return null;
        }
        if (n2 == 0) {
            d4 = line.getX2();
            d3 = line.getY2();
            d2 = line.getX1();
            d = line.getY1();
        } else {
            d4 = line.getX1();
            d3 = line.getY1();
            d2 = line.getX2();
            d = line.getY2();
        }
        if (d2 < (double)rectangle.x) {
            d = d3 + (d - d3) / (d2 - d4) * ((double)rectangle.x - d4);
            d2 = rectangle.x;
        } else if (d2 > (double)(rectangle.x + rectangle.width)) {
            d = d3 + (d - d3) / (d2 - d4) * ((double)(rectangle.x + rectangle.width) - d4);
            d2 = rectangle.x + rectangle.width;
        }
        if (d < (double)rectangle.y) {
            d2 = d4 + (d2 - d4) / (d - d3) * ((double)rectangle.y - d3);
            d = rectangle.y;
        } else if (d > (double)(rectangle.y + rectangle.height)) {
            d2 = d4 + (d2 - d4) / (d - d3) * ((double)(rectangle.y + rectangle.height) - d3);
            d = rectangle.y + rectangle.height;
        }
        point.setLocation((int)Math.round(d2), (int)Math.round(d));
        return point;
    }

    public static int intersection(Line line, Line line2, Point point) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = line.getX1();
        int n6 = line.getX2();
        int n7 = line.getY1();
        int n8 = line.getY2();
        int n9 = line2.getX1();
        int n10 = line2.getX2();
        int n11 = line2.getY1();
        int n12 = line2.getY2();
        int n13 = n6 - n5;
        int n14 = n9 - n10;
        if (n13 < 0) {
            n4 = n6;
            n3 = n5;
        } else {
            n3 = n6;
            n4 = n5;
        }
        if (n14 > 0 ? n3 < n10 || n9 < n4 : n3 < n9 || n10 < n4) {
            return 0;
        }
        int n15 = n8 - n7;
        int n16 = n11 - n12;
        if (n15 < 0) {
            n2 = n8;
            n = n7;
        } else {
            n = n8;
            n2 = n7;
        }
        if (n16 > 0 ? n < n12 || n11 < n2 : n < n11 || n12 < n2) {
            return 0;
        }
        int n17 = n5 - n9;
        int n18 = n7 - n11;
        int n19 = n16 * n17 - n14 * n18;
        int n20 = n15 * n14 - n13 * n16;
        if (n20 > 0 ? n19 < 0 || n19 > n20 : n19 > 0 || n19 < n20) {
            return 0;
        }
        int n21 = n13 * n18 - n15 * n17;
        if (n20 > 0 ? n21 < 0 || n21 > n20 : n21 > 0 || n21 < n20) {
            return 0;
        }
        if (n20 == 0) {
            if (point != null) {
                point.x = Math.min(n3, Math.max(n9, n10));
                point.y = Math.min(n, Math.max(n11, n12));
            }
            return 2;
        }
        if (point != null) {
            int n22 = n19 * n13;
            int n23 = (n22 ^ n20) >= 0 ? n20 / 2 : -n20 / 2;
            point.x = n5 + (n22 + n23) / n20;
            n22 = n19 * n15;
            n23 = (n22 ^ n20) >= 0 ? n20 / 2 : -n20 / 2;
            point.y = n7 + (n22 + n23) / n20;
        }
        return 1;
    }

    public static boolean intersects(Line line, Line line2) {
        return Geometry.intersection(line, line2, null) != 0;
    }

    public static boolean intersects(Rectangle rectangle, Polygon polygon) {
        Rectangle rectangle2 = polygon.getBounds();
        if (rectangle2.x > rectangle.x + rectangle.width || rectangle2.x + rectangle2.width < rectangle.x || rectangle2.y > rectangle.y + rectangle.height || rectangle2.y + rectangle2.height < rectangle.y) {
            return false;
        }
        boolean bl = false;
        Line line = (Line)LinePool.INSTANCE.checkOut();
        Line line2 = (Line)LinePool.INSTANCE.checkOut();
        line2.setLastPoint(polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1]);
        for (int i = 0; i < polygon.npoints; ++i) {
            line2.setFirstPoint(line2.getX2(), line2.getY2());
            line2.setLastPoint(polygon.xpoints[i], polygon.ypoints[i]);
            line.setFirstPoint(rectangle.x, rectangle.y);
            line.setLastPoint(rectangle.x + rectangle.width, rectangle.y);
            if (Geometry.intersects(line2, line)) {
                bl = true;
                break;
            }
            line.setFirstPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            if (Geometry.intersects(line2, line)) {
                bl = true;
                break;
            }
            line.setLastPoint(rectangle.x, rectangle.y + rectangle.height);
            if (Geometry.intersects(line2, line)) {
                bl = true;
                break;
            }
            line.setFirstPoint(rectangle.x, rectangle.y);
            if (!Geometry.intersects(line2, line)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            boolean bl2 = bl = rectangle.x <= rectangle2.x && rectangle.y <= rectangle2.y && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
        }
        if (!bl) {
            bl = polygon.contains(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        }
        LinePool.INSTANCE.checkIn(line);
        LinePool.INSTANCE.checkIn(line2);
        return bl;
    }

    static {
        OUT_LEFT = 1;
        OUT_TOP = 2;
        OUT_RIGHT = 4;
        OUT_BOTTOM = 8;
        NO_INTERSECTION = 0;
        PROPER_INTERSECTION = 1;
        PARALLEL_INTERSECTION = 2;
    }
}

