/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.ObjectPool;
import com.cisco.nm.esper.lib.graphics.Line;
import com.cisco.nm.lib.Debug;

public class LinePool
implements ObjectPool {
    public static final LinePool INSTANCE = new LinePool();
    public static final int DEFAULT_CAPACITY = 8;
    private Line[] pool;
    private int size;

    public LinePool() {
        this(8);
    }

    public LinePool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unable to allocate a pool of capacity ".concat(String.valueOf(String.valueOf(n))));
        }
        this.pool = new Line[n];
        this.size = 0;
    }

    public Object checkOut() {
        return this.checkLineOut();
    }

    public void checkIn(Object object) {
        this.checkLineIn((Line)object);
    }

    public Line checkLineOut() {
        Line line;
        if (this.size > 0) {
            --this.size;
            line = this.pool[this.size];
            this.pool[this.size] = null;
        } else {
            line = this.createLine();
        }
        return line;
    }

    public void checkLineIn(Line line) {
        if (this.size >= this.pool.length) {
            Line[] lineArray = new Line[this.size + 5];
            System.arraycopy(this.pool, 0, lineArray, 0, this.size);
            this.pool = lineArray;
        }
        this.pool[this.size++] = line;
    }

    public Line createLine() {
        Debug.println("Creating line");
        return new Line();
    }

    static {
        DEFAULT_CAPACITY = 8;
    }
}

