/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.ObjectPool;
import com.cisco.nm.lib.Debug;
import java.awt.Point;

public class PointPool
implements ObjectPool {
    public static final PointPool INSTANCE = new PointPool();
    public static final int DEFAULT_CAPACITY = 8;
    private Point[] pool;
    private int size;

    public PointPool() {
        this(8);
    }

    public PointPool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unable to allocate a pool of capacity ".concat(String.valueOf(String.valueOf(n))));
        }
        this.pool = new Point[n];
        this.size = 0;
    }

    public Object checkOut() {
        return this.checkPointOut();
    }

    public void checkIn(Object object) {
        this.checkPointIn((Point)object);
    }

    public Point checkPointOut() {
        Point point;
        if (this.size > 0) {
            --this.size;
            point = this.pool[this.size];
            this.pool[this.size] = null;
        } else {
            point = this.createPoint();
        }
        return point;
    }

    public void checkPointIn(Point point) {
        if (this.size >= this.pool.length) {
            Point[] pointArray = new Point[this.size + 5];
            System.arraycopy(this.pool, 0, pointArray, 0, this.size);
            this.pool = pointArray;
        }
        this.pool[this.size++] = point;
    }

    public Point createPoint() {
        Debug.println("Creating point");
        return new Point();
    }

    static {
        DEFAULT_CAPACITY = 8;
    }
}

